/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.transform;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.shaded.guava18.com.google.common.util.concurrent.RateLimiter;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.sink.transform.RowDataToHoodieFunction;

public class RowDataToHoodieFunctionWithRateLimit<I extends RowData, O extends HoodieRecord>
extends RowDataToHoodieFunction<I, O> {
    private final double totalLimit;
    private transient RateLimiter rateLimiter;

    public RowDataToHoodieFunctionWithRateLimit(RowType rowType, Configuration config) {
        super(rowType, config);
        this.totalLimit = config.getLong(FlinkOptions.WRITE_RATE_LIMIT);
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.rateLimiter = RateLimiter.create((double)(this.totalLimit / (double)this.getRuntimeContext().getNumberOfParallelSubtasks()));
    }

    @Override
    public O map(I i) throws Exception {
        this.rateLimiter.acquire();
        return super.map(i);
    }
}

