/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.utils;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.function.ThrowingRunnable;
import org.slf4j.Logger;

public class NonThrownExecutor
implements AutoCloseable {
    private final Logger logger;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    @VisibleForTesting
    protected final ExceptionHook exceptionHook;
    private final boolean waitForTasksFinish;

    @VisibleForTesting
    protected NonThrownExecutor(Logger logger, @Nullable ExceptionHook exceptionHook, boolean waitForTasksFinish) {
        this.logger = logger;
        this.exceptionHook = exceptionHook;
        this.waitForTasksFinish = waitForTasksFinish;
    }

    public static Builder builder(Logger logger) {
        return new Builder(logger);
    }

    public void execute(ThrowingRunnable<Throwable> action, String actionName, Object ... actionParams) {
        this.execute(action, this.exceptionHook, actionName, actionParams);
    }

    public void execute(ThrowingRunnable<Throwable> action, ExceptionHook hook, String actionName, Object ... actionParams) {
        this.executor.execute(() -> {
            block2: {
                String actionString = String.format(actionName, actionParams);
                try {
                    action.run();
                    this.logger.info("Executor executes action [{}] success!", (Object)actionString);
                }
                catch (Throwable t) {
                    ExceptionUtils.rethrowIfFatalErrorOrOOM((Throwable)t);
                    String errMsg = String.format("Executor executes action [%s] error", actionString);
                    this.logger.error(errMsg, t);
                    if (hook == null) break block2;
                    hook.apply(errMsg, t);
                }
            }
        });
    }

    @Override
    public void close() throws Exception {
        if (this.executor != null) {
            if (this.waitForTasksFinish) {
                this.executor.shutdown();
            } else {
                this.executor.shutdownNow();
            }
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
    }

    public static class Builder {
        private final Logger logger;
        private ExceptionHook exceptionHook;
        private boolean waitForTasksFinish = false;

        private Builder(Logger logger) {
            this.logger = Objects.requireNonNull(logger);
        }

        public NonThrownExecutor build() {
            return new NonThrownExecutor(this.logger, this.exceptionHook, this.waitForTasksFinish);
        }

        public Builder exceptionHook(ExceptionHook exceptionHook) {
            this.exceptionHook = exceptionHook;
            return this;
        }

        public Builder waitForTasksFinish(boolean waitForTasksFinish) {
            this.waitForTasksFinish = waitForTasksFinish;
            return this;
        }
    }

    public static interface ExceptionHook {
        public void apply(String var1, Throwable var2);
    }
}

