/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format.cow;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.vector.writable.WritableIntVector;
import org.apache.flink.table.data.vector.writable.WritableTimestampVector;
import org.apache.hudi.table.format.cow.AbstractColumnReader;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.schema.PrimitiveType;

public class Int64TimestampColumnReader
extends AbstractColumnReader<WritableTimestampVector> {
    private final boolean utcTimestamp;

    public Int64TimestampColumnReader(boolean utcTimestamp, ColumnDescriptor descriptor, PageReader pageReader) throws IOException {
        super(descriptor, pageReader);
        this.utcTimestamp = utcTimestamp;
        this.checkTypeName(PrimitiveType.PrimitiveTypeName.INT64);
    }

    @Override
    protected boolean supportLazyDecode() {
        return false;
    }

    @Override
    protected void readBatch(int rowId, int num, WritableTimestampVector column) {
        for (int i = 0; i < num; ++i) {
            if (this.runLenDecoder.readInteger() == this.maxDefLevel) {
                ByteBuffer buffer = this.readDataBuffer(8);
                column.setTimestamp(rowId + i, Int64TimestampColumnReader.int64ToTimestamp(this.utcTimestamp, buffer.getLong()));
                continue;
            }
            column.setNullAt(rowId + i);
        }
    }

    @Override
    protected void readBatchFromDictionaryIds(int rowId, int num, WritableTimestampVector column, WritableIntVector dictionaryIds) {
        for (int i = rowId; i < rowId + num; ++i) {
            if (column.isNullAt(i)) continue;
            column.setTimestamp(i, Int64TimestampColumnReader.decodeInt64ToTimestamp(this.utcTimestamp, this.dictionary, dictionaryIds.getInt(i)));
        }
    }

    public static TimestampData decodeInt64ToTimestamp(boolean utcTimestamp, Dictionary dictionary, int id) {
        long value = dictionary.decodeToLong(id);
        return Int64TimestampColumnReader.int64ToTimestamp(utcTimestamp, value);
    }

    private static TimestampData int64ToTimestamp(boolean utcTimestamp, long millionsOfDay) {
        if (utcTimestamp) {
            return TimestampData.fromEpochMillis((long)millionsOfDay, (int)0);
        }
        Timestamp timestamp = new Timestamp(millionsOfDay);
        return TimestampData.fromTimestamp((Timestamp)timestamp);
    }
}

