/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format.mor;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.core.io.InputSplit;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.hudi.common.util.Option;

public class MergeOnReadInputSplit
implements InputSplit {
    private static final long serialVersionUID = 1L;
    private static final long NUM_NO_CONSUMPTION = 0L;
    private final int splitNum;
    private final Option<String> basePath;
    private final Option<List<String>> logPaths;
    private final String latestCommit;
    private final String tablePath;
    private final long maxCompactionMemoryInBytes;
    private final String mergeType;
    private final Option<InstantRange> instantRange;
    private long consumed = 0L;

    public MergeOnReadInputSplit(int splitNum, @Nullable String basePath, Option<List<String>> logPaths, String latestCommit, String tablePath, long maxCompactionMemoryInBytes, String mergeType, @Nullable InstantRange instantRange) {
        this.splitNum = splitNum;
        this.basePath = Option.ofNullable((Object)basePath);
        this.logPaths = logPaths;
        this.latestCommit = latestCommit;
        this.tablePath = tablePath;
        this.maxCompactionMemoryInBytes = maxCompactionMemoryInBytes;
        this.mergeType = mergeType;
        this.instantRange = Option.ofNullable((Object)instantRange);
    }

    public Option<String> getBasePath() {
        return this.basePath;
    }

    public Option<List<String>> getLogPaths() {
        return this.logPaths;
    }

    public String getLatestCommit() {
        return this.latestCommit;
    }

    public String getTablePath() {
        return this.tablePath;
    }

    public long getMaxCompactionMemoryInBytes() {
        return this.maxCompactionMemoryInBytes;
    }

    public String getMergeType() {
        return this.mergeType;
    }

    public Option<InstantRange> getInstantRange() {
        return this.instantRange;
    }

    public int getSplitNumber() {
        return this.splitNum;
    }

    public void consume() {
        ++this.consumed;
    }

    public long getConsumed() {
        return this.consumed;
    }

    public boolean isConsumed() {
        return this.consumed != 0L;
    }

    public String toString() {
        return "MergeOnReadInputSplit{splitNum=" + this.splitNum + ", basePath=" + this.basePath + ", logPaths=" + this.logPaths + ", latestCommit='" + this.latestCommit + '\'' + ", tablePath='" + this.tablePath + '\'' + ", maxCompactionMemoryInBytes=" + this.maxCompactionMemoryInBytes + ", mergeType='" + this.mergeType + '\'' + ", instantRange=" + this.instantRange + '}';
    }
}

