/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import org.apache.hudi.avro.AvroSchemaCompatibility;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieAvroSchemaException;
import org.apache.hudi.exception.InvalidUnionTypeException;
import org.apache.hudi.exception.MissingSchemaFieldException;
import org.apache.hudi.exception.SchemaBackwardsCompatibilityException;
import org.apache.hudi.exception.SchemaCompatibilityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSchemaUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AvroSchemaUtils.class);

    private AvroSchemaUtils() {
    }

    public static boolean isSchemaCompatible(Schema prevSchema, Schema newSchema) {
        return AvroSchemaUtils.isSchemaCompatible(prevSchema, newSchema, true);
    }

    public static boolean isSchemaCompatible(Schema prevSchema, Schema newSchema, boolean allowProjection) {
        return AvroSchemaUtils.isSchemaCompatible(prevSchema, newSchema, true, allowProjection);
    }

    public static boolean isSchemaCompatible(Schema prevSchema, Schema newSchema, boolean checkNaming, boolean allowProjection) {
        if (!allowProjection && !AvroSchemaUtils.canProject(prevSchema, newSchema)) {
            return false;
        }
        AvroSchemaCompatibility.SchemaPairCompatibility result = AvroSchemaCompatibility.checkReaderWriterCompatibility(newSchema, prevSchema, checkNaming);
        return result.getType() == AvroSchemaCompatibility.SchemaCompatibilityType.COMPATIBLE;
    }

    public static boolean canProject(Schema prevSchema, Schema newSchema) {
        return AvroSchemaUtils.findMissingFields(prevSchema, newSchema, Collections.emptySet()).isEmpty();
    }

    private static List<Schema.Field> findMissingFields(Schema prevSchema, Schema newSchema, Set<String> exceptCols) {
        return prevSchema.getFields().stream().filter(f -> !exceptCols.contains(f.name())).filter(oldSchemaField -> SchemaCompatibility.lookupWriterField((Schema)newSchema, (Schema.Field)oldSchemaField) == null).collect(Collectors.toList());
    }

    public static String getAvroRecordQualifiedName(String tableName) {
        String sanitizedTableName = HoodieAvroUtils.sanitizeName(tableName);
        return "hoodie." + sanitizedTableName + "." + sanitizedTableName + "_record";
    }

    public static boolean isCompatibleProjectionOf(Schema sourceSchema, Schema targetSchema) {
        return AvroSchemaUtils.isProjectionOfInternal(sourceSchema, targetSchema, AvroSchemaUtils::isAtomicSchemasCompatible);
    }

    private static boolean isAtomicSchemasCompatible(Schema oneAtomicType, Schema anotherAtomicType) {
        return AvroSchemaUtils.isSchemaCompatible(oneAtomicType, anotherAtomicType, false, true);
    }

    public static boolean isStrictProjectionOf(Schema sourceSchema, Schema targetSchema) {
        return AvroSchemaUtils.isProjectionOfInternal(sourceSchema, targetSchema, Objects::equals);
    }

    private static boolean isProjectionOfInternal(Schema sourceSchema, Schema targetSchema, BiFunction<Schema, Schema, Boolean> atomicTypeEqualityPredicate) {
        if (sourceSchema.getType() == targetSchema.getType()) {
            if (sourceSchema.getType() == Schema.Type.RECORD) {
                for (Schema.Field targetField : targetSchema.getFields()) {
                    Schema.Field sourceField = sourceSchema.getField(targetField.name());
                    if (sourceField != null && AvroSchemaUtils.isProjectionOfInternal(sourceField.schema(), targetField.schema(), atomicTypeEqualityPredicate)) continue;
                    return false;
                }
                return true;
            }
            if (sourceSchema.getType() == Schema.Type.ARRAY) {
                return AvroSchemaUtils.isProjectionOfInternal(sourceSchema.getElementType(), targetSchema.getElementType(), atomicTypeEqualityPredicate);
            }
            if (sourceSchema.getType() == Schema.Type.MAP) {
                return AvroSchemaUtils.isProjectionOfInternal(sourceSchema.getValueType(), targetSchema.getValueType(), atomicTypeEqualityPredicate);
            }
            if (sourceSchema.getType() == Schema.Type.UNION) {
                List sourceNestedSchemas = sourceSchema.getTypes();
                List targetNestedSchemas = targetSchema.getTypes();
                if (sourceNestedSchemas.size() != targetNestedSchemas.size()) {
                    return false;
                }
                for (int i = 0; i < sourceNestedSchemas.size(); ++i) {
                    if (AvroSchemaUtils.isProjectionOfInternal((Schema)sourceNestedSchemas.get(i), (Schema)targetNestedSchemas.get(i), atomicTypeEqualityPredicate)) continue;
                    return false;
                }
                return true;
            }
        }
        return atomicTypeEqualityPredicate.apply(sourceSchema, targetSchema);
    }

    public static Option<Schema.Type> findNestedFieldType(Schema schema, String fieldName) {
        String[] parts;
        if (StringUtils.isNullOrEmpty(fieldName)) {
            return Option.empty();
        }
        for (String part : parts = fieldName.split("\\.")) {
            Schema.Field foundField = AvroSchemaUtils.resolveNullableSchema(schema).getField(part);
            if (foundField == null) {
                throw new HoodieAvroSchemaException(fieldName + " not a field in " + schema);
            }
            schema = foundField.schema();
        }
        return Option.of(AvroSchemaUtils.resolveNullableSchema(schema).getType());
    }

    public static Option<Schema.Field> findNestedField(Schema schema, String fieldName) {
        return AvroSchemaUtils.findNestedField(schema, fieldName.split("\\."), 0);
    }

    private static Option<Schema.Field> findNestedField(Schema schema, String[] fieldParts, int index) {
        if (schema.getType().equals((Object)Schema.Type.UNION)) {
            Option<Schema.Field> notUnion = AvroSchemaUtils.findNestedField(AvroSchemaUtils.resolveNullableSchema(schema), fieldParts, index);
            if (!notUnion.isPresent()) {
                return Option.empty();
            }
            Schema.Field nu = notUnion.get();
            return Option.of(new Schema.Field(nu.name(), nu.schema(), nu.doc(), nu.defaultVal()));
        }
        if (fieldParts.length <= index) {
            return Option.empty();
        }
        Schema.Field foundField = schema.getField(fieldParts[index]);
        if (foundField == null) {
            return Option.empty();
        }
        if (index == fieldParts.length - 1) {
            return Option.of(new Schema.Field(foundField.name(), foundField.schema(), foundField.doc(), foundField.defaultVal()));
        }
        Schema foundSchema = foundField.schema();
        Option<Schema.Field> nestedPart = AvroSchemaUtils.findNestedField(foundSchema, fieldParts, index + 1);
        if (!nestedPart.isPresent()) {
            return Option.empty();
        }
        boolean isUnion = false;
        if (foundSchema.getType().equals((Object)Schema.Type.UNION)) {
            isUnion = true;
            foundSchema = AvroSchemaUtils.resolveNullableSchema(foundSchema);
        }
        Schema newSchema = AvroSchemaUtils.createNewSchemaFromFieldsWithReference(foundSchema, Collections.singletonList(nestedPart.get()));
        return Option.of(new Schema.Field(foundField.name(), isUnion ? AvroSchemaUtils.createNullableSchema(newSchema) : newSchema, foundField.doc(), foundField.defaultVal()));
    }

    public static Schema appendFieldsToSchemaDedupNested(Schema schema, List<Schema.Field> newFields) {
        return AvroSchemaUtils.appendFieldsToSchemaBase(schema, newFields, true);
    }

    public static Schema mergeSchemas(Schema a, Schema b) {
        if (!a.getType().equals((Object)Schema.Type.RECORD)) {
            return a;
        }
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        for (Schema.Field f : a.getFields()) {
            Schema.Field foundField = b.getField(f.name());
            fields.add(new Schema.Field(f.name(), foundField == null ? f.schema() : AvroSchemaUtils.mergeSchemas(f.schema(), foundField.schema()), f.doc(), f.defaultVal()));
        }
        for (Schema.Field f : b.getFields()) {
            if (a.getField(f.name()) != null) continue;
            fields.add(new Schema.Field(f.name(), f.schema(), f.doc(), f.defaultVal()));
        }
        return AvroSchemaUtils.createNewSchemaFromFieldsWithReference(a, fields);
    }

    public static Schema appendFieldsToSchema(Schema schema, List<Schema.Field> newFields) {
        return AvroSchemaUtils.appendFieldsToSchemaBase(schema, newFields, false);
    }

    private static Schema appendFieldsToSchemaBase(Schema schema, List<Schema.Field> newFields, boolean dedupNested) {
        List<Schema.Field> fields = schema.getFields().stream().map(field -> new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal())).collect(Collectors.toList());
        if (dedupNested) {
            for (Schema.Field f : newFields) {
                Schema.Field foundField = schema.getField(f.name());
                if (foundField != null) {
                    fields.set(foundField.pos(), new Schema.Field(foundField.name(), AvroSchemaUtils.mergeSchemas(foundField.schema(), f.schema()), foundField.doc(), foundField.defaultVal()));
                    continue;
                }
                fields.add(f);
            }
        } else {
            fields.addAll(newFields);
        }
        return AvroSchemaUtils.createNewSchemaFromFieldsWithReference(schema, fields);
    }

    public static Schema createNewSchemaFromFieldsWithReference(Schema schema, List<Schema.Field> fields) {
        if (schema == null) {
            throw new IllegalArgumentException("Schema must not be null");
        }
        Schema newSchema = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError());
        Map schemaProps = Collections.emptyMap();
        try {
            schemaProps = schema.getObjectProps();
        }
        catch (Exception e) {
            LOG.warn("Error while getting object properties from schema: {}", (Object)schema, (Object)e);
        }
        for (Map.Entry prop : schemaProps.entrySet()) {
            newSchema.addProp((String)prop.getKey(), prop.getValue());
        }
        newSchema.setFields(fields);
        return newSchema;
    }

    public static Schema resolveUnionSchema(Schema schema, String fieldSchemaFullName) {
        if (schema.getType() != Schema.Type.UNION) {
            return schema;
        }
        List innerTypes = schema.getTypes();
        if (innerTypes.size() == 2 && AvroSchemaUtils.isNullable(schema)) {
            return AvroSchemaUtils.resolveNullableSchema(schema);
        }
        Schema nonNullType = innerTypes.stream().filter(it -> it.getType() != Schema.Type.NULL && Objects.equals(it.getFullName(), fieldSchemaFullName)).findFirst().orElse(null);
        if (nonNullType == null) {
            throw new HoodieAvroSchemaException(String.format("Unsupported Avro UNION type %s: Only UNION of a null type and a non-null type is supported", schema));
        }
        return nonNullType;
    }

    public static boolean isNullable(Schema schema) {
        if (schema.getType() != Schema.Type.UNION) {
            return false;
        }
        List innerTypes = schema.getTypes();
        return innerTypes.size() > 1 && innerTypes.stream().anyMatch(it -> it.getType() == Schema.Type.NULL);
    }

    public static Schema resolveNullableSchema(Schema schema) {
        if (schema.getType() != Schema.Type.UNION) {
            return schema;
        }
        List innerTypes = schema.getTypes();
        if (innerTypes.size() != 2) {
            throw new HoodieAvroSchemaException(String.format("Unsupported Avro UNION type %s: Only UNION of a null type and a non-null type is supported", schema));
        }
        Schema firstInnerType = (Schema)innerTypes.get(0);
        Schema secondInnerType = (Schema)innerTypes.get(1);
        if (firstInnerType.getType() != Schema.Type.NULL && secondInnerType.getType() != Schema.Type.NULL || firstInnerType.getType() == Schema.Type.NULL && secondInnerType.getType() == Schema.Type.NULL) {
            throw new HoodieAvroSchemaException(String.format("Unsupported Avro UNION type %s: Only UNION of a null type and a non-null type is supported", schema));
        }
        return firstInnerType.getType() == Schema.Type.NULL ? secondInnerType : firstInnerType;
    }

    public static Schema createNullableSchema(Schema.Type avroType) {
        return AvroSchemaUtils.createNullableSchema(Schema.create((Schema.Type)avroType));
    }

    public static Schema createNullableSchema(Schema schema) {
        ValidationUtils.checkState(schema.getType() != Schema.Type.NULL);
        return Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), schema});
    }

    public static boolean containsFieldInSchema(Schema schema, String fieldName) {
        try {
            Schema.Field field = schema.getField(fieldName);
            return field != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void checkSchemaCompatible(Schema tableSchema, Schema writerSchema, boolean shouldValidate, boolean allowProjection, Set<String> dropPartitionColNames) throws SchemaCompatibilityException {
        AvroSchemaCompatibility.SchemaPairCompatibility result;
        List<Schema.Field> missingFields;
        if (!allowProjection && !(missingFields = AvroSchemaUtils.findMissingFields(tableSchema, writerSchema, dropPartitionColNames)).isEmpty()) {
            throw new MissingSchemaFieldException(missingFields.stream().map(Schema.Field::name).collect(Collectors.toList()), writerSchema, tableSchema);
        }
        if (dropPartitionColNames.isEmpty() && shouldValidate && (result = AvroSchemaCompatibility.checkReaderWriterCompatibility(writerSchema, tableSchema, true)).getType() != AvroSchemaCompatibility.SchemaCompatibilityType.COMPATIBLE) {
            throw new SchemaBackwardsCompatibilityException(result, writerSchema, tableSchema);
        }
    }

    public static void checkValidEvolution(Schema incomingSchema, Schema tableSchema) {
        if (incomingSchema.getType() == Schema.Type.NULL) {
            return;
        }
        ArrayList<String> missingFields = new ArrayList<String>();
        AvroSchemaUtils.findAnyMissingFields(incomingSchema, tableSchema, new ArrayDeque<String>(), missingFields);
        if (!missingFields.isEmpty()) {
            throw new MissingSchemaFieldException(missingFields, incomingSchema, tableSchema);
        }
        AvroSchemaCompatibility.SchemaPairCompatibility result = AvroSchemaCompatibility.checkReaderWriterCompatibility(incomingSchema, tableSchema, false);
        if (result.getType() != AvroSchemaCompatibility.SchemaCompatibilityType.COMPATIBLE) {
            throw new SchemaBackwardsCompatibilityException(result, incomingSchema, tableSchema);
        }
    }

    private static void findAnyMissingFields(Schema incomingSchema, Schema latestTableSchema, Deque<String> visited, List<String> missingFields) {
        AvroSchemaUtils.findAnyMissingFieldsRec(incomingSchema, latestTableSchema, visited, missingFields, incomingSchema, latestTableSchema);
    }

    private static void findAnyMissingFieldsRec(Schema incomingSchema, Schema latestTableSchema, Deque<String> visited, List<String> missingFields, Schema fullIncomingSchema, Schema fullTableSchema) {
        if (incomingSchema.getType() == latestTableSchema.getType()) {
            if (incomingSchema.getType() == Schema.Type.RECORD) {
                visited.addLast(latestTableSchema.getName());
                for (Schema.Field targetField : latestTableSchema.getFields()) {
                    visited.addLast(targetField.name());
                    Schema.Field sourceField = incomingSchema.getField(targetField.name());
                    if (sourceField == null) {
                        missingFields.add(String.join((CharSequence)".", visited));
                    } else {
                        AvroSchemaUtils.findAnyMissingFieldsRec(sourceField.schema(), targetField.schema(), visited, missingFields, fullIncomingSchema, fullTableSchema);
                    }
                    visited.removeLast();
                }
                visited.removeLast();
            } else if (incomingSchema.getType() == Schema.Type.ARRAY) {
                visited.addLast("element");
                AvroSchemaUtils.findAnyMissingFieldsRec(incomingSchema.getElementType(), latestTableSchema.getElementType(), visited, missingFields, fullIncomingSchema, fullTableSchema);
                visited.removeLast();
            } else if (incomingSchema.getType() == Schema.Type.MAP) {
                visited.addLast("value");
                AvroSchemaUtils.findAnyMissingFieldsRec(incomingSchema.getValueType(), latestTableSchema.getValueType(), visited, missingFields, fullIncomingSchema, fullTableSchema);
                visited.removeLast();
            } else if (incomingSchema.getType() == Schema.Type.UNION) {
                List incomingNestedSchemas = incomingSchema.getTypes();
                List latestTableNestedSchemas = latestTableSchema.getTypes();
                if (incomingNestedSchemas.size() != latestTableNestedSchemas.size()) {
                    throw new InvalidUnionTypeException(AvroSchemaUtils.createSchemaErrorString(String.format("Incoming batch field '%s' has union with %d types, while the table schema has %d types", String.join((CharSequence)".", visited), incomingNestedSchemas.size(), latestTableNestedSchemas.size()), fullIncomingSchema, fullTableSchema));
                }
                if (incomingNestedSchemas.size() > 2) {
                    throw new InvalidUnionTypeException(AvroSchemaUtils.createSchemaErrorString(String.format("Union for incoming batch field '%s' should not have more than 2 types but has %d", String.join((CharSequence)".", visited), incomingNestedSchemas.size()), fullIncomingSchema, fullTableSchema));
                }
                for (int i = 0; i < incomingNestedSchemas.size(); ++i) {
                    AvroSchemaUtils.findAnyMissingFieldsRec((Schema)incomingNestedSchemas.get(i), (Schema)latestTableNestedSchemas.get(i), visited, missingFields, fullIncomingSchema, fullTableSchema);
                }
            }
        }
    }

    public static String createSchemaErrorString(String errorMessage, Schema writerSchema, Schema tableSchema) {
        return String.format("%s\nwriterSchema: %s\ntableSchema: %s", errorMessage, writerSchema, tableSchema);
    }
}

