/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.bootstrap.index.hfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieBootstrapFilePartitionInfo;
import org.apache.hudi.avro.model.HoodieBootstrapIndexInfo;
import org.apache.hudi.avro.model.HoodieBootstrapPartitionMetadata;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.common.bootstrap.index.BootstrapIndex;
import org.apache.hudi.common.bootstrap.index.hfile.HFileBootstrapIndex;
import org.apache.hudi.common.model.BootstrapFileMapping;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.SeekableDataInputStream;
import org.apache.hudi.io.hfile.HFileReader;
import org.apache.hudi.io.hfile.HFileReaderImpl;
import org.apache.hudi.io.hfile.KeyValue;
import org.apache.hudi.io.hfile.UTF8StringKey;
import org.apache.hudi.io.util.IOUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HFileBootstrapIndexReader
extends BootstrapIndex.IndexReader {
    private static final Logger LOG = LoggerFactory.getLogger(HFileBootstrapIndexReader.class);
    private final String bootstrapBasePath;
    private final String indexByPartitionPath;
    private final String indexByFileIdPath;
    private transient HFileReader indexByPartitionReader;
    private transient HFileReader indexByFileIdReader;
    private transient HoodieBootstrapIndexInfo bootstrapIndexInfo;

    public HFileBootstrapIndexReader(HoodieTableMetaClient metaClient) {
        super(metaClient);
        StoragePath indexByPartitionPath = HFileBootstrapIndex.partitionIndexPath(metaClient);
        StoragePath indexByFilePath = HFileBootstrapIndex.fileIdIndexPath(metaClient);
        this.indexByPartitionPath = indexByPartitionPath.toString();
        this.indexByFileIdPath = indexByFilePath.toString();
        this.initIndexInfo();
        this.bootstrapBasePath = this.bootstrapIndexInfo.getBootstrapBasePath();
        LOG.info("Loaded HFileBasedBootstrapIndex with source base path :" + this.bootstrapBasePath);
    }

    private static HFileReader createReader(String hFilePath, HoodieStorage storage) throws IOException {
        LOG.info("Opening HFile for reading :" + hFilePath);
        StoragePath path = new StoragePath(hFilePath);
        long fileSize = storage.getPathInfo(path).getLength();
        SeekableDataInputStream stream = storage.openSeekable(path, false);
        return new HFileReaderImpl(stream, fileSize);
    }

    private synchronized void initIndexInfo() {
        if (this.bootstrapIndexInfo == null) {
            try {
                this.bootstrapIndexInfo = this.fetchBootstrapIndexInfo();
            }
            catch (IOException ioe) {
                throw new HoodieException(ioe.getMessage(), ioe);
            }
        }
    }

    private HoodieBootstrapIndexInfo fetchBootstrapIndexInfo() throws IOException {
        return TimelineMetadataUtils.deserializeAvroMetadata(this.partitionIndexReader().getMetaInfo(new UTF8StringKey("INDEX_INFO")).get(), HoodieBootstrapIndexInfo.class);
    }

    private synchronized HFileReader partitionIndexReader() throws IOException {
        if (this.indexByPartitionReader == null) {
            LOG.info("Opening partition index :" + this.indexByPartitionPath);
            this.indexByPartitionReader = HFileBootstrapIndexReader.createReader(this.indexByPartitionPath, this.metaClient.getStorage());
        }
        return this.indexByPartitionReader;
    }

    private synchronized HFileReader fileIdIndexReader() throws IOException {
        if (this.indexByFileIdReader == null) {
            LOG.info("Opening fileId index :" + this.indexByFileIdPath);
            this.indexByFileIdReader = HFileBootstrapIndexReader.createReader(this.indexByFileIdPath, this.metaClient.getStorage());
        }
        return this.indexByFileIdReader;
    }

    @Override
    public List<String> getIndexedPartitionPaths() {
        try {
            return this.getAllKeys(this.partitionIndexReader(), HFileBootstrapIndex::getPartitionFromKey);
        }
        catch (IOException e) {
            throw new HoodieIOException("Unable to read indexed partition paths.", e);
        }
    }

    @Override
    public List<HoodieFileGroupId> getIndexedFileGroupIds() {
        try {
            return this.getAllKeys(this.fileIdIndexReader(), HFileBootstrapIndex::getFileGroupFromKey);
        }
        catch (IOException e) {
            throw new HoodieIOException("Unable to read indexed file group IDs.", e);
        }
    }

    private <T> List<T> getAllKeys(HFileReader reader, Function<String, T> converter) {
        ArrayList<T> keys = new ArrayList<T>();
        try {
            boolean available = reader.seekTo();
            while (available) {
                keys.add(converter.apply(reader.getKeyValue().get().getKey().getContentInString()));
                available = reader.next();
            }
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
        return keys;
    }

    @Override
    public List<BootstrapFileMapping> getSourceFileMappingForPartition(String partition) {
        try {
            HFileReader reader = this.partitionIndexReader();
            UTF8StringKey lookupKey = new UTF8StringKey(HFileBootstrapIndex.getPartitionKey(partition));
            reader.seekTo();
            if (reader.seekTo(lookupKey) == 0) {
                KeyValue keyValue = reader.getKeyValue().get();
                byte[] valBytes = IOUtils.copy(keyValue.getBytes(), keyValue.getValueOffset(), keyValue.getValueLength());
                HoodieBootstrapPartitionMetadata metadata = TimelineMetadataUtils.deserializeAvroMetadata(valBytes, HoodieBootstrapPartitionMetadata.class);
                return metadata.getFileIdToBootstrapFile().entrySet().stream().map(e -> new BootstrapFileMapping(this.bootstrapBasePath, metadata.getBootstrapPartitionPath(), partition, (HoodieFileStatus)((Object)((Object)e.getValue())), (String)e.getKey())).collect(Collectors.toList());
            }
            LOG.warn("No value found for partition key (" + partition + ")");
            return new ArrayList<BootstrapFileMapping>();
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    @Override
    public String getBootstrapBasePath() {
        return this.bootstrapBasePath;
    }

    @Override
    public Map<HoodieFileGroupId, BootstrapFileMapping> getSourceFileMappingForFileIds(List<HoodieFileGroupId> ids) {
        HashMap<HoodieFileGroupId, BootstrapFileMapping> result = new HashMap<HoodieFileGroupId, BootstrapFileMapping>();
        ArrayList<HoodieFileGroupId> fileGroupIds = new ArrayList<HoodieFileGroupId>(ids);
        Collections.sort(fileGroupIds);
        try {
            HFileReader reader = this.fileIdIndexReader();
            reader.seekTo();
            for (HoodieFileGroupId fileGroupId : fileGroupIds) {
                UTF8StringKey lookupKey = new UTF8StringKey(HFileBootstrapIndex.getFileGroupKey(fileGroupId));
                if (reader.seekTo(lookupKey) != 0) continue;
                KeyValue keyValue = reader.getKeyValue().get();
                byte[] valBytes = IOUtils.copy(keyValue.getBytes(), keyValue.getValueOffset(), keyValue.getValueLength());
                HoodieBootstrapFilePartitionInfo fileInfo = TimelineMetadataUtils.deserializeAvroMetadata(valBytes, HoodieBootstrapFilePartitionInfo.class);
                BootstrapFileMapping mapping = new BootstrapFileMapping(this.bootstrapBasePath, fileInfo.getBootstrapPartitionPath(), fileInfo.getPartitionPath(), fileInfo.getBootstrapFileStatus(), fileGroupId.getFileId());
                result.put(fileGroupId, mapping);
            }
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
        return result;
    }

    @Override
    public void close() {
        try {
            if (this.indexByPartitionReader != null) {
                this.indexByPartitionReader.close();
                this.indexByPartitionReader = null;
            }
            if (this.indexByFileIdReader != null) {
                this.indexByFileIdReader.close();
                this.indexByFileIdReader = null;
            }
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }
}

