/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.sync.common.util.Parquet2SparkSchemaUtils;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class SparkDataSourceTableUtils {
    public static Map<String, String> getSparkTableProperties(List<String> partitionNames, String sparkVersion, int schemaLengthThreshold, MessageType schema) {
        int i;
        GroupType originGroupType = schema.asGroupType();
        ArrayList<PrimitiveType> partitionCols = new ArrayList<PrimitiveType>();
        ArrayList<Type> dataCols = new ArrayList<Type>();
        HashMap<String, Object> column2Field = new HashMap<String, Object>();
        for (Type field : originGroupType.getFields()) {
            column2Field.put(field.getName(), field);
        }
        for (String partitionName : partitionNames) {
            partitionCols.add(column2Field.getOrDefault(partitionName, new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, partitionName, OriginalType.UTF8)));
        }
        for (Type field : originGroupType.getFields()) {
            if (partitionNames.contains(field.getName())) continue;
            dataCols.add(field);
        }
        ArrayList<Object> reOrderedFields = new ArrayList<Object>();
        reOrderedFields.addAll(dataCols);
        reOrderedFields.addAll(partitionCols);
        GroupType reOrderedType = new GroupType(originGroupType.getRepetition(), originGroupType.getName(), reOrderedFields);
        HashMap<String, String> sparkProperties = new HashMap<String, String>();
        sparkProperties.put("spark.sql.sources.provider", "hudi");
        if (!StringUtils.isNullOrEmpty(sparkVersion)) {
            sparkProperties.put("spark.sql.create.version", sparkVersion);
        }
        String schemaString = Parquet2SparkSchemaUtils.convertToSparkSchemaJson(reOrderedType);
        int numSchemaPart = (schemaString.length() + schemaLengthThreshold - 1) / schemaLengthThreshold;
        sparkProperties.put("spark.sql.sources.schema.numParts", String.valueOf(numSchemaPart));
        for (i = 0; i < numSchemaPart; ++i) {
            int start = i * schemaLengthThreshold;
            int end = Math.min(start + schemaLengthThreshold, schemaString.length());
            sparkProperties.put("spark.sql.sources.schema.part." + i, schemaString.substring(start, end));
        }
        if (!partitionNames.isEmpty()) {
            sparkProperties.put("spark.sql.sources.schema.numPartCols", String.valueOf(partitionNames.size()));
            for (i = 0; i < partitionNames.size(); ++i) {
                sparkProperties.put("spark.sql.sources.schema.partCol." + i, partitionNames.get(i));
            }
        }
        return sparkProperties;
    }

    public static Map<String, String> getSparkSerdeProperties(boolean readAsOptimized, String basePath) {
        HashMap<String, String> sparkSerdeProperties = new HashMap<String, String>();
        sparkSerdeProperties.put("path", basePath);
        sparkSerdeProperties.put("hoodie.query.as.ro.table", String.valueOf(readAsOptimized));
        return sparkSerdeProperties;
    }
}

