/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.MockHoodieTimeline;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieFileGroup {
    @Test
    public void testCommittedFileSlices() {
        Stream completed = Arrays.asList("001").stream();
        Stream inflight = Arrays.asList("002").stream();
        MockHoodieTimeline activeTimeline = new MockHoodieTimeline(completed, inflight);
        HoodieFileGroup fileGroup = new HoodieFileGroup("", "data", activeTimeline.getCommitsTimeline().filterCompletedInstants());
        for (int i = 0; i < 3; ++i) {
            HoodieBaseFile baseFile = new HoodieBaseFile("data_1_00" + i);
            fileGroup.addBaseFile(baseFile);
        }
        Assertions.assertEquals((long)2L, (long)fileGroup.getAllFileSlices().count());
        Assertions.assertTrue((!fileGroup.getAllFileSlices().anyMatch(s -> s.getBaseInstantTime().equals("002")) ? 1 : 0) != 0);
        Assertions.assertEquals((long)3L, (long)fileGroup.getAllFileSlicesIncludingInflight().count());
        Assertions.assertTrue((boolean)((FileSlice)fileGroup.getLatestFileSlice().get()).getBaseInstantTime().equals("001"));
        Assertions.assertTrue((boolean)((FileSlice)new HoodieFileGroup(fileGroup).getLatestFileSlice().get()).getBaseInstantTime().equals("001"));
    }

    @Test
    public void testCommittedFileSlicesWithSavepointAndHoles() {
        MockHoodieTimeline activeTimeline = new MockHoodieTimeline(Stream.of(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "01"), new HoodieInstant(HoodieInstant.State.COMPLETED, "savepoint", "01"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "03"), new HoodieInstant(HoodieInstant.State.COMPLETED, "savepoint", "03"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "05")).collect(Collectors.toList()));
        HoodieFileGroup fileGroup = new HoodieFileGroup("", "data", activeTimeline.filterCompletedAndCompactionInstants());
        for (int i = 0; i < 7; ++i) {
            HoodieBaseFile baseFile = new HoodieBaseFile("data_1_0" + i);
            fileGroup.addBaseFile(baseFile);
        }
        List allFileSlices = fileGroup.getAllFileSlices().collect(Collectors.toList());
        Assertions.assertEquals((int)6, (int)allFileSlices.size());
        Assertions.assertTrue((!allFileSlices.stream().anyMatch(s -> s.getBaseInstantTime().equals("06")) ? 1 : 0) != 0);
        Assertions.assertEquals((long)7L, (long)fileGroup.getAllFileSlicesIncludingInflight().count());
        Assertions.assertTrue((boolean)((FileSlice)fileGroup.getLatestFileSlice().get()).getBaseInstantTime().equals("05"));
    }
}

