/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestHoodieTableConfig
extends HoodieCommonTestHarness {
    private HoodieStorage storage;
    private StoragePath metaPath;
    private StoragePath cfgPath;
    private StoragePath backupCfgPath;

    @BeforeEach
    public void setUp() throws Exception {
        this.initPath();
        this.storage = HoodieStorageUtils.getStorage((String)this.basePath, (StorageConfiguration)HoodieTestUtils.getDefaultStorageConfWithDefaults());
        this.metaPath = new StoragePath(this.basePath, ".hoodie");
        Properties props = new Properties();
        props.setProperty(HoodieTableConfig.NAME.key(), "test-table");
        HoodieTableConfig.create((HoodieStorage)this.storage, (StoragePath)this.metaPath, (Properties)props);
        this.cfgPath = new StoragePath(this.metaPath, "hoodie.properties");
        this.backupCfgPath = new StoragePath(this.metaPath, "hoodie.properties.backup");
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.storage.close();
    }

    @Test
    public void testCreate() throws IOException {
        Assertions.assertTrue((boolean)this.storage.exists(new StoragePath(this.metaPath, "hoodie.properties")));
        HoodieTableConfig config = new HoodieTableConfig(this.storage, this.metaPath, null, null);
        Assertions.assertEquals((int)6, (int)config.getProps().size());
    }

    @Test
    public void testUpdate() throws IOException {
        Properties updatedProps = new Properties();
        updatedProps.setProperty(HoodieTableConfig.NAME.key(), "test-table2");
        updatedProps.setProperty(HoodieTableConfig.PRECOMBINE_FIELD.key(), "new_field");
        HoodieTableConfig.update((HoodieStorage)this.storage, (StoragePath)this.metaPath, (Properties)updatedProps);
        Assertions.assertTrue((boolean)this.storage.exists(this.cfgPath));
        Assertions.assertFalse((boolean)this.storage.exists(this.backupCfgPath));
        HoodieTableConfig config = new HoodieTableConfig(this.storage, this.metaPath, null, null);
        Assertions.assertEquals((int)7, (int)config.getProps().size());
        Assertions.assertEquals((Object)"test-table2", (Object)config.getTableName());
        Assertions.assertEquals((Object)"new_field", (Object)config.getPreCombineField());
    }

    @Test
    public void testDelete() throws IOException {
        Set deletedProps = CollectionUtils.createSet((Object[])new String[]{HoodieTableConfig.ARCHIVELOG_FOLDER.key(), "hoodie.invalid.config"});
        HoodieTableConfig.delete((HoodieStorage)this.storage, (StoragePath)this.metaPath, (Set)deletedProps);
        Assertions.assertTrue((boolean)this.storage.exists(this.cfgPath));
        Assertions.assertFalse((boolean)this.storage.exists(this.backupCfgPath));
        HoodieTableConfig config = new HoodieTableConfig(this.storage, this.metaPath, null, null);
        Assertions.assertEquals((int)5, (int)config.getProps().size());
        Assertions.assertNull((Object)config.getProps().getProperty("hoodie.invalid.config"));
        Assertions.assertFalse((boolean)config.getProps().contains((Object)HoodieTableConfig.ARCHIVELOG_FOLDER.key()));
    }

    @Test
    public void testReadsWhenPropsFileDoesNotExist() throws IOException {
        this.storage.deleteFile(this.cfgPath);
        Assertions.assertThrows(HoodieIOException.class, () -> new HoodieTableConfig(this.storage, this.metaPath, null, null));
    }

    @Test
    public void testReadsWithUpdateFailures() throws IOException {
        HoodieTableConfig config = new HoodieTableConfig(this.storage, this.metaPath, null, null);
        this.storage.deleteFile(this.cfgPath);
        try (OutputStream out = this.storage.create(this.backupCfgPath);){
            config.getProps().store(out, "");
        }
        Assertions.assertFalse((boolean)this.storage.exists(this.cfgPath));
        Assertions.assertTrue((boolean)this.storage.exists(this.backupCfgPath));
        config = new HoodieTableConfig(this.storage, this.metaPath, null, null);
        Assertions.assertEquals((int)6, (int)config.getProps().size());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testUpdateRecovery(boolean shouldPropsFileExist) throws IOException {
        HoodieTableConfig config = new HoodieTableConfig(this.storage, this.metaPath, null, null);
        if (!shouldPropsFileExist) {
            this.storage.deleteFile(this.cfgPath);
        }
        try (OutputStream out = this.storage.create(this.backupCfgPath);){
            config.getProps().store(out, "");
        }
        HoodieTableConfig.recoverIfNeeded((HoodieStorage)this.storage, (StoragePath)this.cfgPath, (StoragePath)this.backupCfgPath);
        Assertions.assertTrue((boolean)this.storage.exists(this.cfgPath));
        Assertions.assertFalse((boolean)this.storage.exists(this.backupCfgPath));
        config = new HoodieTableConfig(this.storage, this.metaPath, null, null);
        Assertions.assertEquals((int)6, (int)config.getProps().size());
    }

    @Test
    public void testReadRetry() throws IOException {
        this.storage.rename(this.cfgPath, new StoragePath(this.cfgPath.toString() + ".bak"));
        Assertions.assertThrows(HoodieIOException.class, () -> new HoodieTableConfig(this.storage, this.metaPath, null, null));
        this.storage.rename(new StoragePath(this.cfgPath.toString() + ".bak"), this.backupCfgPath);
        new HoodieTableConfig(this.storage, this.metaPath, null, null);
        Properties props = new Properties();
        props.put(HoodieTableConfig.TABLE_CHECKSUM.key(), "0");
        try (OutputStream out = this.storage.create(this.cfgPath);){
            props.store(out, "Wrong checksum in file so is invalid");
        }
        new HoodieTableConfig(this.storage, this.metaPath, null, null);
        out = this.storage.create(this.backupCfgPath);
        var3_3 = null;
        try {
            props.store(out, "Wrong checksum in file so is invalid");
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (out != null) {
                if (var3_3 != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    out.close();
                }
            }
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new HoodieTableConfig(this.storage, this.metaPath, null, null));
    }

    @Test
    public void testConcurrentlyUpdate() throws ExecutionException, InterruptedException {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        Future<?> updaterFuture = executor.submit(() -> {
            for (int i = 0; i < 100; ++i) {
                Properties updatedProps = new Properties();
                updatedProps.setProperty(HoodieTableConfig.NAME.key(), "test-table" + i);
                updatedProps.setProperty(HoodieTableConfig.PRECOMBINE_FIELD.key(), "new_field" + i);
                HoodieTableConfig.update((HoodieStorage)this.storage, (StoragePath)this.metaPath, (Properties)updatedProps);
            }
        });
        Future<?> readerFuture = executor.submit(() -> {
            for (int i = 0; i < 100; ++i) {
                new HoodieTableConfig(this.storage, this.metaPath, null, null);
            }
        });
        updaterFuture.get();
        readerFuture.get();
        executor.shutdown();
    }
}

