/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.common.functional.TestHoodieLogFormat;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.internal.schema.HoodieSchemaException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestTableSchemaResolver {
    @TempDir
    public Path tempDir;

    @Test
    public void testRecreateSchemaWhenDropPartitionColumns() {
        Schema originSchema = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
        String[] pts1 = new String[]{};
        Schema s2 = TableSchemaResolver.appendPartitionColumns((Schema)originSchema, (Option)Option.of((Object)pts1));
        Assertions.assertEquals((Object)originSchema, (Object)s2);
        String[] pts2 = new String[]{"partition_path"};
        Schema s3 = TableSchemaResolver.appendPartitionColumns((Schema)originSchema, (Option)Option.of((Object)pts2));
        Assertions.assertEquals((Object)originSchema, (Object)s3);
        String[] pts3 = new String[]{"user_partition"};
        Schema s4 = TableSchemaResolver.appendPartitionColumns((Schema)originSchema, (Option)Option.of((Object)pts3));
        Assertions.assertNotEquals((Object)originSchema, (Object)s4);
        Assertions.assertTrue((boolean)s4.getFields().stream().anyMatch(f -> f.name().equals("user_partition")));
        Schema.Field f2 = s4.getField("user_partition");
        Assertions.assertEquals((Object)f2.schema(), (Object)AvroSchemaUtils.createNullableSchema((Schema.Type)Schema.Type.STRING));
        String[] pts4 = new String[]{"user_partition", "partition_path"};
        try {
            TableSchemaResolver.appendPartitionColumns((Schema)originSchema, (Option)Option.of((Object)pts3));
        }
        catch (HoodieSchemaException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Partial partition fields are still in the schema"));
        }
    }

    @Test
    public void testReadSchemaFromLogFile() throws IOException, URISyntaxException, InterruptedException {
        String testDir = this.initTestDir("read_schema_from_log_file");
        StoragePath partitionPath = new StoragePath(testDir, "partition1");
        Schema expectedSchema = SchemaTestUtil.getSimpleSchema();
        StoragePath logFilePath = this.writeLogFile(partitionPath, expectedSchema);
        Assertions.assertEquals((Object)expectedSchema, (Object)TableSchemaResolver.readSchemaFromLogFile((HoodieStorage)new HoodieHadoopStorage(logFilePath, HoodieTestUtils.getDefaultStorageConfWithDefaults()), (StoragePath)logFilePath));
    }

    private String initTestDir(String folderName) throws IOException {
        Path basePath = this.tempDir.resolve(folderName);
        Files.createDirectories(basePath, new FileAttribute[0]);
        return basePath.toString();
    }

    private StoragePath writeLogFile(StoragePath partitionPath, Schema schema) throws IOException, URISyntaxException, InterruptedException {
        HoodieStorage storage = HoodieTestUtils.getStorage((StoragePath)partitionPath);
        HoodieLogFormat.Writer writer = HoodieLogFormat.newWriterBuilder().onParentPath(partitionPath).withFileExtension(".log").withFileId("test-fileid1").overBaseCommit("100").withStorage(storage).build();
        List records = SchemaTestUtil.generateTestRecords((int)0, (int)100);
        HashMap<HoodieLogBlock.HeaderMetadataType, String> header = new HashMap<HoodieLogBlock.HeaderMetadataType, String>();
        header.put(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME, "100");
        header.put(HoodieLogBlock.HeaderMetadataType.SCHEMA, schema.toString());
        HoodieDataBlock dataBlock = TestHoodieLogFormat.getDataBlock(HoodieLogBlock.HoodieLogBlockType.AVRO_DATA_BLOCK, records, header);
        writer.appendBlock((HoodieLogBlock)dataBlock);
        writer.close();
        return writer.getLogFile().getPath();
    }
}

