/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanPartitionMetadata;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.MockHoodieTimeline;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestTimelineUtils
extends HoodieCommonTestHarness {
    @BeforeEach
    public void setUp() throws Exception {
        this.initMetaClient();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanMetaClient();
    }

    @Test
    public void testGetPartitionsWithReplaceCommits() throws IOException {
        HoodieActiveTimeline activeTimeline = this.metaClient.getActiveTimeline();
        HoodieTimeline activeCommitTimeline = activeTimeline.getCommitAndReplaceTimeline();
        Assertions.assertTrue((boolean)activeCommitTimeline.empty());
        String ts1 = "1";
        String replacePartition = "2021/01/01";
        String newFilePartition = "2021/01/02";
        HoodieInstant instant1 = new HoodieInstant(true, "replacecommit", ts1);
        activeTimeline.createNewInstant(instant1);
        activeTimeline.saveAsComplete(instant1, Option.of((Object)this.getReplaceCommitMetadata(this.basePath, ts1, replacePartition, 2, newFilePartition, 0, Collections.emptyMap(), WriteOperationType.CLUSTER)));
        this.metaClient.reloadActiveTimeline();
        List partitions = TimelineUtils.getAffectedPartitions((HoodieTimeline)this.metaClient.getActiveTimeline().findInstantsAfter("0", 10));
        Assertions.assertEquals((int)1, (int)partitions.size());
        Assertions.assertEquals((Object)replacePartition, partitions.get(0));
        String ts2 = "2";
        HoodieInstant instant2 = new HoodieInstant(true, "replacecommit", ts2);
        activeTimeline.createNewInstant(instant2);
        activeTimeline.saveAsComplete(instant2, Option.of((Object)this.getReplaceCommitMetadata(this.basePath, ts2, replacePartition, 0, newFilePartition, 3, Collections.emptyMap(), WriteOperationType.CLUSTER)));
        this.metaClient.reloadActiveTimeline();
        partitions = TimelineUtils.getAffectedPartitions((HoodieTimeline)this.metaClient.getActiveTimeline().findInstantsAfter("1", 10));
        Assertions.assertEquals((int)1, (int)partitions.size());
        Assertions.assertEquals((Object)newFilePartition, partitions.get(0));
        partitions = TimelineUtils.getAffectedPartitions((HoodieTimeline)this.metaClient.getActiveTimeline().findInstantsAfter("0", 10));
        Assertions.assertEquals((int)2, (int)partitions.size());
        Assertions.assertTrue((boolean)partitions.contains(replacePartition));
        Assertions.assertTrue((boolean)partitions.contains(newFilePartition));
    }

    @Test
    public void testGetPartitions() throws IOException {
        HoodieActiveTimeline activeTimeline = this.metaClient.getActiveTimeline();
        HoodieTimeline activeCommitTimeline = activeTimeline.getCommitAndReplaceTimeline();
        Assertions.assertTrue((boolean)activeCommitTimeline.empty());
        String olderPartition = "0";
        for (int i = 1; i <= 5; ++i) {
            String ts = i + "";
            HoodieInstant instant = new HoodieInstant(true, "commit", ts);
            activeTimeline.createNewInstant(instant);
            activeTimeline.saveAsComplete(instant, Option.of((Object)this.getCommitMetadata(this.basePath, ts, ts, 2, Collections.emptyMap())));
            HoodieInstant cleanInstant = new HoodieInstant(true, "clean", ts);
            activeTimeline.createNewInstant(cleanInstant);
            activeTimeline.saveAsComplete(cleanInstant, this.getCleanMetadata(olderPartition, ts, false));
        }
        this.metaClient.reloadActiveTimeline();
        List partitions = TimelineUtils.getAffectedPartitions((HoodieTimeline)this.metaClient.getActiveTimeline().findInstantsAfter("1", 10));
        Assertions.assertEquals((int)5, (int)partitions.size());
        Assertions.assertEquals((Object)partitions, Arrays.asList("0", "2", "3", "4", "5"));
        partitions = TimelineUtils.getAffectedPartitions((HoodieTimeline)this.metaClient.getActiveTimeline().findInstantsInRange("1", "4"));
        Assertions.assertEquals((int)4, (int)partitions.size());
        Assertions.assertEquals((Object)partitions, Arrays.asList("0", "2", "3", "4"));
        partitions = TimelineUtils.getWrittenPartitions((HoodieTimeline)this.metaClient.getActiveTimeline().findInstantsAfter("1", 10));
        Assertions.assertEquals((int)4, (int)partitions.size());
        Assertions.assertEquals((Object)partitions, Arrays.asList("2", "3", "4", "5"));
        partitions = TimelineUtils.getWrittenPartitions((HoodieTimeline)this.metaClient.getActiveTimeline().findInstantsInRange("1", "4"));
        Assertions.assertEquals((int)3, (int)partitions.size());
        Assertions.assertEquals((Object)partitions, Arrays.asList("2", "3", "4"));
    }

    @Test
    public void testGetPartitionsUnPartitioned() throws IOException {
        HoodieActiveTimeline activeTimeline = this.metaClient.getActiveTimeline();
        HoodieTimeline activeCommitTimeline = activeTimeline.getCommitAndReplaceTimeline();
        Assertions.assertTrue((boolean)activeCommitTimeline.empty());
        String partitionPath = "";
        for (int i = 1; i <= 5; ++i) {
            String ts = i + "";
            HoodieInstant instant = new HoodieInstant(true, "commit", ts);
            activeTimeline.createNewInstant(instant);
            activeTimeline.saveAsComplete(instant, Option.of((Object)this.getCommitMetadata(this.basePath, partitionPath, ts, 2, Collections.emptyMap())));
            HoodieInstant cleanInstant = new HoodieInstant(true, "clean", ts);
            activeTimeline.createNewInstant(cleanInstant);
            activeTimeline.saveAsComplete(cleanInstant, this.getCleanMetadata(partitionPath, ts, false));
        }
        this.metaClient.reloadActiveTimeline();
        List partitions = TimelineUtils.getAffectedPartitions((HoodieTimeline)this.metaClient.getActiveTimeline().findInstantsAfter("1", 10));
        Assertions.assertTrue((boolean)partitions.isEmpty());
        partitions = TimelineUtils.getAffectedPartitions((HoodieTimeline)this.metaClient.getActiveTimeline().findInstantsInRange("1", "4"));
        Assertions.assertTrue((boolean)partitions.isEmpty());
    }

    @Test
    public void testRestoreInstants() throws Exception {
        HoodieActiveTimeline activeTimeline = this.metaClient.getActiveTimeline();
        HoodieTimeline activeCommitTimeline = activeTimeline.getCommitAndReplaceTimeline();
        Assertions.assertTrue((boolean)activeCommitTimeline.empty());
        for (int i = 1; i <= 5; ++i) {
            String ts = i + "";
            HoodieInstant instant = new HoodieInstant(true, "restore", ts);
            activeTimeline.createNewInstant(instant);
            activeTimeline.saveAsComplete(instant, Option.of((Object)this.getRestoreMetadata(this.basePath, ts, ts, 2, "commit")));
        }
        this.metaClient.reloadActiveTimeline();
        List partitions = TimelineUtils.getAffectedPartitions((HoodieTimeline)this.metaClient.getActiveTimeline().findInstantsAfter("1", 10));
        Assertions.assertEquals((Object)partitions, Arrays.asList("2", "3", "4", "5"));
        partitions = TimelineUtils.getAffectedPartitions((HoodieTimeline)this.metaClient.getActiveTimeline().findInstantsInRange("1", "4"));
        Assertions.assertEquals((Object)partitions, Arrays.asList("2", "3", "4"));
    }

    @Test
    public void testGetExtraMetadata() throws Exception {
        String extraMetadataKey = "test_key";
        String extraMetadataValue1 = "test_value1";
        HoodieActiveTimeline activeTimeline = this.metaClient.getActiveTimeline();
        HoodieTimeline activeCommitTimeline = activeTimeline.getCommitAndReplaceTimeline();
        Assertions.assertTrue((boolean)activeCommitTimeline.empty());
        Assertions.assertFalse((boolean)TimelineUtils.getExtraMetadataFromLatest((HoodieTableMetaClient)this.metaClient, (String)extraMetadataKey).isPresent());
        String ts = "0";
        HoodieInstant instant = new HoodieInstant(true, "commit", ts);
        activeTimeline.createNewInstant(instant);
        activeTimeline.saveAsComplete(instant, Option.of((Object)this.getCommitMetadata(this.basePath, ts, ts, 2, Collections.emptyMap())));
        ts = "1";
        instant = new HoodieInstant(true, "commit", ts);
        activeTimeline.createNewInstant(instant);
        HashMap<String, String> extraMetadata = new HashMap<String, String>();
        extraMetadata.put(extraMetadataKey, extraMetadataValue1);
        activeTimeline.saveAsComplete(instant, Option.of((Object)this.getCommitMetadata(this.basePath, ts, ts, 2, extraMetadata)));
        this.metaClient.reloadActiveTimeline();
        this.verifyExtraMetadataLatestValue(extraMetadataKey, extraMetadataValue1, false);
        Assertions.assertFalse((boolean)TimelineUtils.getExtraMetadataFromLatest((HoodieTableMetaClient)this.metaClient, (String)"unknownKey").isPresent());
        String ts2 = "2";
        HoodieInstant instant2 = new HoodieInstant(true, "replacecommit", ts2);
        activeTimeline.createNewInstant(instant2);
        String newValueForMetadata = "newValue2";
        extraMetadata.put(extraMetadataKey, newValueForMetadata);
        activeTimeline.saveAsComplete(instant2, Option.of((Object)this.getReplaceCommitMetadata(this.basePath, ts2, "p2", 0, "p2", 3, extraMetadata, WriteOperationType.CLUSTER)));
        this.metaClient.reloadActiveTimeline();
        this.verifyExtraMetadataLatestValue(extraMetadataKey, extraMetadataValue1, false);
        this.verifyExtraMetadataLatestValue(extraMetadataKey, newValueForMetadata, true);
        Assertions.assertFalse((boolean)TimelineUtils.getExtraMetadataFromLatest((HoodieTableMetaClient)this.metaClient, (String)"unknownKey").isPresent());
        Map extraMetadataEntries = TimelineUtils.getAllExtraMetadataForKey((HoodieTableMetaClient)this.metaClient, (String)extraMetadataKey);
        Assertions.assertEquals((int)3, (int)extraMetadataEntries.size());
        Assertions.assertFalse((boolean)((Option)extraMetadataEntries.get("0")).isPresent());
        Assertions.assertTrue((boolean)((Option)extraMetadataEntries.get("1")).isPresent());
        Assertions.assertEquals((Object)extraMetadataValue1, (Object)((Option)extraMetadataEntries.get("1")).get());
        Assertions.assertTrue((boolean)((Option)extraMetadataEntries.get("2")).isPresent());
        Assertions.assertEquals((Object)newValueForMetadata, (Object)((Option)extraMetadataEntries.get("2")).get());
    }

    @Test
    public void testGetCommitsTimelineAfter() throws IOException {
        String startTs = "010";
        HoodieTableMetaClient mockMetaClient = this.prepareMetaClient(Arrays.asList(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "009", "013"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "010", "010"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "011", "011"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "012", "012")), Arrays.asList(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "001", "001"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "002", "002")), startTs);
        this.verifyTimeline(Arrays.asList(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "009"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "011"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "012")), TimelineUtils.getCommitsTimelineAfter((HoodieTableMetaClient)mockMetaClient, (String)startTs, (Option)Option.of((Object)startTs)));
        ((HoodieTableMetaClient)Mockito.verify((Object)mockMetaClient, (VerificationMode)Mockito.never())).getArchivedTimeline((String)ArgumentMatchers.any());
        startTs = "001";
        mockMetaClient = this.prepareMetaClient(Arrays.asList(new HoodieInstant(HoodieInstant.State.COMPLETED, "rollback", "009", "009"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "010", "010"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "011", "011"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "012", "012")), Arrays.asList(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "001", "001"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "002", "002")), startTs);
        this.verifyTimeline(Arrays.asList(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "002", "002"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "010", "010"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "011", "011"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "012", "012")), TimelineUtils.getCommitsTimelineAfter((HoodieTableMetaClient)mockMetaClient, (String)startTs, (Option)Option.of((Object)startTs)));
        ((HoodieTableMetaClient)Mockito.verify((Object)mockMetaClient, (VerificationMode)Mockito.times((int)1))).getArchivedTimeline((String)ArgumentMatchers.any());
        startTs = "005";
        mockMetaClient = this.prepareMetaClient(Arrays.asList(new HoodieInstant(HoodieInstant.State.COMPLETED, "rollback", "003", "003"), new HoodieInstant(HoodieInstant.State.COMPLETED, "rollback", "007", "007"), new HoodieInstant(HoodieInstant.State.COMPLETED, "rollback", "009", "009"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "010", "010"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "011", "011"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "012", "012")), Arrays.asList(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "001", "001"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "002", "002"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "005", "005"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "006", "006"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "008", "008")), startTs);
        this.verifyTimeline(Arrays.asList(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "006", "006"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "008", "008"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "010", "010"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "011", "011"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "012", "012")), TimelineUtils.getCommitsTimelineAfter((HoodieTableMetaClient)mockMetaClient, (String)startTs, (Option)Option.of((Object)startTs)));
        ((HoodieTableMetaClient)Mockito.verify((Object)mockMetaClient, (VerificationMode)Mockito.times((int)1))).getArchivedTimeline((String)ArgumentMatchers.any());
    }

    private HoodieTableMetaClient prepareMetaClient(List<HoodieInstant> activeInstants, List<HoodieInstant> archivedInstants, String startTs) throws IOException {
        HoodieTableMetaClient mockMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        HoodieArchivedTimeline mockArchivedTimeline = (HoodieArchivedTimeline)Mockito.mock(HoodieArchivedTimeline.class);
        Mockito.when((Object)mockMetaClient.scanHoodieInstantsFromFileSystem((Set)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true))).thenReturn(activeInstants);
        HoodieActiveTimeline activeTimeline = new HoodieActiveTimeline(mockMetaClient);
        Mockito.when((Object)mockMetaClient.getActiveTimeline()).thenReturn((Object)activeTimeline);
        Set validWriteActions = CollectionUtils.createSet((Object[])new String[]{"commit", "deltacommit", "compaction", "logcompaction", "replacecommit"});
        Mockito.when((Object)mockMetaClient.getArchivedTimeline((String)ArgumentMatchers.any())).thenReturn((Object)mockArchivedTimeline);
        HoodieDefaultTimeline mergedTimeline = new HoodieDefaultTimeline(archivedInstants.stream().filter(instant -> instant.getTimestamp().compareTo(startTs) >= 0), i -> Option.empty()).mergeTimeline((HoodieDefaultTimeline)activeTimeline);
        Mockito.when((Object)mockArchivedTimeline.mergeTimeline((HoodieDefaultTimeline)ArgumentMatchers.eq((Object)activeTimeline))).thenReturn((Object)mergedTimeline);
        HoodieDefaultTimeline mergedWriteTimeline = new HoodieDefaultTimeline(archivedInstants.stream().filter(instant -> instant.getTimestamp().compareTo(startTs) >= 0), i -> Option.empty()).mergeTimeline(activeTimeline.getWriteTimeline());
        Mockito.when((Object)mockArchivedTimeline.mergeTimeline((HoodieDefaultTimeline)ArgumentMatchers.argThat(timeline -> timeline.filter(instant -> instant.getAction().equals("rollback")).countInstants() == 0))).thenReturn((Object)mergedWriteTimeline);
        return mockMetaClient;
    }

    public void verifyTimeline(List<HoodieInstant> expectedInstants, HoodieTimeline timeline) {
        Assertions.assertEquals(expectedInstants.stream().sorted().collect(Collectors.toList()), timeline.getInstants().stream().sorted().collect(Collectors.toList()));
    }

    @Test
    public void testGetEarliestInstantForMetadataArchival() throws IOException {
        Assertions.assertEquals((Object)Option.empty(), (Object)TimelineUtils.getEarliestInstantForMetadataArchival((HoodieActiveTimeline)this.prepareActiveTimeline(new ArrayList<HoodieInstant>()), (boolean)false));
        Assertions.assertEquals((Object)Option.of((Object)new HoodieInstant(HoodieInstant.State.REQUESTED, "clean", "003")), (Object)TimelineUtils.getEarliestInstantForMetadataArchival((HoodieActiveTimeline)this.prepareActiveTimeline(Arrays.asList(new HoodieInstant(HoodieInstant.State.COMPLETED, "rollback", "001"), new HoodieInstant(HoodieInstant.State.COMPLETED, "clean", "002"), new HoodieInstant(HoodieInstant.State.REQUESTED, "clean", "003"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "010"), new HoodieInstant(HoodieInstant.State.COMPLETED, "replacecommit", "011"))), (boolean)false));
        Assertions.assertEquals((Object)Option.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "010")), (Object)TimelineUtils.getEarliestInstantForMetadataArchival((HoodieActiveTimeline)this.prepareActiveTimeline(Arrays.asList(new HoodieInstant(HoodieInstant.State.COMPLETED, "rollback", "001"), new HoodieInstant(HoodieInstant.State.COMPLETED, "clean", "002"), new HoodieInstant(HoodieInstant.State.COMPLETED, "clean", "003"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "010"), new HoodieInstant(HoodieInstant.State.COMPLETED, "replacecommit", "011"))), (boolean)false));
        Assertions.assertEquals((Object)Option.of((Object)new HoodieInstant(HoodieInstant.State.INFLIGHT, "rollback", "003")), (Object)TimelineUtils.getEarliestInstantForMetadataArchival((HoodieActiveTimeline)this.prepareActiveTimeline(Arrays.asList(new HoodieInstant(HoodieInstant.State.COMPLETED, "rollback", "001"), new HoodieInstant(HoodieInstant.State.COMPLETED, "rollback", "002"), new HoodieInstant(HoodieInstant.State.INFLIGHT, "rollback", "003"))), (boolean)false));
        Assertions.assertEquals((Object)Option.empty(), (Object)TimelineUtils.getEarliestInstantForMetadataArchival((HoodieActiveTimeline)this.prepareActiveTimeline(Arrays.asList(new HoodieInstant(HoodieInstant.State.COMPLETED, "rollback", "001"), new HoodieInstant(HoodieInstant.State.COMPLETED, "rollback", "002"), new HoodieInstant(HoodieInstant.State.COMPLETED, "rollback", "003"))), (boolean)false));
        HoodieActiveTimeline timeline = this.prepareActiveTimeline(Arrays.asList(new HoodieInstant(HoodieInstant.State.COMPLETED, "rollback", "001"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "003"), new HoodieInstant(HoodieInstant.State.COMPLETED, "savepoint", "003"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "010"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "011")));
        Assertions.assertEquals((Object)Option.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "003")), (Object)TimelineUtils.getEarliestInstantForMetadataArchival((HoodieActiveTimeline)timeline, (boolean)false));
        Assertions.assertEquals((Object)Option.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "010")), (Object)TimelineUtils.getEarliestInstantForMetadataArchival((HoodieActiveTimeline)timeline, (boolean)true));
    }

    private HoodieActiveTimeline prepareActiveTimeline(List<HoodieInstant> activeInstants) throws IOException {
        HoodieTableMetaClient mockMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        Mockito.when((Object)mockMetaClient.scanHoodieInstantsFromFileSystem((Set)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true))).thenReturn(activeInstants);
        return new HoodieActiveTimeline(mockMetaClient);
    }

    private void verifyExtraMetadataLatestValue(String extraMetadataKey, String expected, boolean includeClustering) {
        Option extraLatestValue = includeClustering ? TimelineUtils.getExtraMetadataFromLatestIncludeClustering((HoodieTableMetaClient)this.metaClient, (String)extraMetadataKey) : TimelineUtils.getExtraMetadataFromLatest((HoodieTableMetaClient)this.metaClient, (String)extraMetadataKey);
        Assertions.assertTrue((boolean)extraLatestValue.isPresent());
        Assertions.assertEquals((Object)expected, (Object)extraLatestValue.get());
    }

    private byte[] getRestoreMetadata(String basePath, String partition, String commitTs, int count, String actionType) throws IOException {
        ArrayList<HoodieRollbackMetadata> rollbackM = new ArrayList<HoodieRollbackMetadata>();
        rollbackM.add(this.getRollbackMetadataInstance(basePath, partition, commitTs, count, actionType));
        ArrayList<HoodieInstant> rollbackInstants = new ArrayList<HoodieInstant>();
        rollbackInstants.add(new HoodieInstant(false, commitTs, actionType));
        HoodieRestoreMetadata metadata = TimelineMetadataUtils.convertRestoreMetadata((String)commitTs, (long)200L, rollbackInstants, Collections.singletonMap(commitTs, rollbackM));
        return (byte[])TimelineMetadataUtils.serializeRestoreMetadata((HoodieRestoreMetadata)metadata).get();
    }

    private HoodieRollbackMetadata getRollbackMetadataInstance(String basePath, String partition, String commitTs, int count, String actionType) {
        ArrayList<String> deletedFiles = new ArrayList<String>();
        for (int i = 1; i <= count; ++i) {
            deletedFiles.add("file-" + i);
        }
        ArrayList<HoodieInstant> rollbacks = new ArrayList<HoodieInstant>();
        rollbacks.add(new HoodieInstant(false, actionType, commitTs));
        HoodieRollbackStat rollbackStat = new HoodieRollbackStat(partition, deletedFiles, Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap());
        ArrayList<HoodieRollbackStat> rollbackStats = new ArrayList<HoodieRollbackStat>();
        rollbackStats.add(rollbackStat);
        return TimelineMetadataUtils.convertRollbackMetadata((String)commitTs, (Option)Option.empty(), rollbacks, rollbackStats);
    }

    private byte[] getCommitMetadata(String basePath, String partition, String commitTs, int count, Map<String, String> extraMetadata) throws IOException {
        HoodieCommitMetadata commit = new HoodieCommitMetadata();
        for (int i = 1; i <= count; ++i) {
            HoodieWriteStat stat = new HoodieWriteStat();
            stat.setFileId(i + "");
            stat.setPartitionPath(Paths.get(basePath, partition).toString());
            stat.setPath(commitTs + "." + i + this.metaClient.getTableConfig().getBaseFileFormat().getFileExtension());
            commit.addWriteStat(partition, stat);
        }
        for (Map.Entry<String, String> extraEntries : extraMetadata.entrySet()) {
            commit.addMetadata(extraEntries.getKey(), extraEntries.getValue());
        }
        return StringUtils.getUTF8Bytes((String)commit.toJsonString());
    }

    private byte[] getReplaceCommitMetadata(String basePath, String commitTs, String replacePartition, int replaceCount, String newFilePartition, int newFileCount, Map<String, String> extraMetadata, WriteOperationType operationType) throws IOException {
        HoodieReplaceCommitMetadata commit = new HoodieReplaceCommitMetadata();
        commit.setOperationType(operationType);
        for (int i = 1; i <= newFileCount; ++i) {
            HoodieWriteStat stat = new HoodieWriteStat();
            stat.setFileId(i + "");
            stat.setPartitionPath(Paths.get(basePath, newFilePartition).toString());
            stat.setPath(commitTs + "." + i + this.metaClient.getTableConfig().getBaseFileFormat().getFileExtension());
            commit.addWriteStat(newFilePartition, stat);
        }
        HashMap partitionToReplaceFileIds = new HashMap();
        if (replaceCount > 0) {
            partitionToReplaceFileIds.put(replacePartition, new ArrayList());
        }
        for (int i = 1; i <= replaceCount; ++i) {
            ((List)partitionToReplaceFileIds.get(replacePartition)).add(FSUtils.createNewFileIdPfx());
        }
        commit.setPartitionToReplaceFileIds(partitionToReplaceFileIds);
        for (Map.Entry<String, String> extraEntries : extraMetadata.entrySet()) {
            commit.addMetadata(extraEntries.getKey(), extraEntries.getValue());
        }
        return StringUtils.getUTF8Bytes((String)commit.toJsonString());
    }

    private Option<byte[]> getCleanMetadata(String partition, String time, boolean isPartitionDeleted) throws IOException {
        HashMap<String, HoodieCleanPartitionMetadata> partitionToFilesCleaned = new HashMap<String, HoodieCleanPartitionMetadata>();
        ArrayList<String> filesDeleted = new ArrayList<String>();
        filesDeleted.add("file-" + partition + "-" + time + "1");
        filesDeleted.add("file-" + partition + "-" + time + "2");
        HoodieCleanPartitionMetadata partitionMetadata = HoodieCleanPartitionMetadata.newBuilder().setPartitionPath(partition).setPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS.name()).setFailedDeleteFiles(Collections.emptyList()).setDeletePathPatterns(Collections.emptyList()).setSuccessDeleteFiles(filesDeleted).setIsPartitionDeleted(Boolean.valueOf(isPartitionDeleted)).build();
        partitionToFilesCleaned.putIfAbsent(partition, partitionMetadata);
        HoodieCleanMetadata cleanMetadata = HoodieCleanMetadata.newBuilder().setVersion(Integer.valueOf(1)).setTimeTakenInMillis(100L).setTotalFilesDeleted(1).setStartCleanTime(time).setEarliestCommitToRetain(time).setLastCompletedCommitTimestamp("").setPartitionMetadata(partitionToFilesCleaned).build();
        return TimelineMetadataUtils.serializeCleanMetadata((HoodieCleanMetadata)cleanMetadata);
    }

    @ParameterizedTest
    @EnumSource(value=TimelineUtils.HollowCommitHandling.class)
    public void testHandleHollowCommitIfNeeded(TimelineUtils.HollowCommitHandling handlingMode) throws Exception {
        HoodieTestTable.of(this.metaClient).addCommit("001").addInflightCommit("003").addCommit("005");
        Stream<String> completed = Stream.of("001", "005");
        MockHoodieTimeline completedTimeline = new MockHoodieTimeline(completed, Stream.empty());
        switch (handlingMode) {
            case FAIL: {
                HoodieException e = (HoodieException)Assertions.assertThrows(HoodieException.class, () -> this.lambda$testHandleHollowCommitIfNeeded$6((HoodieTimeline)completedTimeline, handlingMode));
                Assertions.assertTrue((boolean)e.getMessage().startsWith("Found hollow commit:"));
                break;
            }
            case BLOCK: {
                HoodieTimeline filteredTimeline = TimelineUtils.handleHollowCommitIfNeeded((HoodieTimeline)completedTimeline, (HoodieTableMetaClient)this.metaClient, (TimelineUtils.HollowCommitHandling)handlingMode);
                Assertions.assertTrue((boolean)filteredTimeline.containsInstant("001"));
                Assertions.assertFalse((boolean)filteredTimeline.containsInstant("003"));
                Assertions.assertFalse((boolean)filteredTimeline.containsInstant("005"));
                break;
            }
            case USE_TRANSITION_TIME: {
                HoodieTimeline filteredTimeline = TimelineUtils.handleHollowCommitIfNeeded((HoodieTimeline)completedTimeline, (HoodieTableMetaClient)this.metaClient, (TimelineUtils.HollowCommitHandling)handlingMode);
                Assertions.assertTrue((boolean)filteredTimeline.containsInstant("001"));
                Assertions.assertFalse((boolean)filteredTimeline.containsInstant("003"));
                Assertions.assertTrue((boolean)filteredTimeline.containsInstant("005"));
                break;
            }
            default: {
                Assertions.fail((String)"should cover all handling mode.");
            }
        }
    }

    @Test
    public void testGetDroppedPartitions() throws Exception {
        HoodieActiveTimeline activeTimeline = this.metaClient.getActiveTimeline();
        HoodieTimeline activeCommitTimeline = activeTimeline.getCommitAndReplaceTimeline();
        Assertions.assertTrue((boolean)activeCommitTimeline.empty());
        String olderPartition = "p1";
        HoodieInstant instant1 = new HoodieInstant(true, "commit", "00001");
        activeTimeline.createNewInstant(instant1);
        activeTimeline.saveAsComplete(instant1, Option.of((Object)this.getCommitMetadata(this.basePath, olderPartition, "00001", 2, Collections.emptyMap())));
        this.metaClient.reloadActiveTimeline();
        List droppedPartitions = TimelineUtils.getDroppedPartitions((HoodieTableMetaClient)this.metaClient, (Option)Option.empty(), (Option)Option.empty());
        Assertions.assertEquals((int)0, (int)droppedPartitions.size());
        HoodieInstant instant2 = new HoodieInstant(true, "commit", "00002");
        activeTimeline.createNewInstant(instant2);
        activeTimeline.saveAsComplete(instant2, Option.of((Object)this.getCommitMetadata(this.basePath, "p2", "00002", 2, Collections.emptyMap())));
        this.metaClient.reloadActiveTimeline();
        droppedPartitions = TimelineUtils.getDroppedPartitions((HoodieTableMetaClient)this.metaClient, (Option)Option.empty(), (Option)Option.empty());
        Assertions.assertEquals((int)0, (int)droppedPartitions.size());
        HoodieInstant cleanInstant = new HoodieInstant(true, "clean", "00003");
        activeTimeline.createNewInstant(cleanInstant);
        activeTimeline.saveAsComplete(cleanInstant, this.getCleanMetadata(olderPartition, "00003", true));
        this.metaClient.reloadActiveTimeline();
        droppedPartitions = TimelineUtils.getDroppedPartitions((HoodieTableMetaClient)this.metaClient, (Option)Option.empty(), (Option)Option.empty());
        Assertions.assertEquals((int)1, (int)droppedPartitions.size());
        Assertions.assertEquals((Object)olderPartition, droppedPartitions.get(0));
    }

    private /* synthetic */ void lambda$testHandleHollowCommitIfNeeded$6(HoodieTimeline completedTimeline, TimelineUtils.HollowCommitHandling handlingMode) throws Throwable {
        TimelineUtils.handleHollowCommitIfNeeded((HoodieTimeline)completedTimeline, (HoodieTableMetaClient)this.metaClient, (TimelineUtils.HollowCommitHandling)handlingMode);
    }
}

