/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.hudi.common.table.log.LogReaderUtils;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.roaringbitmap.longlong.Roaring64NavigableMap;

public class TestLogReaderUtils {
    @Test
    public void testEncodeAndDecodePositions() throws IOException {
        List<Long> positions = TestLogReaderUtils.generatePositions();
        String content = LogReaderUtils.encodePositions(positions);
        Roaring64NavigableMap roaring64NavigableMap = LogReaderUtils.decodeRecordPositionsHeader((String)content);
        TestLogReaderUtils.assertPositionEquals(positions, roaring64NavigableMap);
    }

    @Test
    public void testEncodeBitmapAndDecodePositions() throws IOException {
        Roaring64NavigableMap positionBitmap = new Roaring64NavigableMap();
        List<Long> positions = TestLogReaderUtils.generatePositions();
        positions.forEach(xva$0 -> positionBitmap.add(new long[]{xva$0}));
        String content = LogReaderUtils.encodePositions((Roaring64NavigableMap)positionBitmap);
        Roaring64NavigableMap roaring64NavigableMap = LogReaderUtils.decodeRecordPositionsHeader((String)content);
        TestLogReaderUtils.assertPositionEquals(positions, roaring64NavigableMap);
    }

    @Test
    public void testCompatibilityOfDecodingPositions() throws IOException {
        List<Long> expectedPositions = Arrays.stream(HoodieTestTable.readLastLineFromResourceFile("/format/expected_record_positions.data").split(",")).map(Long::parseLong).collect(Collectors.toList());
        String content = HoodieTestTable.readLastLineFromResourceFile("/format/record_positions_header_v3.data");
        Roaring64NavigableMap roaring64NavigableMap = LogReaderUtils.decodeRecordPositionsHeader((String)content);
        TestLogReaderUtils.assertPositionEquals(expectedPositions, roaring64NavigableMap);
    }

    public static List<Long> generatePositions() {
        Random random = new Random(8227L);
        HashSet<Long> positions = new HashSet<Long>();
        while (positions.size() < 1000) {
            long pos = Math.abs(random.nextLong() % 1000000000000L);
            positions.add(pos);
        }
        return new ArrayList<Long>(positions);
    }

    public static void assertPositionEquals(List<Long> expectedPositions, Roaring64NavigableMap roaring64NavigableMap) {
        List sortedExpectedPositions = expectedPositions.stream().sorted().collect(Collectors.toList());
        Iterator expectedIterator = sortedExpectedPositions.iterator();
        Iterator iterator = roaring64NavigableMap.iterator();
        while (expectedIterator.hasNext() && iterator.hasNext()) {
            Assertions.assertEquals((Long)((Long)expectedIterator.next()), (Long)((Long)iterator.next()));
        }
        Assertions.assertFalse((boolean)expectedIterator.hasNext());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }
}

