/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.StorageConfiguration;
import org.junit.jupiter.api.io.TempDir;

public class HoodieCommonTestHarness {
    protected static final String BASE_FILE_EXTENSION = ((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension();
    protected String tableName;
    protected String basePath;
    protected URI baseUri;
    protected HoodieTestDataGenerator dataGen;
    protected HoodieTableMetaClient metaClient;
    @TempDir
    public Path tempDir;

    protected void setTableName(String tableName) {
        this.tableName = tableName;
    }

    protected void initPath() {
        this.initPath("dataset");
    }

    protected void initPath(String folderName) {
        try {
            Path basePath = this.tempDir.resolve(folderName);
            Files.createDirectories(basePath, new FileAttribute[0]);
            this.basePath = basePath.toAbsolutePath().toString();
            this.baseUri = basePath.toUri();
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    protected void initTestDataGenerator() {
        this.dataGen = new HoodieTestDataGenerator();
    }

    protected void initTestDataGenerator(String[] partitionPaths) {
        this.dataGen = new HoodieTestDataGenerator(partitionPaths);
    }

    protected void cleanupTestDataGenerator() {
        if (this.dataGen != null) {
            this.dataGen = null;
        }
    }

    protected void initMetaClient() throws IOException {
        if (this.basePath == null) {
            this.initPath();
        }
        this.metaClient = HoodieTestUtils.init((String)this.basePath, (HoodieTableType)this.getTableType());
    }

    protected void cleanMetaClient() {
        if (this.metaClient != null) {
            this.metaClient = null;
        }
    }

    protected void refreshFsView() throws IOException {
        this.metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)this.metaClient.getStorageConf(), (String)this.basePath);
    }

    protected SyncableFileSystemView getFileSystemView(HoodieTimeline timeline) throws IOException {
        return this.getFileSystemView(timeline, false);
    }

    protected SyncableFileSystemView getFileSystemView(HoodieTimeline timeline, boolean enableIncrementalTimelineSync) {
        return new HoodieTableFileSystemView(this.metaClient, timeline, enableIncrementalTimelineSync);
    }

    protected SyncableFileSystemView getFileSystemView(HoodieTableMetaClient metaClient) throws IOException {
        return this.getFileSystemView(metaClient, metaClient.getActiveTimeline().filterCompletedOrMajorOrMinorCompactionInstants());
    }

    protected SyncableFileSystemView getFileSystemView(HoodieTableMetaClient metaClient, HoodieTimeline timeline) throws IOException {
        return this.getFileSystemView(timeline, true);
    }

    protected SyncableFileSystemView getFileSystemViewWithUnCommittedSlices(HoodieTableMetaClient metaClient) {
        try {
            return new HoodieTableFileSystemView(metaClient, (HoodieTimeline)metaClient.getActiveTimeline(), HoodieTestTable.of(metaClient).listAllBaseAndLogFiles());
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Error getting file system view", ioe);
        }
    }

    protected HoodieTableType getTableType() {
        return HoodieTableType.COPY_ON_WRITE;
    }
}

