/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Paths;
import java.time.Instant;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.TablePathUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public final class TestTablePathUtils {
    private static final String BASE_FILE_EXTENSION = ((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension();
    @TempDir
    public File tempDir;
    private static HoodieStorage storage;
    private static StoragePath tablePath;
    private static StoragePath partitionPath1;
    private static StoragePath partitionPath2;
    private static StoragePath filePath1;
    private static StoragePath filePath2;

    private void setup() throws IOException {
        this.setup((Option<HoodieFileFormat>)Option.empty());
    }

    private void setup(Option<HoodieFileFormat> partitionMetafileFormat) throws IOException {
        URI tablePathURI = Paths.get(this.tempDir.getAbsolutePath(), "test_table").toUri();
        tablePath = new StoragePath(tablePathURI);
        storage = HoodieStorageUtils.getStorage((String)tablePathURI.toString(), (StorageConfiguration)HoodieTestUtils.getDefaultStorageConfWithDefaults());
        Assertions.assertTrue((boolean)new File(Paths.get(tablePathURI.getPath(), ".hoodie/.aux/.bootstrap").toUri()).mkdirs());
        URI partitionPathURI1 = Paths.get(tablePathURI.getPath(), "key1=abc/key2=def").toUri();
        partitionPath1 = new StoragePath(partitionPathURI1);
        URI partitionPathURI2 = Paths.get(tablePathURI.getPath(), "key1=xyz/key2=def").toUri();
        partitionPath2 = new StoragePath(partitionPathURI2);
        Assertions.assertTrue((boolean)new File(partitionPathURI1).mkdirs());
        Assertions.assertTrue((boolean)new File(partitionPathURI2).mkdirs());
        HoodiePartitionMetadata partitionMetadata1 = new HoodiePartitionMetadata(storage, Instant.now().toString(), tablePath, partitionPath1, partitionMetafileFormat);
        partitionMetadata1.trySave();
        HoodiePartitionMetadata partitionMetadata2 = new HoodiePartitionMetadata(storage, Instant.now().toString(), tablePath, partitionPath2, partitionMetafileFormat);
        partitionMetadata2.trySave();
        URI filePathURI1 = Paths.get(partitionPathURI1.getPath(), "data1" + BASE_FILE_EXTENSION).toUri();
        filePath1 = new StoragePath(filePathURI1);
        URI filePathURI2 = Paths.get(partitionPathURI2.getPath(), "data2" + BASE_FILE_EXTENSION).toUri();
        filePath2 = new StoragePath(filePathURI2);
        Assertions.assertTrue((boolean)new File(filePathURI1).createNewFile());
        Assertions.assertTrue((boolean)new File(filePathURI2).createNewFile());
    }

    @Test
    void getTablePathFromTablePath() throws IOException {
        this.setup();
        Option inferredTablePath = TablePathUtils.getTablePath((HoodieStorage)storage, (StoragePath)tablePath);
        Assertions.assertEquals((Object)tablePath, (Object)inferredTablePath.get());
    }

    @Test
    void getTablePathFromMetadataFolderPath() throws IOException {
        this.setup();
        StoragePath metaFolder = new StoragePath(tablePath, ".hoodie");
        Option inferredTablePath = TablePathUtils.getTablePath((HoodieStorage)storage, (StoragePath)metaFolder);
        Assertions.assertEquals((Object)tablePath, (Object)inferredTablePath.get());
    }

    @Test
    void getTablePathFromMetadataSubFolderPath() throws IOException {
        this.setup();
        StoragePath auxFolder = new StoragePath(tablePath, ".hoodie/.aux");
        Assertions.assertEquals((Object)tablePath, (Object)TablePathUtils.getTablePath((HoodieStorage)storage, (StoragePath)auxFolder).get());
        StoragePath bootstrapIndexFolder = new StoragePath(tablePath, ".hoodie/.aux/.bootstrap");
        Assertions.assertEquals((Object)tablePath, (Object)TablePathUtils.getTablePath((HoodieStorage)storage, (StoragePath)bootstrapIndexFolder).get());
        StoragePath metadataTableFolder = new StoragePath(tablePath, ".hoodie/metadata");
        StoragePath metadataTableMetaFolder = new StoragePath(metadataTableFolder, ".hoodie");
        Assertions.assertTrue((boolean)new File(metadataTableMetaFolder.toUri()).mkdirs());
        Assertions.assertEquals((Object)metadataTableFolder, (Object)TablePathUtils.getTablePath((HoodieStorage)storage, (StoragePath)metadataTableFolder).get());
        StoragePath metadataTablePartitionFolder = new StoragePath(metadataTableFolder, "column_stats");
        Assertions.assertTrue((boolean)new File(metadataTablePartitionFolder.toUri()).mkdir());
        Assertions.assertEquals((Object)metadataTableFolder, (Object)TablePathUtils.getTablePath((HoodieStorage)storage, (StoragePath)metadataTablePartitionFolder).get());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieFileFormat.class, names={"PARQUET", "ORC"})
    void getTablePathFromPartitionFolderPath(HoodieFileFormat partitionMetafileFormat) throws IOException {
        this.setup((Option<HoodieFileFormat>)Option.of((Object)partitionMetafileFormat));
        Option inferredTablePath = TablePathUtils.getTablePath((HoodieStorage)storage, (StoragePath)partitionPath1);
        Assertions.assertEquals((Object)tablePath, (Object)inferredTablePath.get());
        inferredTablePath = TablePathUtils.getTablePath((HoodieStorage)storage, (StoragePath)partitionPath2);
        Assertions.assertEquals((Object)tablePath, (Object)inferredTablePath.get());
    }

    @Test
    void getTablePathFromFilePath() throws IOException {
        this.setup();
        Option inferredTablePath = TablePathUtils.getTablePath((HoodieStorage)storage, (StoragePath)filePath1);
        Assertions.assertEquals((Object)tablePath, (Object)inferredTablePath.get());
        inferredTablePath = TablePathUtils.getTablePath((HoodieStorage)storage, (StoragePath)filePath2);
        Assertions.assertEquals((Object)tablePath, (Object)inferredTablePath.get());
    }
}

