/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.testutils.AvroBinaryTestPayload;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.testutils.SpillableMapTestUtils;
import org.apache.hudi.common.util.HoodieRecordSizeEstimator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SizeEstimator;
import org.apache.hudi.common.util.SpillableMapUtils;
import org.apache.hudi.common.util.collection.BitCaskDiskMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestBitCaskDiskMap
extends HoodieCommonTestHarness {
    @BeforeEach
    public void setup() {
        this.initPath();
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testSimpleInsert(boolean isCompressionEnabled) throws IOException, URISyntaxException {
        BitCaskDiskMap records = new BitCaskDiskMap(this.basePath, isCompressionEnabled);
        SchemaTestUtil testUtil = new SchemaTestUtil();
        List iRecords = testUtil.generateHoodieTestRecords(0, 100);
        List recordKeys = SpillableMapTestUtils.upsertRecords((List)iRecords, (Map)records);
        Map<String, IndexedRecord> originalRecords = iRecords.stream().collect(Collectors.toMap(k -> ((GenericRecord)k).get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString(), v -> v));
        Assertions.assertTrue((records.sizeOfFileOnDiskInBytes() > 0L ? 1 : 0) != 0);
        for (HoodieRecord rec : records) {
            assert (recordKeys.contains(rec.getRecordKey()));
            IndexedRecord originalRecord = originalRecords.get(rec.getRecordKey());
            HoodieAvroPayload payload = (HoodieAvroPayload)rec.getData();
            Option value = payload.getInsertValue(HoodieAvroUtils.addMetadataFields((Schema)SchemaTestUtil.getSimpleSchema()));
            Assertions.assertEquals((Object)originalRecord, (Object)value.get());
        }
        this.verifyCleanup((BitCaskDiskMap<String, HoodieRecord>)records);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testSimpleInsertWithoutHoodieMetadata(boolean isCompressionEnabled) throws IOException, URISyntaxException {
        BitCaskDiskMap records = new BitCaskDiskMap(this.basePath, isCompressionEnabled);
        SchemaTestUtil testUtil = new SchemaTestUtil();
        List hoodieRecords = testUtil.generateHoodieTestRecordsWithoutHoodieMetadata(0, 1000);
        HashSet recordKeys = new HashSet();
        hoodieRecords.forEach(r -> {
            records.put((Serializable)((Object)r.getRecordKey()), (Serializable)r);
            recordKeys.add(r.getRecordKey());
        });
        Assertions.assertTrue((records.sizeOfFileOnDiskInBytes() > 0L ? 1 : 0) != 0);
        Iterator itr = records.iterator();
        ArrayList<HoodieRecord> oRecords = new ArrayList<HoodieRecord>();
        while (itr.hasNext()) {
            HoodieRecord rec = (HoodieRecord)itr.next();
            oRecords.add(rec);
            assert (recordKeys.contains(rec.getRecordKey()));
        }
        this.verifyCleanup((BitCaskDiskMap<String, HoodieRecord>)records);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testSimpleUpsert(boolean isCompressionEnabled) throws IOException, URISyntaxException {
        Schema schema = HoodieAvroUtils.addMetadataFields((Schema)SchemaTestUtil.getSimpleSchema());
        BitCaskDiskMap records = new BitCaskDiskMap(this.basePath, isCompressionEnabled);
        SchemaTestUtil testUtil = new SchemaTestUtil();
        List iRecords = testUtil.generateHoodieTestRecords(0, 100);
        List recordKeys = SpillableMapTestUtils.upsertRecords((List)iRecords, (Map)records);
        long fileSize = records.sizeOfFileOnDiskInBytes();
        Assertions.assertTrue((fileSize > 0L ? 1 : 0) != 0);
        List updatedRecords = SchemaTestUtil.updateHoodieTestRecords((List)recordKeys, (List)testUtil.generateHoodieTestRecords(0, 100), (String)HoodieActiveTimeline.createNewInstantTime());
        String newCommitTime = ((GenericRecord)updatedRecords.get(0)).get(HoodieRecord.COMMIT_TIME_METADATA_FIELD).toString();
        recordKeys = SpillableMapTestUtils.upsertRecords((List)updatedRecords, (Map)records);
        Assertions.assertTrue((records.sizeOfFileOnDiskInBytes() > fileSize ? 1 : 0) != 0);
        for (HoodieRecord rec : records) {
            assert (recordKeys.contains(rec.getRecordKey()));
            try {
                IndexedRecord indexedRecord = (IndexedRecord)((HoodieRecordPayload)rec.getData()).getInsertValue(schema).get();
                String latestCommitTime = ((GenericRecord)indexedRecord).get(HoodieRecord.COMMIT_TIME_METADATA_FIELD).toString();
                Assertions.assertEquals((Object)latestCommitTime, (Object)newCommitTime);
            }
            catch (IOException io) {
                throw new UncheckedIOException(io);
            }
        }
        this.verifyCleanup((BitCaskDiskMap<String, HoodieRecord>)records);
    }

    @Test
    public void testSizeEstimator() throws IOException, URISyntaxException {
        SchemaTestUtil testUtil = new SchemaTestUtil();
        Schema schema = SchemaTestUtil.getSimpleSchema();
        List hoodieRecords = testUtil.generateHoodieTestRecords(0, 1, schema);
        long payloadSize = SpillableMapUtils.computePayloadSize(hoodieRecords.remove(0), (SizeEstimator)new HoodieRecordSizeEstimator(schema));
        Assertions.assertTrue((payloadSize > 0L ? 1 : 0) != 0);
        schema = HoodieAvroUtils.addMetadataFields((Schema)schema);
        hoodieRecords = testUtil.generateHoodieTestRecords(0, 1, schema);
        payloadSize = SpillableMapUtils.computePayloadSize(hoodieRecords.remove(0), (SizeEstimator)new HoodieRecordSizeEstimator(schema));
        Assertions.assertTrue((payloadSize > 0L ? 1 : 0) != 0);
        schema = SchemaTestUtil.getSimpleSchema();
        List indexedRecords = testUtil.generateHoodieTestRecords(0, 1);
        hoodieRecords = indexedRecords.stream().map(r -> new HoodieAvroRecord(new HoodieKey(UUID.randomUUID().toString(), "0000/00/00"), (HoodieRecordPayload)new AvroBinaryTestPayload(Option.of((Object)((GenericRecord)r))))).collect(Collectors.toList());
        payloadSize = SpillableMapUtils.computePayloadSize(hoodieRecords.remove(0), (SizeEstimator)new HoodieRecordSizeEstimator(schema));
        Assertions.assertTrue((payloadSize > 0L ? 1 : 0) != 0);
        Schema simpleSchemaWithMetadata = HoodieAvroUtils.addMetadataFields((Schema)SchemaTestUtil.getSimpleSchema());
        indexedRecords = testUtil.generateHoodieTestRecords(0, 1);
        hoodieRecords = indexedRecords.stream().map(r -> new HoodieAvroRecord(new HoodieKey(UUID.randomUUID().toString(), "0000/00/00"), (HoodieRecordPayload)new AvroBinaryTestPayload(Option.of((Object)HoodieAvroUtils.rewriteRecord((GenericRecord)((GenericRecord)r), (Schema)simpleSchemaWithMetadata))))).collect(Collectors.toList());
        payloadSize = SpillableMapUtils.computePayloadSize(hoodieRecords.remove(0), (SizeEstimator)new HoodieRecordSizeEstimator(schema));
        Assertions.assertTrue((payloadSize > 0L ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testPutAll(boolean isCompressionEnabled) throws IOException, URISyntaxException {
        BitCaskDiskMap records = new BitCaskDiskMap(this.basePath, isCompressionEnabled);
        SchemaTestUtil testUtil = new SchemaTestUtil();
        List iRecords = testUtil.generateHoodieTestRecords(0, 100);
        HashMap recordMap = new HashMap();
        iRecords.forEach(r -> {
            String key = ((GenericRecord)r).get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
            String partitionPath = ((GenericRecord)r).get(HoodieRecord.PARTITION_PATH_METADATA_FIELD).toString();
            HoodieAvroRecord value = new HoodieAvroRecord(new HoodieKey(key, partitionPath), (HoodieRecordPayload)new HoodieAvroPayload(Option.of((Object)((GenericRecord)r))));
            recordMap.put(key, value);
        });
        records.putAll(recordMap);
        Assertions.assertTrue((records.sizeOfFileOnDiskInBytes() > 0L ? 1 : 0) != 0);
        for (Map.Entry entry : records.entrySet()) {
            Assertions.assertTrue((boolean)recordMap.containsKey(entry.getKey()));
        }
    }

    @Disabled
    @Test
    public void testSizeEstimatorPerformance() throws IOException, URISyntaxException {
        Schema schema = SchemaTestUtil.getSimpleSchema();
        SchemaTestUtil testUtil = new SchemaTestUtil();
        List hoodieRecords = testUtil.generateHoodieTestRecords(0, 1, schema);
        HoodieRecordSizeEstimator sizeEstimator = new HoodieRecordSizeEstimator(schema);
        HoodieRecord record = (HoodieRecord)hoodieRecords.remove(0);
        long startTime = System.currentTimeMillis();
        SpillableMapUtils.computePayloadSize((Object)record, (SizeEstimator)sizeEstimator);
        long timeTaken = System.currentTimeMillis() - startTime;
        System.out.println("Time taken :" + timeTaken);
        Assertions.assertTrue((timeTaken < 100L ? 1 : 0) != 0);
    }

    private void verifyCleanup(BitCaskDiskMap<String, HoodieRecord> records) {
        File basePathDir = new File(this.basePath);
        assert (Objects.requireNonNull(basePathDir.list()).length > 0);
        records.close();
        Assertions.assertEquals((int)Objects.requireNonNull(basePathDir.list()).length, (int)0);
    }
}

