/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hadoop;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.io.hadoop.HoodieAvroOrcReader;
import org.apache.hudi.io.hadoop.HoodieAvroParquetReader;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestHoodieAvroFileReaderFactory {
    @TempDir
    public Path tempDir;

    @Test
    public void testGetFileReader() throws IOException {
        HoodieStorage storage = HoodieTestUtils.getDefaultStorage();
        StoragePath parquetPath = new StoragePath("/partition/path/f1_1-0-1_000.parquet");
        HoodieFileReader parquetReader = HoodieIOFactory.getIOFactory((HoodieStorage)storage).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader(ConfigUtils.DEFAULT_HUDI_CONFIG_FOR_READER, parquetPath);
        Assertions.assertTrue((boolean)(parquetReader instanceof HoodieAvroParquetReader));
        StoragePath logPath = new StoragePath("/partition/path/f.b51192a8-574b-4a85-b246-bcfec03ac8bf_100.log.2_1-0-1");
        Throwable thrown = Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            HoodieFileReader logWriter = HoodieIOFactory.getIOFactory((HoodieStorage)storage).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader(ConfigUtils.DEFAULT_HUDI_CONFIG_FOR_READER, logPath);
        }, (String)"should fail since log storage reader is not supported yet.");
        Assertions.assertTrue((boolean)thrown.getMessage().contains("format not supported yet."));
        StoragePath orcPath = new StoragePath("/partition/path/f1_1-0-1_000.orc");
        HoodieFileReader orcReader = HoodieIOFactory.getIOFactory((HoodieStorage)storage).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader(ConfigUtils.DEFAULT_HUDI_CONFIG_FOR_READER, orcPath);
        Assertions.assertTrue((boolean)(orcReader instanceof HoodieAvroOrcReader));
    }
}

