/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hadoop;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.io.storage.HoodieAvroFileReader;
import org.apache.hudi.io.storage.HoodieAvroFileWriter;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public abstract class TestHoodieReaderWriterBase {
    protected static final int NUM_RECORDS = 50;
    @TempDir
    protected File tempDir;

    protected abstract StoragePath getFilePath();

    protected abstract HoodieAvroFileWriter createWriter(Schema var1, boolean var2) throws Exception;

    protected abstract HoodieAvroFileReader createReader(HoodieStorage var1) throws Exception;

    protected abstract void verifyMetadata(HoodieStorage var1) throws IOException;

    protected abstract void verifySchema(HoodieStorage var1, String var2) throws IOException;

    @BeforeEach
    @AfterEach
    public void clearTempFile() {
        File file = new File(this.getFilePath().toString());
        if (file.exists()) {
            file.delete();
        }
    }

    @Test
    public void testWriteReadMetadata() throws Exception {
        Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieReaderWriterBase.class, (String)"/exampleSchema.avsc");
        this.writeFileWithSimpleSchema();
        HoodieStorage storage = HoodieTestUtils.getStorage((StoragePath)this.getFilePath());
        this.verifyMetadata(storage);
        try (HoodieAvroFileReader hoodieReader = this.createReader(storage);){
            BloomFilter filter = hoodieReader.readBloomFilter();
            for (int i = 0; i < 50; ++i) {
                String key = "key" + String.format("%02d", i);
                Assertions.assertTrue((boolean)filter.mightContain(key));
            }
            Assertions.assertFalse((boolean)filter.mightContain("non-existent-key"));
            Assertions.assertEquals((Object)avroSchema, (Object)hoodieReader.getSchema());
            Assertions.assertEquals((long)50L, (long)hoodieReader.getTotalRecords());
            String[] minMaxRecordKeys = hoodieReader.readMinMaxRecordKeys();
            Assertions.assertEquals((int)2, (int)minMaxRecordKeys.length);
            Assertions.assertEquals((Object)"key00", (Object)minMaxRecordKeys[0]);
            Assertions.assertEquals((Object)"key49", (Object)minMaxRecordKeys[1]);
        }
    }

    @Test
    public void testWriteReadPrimitiveRecord() throws Exception {
        String schemaPath = "/exampleSchema.avsc";
        this.writeFileWithSimpleSchema();
        HoodieStorage storage = HoodieTestUtils.getStorage((StoragePath)this.getFilePath());
        this.verifyMetadata(storage);
        this.verifySchema(storage, schemaPath);
        this.verifySimpleRecords((Iterator<HoodieRecord<IndexedRecord>>)this.createReader(storage).getRecordIterator());
    }

    @Test
    public void testWriteReadComplexRecord() throws Exception {
        String schemaPath = "/exampleSchemaWithUDT.avsc";
        Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieReaderWriterBase.class, (String)schemaPath);
        Schema udtSchema = (Schema)avroSchema.getField("driver").schema().getTypes().get(1);
        HoodieAvroFileWriter writer = this.createWriter(avroSchema, true);
        for (int i = 0; i < 50; ++i) {
            GenericData.Record record = new GenericData.Record(avroSchema);
            String key = "key" + String.format("%02d", i);
            record.put("_row_key", (Object)key);
            record.put("time", (Object)Integer.toString(i));
            record.put("number", (Object)i);
            GenericData.Record innerRecord = new GenericData.Record(udtSchema);
            innerRecord.put("driver_name", (Object)("driver" + i));
            innerRecord.put("list", Collections.singletonList(i));
            innerRecord.put("map", Collections.singletonMap(key, "value" + i));
            record.put("driver", (Object)innerRecord);
            writer.writeAvro(key, (IndexedRecord)record);
        }
        writer.close();
        HoodieStorage storage = HoodieTestUtils.getStorage((StoragePath)this.getFilePath());
        this.verifyMetadata(storage);
        this.verifySchema(storage, schemaPath);
        this.verifyComplexRecords((Iterator<HoodieRecord<IndexedRecord>>)this.createReader(storage).getRecordIterator());
    }

    @ParameterizedTest
    @ValueSource(strings={"/exampleEvolvedSchema.avsc", "/exampleEvolvedSchemaChangeOrder.avsc", "/exampleEvolvedSchemaColumnRequire.avsc", "/exampleEvolvedSchemaColumnType.avsc", "/exampleEvolvedSchemaDeleteColumn.avsc"})
    public void testWriteReadWithEvolvedSchema(String evolvedSchemaPath) throws Exception {
        this.writeFileWithSimpleSchema();
        HoodieStorage storage = HoodieTestUtils.getStorage((StoragePath)this.getFilePath());
        try (HoodieAvroFileReader hoodieReader = this.createReader(storage);){
            this.verifyReaderWithSchema(evolvedSchemaPath, hoodieReader);
        }
    }

    @Test
    public void testReaderFilterRowKeys() throws Exception {
        this.writeFileWithSchemaWithMeta();
        HoodieStorage storage = HoodieTestUtils.getStorage((StoragePath)this.getFilePath());
        this.verifyMetadata(storage);
        this.verifyFilterRowKeys(this.createReader(storage));
    }

    protected void writeFileWithSimpleSchema() throws Exception {
        Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieReaderWriterBase.class, (String)"/exampleSchema.avsc");
        HoodieAvroFileWriter writer = this.createWriter(avroSchema, true);
        for (int i = 0; i < 50; ++i) {
            GenericData.Record record = new GenericData.Record(avroSchema);
            String key = "key" + String.format("%02d", i);
            record.put("_row_key", (Object)key);
            record.put("time", (Object)Integer.toString(i));
            record.put("number", (Object)i);
            HoodieAvroIndexedRecord avroRecord = new HoodieAvroIndexedRecord((IndexedRecord)record);
            writer.write(key, (HoodieRecord)avroRecord, avroSchema);
        }
        writer.close();
    }

    private void writeFileWithSchemaWithMeta() throws Exception {
        Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieReaderWriterBase.class, (String)"/exampleSchemaWithMetaFields.avsc");
        HoodieAvroFileWriter writer = this.createWriter(avroSchema, true);
        for (int i = 0; i < 50; ++i) {
            GenericData.Record record = new GenericData.Record(avroSchema);
            String key = "key" + String.format("%02d", i);
            record.put("_row_key", (Object)key);
            record.put("time", (Object)Integer.toString(i));
            record.put("number", (Object)i);
            writer.writeAvroWithMetadata(new HoodieKey((String)record.get("_row_key"), Integer.toString((Integer)record.get("number"))), (IndexedRecord)record);
        }
        writer.close();
    }

    protected void verifySimpleRecords(Iterator<HoodieRecord<IndexedRecord>> iterator) {
        int index = 0;
        while (iterator.hasNext()) {
            GenericRecord record = (GenericRecord)iterator.next().getData();
            String key = "key" + String.format("%02d", index);
            Assertions.assertEquals((Object)key, (Object)record.get("_row_key").toString());
            Assertions.assertEquals((Object)Integer.toString(index), (Object)record.get("time").toString());
            Assertions.assertEquals((Object)index, (Object)record.get("number"));
            ++index;
        }
    }

    private void verifyComplexRecords(Iterator<HoodieRecord<IndexedRecord>> iterator) {
        int index = 0;
        while (iterator.hasNext()) {
            GenericRecord record = (GenericRecord)iterator.next().getData();
            String key = "key" + String.format("%02d", index);
            Assertions.assertEquals((Object)key, (Object)record.get("_row_key").toString());
            Assertions.assertEquals((Object)Integer.toString(index), (Object)record.get("time").toString());
            Assertions.assertEquals((Object)index, (Object)record.get("number"));
            GenericRecord innerRecord = (GenericRecord)record.get("driver");
            Assertions.assertEquals((Object)("driver" + index), (Object)innerRecord.get("driver_name").toString());
            Assertions.assertEquals((int)1, (int)((List)innerRecord.get("list")).size());
            Assertions.assertEquals((Object)index, ((List)innerRecord.get("list")).get(0));
            Map mapping = (Map)innerRecord.get("map");
            boolean match = false;
            for (Object innerKey : mapping.keySet()) {
                if (!innerKey.toString().equals(key)) continue;
                Assertions.assertEquals((Object)("value" + index), (Object)mapping.get(innerKey).toString());
                match = true;
            }
            Assertions.assertTrue((boolean)match);
            ++index;
        }
    }

    private void verifyFilterRowKeys(HoodieAvroFileReader hoodieReader) {
        Set candidateRowKeys = IntStream.range(40, 100).mapToObj(i -> "key" + String.format("%02d", i)).collect(Collectors.toCollection(TreeSet::new));
        List expectedKeys = IntStream.range(40, 50).mapToObj(i -> "key" + String.format("%02d", i)).sorted().collect(Collectors.toList());
        Assertions.assertEquals(expectedKeys, hoodieReader.filterRowKeys(candidateRowKeys).stream().sorted().collect(Collectors.toList()));
    }

    private void verifyReaderWithSchema(String schemaPath, HoodieAvroFileReader hoodieReader) throws IOException {
        Schema evolvedSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieReaderWriterBase.class, (String)schemaPath);
        ClosableIterator iter = hoodieReader.getRecordIterator(evolvedSchema);
        int index = 0;
        while (iter.hasNext()) {
            this.verifyRecord(schemaPath, (GenericRecord)((HoodieRecord)iter.next()).getData(), index);
            ++index;
        }
    }

    private void verifyRecord(String schemaPath, GenericRecord record, int index) {
        String numStr = String.format("%02d", index);
        Assertions.assertEquals((Object)("key" + numStr), (Object)record.get("_row_key").toString());
        Assertions.assertEquals((Object)Integer.toString(index), (Object)record.get("time").toString());
        if (schemaPath.equals("/exampleEvolvedSchemaColumnType.avsc")) {
            Assertions.assertEquals((Object)Integer.toString(index), (Object)record.get("number").toString());
            Assertions.assertNull((Object)record.getSchema().getField("added_field"));
        } else if (schemaPath.equals("/exampleEvolvedSchemaDeleteColumn.avsc")) {
            Assertions.assertNull((Object)record.getSchema().getField("number"));
            Assertions.assertNull((Object)record.getSchema().getField("added_field"));
        } else {
            Assertions.assertEquals((Object)index, (Object)record.get("number"));
            Assertions.assertNull((Object)record.get("added_field"));
        }
    }
}

