/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.model.HoodieColumnRangeMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieMetadataPayload
extends HoodieCommonTestHarness {
    public static final String PARTITION_NAME = "2022/10/01";

    @Test
    public void testFileSystemMetadataPayloadMerging() {
        Map firstCommitAddedFiles = CollectionUtils.createImmutableMap((Pair[])new Pair[]{Pair.of((Object)"file1.parquet", (Object)1000L), Pair.of((Object)"file2.parquet", (Object)2000L), Pair.of((Object)"file3.parquet", (Object)3000L)});
        HoodieRecord firstPartitionFilesRecord = HoodieMetadataPayload.createPartitionFilesRecord((String)PARTITION_NAME, (Map)firstCommitAddedFiles, Collections.emptyList());
        Map secondCommitAddedFiles = CollectionUtils.createImmutableMap((Pair[])new Pair[]{Pair.of((Object)"file3.parquet", (Object)3333L), Pair.of((Object)"file4.parquet", (Object)4000L), Pair.of((Object)"file5.parquet", (Object)5000L)});
        List<String> secondCommitDeletedFiles = Collections.singletonList("file1.parquet");
        HoodieRecord secondPartitionFilesRecord = HoodieMetadataPayload.createPartitionFilesRecord((String)PARTITION_NAME, (Map)secondCommitAddedFiles, secondCommitDeletedFiles);
        HoodieMetadataPayload combinedPartitionFilesRecordPayload = ((HoodieMetadataPayload)secondPartitionFilesRecord.getData()).preCombine((HoodieMetadataPayload)firstPartitionFilesRecord.getData());
        HoodieMetadataPayload expectedCombinedPartitionedFilesRecordPayload = (HoodieMetadataPayload)HoodieMetadataPayload.createPartitionFilesRecord((String)PARTITION_NAME, (Map)CollectionUtils.createImmutableMap((Pair[])new Pair[]{Pair.of((Object)"file2.parquet", (Object)2000L), Pair.of((Object)"file3.parquet", (Object)3333L), Pair.of((Object)"file4.parquet", (Object)4000L), Pair.of((Object)"file5.parquet", (Object)5000L)}), Collections.emptyList()).getData();
        Assertions.assertEquals((Object)expectedCombinedPartitionedFilesRecordPayload, (Object)combinedPartitionFilesRecordPayload);
    }

    @Test
    public void testFileSystemMetadataPayloadMergingWithDeletions() {
        Map addedFileMap = CollectionUtils.createImmutableMap((Pair[])new Pair[]{Pair.of((Object)"file1.parquet", (Object)1000L), Pair.of((Object)"file2.parquet", (Object)2000L), Pair.of((Object)"file3.parquet", (Object)3000L), Pair.of((Object)"file4.parquet", (Object)4000L)});
        HoodieRecord additionRecord = HoodieMetadataPayload.createPartitionFilesRecord((String)PARTITION_NAME, (Map)addedFileMap, Collections.emptyList());
        ArrayList<String> deletedFileList1 = new ArrayList<String>();
        deletedFileList1.add("file1.parquet");
        deletedFileList1.add("file3.parquet");
        HoodieRecord deletionRecord1 = HoodieMetadataPayload.createPartitionFilesRecord((String)PARTITION_NAME, Collections.emptyMap(), deletedFileList1);
        ArrayList<String> deletedFileList2 = new ArrayList<String>();
        deletedFileList2.add("file1.parquet");
        deletedFileList2.add("file4.parquet");
        HoodieRecord deletionRecord2 = HoodieMetadataPayload.createPartitionFilesRecord((String)PARTITION_NAME, Collections.emptyMap(), deletedFileList2);
        Assertions.assertEquals((Object)HoodieMetadataPayload.createPartitionFilesRecord((String)PARTITION_NAME, (Map)CollectionUtils.createImmutableMap((Pair[])new Pair[]{Pair.of((Object)"file2.parquet", (Object)2000L), Pair.of((Object)"file4.parquet", (Object)4000L)}), Collections.emptyList()).getData(), (Object)((HoodieMetadataPayload)deletionRecord1.getData()).preCombine((HoodieMetadataPayload)additionRecord.getData()));
        ArrayList<String> expectedDeleteFileList = new ArrayList<String>();
        expectedDeleteFileList.add("file1.parquet");
        expectedDeleteFileList.add("file3.parquet");
        expectedDeleteFileList.add("file4.parquet");
        Assertions.assertEquals((Object)HoodieMetadataPayload.createPartitionFilesRecord((String)PARTITION_NAME, Collections.emptyMap(), expectedDeleteFileList).getData(), (Object)((HoodieMetadataPayload)deletionRecord2.getData()).preCombine((HoodieMetadataPayload)deletionRecord1.getData()));
        Assertions.assertEquals((Object)HoodieMetadataPayload.createPartitionFilesRecord((String)PARTITION_NAME, (Map)CollectionUtils.createImmutableMap((Pair[])new Pair[]{Pair.of((Object)"file2.parquet", (Object)2000L)}), Collections.emptyList()).getData(), (Object)((HoodieMetadataPayload)deletionRecord2.getData()).preCombine((HoodieMetadataPayload)deletionRecord1.getData()).preCombine((HoodieMetadataPayload)additionRecord.getData()));
        Assertions.assertEquals((Object)HoodieMetadataPayload.createPartitionFilesRecord((String)PARTITION_NAME, (Map)CollectionUtils.createImmutableMap((Pair[])new Pair[]{Pair.of((Object)"file2.parquet", (Object)2000L)}), Collections.singletonList("file1.parquet")).getData(), (Object)((HoodieMetadataPayload)deletionRecord2.getData()).preCombine(((HoodieMetadataPayload)deletionRecord1.getData()).preCombine((HoodieMetadataPayload)additionRecord.getData())));
    }

    @Test
    public void testColumnStatsPayloadMerging() throws IOException {
        String fileName = "file.parquet";
        String targetColName = "c1";
        HoodieColumnRangeMetadata c1Metadata = HoodieColumnRangeMetadata.create((String)fileName, (String)targetColName, (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(1000), (long)5L, (long)1000L, (long)123456L, (long)123456L);
        HoodieRecord columnStatsRecord = (HoodieRecord)HoodieMetadataPayload.createColumnStatsRecords((String)PARTITION_NAME, Collections.singletonList(c1Metadata), (boolean)false).findFirst().get();
        HoodieColumnRangeMetadata c1AppendedBlockMetadata = HoodieColumnRangeMetadata.create((String)fileName, (String)targetColName, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(500), (long)0L, (long)100L, (long)12345L, (long)12345L);
        HoodieRecord updatedColumnStatsRecord = (HoodieRecord)HoodieMetadataPayload.createColumnStatsRecords((String)PARTITION_NAME, Collections.singletonList(c1AppendedBlockMetadata), (boolean)false).findFirst().get();
        HoodieMetadataPayload combinedMetadataPayload = ((HoodieMetadataPayload)columnStatsRecord.getData()).preCombine((HoodieMetadataPayload)updatedColumnStatsRecord.getData());
        HoodieColumnRangeMetadata expectedColumnRangeMetadata = HoodieColumnRangeMetadata.create((String)fileName, (String)targetColName, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1000), (long)5L, (long)1100L, (long)135801L, (long)135801L);
        HoodieRecord expectedColumnStatsRecord = (HoodieRecord)HoodieMetadataPayload.createColumnStatsRecords((String)PARTITION_NAME, Collections.singletonList(expectedColumnRangeMetadata), (boolean)false).findFirst().get();
        Assertions.assertEquals((Object)combinedMetadataPayload, (Object)expectedColumnStatsRecord.getData());
        Option alternativelyCombinedMetadataPayloadAvro = ((HoodieMetadataPayload)columnStatsRecord.getData()).combineAndGetUpdateValue((IndexedRecord)((HoodieMetadataPayload)updatedColumnStatsRecord.getData()).getInsertValue(null).get(), null);
        Assertions.assertEquals((Object)combinedMetadataPayload.getInsertValue(null), (Object)alternativelyCombinedMetadataPayloadAvro);
        HoodieColumnRangeMetadata c1StubbedMetadata = HoodieColumnRangeMetadata.stub((String)fileName, (String)targetColName);
        HoodieRecord deletedColumnStatsRecord = (HoodieRecord)HoodieMetadataPayload.createColumnStatsRecords((String)PARTITION_NAME, Collections.singletonList(c1StubbedMetadata), (boolean)true).findFirst().get();
        HoodieMetadataPayload deletedCombinedMetadataPayload = ((HoodieMetadataPayload)deletedColumnStatsRecord.getData()).preCombine((HoodieMetadataPayload)columnStatsRecord.getData());
        Assertions.assertEquals((Object)deletedColumnStatsRecord.getData(), (Object)deletedCombinedMetadataPayload);
        HoodieMetadataPayload overwrittenCombinedMetadataPayload = ((HoodieMetadataPayload)columnStatsRecord.getData()).preCombine((HoodieMetadataPayload)deletedColumnStatsRecord.getData());
        Assertions.assertEquals((Object)columnStatsRecord.getData(), (Object)overwrittenCombinedMetadataPayload);
    }
}

