/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hadoop;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileInfo;
import org.apache.hadoop.hbase.io.hfile.ReaderContext;
import org.apache.hadoop.hbase.io.hfile.ReaderContextBuilder;
import org.apache.hudi.common.util.io.ByteBufferBackedInputStream;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;

public class HoodieHFileUtils {
    private static final boolean USE_PRIMARY_REPLICA_READER = true;

    public static HFile.Reader createHFileReader(FileSystem fs, Path path, CacheConfig cacheConfig, Configuration configuration) {
        try {
            return HFile.createReader((FileSystem)fs, (Path)path, (CacheConfig)cacheConfig, (boolean)true, (Configuration)configuration);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to initialize HFile reader for  " + path, e);
        }
    }

    public static HFile.Reader createHFileReader(HoodieStorage storage, StoragePath path, CacheConfig cacheConfig, Configuration configuration) {
        try {
            return HFile.createReader((FileSystem)((FileSystem)storage.getFileSystem()), (Path)new Path(path.toUri()), (CacheConfig)cacheConfig, (boolean)true, (Configuration)configuration);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to initialize HFile reader for  " + path, e);
        }
    }

    public static HFile.Reader createHFileReader(HoodieStorage storage, StoragePath dummyPath, byte[] content) {
        Configuration conf = new Configuration(false);
        SeekableByteArrayInputStream bis = new SeekableByteArrayInputStream(content);
        FSDataInputStream fsdis = new FSDataInputStream((InputStream)((Object)bis));
        FSDataInputStreamWrapper stream = new FSDataInputStreamWrapper(fsdis);
        ReaderContext context = new ReaderContextBuilder().withFilePath(new Path(dummyPath.toUri())).withInputStreamWrapper(stream).withFileSize((long)content.length).withFileSystem((FileSystem)storage.getFileSystem()).withPrimaryReplicaReader(true).withReaderType(ReaderContext.ReaderType.STREAM).build();
        try {
            HFileInfo fileInfo = new HFileInfo(context, conf);
            HFile.Reader reader = HFile.createReader((ReaderContext)context, (HFileInfo)fileInfo, (CacheConfig)new CacheConfig(conf), (Configuration)conf);
            fileInfo.initMetaAndIndex(reader);
            return reader;
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to initialize HFile reader for  " + dummyPath, e);
        }
    }

    static class SeekableByteArrayInputStream
    extends ByteBufferBackedInputStream
    implements Seekable,
    PositionedReadable {
        public SeekableByteArrayInputStream(byte[] buf) {
            super(buf);
        }

        public long getPos() throws IOException {
            return this.getPosition();
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            return false;
        }

        public int read(long position, byte[] buffer, int offset, int length) throws IOException {
            return this.copyFrom(position, buffer, offset, length);
        }

        public void readFully(long position, byte[] buffer) throws IOException {
            this.read(position, buffer, 0, buffer.length);
        }

        public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
            this.read(position, buffer, offset, length);
        }
    }
}

