/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction.lock;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hudi.client.transaction.lock.NoopLockProvider;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestNoopLockProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TestNoopLockProvider.class);
    private final StorageConfiguration<?> storageConf = HoodieTestUtils.getDefaultStorageConf();
    private final LockConfiguration lockConfiguration1;
    private final LockConfiguration lockConfiguration2;

    public TestNoopLockProvider() {
        TypedProperties properties = new TypedProperties();
        properties.put((Object)HoodieCommonConfig.BASE_PATH.key(), (Object)"table1");
        this.lockConfiguration1 = new LockConfiguration((Properties)properties);
        properties.put((Object)HoodieCommonConfig.BASE_PATH.key(), (Object)"table2");
        this.lockConfiguration2 = new LockConfiguration((Properties)properties);
    }

    @Test
    public void testLockAcquisition() {
        NoopLockProvider noopLockProvider = new NoopLockProvider(this.lockConfiguration1, this.storageConf);
        Assertions.assertDoesNotThrow(() -> noopLockProvider.lock());
        Assertions.assertDoesNotThrow(() -> noopLockProvider.unlock());
    }

    @Test
    public void testLockReAcquisitionBySameThread() {
        NoopLockProvider noopLockProvider = new NoopLockProvider(this.lockConfiguration1, this.storageConf);
        Assertions.assertDoesNotThrow(() -> noopLockProvider.lock());
        Assertions.assertDoesNotThrow(() -> noopLockProvider.lock());
        Assertions.assertDoesNotThrow(() -> noopLockProvider.unlock());
        Assertions.assertDoesNotThrow(() -> noopLockProvider.lock());
    }

    @Test
    public void testLockReAcquisitionBySameThreadWithTwoTables() {
        NoopLockProvider noopLockProvider1 = new NoopLockProvider(this.lockConfiguration1, this.storageConf);
        NoopLockProvider noopLockProvider2 = new NoopLockProvider(this.lockConfiguration2, this.storageConf);
        Assertions.assertDoesNotThrow(() -> noopLockProvider1.lock());
        Assertions.assertDoesNotThrow(() -> noopLockProvider2.lock());
        Assertions.assertDoesNotThrow(() -> noopLockProvider1.lock());
        Assertions.assertDoesNotThrow(() -> noopLockProvider1.lock());
        Assertions.assertDoesNotThrow(() -> noopLockProvider1.unlock());
        Assertions.assertDoesNotThrow(() -> noopLockProvider2.unlock());
    }

    @Test
    public void testLockReAcquisitionByDifferentThread() {
        final NoopLockProvider noopLockProvider = new NoopLockProvider(this.lockConfiguration1, this.storageConf);
        final AtomicBoolean writer2Completed = new AtomicBoolean(false);
        Assertions.assertDoesNotThrow(() -> noopLockProvider.lock());
        Thread writer2 = new Thread(new Runnable(){

            @Override
            public void run() {
                Assertions.assertDoesNotThrow(() -> noopLockProvider.lock());
                Assertions.assertDoesNotThrow(() -> noopLockProvider.unlock());
                writer2Completed.set(true);
            }
        });
        writer2.start();
        Assertions.assertDoesNotThrow(() -> noopLockProvider.unlock());
        try {
            writer2.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)writer2Completed.get());
        writer2.interrupt();
    }
}

