/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.ConsistencyGuard;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.NoOpConsistencyGuard;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hadoop.fs.HoodieWrapperFileSystem;
import org.apache.hudi.hadoop.fs.inline.HadoopInLineFSUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.junit.Rule;
import org.junit.contrib.java.lang.system.EnvironmentVariables;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class TestFSUtils
extends HoodieCommonTestHarness {
    private static final String TEST_WRITE_TOKEN = "1-0-1";
    @Rule
    public final EnvironmentVariables environmentVariables = new EnvironmentVariables();

    @BeforeEach
    public void setUp() throws IOException {
        this.initMetaClient();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanMetaClient();
    }

    @Test
    public void testMakeDataFileName() {
        String instantTime = TimelineUtils.formatDate((Date)new Date());
        String fileName = UUID.randomUUID().toString();
        Assertions.assertEquals((Object)FSUtils.makeBaseFileName((String)instantTime, (String)TEST_WRITE_TOKEN, (String)fileName, (String)HoodieCommonTestHarness.BASE_FILE_EXTENSION), (Object)(fileName + "_" + TEST_WRITE_TOKEN + "_" + instantTime + HoodieCommonTestHarness.BASE_FILE_EXTENSION));
    }

    @Test
    public void testMaskFileName() {
        String instantTime = TimelineUtils.formatDate((Date)new Date());
        int taskPartitionId = 2;
        Assertions.assertEquals((Object)FSUtils.maskWithoutFileId((String)instantTime, (int)taskPartitionId), (Object)("*_" + taskPartitionId + "_" + instantTime + HoodieCommonTestHarness.BASE_FILE_EXTENSION));
    }

    @Test
    public void testProcessFiles() throws Exception {
        List<String> folders = Arrays.asList("2016/04/15", "2016/05/16", ".hoodie/.temp/2/2016/04/15", ".hoodie/.temp/2/2016/05/16");
        folders.forEach(f -> {
            try {
                this.metaClient.getStorage().createDirectory(new StoragePath(new StoragePath(this.basePath), f));
            }
            catch (IOException e) {
                throw new HoodieException((Throwable)e);
            }
        });
        List<String> files = Stream.of("2016/04/15/1_1-0-1_20190528120000", "2016/05/16/2_1-0-1_20190528120000", ".hoodie/.temp/2/2016/05/16/2_1-0-1_20190528120000", ".hoodie/.temp/2/2016/04/15/1_1-0-1_20190528120000").map(fileName -> fileName + HoodieCommonTestHarness.BASE_FILE_EXTENSION).collect(Collectors.toList());
        files.forEach(f -> {
            try {
                this.metaClient.getStorage().create(new StoragePath(new StoragePath(this.basePath), f));
            }
            catch (IOException e) {
                throw new HoodieException((Throwable)e);
            }
        });
        ArrayList collected = new ArrayList();
        FSUtils.processFiles((HoodieStorage)this.metaClient.getStorage(), (String)this.basePath, status -> {
            collected.add(status.getPath().toString());
            return true;
        }, (boolean)true);
        Assertions.assertTrue((boolean)collected.stream().noneMatch(s -> s.contains(".hoodie")), (String)("Hoodie MetaFolder MUST be skipped but got :" + collected));
        Assertions.assertEquals((int)2, (int)collected.size());
        ArrayList collected2 = new ArrayList();
        FSUtils.processFiles((HoodieStorage)this.metaClient.getStorage(), (String)this.basePath, status -> {
            collected2.add(status.getPath().toString());
            return true;
        }, (boolean)false);
        Assertions.assertFalse((boolean)collected2.stream().noneMatch(s -> s.contains(".hoodie")), (String)("Hoodie MetaFolder will be present :" + collected2));
        Assertions.assertEquals((int)5, (int)collected2.size(), (String)("Collected=" + collected2));
    }

    @Test
    public void testGetCommitTime() {
        String instantTime = TimelineUtils.formatDate((Date)new Date());
        String fileName = UUID.randomUUID().toString();
        String fullFileName = FSUtils.makeBaseFileName((String)instantTime, (String)TEST_WRITE_TOKEN, (String)fileName, (String)HoodieCommonTestHarness.BASE_FILE_EXTENSION);
        Assertions.assertEquals((Object)instantTime, (Object)FSUtils.getCommitTime((String)fullFileName));
        fullFileName = FSUtils.makeLogFileName((String)fileName, (String)HoodieFileFormat.HOODIE_LOG.getFileExtension(), (String)instantTime, (int)1, (String)TEST_WRITE_TOKEN);
        Assertions.assertEquals((Object)instantTime, (Object)FSUtils.getCommitTime((String)fullFileName));
    }

    @Test
    public void testGetFileNameWithoutMeta() {
        String instantTime = TimelineUtils.formatDate((Date)new Date());
        String fileName = UUID.randomUUID().toString();
        String fullFileName = FSUtils.makeBaseFileName((String)instantTime, (String)TEST_WRITE_TOKEN, (String)fileName, (String)HoodieCommonTestHarness.BASE_FILE_EXTENSION);
        Assertions.assertEquals((Object)fileName, (Object)FSUtils.getFileId((String)fullFileName));
    }

    @Test
    public void testEnvVarVariablesPickedup() {
        this.environmentVariables.set("HOODIE_ENV_fs_DOT_key1", "value1");
        Configuration conf = HadoopFSUtils.prepareHadoopConf((Configuration)((Configuration)HoodieTestUtils.getDefaultStorageConf().unwrap()));
        Assertions.assertEquals((Object)"value1", (Object)conf.get("fs.key1"));
        conf.set("fs.key1", "value11");
        conf.set("fs.key2", "value2");
        Assertions.assertEquals((Object)"value11", (Object)conf.get("fs.key1"));
        Assertions.assertEquals((Object)"value2", (Object)conf.get("fs.key2"));
    }

    @Test
    public void testGetRelativePartitionPath() {
        Path basePath = new Path("/test/apache");
        Path partitionPath = new Path("/test/apache/hudi/sub");
        Assertions.assertEquals((Object)"hudi/sub", (Object)HadoopFSUtils.getRelativePartitionPath((Path)basePath, (Path)partitionPath));
        Path nonPartitionPath = new Path("/test/something/else");
        Assertions.assertThrows(IllegalArgumentException.class, () -> HadoopFSUtils.getRelativePartitionPath((Path)basePath, (Path)nonPartitionPath));
    }

    @ParameterizedTest
    @CsvSource(value={"/test,/test,", "s3://test,s3://test,", "s3://test/foo,s3://test/foo,", "/test/foo,/test/foo,", "/test/apache/apache,/test/apache/apache/hudi,hudi", "/test/apache,/test/apache/hudi,hudi", "s3://test/apache,s3://test/apache/apache/hudi,apache/hudi"})
    public void testGetRelativePartitionPath(String basePathStr, String partitionPathStr, String expected) {
        StoragePath basePath = new StoragePath(basePathStr);
        StoragePath partitionPath = new StoragePath(partitionPathStr);
        String result = FSUtils.getRelativePartitionPath((StoragePath)basePath, (StoragePath)partitionPath);
        Assertions.assertEquals((Object)(expected == null ? "" : expected), (Object)result);
    }

    @Test
    public void testOldLogFileName() {
        String partitionPath = "2019/01/01/";
        String fileName = UUID.randomUUID().toString();
        String oldLogFile = TestFSUtils.makeOldLogFileName(fileName, ".log", "100", 1);
        StoragePath rlPath = new StoragePath(new StoragePath(partitionPath), oldLogFile);
        Assertions.assertTrue((boolean)FSUtils.isLogFile((StoragePath)rlPath));
        Assertions.assertEquals((Object)fileName, (Object)FSUtils.getFileIdFromLogPath((StoragePath)rlPath));
        Assertions.assertEquals((Object)"100", (Object)FSUtils.getDeltaCommitTimeFromLogPath((StoragePath)rlPath));
        Assertions.assertEquals((int)1, (int)FSUtils.getFileVersionFromLog((StoragePath)rlPath));
        Assertions.assertNull((Object)FSUtils.getTaskPartitionIdFromLogPath((StoragePath)rlPath));
        Assertions.assertNull((Object)FSUtils.getStageIdFromLogPath((StoragePath)rlPath));
        Assertions.assertNull((Object)FSUtils.getTaskAttemptIdFromLogPath((StoragePath)rlPath));
        Assertions.assertNull((Object)FSUtils.getWriteTokenFromLogPath((StoragePath)rlPath));
    }

    @Test
    public void tesLogFileName() {
        String partitionPath = "2019/01/01/";
        String fileName = UUID.randomUUID().toString();
        String logFile = FSUtils.makeLogFileName((String)fileName, (String)".log", (String)"100", (int)2, (String)TEST_WRITE_TOKEN);
        System.out.println("Log File =" + logFile);
        StoragePath rlPath = new StoragePath(new StoragePath(partitionPath), logFile);
        StoragePath inlineFsPath = HadoopInLineFSUtils.getInlineFilePath((StoragePath)new StoragePath(rlPath.toUri()), (String)"file", (long)0L, (long)100L);
        Assertions.assertTrue((boolean)FSUtils.isLogFile((StoragePath)rlPath));
        Assertions.assertTrue((boolean)FSUtils.isLogFile((StoragePath)inlineFsPath));
        Assertions.assertEquals((Object)fileName, (Object)FSUtils.getFileIdFromLogPath((StoragePath)rlPath));
        Assertions.assertEquals((Object)"100", (Object)FSUtils.getDeltaCommitTimeFromLogPath((StoragePath)rlPath));
        Assertions.assertEquals((int)2, (int)FSUtils.getFileVersionFromLog((StoragePath)rlPath));
        Assertions.assertEquals((int)1, (Integer)FSUtils.getTaskPartitionIdFromLogPath((StoragePath)rlPath));
        Assertions.assertEquals((int)0, (Integer)FSUtils.getStageIdFromLogPath((StoragePath)rlPath));
        Assertions.assertEquals((int)1, (Integer)FSUtils.getTaskAttemptIdFromLogPath((StoragePath)rlPath));
        Assertions.assertEquals((Object)logFile, (Object)FSUtils.getFileNameFromPath((String)("/tmp/path/" + logFile)));
        Assertions.assertEquals((Object)logFile, (Object)FSUtils.getFileNameFromPath((String)("/tmp/abc/def/path/" + logFile)));
        Assertions.assertEquals((Object)logFile, (Object)FSUtils.getFileNameFromPath((String)("/tmp/" + logFile)));
    }

    @Test
    public void testCdcLogFileName() {
        String partitionPath = "2022/11/04/";
        String fileName = UUID.randomUUID().toString();
        String logFile = FSUtils.makeLogFileName((String)fileName, (String)".log", (String)"100", (int)2, (String)TEST_WRITE_TOKEN) + ".cdc";
        StoragePath path = new StoragePath(new StoragePath(partitionPath), logFile);
        Assertions.assertTrue((boolean)FSUtils.isLogFile((StoragePath)path));
        Assertions.assertEquals((Object)"log", (Object)FSUtils.getFileExtensionFromLog((StoragePath)path));
        Assertions.assertEquals((Object)fileName, (Object)FSUtils.getFileIdFromLogPath((StoragePath)path));
        Assertions.assertEquals((Object)"100", (Object)FSUtils.getDeltaCommitTimeFromLogPath((StoragePath)path));
        Assertions.assertEquals((int)1, (Integer)FSUtils.getTaskPartitionIdFromLogPath((StoragePath)path));
        Assertions.assertEquals((Object)TEST_WRITE_TOKEN, (Object)FSUtils.getWriteTokenFromLogPath((StoragePath)path));
        Assertions.assertEquals((int)0, (Integer)FSUtils.getStageIdFromLogPath((StoragePath)path));
        Assertions.assertEquals((int)1, (Integer)FSUtils.getTaskAttemptIdFromLogPath((StoragePath)path));
        Assertions.assertEquals((int)2, (int)FSUtils.getFileVersionFromLog((StoragePath)path));
    }

    @Test
    public void testArchiveLogFileName() {
        String partitionPath = "2022/11/04/";
        String fileName = "commits";
        String logFile = FSUtils.makeLogFileName((String)fileName, (String)".archive", (String)"", (int)2, (String)TEST_WRITE_TOKEN);
        StoragePath path = new StoragePath(new StoragePath(partitionPath), logFile);
        Assertions.assertFalse((boolean)FSUtils.isLogFile((StoragePath)path));
        Assertions.assertEquals((Object)"archive", (Object)FSUtils.getFileExtensionFromLog((StoragePath)path));
        Assertions.assertEquals((Object)fileName, (Object)FSUtils.getFileIdFromLogPath((StoragePath)path));
        Assertions.assertEquals((Object)"", (Object)FSUtils.getDeltaCommitTimeFromLogPath((StoragePath)path));
        Assertions.assertEquals((int)1, (Integer)FSUtils.getTaskPartitionIdFromLogPath((StoragePath)path));
        Assertions.assertEquals((Object)TEST_WRITE_TOKEN, (Object)FSUtils.getWriteTokenFromLogPath((StoragePath)path));
        Assertions.assertEquals((int)0, (Integer)FSUtils.getStageIdFromLogPath((StoragePath)path));
        Assertions.assertEquals((int)1, (Integer)FSUtils.getTaskAttemptIdFromLogPath((StoragePath)path));
        Assertions.assertEquals((int)2, (int)FSUtils.getFileVersionFromLog((StoragePath)path));
    }

    @Test
    public void testOldLogFilesComparison() {
        String log1Ver0 = TestFSUtils.makeOldLogFileName("file1", ".log", "1", 0);
        String log1Ver1 = TestFSUtils.makeOldLogFileName("file1", ".log", "1", 1);
        String log1base2 = TestFSUtils.makeOldLogFileName("file1", ".log", "2", 0);
        List logFiles = Stream.of(log1base2, log1Ver1, log1Ver0).map(HoodieLogFile::new).sorted(HoodieLogFile.getLogFileComparator()).collect(Collectors.toList());
        Assertions.assertEquals((Object)log1Ver0, (Object)((HoodieLogFile)logFiles.get(0)).getFileName());
        Assertions.assertEquals((Object)log1Ver1, (Object)((HoodieLogFile)logFiles.get(1)).getFileName());
        Assertions.assertEquals((Object)log1base2, (Object)((HoodieLogFile)logFiles.get(2)).getFileName());
    }

    @Test
    public void testLogFilesComparison() {
        String log1Ver0W0 = FSUtils.makeLogFileName((String)"file1", (String)".log", (String)"1", (int)0, (String)"0-0-1");
        String log1Ver0W1 = FSUtils.makeLogFileName((String)"file1", (String)".log", (String)"1", (int)0, (String)"1-1-1");
        String log1Ver1W0 = FSUtils.makeLogFileName((String)"file1", (String)".log", (String)"1", (int)1, (String)"0-0-1");
        String log1Ver1W1 = FSUtils.makeLogFileName((String)"file1", (String)".log", (String)"1", (int)1, (String)"1-1-1");
        String log1base2W0 = FSUtils.makeLogFileName((String)"file1", (String)".log", (String)"2", (int)0, (String)"0-0-1");
        String log1base2W1 = FSUtils.makeLogFileName((String)"file1", (String)".log", (String)"2", (int)0, (String)"1-1-1");
        List logFiles = Stream.of(log1Ver1W1, log1base2W0, log1base2W1, log1Ver1W0, log1Ver0W1, log1Ver0W0).map(HoodieLogFile::new).sorted(HoodieLogFile.getLogFileComparator()).collect(Collectors.toList());
        Assertions.assertEquals((Object)log1Ver0W0, (Object)((HoodieLogFile)logFiles.get(0)).getFileName());
        Assertions.assertEquals((Object)log1Ver0W1, (Object)((HoodieLogFile)logFiles.get(1)).getFileName());
        Assertions.assertEquals((Object)log1Ver1W0, (Object)((HoodieLogFile)logFiles.get(2)).getFileName());
        Assertions.assertEquals((Object)log1Ver1W1, (Object)((HoodieLogFile)logFiles.get(3)).getFileName());
        Assertions.assertEquals((Object)log1base2W0, (Object)((HoodieLogFile)logFiles.get(4)).getFileName());
        Assertions.assertEquals((Object)log1base2W1, (Object)((HoodieLogFile)logFiles.get(5)).getFileName());
    }

    @Test
    public void testLogFilesComparisonWithCDCFile() {
        HoodieLogFile log1 = new HoodieLogFile(new StoragePath(FSUtils.makeLogFileName((String)"file1", (String)".log", (String)"1", (int)0, (String)"0-0-1")));
        HoodieLogFile log2 = new HoodieLogFile(new StoragePath(FSUtils.makeLogFileName((String)"file1", (String)".log", (String)"2", (int)0, (String)"0-0-1")));
        HoodieLogFile log3 = new HoodieLogFile(new StoragePath(FSUtils.makeLogFileName((String)"file1", (String)".log", (String)"2", (int)1, (String)"0-0-1")));
        HoodieLogFile log4 = new HoodieLogFile(new StoragePath(FSUtils.makeLogFileName((String)"file1", (String)".log", (String)"2", (int)1, (String)"1-1-1")));
        HoodieLogFile log5 = new HoodieLogFile(new StoragePath(FSUtils.makeLogFileName((String)"file1", (String)".log", (String)"2", (int)1, (String)"1-1-1") + ".cdc"));
        TreeSet<HoodieLogFile> logFilesSet = new TreeSet<HoodieLogFile>(HoodieLogFile.getLogFileComparator());
        logFilesSet.add(log1);
        logFilesSet.add(log2);
        logFilesSet.add(log3);
        logFilesSet.add(log4);
        logFilesSet.add(log5);
        ArrayList logFilesList = new ArrayList(logFilesSet);
        Assertions.assertEquals((Object)log1, logFilesList.get(0));
        Assertions.assertEquals((Object)log2, logFilesList.get(1));
        Assertions.assertEquals((Object)log3, logFilesList.get(2));
        Assertions.assertEquals((Object)log4, logFilesList.get(3));
        Assertions.assertEquals((Object)log5, logFilesList.get(4));
    }

    public static String makeOldLogFileName(String fileId, String logFileExtension, String deltaCommitTime, int version) {
        return "." + String.format("%s_%s%s.%d", fileId, deltaCommitTime, logFileExtension, version);
    }

    @Test
    public void testFileNameRelatedFunctions() throws Exception {
        String instantTime = "20160501010101";
        String partitionStr = "2016/05/01";
        int taskPartitionId = 456;
        String writeToken = "456";
        String fileId = "Id123";
        int version = 1;
        String LOG_STR = "log";
        String LOG_EXTENSION = ".log";
        String dataFileName = FSUtils.makeBaseFileName((String)instantTime, (String)writeToken, (String)fileId, (String)HoodieCommonTestHarness.BASE_FILE_EXTENSION);
        Assertions.assertEquals((Object)instantTime, (Object)FSUtils.getCommitTime((String)dataFileName));
        Assertions.assertEquals((Object)fileId, (Object)FSUtils.getFileId((String)dataFileName));
        String logFileName = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)instantTime, (int)version, (String)writeToken);
        Assertions.assertTrue((boolean)FSUtils.isLogFile((StoragePath)new StoragePath(logFileName)));
        Assertions.assertEquals((Object)instantTime, (Object)FSUtils.getDeltaCommitTimeFromLogPath((StoragePath)new StoragePath(logFileName)));
        Assertions.assertEquals((Object)fileId, (Object)FSUtils.getFileIdFromLogPath((StoragePath)new StoragePath(logFileName)));
        Assertions.assertEquals((int)version, (int)FSUtils.getFileVersionFromLog((StoragePath)new StoragePath(logFileName)));
        Assertions.assertEquals((Object)"log", (Object)FSUtils.getFileExtensionFromLog((StoragePath)new StoragePath(logFileName)));
        java.nio.file.Path partitionPath = Paths.get(this.basePath, partitionStr);
        Files.createDirectories(partitionPath, new FileAttribute[0]);
        String log1 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)instantTime, (int)1, (String)writeToken);
        Files.createFile(partitionPath.resolve(log1), new FileAttribute[0]);
        String log2 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)instantTime, (int)2, (String)writeToken);
        Files.createFile(partitionPath.resolve(log2), new FileAttribute[0]);
        String log3 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)instantTime, (int)3, (String)writeToken);
        Files.createFile(partitionPath.resolve(log3), new FileAttribute[0]);
        Assertions.assertEquals((int)3, (int)((Integer)((Pair)FSUtils.getLatestLogVersion((HoodieStorage)HoodieStorageUtils.getStorage((String)this.basePath, (StorageConfiguration)HadoopFSUtils.getStorageConf((Configuration)new Configuration())), (StoragePath)new StoragePath(partitionPath.toString()), (String)fileId, (String)".log", (String)instantTime).get()).getLeft()));
    }

    @Test
    public void testGetFilename() {
        Assertions.assertEquals((Object)"file1.parquet", (Object)FSUtils.getFileName((String)"/2022/07/29/file1.parquet", (String)"/2022/07/29"));
        Assertions.assertEquals((Object)"file2.parquet", (Object)FSUtils.getFileName((String)"2022/07/29/file2.parquet", (String)"2022/07/29"));
        Assertions.assertEquals((Object)"file3.parquet", (Object)FSUtils.getFileName((String)"/file3.parquet", (String)""));
        Assertions.assertEquals((Object)"file4.parquet", (Object)FSUtils.getFileName((String)"file4.parquet", (String)""));
    }

    private void prepareTestDirectory(HoodieStorage storage, StoragePath rootDir) throws IOException {
        String subDir1 = rootDir + "/subdir1";
        String file1 = subDir1 + "/file1.txt";
        String subDir2 = rootDir + "/subdir2";
        String file2 = subDir2 + "/file2.txt";
        String file3 = rootDir + "/file3.txt";
        String[] dirs = new String[]{rootDir.toString(), subDir1, subDir2};
        String[] files = new String[]{file1, file2, file3};
        this.cleanUpTestDirectory(storage, rootDir);
        for (String dir : dirs) {
            storage.createDirectory(new StoragePath(dir));
        }
        for (String filename : files) {
            storage.create(new StoragePath(filename));
        }
    }

    private void cleanUpTestDirectory(HoodieStorage storage, StoragePath rootDir) throws IOException {
        storage.deleteDirectory(rootDir);
    }

    @Test
    public void testDeleteExistingDir() throws IOException {
        StoragePath rootDir = this.getHoodieTempDir();
        HoodieStorage storage = this.metaClient.getStorage();
        this.prepareTestDirectory(storage, rootDir);
        Assertions.assertTrue((boolean)storage.exists(rootDir));
        Assertions.assertTrue((boolean)FSUtils.deleteDir((HoodieEngineContext)new HoodieLocalEngineContext(this.metaClient.getStorageConf()), (HoodieStorage)storage, (StoragePath)rootDir, (int)2));
        Assertions.assertFalse((boolean)storage.exists(rootDir));
    }

    @Test
    public void testDeleteNonExistingDir() throws IOException {
        StoragePath rootDir = this.getHoodieTempDir();
        this.cleanUpTestDirectory(this.metaClient.getStorage(), rootDir);
        Assertions.assertFalse((boolean)FSUtils.deleteDir((HoodieEngineContext)new HoodieLocalEngineContext(this.metaClient.getStorageConf()), (HoodieStorage)this.metaClient.getStorage(), (StoragePath)rootDir, (int)2));
    }

    @Test
    public void testDeleteSubDirectoryRecursively() throws IOException {
        StoragePath rootDir = this.getHoodieTempDir();
        StoragePath subDir = new StoragePath(rootDir, "subdir1");
        HoodieStorage storage = this.metaClient.getStorage();
        this.prepareTestDirectory(storage, rootDir);
        Assertions.assertTrue((boolean)FSUtils.deleteSubPath((String)subDir.toString(), (StorageConfiguration)storage.getConf(), (boolean)true));
    }

    @Test
    public void testDeleteSubDirectoryNonRecursively() throws IOException {
        StoragePath rootDir = this.getHoodieTempDir();
        StoragePath subDir = new StoragePath(rootDir, "subdir1");
        HoodieStorage storage = this.metaClient.getStorage();
        this.prepareTestDirectory(storage, rootDir);
        Assertions.assertThrows(HoodieIOException.class, () -> FSUtils.deleteSubPath((String)subDir.toString(), (StorageConfiguration)storage.getConf(), (boolean)false));
    }

    @Test
    public void testDeleteSubPathAsFile() throws IOException {
        StoragePath rootDir = this.getHoodieTempDir();
        StoragePath subDir = new StoragePath(rootDir, "file3.txt");
        HoodieStorage storage = this.metaClient.getStorage();
        this.prepareTestDirectory(storage, rootDir);
        Assertions.assertTrue((boolean)FSUtils.deleteSubPath((String)subDir.toString(), (StorageConfiguration)storage.getConf(), (boolean)false));
    }

    @Test
    public void testDeleteNonExistingSubDirectory() throws IOException {
        StoragePath rootDir = this.getHoodieTempDir();
        StoragePath subDir = new StoragePath(rootDir, "subdir10");
        HoodieStorage storage = this.metaClient.getStorage();
        this.cleanUpTestDirectory(storage, rootDir);
        Assertions.assertFalse((boolean)FSUtils.deleteSubPath((String)subDir.toString(), (StorageConfiguration)storage.getConf(), (boolean)true));
    }

    @Test
    public void testParallelizeSubPathProcessWithExistingDir() throws IOException {
        StoragePath rootDir = this.getHoodieTempDir();
        HoodieStorage storage = this.metaClient.getStorage();
        this.prepareTestDirectory(storage, rootDir);
        Map result = FSUtils.parallelizeSubPathProcess((HoodieEngineContext)new HoodieLocalEngineContext(storage.getConf()), (HoodieStorage)storage, (StoragePath)rootDir, (int)2, fileStatus -> !fileStatus.getPath().getName().contains("1"), (FSUtils.SerializableFunction & Serializable)pairOfSubPathAndConf -> {
            Path subPath = new Path((String)pairOfSubPathAndConf.getKey());
            List<Object> listFiles = new ArrayList();
            try {
                FileSystem fs = subPath.getFileSystem((Configuration)((StorageConfiguration)pairOfSubPathAndConf.getValue()).unwrapAs(Configuration.class));
                FileStatus[] fileStatuses = fs.listStatus(subPath);
                listFiles = Arrays.stream(fileStatuses).map(fileStatus -> fileStatus.getPath().getName()).collect(Collectors.toList());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return listFiles;
        });
        Assertions.assertEquals((int)2, (int)result.size());
        for (String subPath : result.keySet()) {
            if (subPath.contains("subdir2")) {
                Assertions.assertEquals(Collections.singletonList("file2.txt"), result.get(subPath));
                continue;
            }
            if (!subPath.contains("file3")) continue;
            Assertions.assertEquals(Collections.singletonList("file3.txt"), result.get(subPath));
        }
    }

    @Test
    public void testGetFileStatusAtLevel() throws IOException {
        StoragePath hoodieTempDir = this.getHoodieTempDir();
        HoodieStorage storage = this.metaClient.getStorage();
        this.prepareTestDirectory(storage, hoodieTempDir);
        List fileStatusList = HadoopFSUtils.getFileStatusAtLevel((HoodieEngineContext)new HoodieLocalEngineContext(storage.getConf()), (FileSystem)((FileSystem)storage.getFileSystem()), (Path)new Path(this.baseUri), (int)3, (int)2);
        Assertions.assertEquals((Object)CollectionUtils.createImmutableSet((Object[])new Path[]{new Path(this.baseUri.toString(), ".hoodie/.temp/subdir1/file1.txt"), new Path(this.baseUri.toString(), ".hoodie/.temp/subdir2/file2.txt")}), fileStatusList.stream().map(FileStatus::getPath).filter(filePath -> filePath.getName().endsWith(".txt")).collect(Collectors.toSet()));
    }

    @Test
    public void testGetFileExtension() {
        String pathWithExtension = "/path/to/some/file/sample.parquet";
        String pathWithoutExtension = "/path/to/some/file/sample";
        String justFileNameWithExtension = "sample.orc";
        String justFileNameWithoutExtension = "sample";
        String result1 = FSUtils.getFileExtension((String)pathWithExtension);
        Assertions.assertEquals((Object)".parquet", (Object)result1);
        String result2 = FSUtils.getFileExtension((String)pathWithoutExtension);
        Assertions.assertEquals((Object)"", (Object)result2);
        String result3 = FSUtils.getFileExtension((String)justFileNameWithExtension);
        Assertions.assertEquals((Object)".orc", (Object)result3);
        String result4 = FSUtils.getFileExtension((String)justFileNameWithoutExtension);
        Assertions.assertEquals((Object)"", (Object)result4);
        Assertions.assertThrows(NullPointerException.class, () -> FSUtils.getFileExtension(null));
    }

    @Test
    public void testMakeQualified() {
        FileSystem fs = HadoopFSUtils.getFs((String)"file:///a/b/c", (Configuration)new Configuration());
        HoodieWrapperFileSystem wrapperFs = new HoodieWrapperFileSystem(fs, (ConsistencyGuard)new NoOpConsistencyGuard());
        HoodieHadoopStorage storage = new HoodieHadoopStorage(fs);
        HoodieHadoopStorage wrapperStorage = new HoodieHadoopStorage((FileSystem)wrapperFs);
        Assertions.assertEquals((Object)new StoragePath("file:///x/y"), (Object)FSUtils.makeQualified((HoodieStorage)storage, (StoragePath)new StoragePath("/x/y")));
        Assertions.assertEquals((Object)new StoragePath("file:///x/y"), (Object)FSUtils.makeQualified((HoodieStorage)wrapperStorage, (StoragePath)new StoragePath("/x/y")));
        Assertions.assertEquals((Object)new StoragePath("s3://x/y"), (Object)FSUtils.makeQualified((HoodieStorage)storage, (StoragePath)new StoragePath("s3://x/y")));
        Assertions.assertEquals((Object)new StoragePath("s3://x/y"), (Object)FSUtils.makeQualified((HoodieStorage)wrapperStorage, (StoragePath)new StoragePath("s3://x/y")));
    }

    @Test
    public void testSetModificationTime() throws IOException {
        StoragePath path = new StoragePath(this.basePath, "dummy.txt");
        FileSystem fs = HadoopFSUtils.getFs((String)this.basePath, (Configuration)new Configuration());
        HoodieHadoopStorage storage = new HoodieHadoopStorage(fs);
        storage.create(path);
        long modificationTime = System.currentTimeMillis();
        storage.setModificationTime(path, modificationTime);
        Assertions.assertEquals((long)(modificationTime / 1000L), (long)(fs.getFileStatus(HadoopFSUtils.convertToHadoopPath((StoragePath)path)).getModificationTime() / 1000L));
    }

    @Test
    void testComparePathsWithoutScheme() {
        String path1 = "s3://test_bucket_one/table/base/path";
        String path2 = "s3a://test_bucket_two/table/base/path";
        Assertions.assertFalse((boolean)FSUtils.comparePathsWithoutScheme((String)path1, (String)path2), (String)"should return false since bucket names dont match");
        path1 = "s3a://test_bucket_one/table/new_base/path";
        path2 = "s3a://test_bucket_one/table/old_base/path";
        Assertions.assertFalse((boolean)FSUtils.comparePathsWithoutScheme((String)path1, (String)path2), (String)"should return false since paths don't match");
        path1 = "s3://test_bucket_one/table/base/path";
        path2 = "s3a://test_bucket_one/table/base/path";
        Assertions.assertTrue((boolean)FSUtils.comparePathsWithoutScheme((String)path1, (String)path2), (String)"should return false since bucket names match without file shema");
        path1 = "s3a://test_bucket_one/table/base/path";
        path2 = "s3a://test_bucket_one/table/base/path";
        Assertions.assertTrue((boolean)FSUtils.comparePathsWithoutScheme((String)path1, (String)path2), (String)"should return true since bucket names and path matches");
        path1 = "gs://test_bucket_one/table/base/path";
        path2 = "gs://test_bucket_two/table/base/path";
        Assertions.assertFalse((boolean)FSUtils.comparePathsWithoutScheme((String)path1, (String)path2), (String)"should return true since bucket names and path matches");
        path1 = "gs://test_bucket_one/table/base/path";
        path2 = "gs://test_bucket_one/table/base/path";
        Assertions.assertTrue((boolean)FSUtils.comparePathsWithoutScheme((String)path1, (String)path2), (String)"should return true since bucket names and path matches");
        path1 = "file:/var/table/base/path";
        path2 = "/var/table/base/path";
        Assertions.assertTrue((boolean)FSUtils.comparePathsWithoutScheme((String)path1, (String)path2), (String)"should return true since path matches");
        path1 = "file:/var/table/base/path";
        path2 = "file:/var/table/old_base/path";
        Assertions.assertFalse((boolean)FSUtils.comparePathsWithoutScheme((String)path1, (String)path2), (String)"should return false since path doesn't matches");
        path1 = "table/base/path";
        path2 = "table/base/path";
        Assertions.assertTrue((boolean)FSUtils.comparePathsWithoutScheme((String)path1, (String)path2), (String)"should return true since relative path doesn't matches");
    }

    @Test
    void testGetPathWithoutScheme() {
        String path1 = "s3://test_bucket_one/table/base/path";
        Assertions.assertEquals((Object)FSUtils.getPathWithoutScheme((Path)new Path(path1)).toUri().toString(), (Object)"//test_bucket_one/table/base/path", (String)"should return false since bucket names dont match");
        path1 = "s3a://test_bucket_one/table/base/path";
        Assertions.assertEquals((Object)FSUtils.getPathWithoutScheme((Path)new Path(path1)).toUri().toString(), (Object)"//test_bucket_one/table/base/path", (String)"should return false since bucket names dont match");
        path1 = "gs://test_bucket_one/table/base/path";
        Assertions.assertEquals((Object)FSUtils.getPathWithoutScheme((Path)new Path(path1)).toUri().toString(), (Object)"//test_bucket_one/table/base/path", (String)"should return false since bucket names dont match");
    }

    private StoragePath getHoodieTempDir() {
        return new StoragePath(this.baseUri.toString(), ".hoodie/.temp");
    }
}

