/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs.inline;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hudi.common.testutils.FileSystemTestUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.hadoop.fs.inline.InLineFileSystem;
import org.apache.hudi.hadoop.fs.inline.InMemoryFileSystem;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public abstract class TestInLineFileSystemHFileInLiningBase {
    protected static final String LOCAL_FORMATTER = "%010d";
    protected static final String VALUE_PREFIX = "value";
    private static final int MIN_BLOCK_BYTES = 1024;
    private final Configuration inMemoryConf;
    private final Configuration inlineConf;
    private final int maxRows = 100 + FileSystemTestUtils.RANDOM.nextInt(1000);
    private Path generatedPath;

    public TestInLineFileSystemHFileInLiningBase() {
        this.inMemoryConf = new Configuration();
        this.inMemoryConf.set("fs.inmemfs.impl", InMemoryFileSystem.class.getName());
        this.inlineConf = new Configuration();
        this.inlineConf.set("fs.inlinefs.impl", InLineFileSystem.class.getName());
    }

    protected abstract void validateHFileReading(InLineFileSystem var1, Configuration var2, Configuration var3, Path var4, int var5) throws IOException;

    @AfterEach
    public void teardown() throws IOException {
        File filePath;
        if (this.generatedPath != null && (filePath = new File(this.generatedPath.toString().substring(this.generatedPath.toString().indexOf(58) + 1))).exists()) {
            FileSystemTestUtils.deleteFile(filePath);
        }
    }

    @Test
    public void testSimpleInlineFileSystem() throws IOException {
        Path outerPath;
        Path outerInMemFSPath = FileSystemTestUtils.getRandomOuterInMemPath();
        this.generatedPath = outerPath = new Path("file" + outerInMemFSPath.toString().substring(outerInMemFSPath.toString().indexOf(58)));
        CacheConfig cacheConf = new CacheConfig(this.inMemoryConf);
        FSDataOutputStream fout = this.createFSOutput(outerInMemFSPath, this.inMemoryConf);
        HFileContext meta = new HFileContextBuilder().withBlockSize(1024).withCellComparator((CellComparator)CellComparatorImpl.COMPARATOR).build();
        HFile.Writer writer = HFile.getWriterFactory((Configuration)this.inMemoryConf, (CacheConfig)cacheConf).withOutputStream(fout).withFileContext(meta).create();
        this.writeRecords(writer);
        fout.close();
        byte[] inlineBytes = this.getBytesToInline(outerInMemFSPath);
        long startOffset = this.generateOuterFile(outerPath, inlineBytes);
        long inlineLength = inlineBytes.length;
        Path inlinePath = new Path(FileSystemTestUtils.getPhantomFile(new StoragePath(outerPath.toUri()), startOffset, inlineLength).toUri());
        InLineFileSystem inlineFileSystem = (InLineFileSystem)inlinePath.getFileSystem(this.inlineConf);
        FSDataInputStream fin = inlineFileSystem.open(inlinePath);
        this.validateHFileReading(inlineFileSystem, this.inMemoryConf, this.inlineConf, inlinePath, this.maxRows);
        fin.close();
        outerPath.getFileSystem(this.inMemoryConf).delete(outerPath, true);
    }

    protected Set<Integer> getRandomValidRowIds(int count) {
        HashSet<Integer> rowIds = new HashSet<Integer>();
        while (rowIds.size() < count) {
            int index = FileSystemTestUtils.RANDOM.nextInt(this.maxRows);
            if (rowIds.contains(index)) continue;
            rowIds.add(index);
        }
        return rowIds;
    }

    private FSDataOutputStream createFSOutput(Path name, Configuration conf) throws IOException {
        return name.getFileSystem(conf).create(name);
    }

    private void writeRecords(HFile.Writer writer) throws IOException {
        this.writeSomeRecords(writer);
        writer.close();
    }

    private void writeSomeRecords(HFile.Writer writer) throws IOException {
        for (int i = 0; i < this.maxRows; ++i) {
            String key = String.format(LOCAL_FORMATTER, i);
            KeyValue kv = new KeyValue(StringUtils.getUTF8Bytes((String)key), StringUtils.getUTF8Bytes((String)"family"), StringUtils.getUTF8Bytes((String)"qual"), StringUtils.getUTF8Bytes((String)(VALUE_PREFIX + key)));
            writer.append((Cell)kv);
        }
    }

    private long generateOuterFile(Path outerPath, byte[] inlineBytes) throws IOException {
        FSDataOutputStream wrappedOut = outerPath.getFileSystem(this.inMemoryConf).create(outerPath, true);
        this.writeRandomBytes(wrappedOut, 10);
        long startOffset = wrappedOut.getPos();
        wrappedOut.write(inlineBytes);
        this.writeRandomBytes(wrappedOut, 5);
        wrappedOut.hsync();
        wrappedOut.close();
        return startOffset;
    }

    private byte[] getBytesToInline(Path outerInMemFSPath) throws IOException {
        InMemoryFileSystem inMemoryFileSystem = (InMemoryFileSystem)outerInMemFSPath.getFileSystem(this.inMemoryConf);
        return inMemoryFileSystem.getFileAsBytes();
    }

    private void writeRandomBytes(FSDataOutputStream writer, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            writer.writeUTF(UUID.randomUUID().toString());
        }
    }
}

