/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestHoodiePartitionMetadata
extends HoodieCommonTestHarness {
    HoodieStorage storage;

    @BeforeEach
    public void setupTest() throws IOException {
        this.initMetaClient();
        this.storage = this.metaClient.getStorage();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.storage.close();
        this.cleanMetaClient();
    }

    static Stream<Arguments> formatProviderFn() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{Option.empty()}), Arguments.arguments((Object[])new Object[]{Option.of((Object)HoodieFileFormat.PARQUET)}), Arguments.arguments((Object[])new Object[]{Option.of((Object)HoodieFileFormat.ORC)}));
    }

    @ParameterizedTest
    @MethodSource(value={"formatProviderFn"})
    public void testTextFormatMetaFile(Option<HoodieFileFormat> format) throws IOException {
        StoragePath partitionPath = new StoragePath(this.basePath, "a/b/" + (String)format.map(Enum::name).orElse((Object)"text"));
        this.storage.createDirectory(partitionPath);
        String commitTime = "000000000001";
        HoodiePartitionMetadata writtenMetadata = new HoodiePartitionMetadata(this.metaClient.getStorage(), "000000000001", new StoragePath(this.basePath), partitionPath, format);
        writtenMetadata.trySave();
        HoodiePartitionMetadata readMetadata = new HoodiePartitionMetadata(this.metaClient.getStorage(), partitionPath);
        Assertions.assertTrue((boolean)HoodiePartitionMetadata.hasPartitionMetadata((HoodieStorage)this.storage, (StoragePath)partitionPath));
        Assertions.assertEquals((Object)Option.of((Object)"000000000001"), (Object)readMetadata.readPartitionCreatedCommitTime());
        Assertions.assertEquals((int)3, (int)readMetadata.getPartitionDepth());
    }

    @Test
    public void testErrorIfAbsent() throws IOException {
        StoragePath partitionPath = new StoragePath(this.basePath, "a/b/not-a-partition");
        this.storage.createDirectory(partitionPath);
        HoodiePartitionMetadata readMetadata = new HoodiePartitionMetadata(this.metaClient.getStorage(), partitionPath);
        Assertions.assertThrows(HoodieException.class, () -> ((HoodiePartitionMetadata)readMetadata).readPartitionCreatedCommitTime());
    }

    @Test
    public void testFileNames() {
        Assertions.assertEquals((Object)new StoragePath("/a/b/c/.hoodie_partition_metadata"), (Object)HoodiePartitionMetadata.textFormatMetaFilePath((StoragePath)new StoragePath("/a/b/c")));
        Assertions.assertEquals(Arrays.asList(new StoragePath("/a/b/c/.hoodie_partition_metadata.parquet"), new StoragePath("/a/b/c/.hoodie_partition_metadata.orc")), (Object)HoodiePartitionMetadata.baseFormatMetaFilePaths((StoragePath)new StoragePath("/a/b/c")));
    }
}

