/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.collection.Triple;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

public class TestHoodieTableConfig
extends HoodieCommonTestHarness {
    private HoodieStorage storage;
    private StoragePath metaPath;
    private StoragePath cfgPath;
    private StoragePath backupCfgPath;

    @BeforeEach
    public void setUp() throws Exception {
        this.initPath();
        this.storage = HoodieStorageUtils.getStorage((String)this.basePath, (StorageConfiguration)HoodieTestUtils.getDefaultStorageConfWithDefaults());
        this.metaPath = new StoragePath(this.basePath, ".hoodie");
        Properties props = new Properties();
        props.setProperty(HoodieTableConfig.NAME.key(), "test-table");
        HoodieTableConfig.create((HoodieStorage)this.storage, (StoragePath)this.metaPath, (Properties)props);
        this.cfgPath = new StoragePath(this.metaPath, "hoodie.properties");
        this.backupCfgPath = new StoragePath(this.metaPath, "hoodie.properties.backup");
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.storage.close();
    }

    @Test
    public void testCreate() throws IOException {
        Assertions.assertTrue((boolean)this.storage.exists(new StoragePath(this.metaPath, "hoodie.properties")));
        HoodieTableConfig config = new HoodieTableConfig(this.storage, this.metaPath, null, null, null);
        Assertions.assertEquals((int)7, (int)config.getProps().size());
    }

    @Test
    public void testUpdate() throws IOException {
        Properties updatedProps = new Properties();
        updatedProps.setProperty(HoodieTableConfig.NAME.key(), "test-table2");
        updatedProps.setProperty(HoodieTableConfig.PRECOMBINE_FIELD.key(), "new_field");
        HoodieTableConfig.update((HoodieStorage)this.storage, (StoragePath)this.metaPath, (Properties)updatedProps);
        Assertions.assertTrue((boolean)this.storage.exists(this.cfgPath));
        Assertions.assertFalse((boolean)this.storage.exists(this.backupCfgPath));
        HoodieTableConfig config = new HoodieTableConfig(this.storage, this.metaPath, null, null, null);
        Assertions.assertEquals((int)8, (int)config.getProps().size());
        Assertions.assertEquals((Object)"test-table2", (Object)config.getTableName());
        Assertions.assertEquals((Object)"new_field", (Object)config.getPreCombineField());
    }

    @Test
    public void testDelete() throws IOException {
        Set deletedProps = CollectionUtils.createSet((Object[])new String[]{HoodieTableConfig.TIMELINE_HISTORY_PATH.key(), "hoodie.invalid.config"});
        HoodieTableConfig.delete((HoodieStorage)this.storage, (StoragePath)this.metaPath, (Set)deletedProps);
        Assertions.assertTrue((boolean)this.storage.exists(this.cfgPath));
        Assertions.assertFalse((boolean)this.storage.exists(this.backupCfgPath));
        HoodieTableConfig config = new HoodieTableConfig(this.storage, this.metaPath, null, null, null);
        Assertions.assertEquals((int)6, (int)config.getProps().size());
        Assertions.assertNull((Object)config.getProps().getProperty("hoodie.invalid.config"));
        Assertions.assertFalse((boolean)config.getProps().contains((Object)HoodieTableConfig.TIMELINE_HISTORY_PATH.key()));
    }

    @Test
    public void testReadsWhenPropsFileDoesNotExist() throws IOException {
        this.storage.deleteFile(this.cfgPath);
        Assertions.assertThrows(HoodieIOException.class, () -> new HoodieTableConfig(this.storage, this.metaPath, null, null, null));
    }

    @Test
    public void testReadsWithUpdateFailures() throws IOException {
        HoodieTableConfig config = new HoodieTableConfig(this.storage, this.metaPath, null, null, null);
        this.storage.deleteFile(this.cfgPath);
        try (OutputStream out = this.storage.create(this.backupCfgPath);){
            config.getProps().store(out, "");
        }
        Assertions.assertFalse((boolean)this.storage.exists(this.cfgPath));
        Assertions.assertTrue((boolean)this.storage.exists(this.backupCfgPath));
        config = new HoodieTableConfig(this.storage, this.metaPath, null, null, null);
        Assertions.assertEquals((int)7, (int)config.getProps().size());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testUpdateRecovery(boolean shouldPropsFileExist) throws IOException {
        HoodieTableConfig config = new HoodieTableConfig(this.storage, this.metaPath, null, null, null);
        if (!shouldPropsFileExist) {
            this.storage.deleteFile(this.cfgPath);
        }
        try (OutputStream out = this.storage.create(this.backupCfgPath);){
            config.getProps().store(out, "");
        }
        ConfigUtils.recoverIfNeeded((HoodieStorage)this.storage, (StoragePath)this.cfgPath, (StoragePath)this.backupCfgPath);
        Assertions.assertTrue((boolean)this.storage.exists(this.cfgPath));
        Assertions.assertFalse((boolean)this.storage.exists(this.backupCfgPath));
        config = new HoodieTableConfig(this.storage, this.metaPath, null, null, null);
        Assertions.assertEquals((int)7, (int)config.getProps().size());
    }

    @Test
    public void testReadRetry() throws IOException {
        this.storage.rename(this.cfgPath, new StoragePath(this.cfgPath.toString() + ".bak"));
        Assertions.assertThrows(HoodieIOException.class, () -> new HoodieTableConfig(this.storage, this.metaPath, null, null, null));
        this.storage.rename(new StoragePath(this.cfgPath.toString() + ".bak"), this.backupCfgPath);
        new HoodieTableConfig(this.storage, this.metaPath, null, null, null);
        Properties props = new Properties();
        props.put(HoodieTableConfig.TABLE_CHECKSUM.key(), "0");
        try (OutputStream out = this.storage.create(this.cfgPath);){
            props.store(out, "Wrong checksum in file so is invalid");
        }
        new HoodieTableConfig(this.storage, this.metaPath, null, null, null);
        out = this.storage.create(this.backupCfgPath);
        var3_3 = null;
        try {
            props.store(out, "Wrong checksum in file so is invalid");
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (out != null) {
                if (var3_3 != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    out.close();
                }
            }
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new HoodieTableConfig(this.storage, this.metaPath, null, null, null));
    }

    @Test
    public void testConcurrentlyUpdate() throws ExecutionException, InterruptedException {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        Future<?> updaterFuture = executor.submit(() -> {
            for (int i = 0; i < 100; ++i) {
                Properties updatedProps = new Properties();
                updatedProps.setProperty(HoodieTableConfig.NAME.key(), "test-table" + i);
                updatedProps.setProperty(HoodieTableConfig.PRECOMBINE_FIELD.key(), "new_field" + i);
                HoodieTableConfig.update((HoodieStorage)this.storage, (StoragePath)this.metaPath, (Properties)updatedProps);
            }
        });
        Future<?> readerFuture = executor.submit(() -> {
            for (int i = 0; i < 100; ++i) {
                new HoodieTableConfig(this.storage, this.metaPath, null, null, null);
            }
        });
        updaterFuture.get();
        readerFuture.get();
        executor.shutdown();
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableVersion.class, names={"SEVEN", "EIGHT"})
    public void testPartitionFields(HoodieTableVersion version) {
        Properties updatedProps = new Properties();
        updatedProps.setProperty(HoodieTableConfig.PARTITION_FIELDS.key(), version.greaterThan(HoodieTableVersion.SEVEN) ? "p1:simple,p2:timestamp" : "p1,p2");
        updatedProps.setProperty(HoodieTableConfig.VERSION.key(), String.valueOf(HoodieTableVersion.EIGHT.versionCode()));
        HoodieTableConfig.update((HoodieStorage)this.storage, (StoragePath)this.metaPath, (Properties)updatedProps);
        HoodieTableConfig config = new HoodieTableConfig(this.storage, this.metaPath, null, null, null);
        Assertions.assertArrayEquals((Object[])new String[]{"p1", "p2"}, (Object[])((Object[])config.getPartitionFields().get()));
        Assertions.assertEquals((Object)"p1,p2", (Object)config.getPartitionFieldProp());
    }

    @ParameterizedTest
    @ValueSource(strings={"p1:simple,p2:timestamp", "p1,p2"})
    public void testPartitionFieldAPIs(String partitionFields) {
        Properties updatedProps = new Properties();
        updatedProps.setProperty(HoodieTableConfig.PARTITION_FIELDS.key(), partitionFields);
        HoodieTableConfig.update((HoodieStorage)this.storage, (StoragePath)this.metaPath, (Properties)updatedProps);
        HoodieTableConfig config = new HoodieTableConfig(this.storage, this.metaPath, null, null, null);
        Assertions.assertEquals((Object)partitionFields, (Object)HoodieTableConfig.getPartitionFieldPropForKeyGenerator((HoodieConfig)config).get());
        Assertions.assertEquals((Object)"p1,p2", (Object)HoodieTableConfig.getPartitionFieldProp((HoodieConfig)config).get());
        Assertions.assertArrayEquals((Object[])Arrays.stream(partitionFields.split(",")).toArray(), (Object[])((List)HoodieTableConfig.getPartitionFieldsForKeyGenerator((HoodieConfig)config).get()).toArray());
        Assertions.assertArrayEquals((Object[])new String[]{"p1", "p2"}, (Object[])((Object[])HoodieTableConfig.getPartitionFields((HoodieConfig)config).get()));
        Assertions.assertEquals((Object)"p1", (Object)HoodieTableConfig.getPartitionFieldWithoutKeyGenPartitionType((String)partitionFields.split(",")[0], (HoodieConfig)config));
    }

    @Test
    public void testValidateConfigVersion() {
        Assertions.assertTrue((boolean)HoodieTableConfig.validateConfigVersion((ConfigProperty)HoodieTableConfig.INITIAL_VERSION, (HoodieTableVersion)HoodieTableVersion.EIGHT));
        Assertions.assertTrue((boolean)HoodieTableConfig.validateConfigVersion((ConfigProperty)ConfigProperty.key((String)"").noDefaultValue().withDocumentation(""), (HoodieTableVersion)HoodieTableVersion.SIX));
        Assertions.assertFalse((boolean)HoodieTableConfig.validateConfigVersion((ConfigProperty)HoodieTableConfig.INITIAL_VERSION, (HoodieTableVersion)HoodieTableVersion.SIX));
    }

    @Test
    public void testDropInvalidConfigs() {
        HoodieConfig config = new HoodieConfig();
        config.setValue(HoodieTableConfig.VERSION, String.valueOf(HoodieTableVersion.SIX.versionCode()));
        config.setValue(HoodieTableConfig.INITIAL_VERSION, String.valueOf(HoodieTableVersion.EIGHT.versionCode()));
        config.setValue(HoodieTableConfig.RECORD_MERGE_MODE, RecordMergeMode.COMMIT_TIME_ORDERING.name());
        HoodieTableConfig.dropInvalidConfigs((HoodieConfig)config);
        Assertions.assertTrue((boolean)config.contains(HoodieTableConfig.VERSION));
        Assertions.assertFalse((boolean)config.contains(HoodieTableConfig.INITIAL_VERSION));
        Assertions.assertFalse((boolean)config.contains(HoodieTableConfig.RECORD_MERGE_MODE));
        config = new HoodieConfig();
        config.setValue(HoodieTableConfig.VERSION, String.valueOf(HoodieTableVersion.EIGHT.versionCode()));
        config.setValue(HoodieTableConfig.RECORD_MERGE_MODE, RecordMergeMode.COMMIT_TIME_ORDERING.name());
        HoodieTableConfig.dropInvalidConfigs((HoodieConfig)config);
        Assertions.assertTrue((boolean)config.contains(HoodieTableConfig.RECORD_MERGE_MODE));
    }

    @Test
    public void testDefinedTableConfigs() {
        List configProperties = HoodieTableConfig.definedTableConfigs();
        Assertions.assertEquals((int)38, (int)configProperties.size());
        configProperties.forEach(c -> {
            Assertions.assertNotNull((Object)c);
            Assertions.assertFalse((boolean)c.doc().isEmpty());
        });
    }

    private static Stream<Arguments> argumentsForInferringRecordMergeMode() {
        String defaultPayload = DefaultHoodieRecordPayload.class.getName();
        String overwritePayload = OverwriteWithLatestAvroPayload.class.getName();
        String customPayload = "custom_payload";
        String customStrategy = "custom_strategy";
        String orderingFieldName = "timestamp";
        Stream<Arguments> arguments = Stream.of(Arguments.arguments((Object[])new Object[]{null, null, null, null, "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{null, null, null, "", "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{null, null, null, orderingFieldName, "false", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{null, "", "", null, "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{null, "", "", orderingFieldName, "false", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, null, null, null, "false", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, null, null, orderingFieldName, "false", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, null, orderingFieldName, "false", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", orderingFieldName, "false", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, null, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", orderingFieldName, "false", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{null, defaultPayload, null, null, "false", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{null, defaultPayload, null, orderingFieldName, "false", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{null, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", orderingFieldName, "false", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{null, null, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", null, "false", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{null, null, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", orderingFieldName, "false", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, null, null, null, "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, null, null, "", "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, null, null, orderingFieldName, "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, null, null, "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d", null, "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, null, "ce9acb64-bde0-424c-9b91-f6ebba25356d", null, "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{null, overwritePayload, null, null, "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{null, overwritePayload, null, "", "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{null, overwritePayload, null, orderingFieldName, "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{null, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d", null, "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{null, null, "ce9acb64-bde0-424c-9b91-f6ebba25356d", null, "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{null, null, "ce9acb64-bde0-424c-9b91-f6ebba25356d", orderingFieldName, "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, customPayload, null, null, "false", RecordMergeMode.CUSTOM, customPayload, "00000000-0000-0000-0000-000000000000"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, customPayload, "00000000-0000-0000-0000-000000000000", null, "false", RecordMergeMode.CUSTOM, customPayload, "00000000-0000-0000-0000-000000000000"}), Arguments.arguments((Object[])new Object[]{null, customPayload, "00000000-0000-0000-0000-000000000000", null, "false", RecordMergeMode.CUSTOM, customPayload, "00000000-0000-0000-0000-000000000000"}), Arguments.arguments((Object[])new Object[]{null, customPayload, null, null, "false", RecordMergeMode.CUSTOM, customPayload, "00000000-0000-0000-0000-000000000000"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, null, customStrategy, null, "false", RecordMergeMode.CUSTOM, defaultPayload, customStrategy}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, customPayload, customStrategy, null, "false", RecordMergeMode.CUSTOM, customPayload, customStrategy}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, defaultPayload, customStrategy, null, "six-only", RecordMergeMode.CUSTOM, defaultPayload, customStrategy}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, defaultPayload, "00000000-0000-0000-0000-000000000000", null, "six-only", RecordMergeMode.CUSTOM, defaultPayload, "00000000-0000-0000-0000-000000000000"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, overwritePayload, "00000000-0000-0000-0000-000000000000", null, "six-only", RecordMergeMode.CUSTOM, overwritePayload, "00000000-0000-0000-0000-000000000000"}), Arguments.arguments((Object[])new Object[]{null, defaultPayload, "00000000-0000-0000-0000-000000000000", null, "false", null, defaultPayload, null}), Arguments.arguments((Object[])new Object[]{null, overwritePayload, "00000000-0000-0000-0000-000000000000", null, "false", null, overwritePayload, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, null, null, null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, null, "00000000-0000-0000-0000-000000000000", null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, overwritePayload, null, orderingFieldName, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, customPayload, null, orderingFieldName, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, null, "ce9acb64-bde0-424c-9b91-f6ebba25356d", orderingFieldName, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, null, customStrategy, orderingFieldName, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, null, "00000000-0000-0000-0000-000000000000", orderingFieldName, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, defaultPayload, null, null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, customPayload, null, null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, null, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, null, customStrategy, null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, null, "00000000-0000-0000-0000-000000000000", null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, defaultPayload, null, null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, overwritePayload, null, null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, null, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, null, "ce9acb64-bde0-424c-9b91-f6ebba25356d", null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, defaultPayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d", null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, overwritePayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{null, defaultPayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d", null, "eight-only", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{null, overwritePayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", null, "eight-only", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}));
        return arguments;
    }

    @ParameterizedTest
    @MethodSource(value={"argumentsForInferringRecordMergeMode"})
    public void testInferMergeMode(RecordMergeMode inputMergeMode, String inputPayloadClass, String inputMergeStrategy, String orderingFieldName, String shouldThrowString, RecordMergeMode outputMergeMode, String outputPayloadClass, String outputMergeStrategy) throws IOException {
        Arrays.stream(new HoodieTableVersion[]{HoodieTableVersion.EIGHT, HoodieTableVersion.SIX}).forEach(tableVersion -> {
            boolean shouldThrow = "eight-only".equals(shouldThrowString) ? tableVersion.greaterThanOrEquals(HoodieTableVersion.EIGHT) : ("six-only".equals(shouldThrowString) ? !tableVersion.greaterThanOrEquals(HoodieTableVersion.EIGHT) : Boolean.parseBoolean(shouldThrowString));
            RecordMergeMode expectedMergeMode = outputMergeMode;
            String expectedMergeStrategy = outputMergeStrategy;
            if (!shouldThrow && outputMergeMode == null) {
                expectedMergeMode = tableVersion.greaterThanOrEquals(HoodieTableVersion.EIGHT) ? RecordMergeMode.CUSTOM : HoodieTableConfig.inferRecordMergeModeFromPayloadClass((String)outputPayloadClass);
                String string = expectedMergeStrategy = tableVersion.greaterThanOrEquals(HoodieTableVersion.EIGHT) ? "00000000-0000-0000-0000-000000000000" : HoodieRecordMerger.getRecordMergeStrategyId((RecordMergeMode)expectedMergeMode, (String)outputPayloadClass, null);
            }
            if (shouldThrow) {
                Assertions.assertThrows(IllegalArgumentException.class, () -> HoodieTableConfig.inferCorrectMergingBehavior((RecordMergeMode)inputMergeMode, (String)inputPayloadClass, (String)inputMergeStrategy, (String)orderingFieldName, (HoodieTableVersion)tableVersion));
            } else {
                Triple inferredConfigs = HoodieTableConfig.inferCorrectMergingBehavior((RecordMergeMode)inputMergeMode, (String)inputPayloadClass, (String)inputMergeStrategy, (String)orderingFieldName, (HoodieTableVersion)tableVersion);
                Assertions.assertEquals((Object)expectedMergeMode, (Object)inferredConfigs.getLeft());
                Assertions.assertEquals((Object)outputPayloadClass, (Object)inferredConfigs.getMiddle());
                Assertions.assertEquals((Object)expectedMergeStrategy, (Object)inferredConfigs.getRight());
            }
        });
    }
}

