/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieIndexMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHoodieTableMetaClient
extends HoodieCommonTestHarness {
    @BeforeEach
    public void init() throws IOException {
        this.initMetaClient();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanMetaClient();
    }

    @Test
    public void checkMetadata() {
        Assertions.assertEquals((Object)"raw_trips", (Object)this.metaClient.getTableConfig().getTableName(), (String)"Table name should be raw_trips");
        Assertions.assertEquals((Object)this.basePath, (Object)this.metaClient.getBasePath().toString(), (String)"Basepath should be the one assigned");
        Assertions.assertEquals((Object)(this.basePath + "/.hoodie"), (Object)this.metaClient.getMetaPath().toString(), (String)"Metapath should be ${basepath}/.hoodie");
        Assertions.assertTrue((boolean)this.metaClient.getTableConfig().getProps().containsKey((Object)HoodieTableConfig.TABLE_CHECKSUM.key()));
        Assertions.assertTrue((boolean)HoodieTableConfig.validateChecksum((Properties)this.metaClient.getTableConfig().getProps()));
        Assertions.assertEquals((Object)HoodieTableVersion.current(), (Object)this.metaClient.getTableConfig().getTableInitialVersion());
    }

    @Test
    public void testSerDe() {
        HoodieTableMetaClient deserializedMetaClient = (HoodieTableMetaClient)HoodieTestUtils.serializeDeserialize((Serializable)this.metaClient, HoodieTableMetaClient.class);
        Assertions.assertNotNull((Object)deserializedMetaClient);
        HoodieActiveTimeline commitTimeline = deserializedMetaClient.getActiveTimeline();
        HoodieInstant instant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", "1");
        commitTimeline.createNewInstant(instant);
        commitTimeline.saveAsComplete(instant, Option.of((Object)StringUtils.getUTF8Bytes((String)"test-detail")));
        commitTimeline = commitTimeline.reload();
        HoodieInstant completedInstant = (HoodieInstant)commitTimeline.getInstantsAsStream().findFirst().get();
        Assertions.assertTrue((boolean)completedInstant.isCompleted());
        Assertions.assertEquals((Object)completedInstant.requestedTime(), (Object)instant.requestedTime());
        Assertions.assertArrayEquals((byte[])StringUtils.getUTF8Bytes((String)"test-detail"), (byte[])((byte[])commitTimeline.getInstantDetails(completedInstant).get()), (String)"Commit value should be \"test-detail\"");
    }

    @Test
    public void testCommitTimeline() {
        HoodieActiveTimeline activeTimeline = this.metaClient.getActiveTimeline();
        HoodieTimeline activeCommitTimeline = activeTimeline.getCommitAndReplaceTimeline();
        Assertions.assertTrue((boolean)activeCommitTimeline.empty(), (String)"Should be empty commit timeline");
        HoodieInstant instant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", "1");
        activeTimeline.createNewInstant(instant);
        activeTimeline.saveAsComplete(instant, Option.of((Object)StringUtils.getUTF8Bytes((String)"test-detail")));
        activeTimeline = this.metaClient.getActiveTimeline();
        activeCommitTimeline = activeTimeline.getCommitAndReplaceTimeline();
        Assertions.assertTrue((boolean)activeCommitTimeline.empty(), (String)"Should be empty commit timeline");
        activeTimeline = activeTimeline.reload();
        HoodieInstant completedInstant = (HoodieInstant)activeTimeline.getCommitsTimeline().getInstantsAsStream().findFirst().get();
        activeCommitTimeline = activeTimeline.getCommitAndReplaceTimeline();
        Assertions.assertFalse((boolean)activeCommitTimeline.empty(), (String)"Should be the 1 commit we made");
        Assertions.assertTrue((boolean)completedInstant.isCompleted());
        Assertions.assertTrue((boolean)completedInstant.requestedTime().equals(instant.requestedTime()));
        Assertions.assertArrayEquals((byte[])StringUtils.getUTF8Bytes((String)"test-detail"), (byte[])((byte[])activeCommitTimeline.getInstantDetails(completedInstant).get()), (String)"Commit value should be \"test-detail\"");
    }

    @Test
    public void testEquals() throws IOException {
        HoodieTableMetaClient metaClient1 = HoodieTestUtils.init((String)this.tempDir.toAbsolutePath().toString(), (HoodieTableType)this.getTableType());
        HoodieTableMetaClient metaClient2 = HoodieTestUtils.init((String)this.tempDir.toAbsolutePath().toString(), (HoodieTableType)this.getTableType());
        Assertions.assertEquals((Object)metaClient1, (Object)metaClient2);
        Assertions.assertNotEquals((Object)metaClient1, null);
        Assertions.assertNotEquals((Object)metaClient1, (Object)new Object());
    }

    @Test
    public void testToString() throws IOException {
        HoodieTableMetaClient metaClient1 = HoodieTestUtils.init((String)this.tempDir.toAbsolutePath().toString(), (HoodieTableType)this.getTableType());
        HoodieTableMetaClient metaClient2 = HoodieTestUtils.init((String)this.tempDir.toAbsolutePath().toString(), (HoodieTableType)this.getTableType());
        Assertions.assertEquals((Object)metaClient1.toString(), (Object)metaClient2.toString());
        Assertions.assertNotEquals((Object)metaClient1.toString(), (Object)new Object().toString());
    }

    @Test
    public void testTableVersion() throws IOException {
        String basePath = this.tempDir.toAbsolutePath() + "/" + "t1";
        HoodieTableMetaClient metaClient1 = HoodieTableMetaClient.newTableBuilder().setTableType(HoodieTableType.MERGE_ON_READ.name()).setTableName("table-version-test").setTableVersion(HoodieTableVersion.SIX.versionCode()).initTable(this.metaClient.getStorageConf(), basePath);
        Assertions.assertEquals((Object)HoodieTableVersion.SIX, (Object)metaClient1.getTableConfig().getTableVersion());
        HoodieTableMetaClient metaClient2 = HoodieTableMetaClient.builder().setConf(this.metaClient.getStorageConf()).setBasePath(basePath).build();
        Assertions.assertEquals((Object)HoodieTableVersion.SIX, (Object)metaClient2.getTableConfig().getTableVersion());
    }

    @Test
    public void testGenerateFromAnotherMetaClient() throws IOException {
        String basePath1 = this.tempDir.toAbsolutePath().toString() + "/" + "t2A";
        String basePath2 = this.tempDir.toAbsolutePath().toString() + "/" + "t2B";
        HoodieTableMetaClient metaClient1 = HoodieTableMetaClient.newTableBuilder().setTableType(HoodieTableType.MERGE_ON_READ.name()).setTableName("table-version-test").setTableVersion(HoodieTableVersion.SIX.versionCode()).initTable(this.metaClient.getStorageConf(), basePath1);
        HoodieTableMetaClient metaClient2 = HoodieTableMetaClient.newTableBuilder().fromMetaClient(metaClient1).initTable(this.metaClient.getStorageConf(), basePath2);
        Assertions.assertEquals((Object)metaClient1.getTableConfig().getTableType(), (Object)metaClient2.getTableConfig().getTableType());
        Assertions.assertEquals((Object)metaClient1.getTableConfig().getTableVersion(), (Object)metaClient2.getTableConfig().getTableVersion());
        Assertions.assertEquals((Object)metaClient1.getTableConfig().getTableName(), (Object)metaClient2.getTableConfig().getTableName());
    }

    @Test
    public void testTableBuilderRequiresTableNameAndType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> HoodieTableMetaClient.builder().setConf(this.metaClient.getStorageConf()).build());
        Assertions.assertThrows(IllegalArgumentException.class, () -> HoodieTableMetaClient.newTableBuilder().setTableName("test-table").initTable(this.metaClient.getStorageConf(), this.tempDir.toAbsolutePath().toString() + "/" + "failing2"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HoodieTableMetaClient.newTableBuilder().setTableType(HoodieTableType.COPY_ON_WRITE.name()).initTable(this.metaClient.getStorageConf(), this.tempDir.toAbsolutePath().toString() + "/" + "failing3"));
    }

    @Test
    public void testCreateMetaClientFromProperties() throws IOException {
        String basePath = this.tempDir.toAbsolutePath().toString() + "/" + "t5";
        Properties props = new Properties();
        props.setProperty(HoodieTableConfig.NAME.key(), "test-table");
        props.setProperty(HoodieTableConfig.TYPE.key(), HoodieTableType.COPY_ON_WRITE.name());
        props.setProperty(HoodieTableConfig.PRECOMBINE_FIELD.key(), "timestamp");
        HoodieTableMetaClient metaClient1 = HoodieTableMetaClient.newTableBuilder().fromProperties(props).initTable(this.metaClient.getStorageConf(), basePath);
        HoodieTableMetaClient metaClient2 = HoodieTableMetaClient.builder().setConf(this.metaClient.getStorageConf()).setBasePath(basePath).build();
        Assertions.assertEquals((Object)metaClient1.getTableConfig().getTableName(), (Object)metaClient2.getTableConfig().getTableName());
        Assertions.assertEquals((Object)metaClient1.getTableConfig().getTableType(), (Object)metaClient2.getTableConfig().getTableType());
        Assertions.assertEquals((Object)metaClient1.getTableConfig().getPreCombineField(), (Object)metaClient2.getTableConfig().getPreCombineField());
        Assertions.assertEquals((Object)HoodieTableVersion.current(), (Object)metaClient2.getTableConfig().getTableVersion());
    }

    @Test
    public void testCreateLayoutInStorage() throws IOException {
        String basePath = this.tempDir.toAbsolutePath().toString() + "/" + "t6";
        HoodieTableMetaClient metaClient1 = HoodieTableMetaClient.newTableBuilder().setTableType(HoodieTableType.COPY_ON_WRITE.name()).setTableName("table-layout-test").initTable(this.metaClient.getStorageConf(), basePath);
        this.metaClient.getRawStorage().exists(new StoragePath(basePath, ".hoodie/.aux"));
        this.metaClient.getRawStorage().exists(new StoragePath(basePath, ".hoodie"));
        this.metaClient.getRawStorage().exists(new StoragePath(basePath, ".hoodie/.temp"));
        this.metaClient.getRawStorage().exists(new StoragePath(basePath, (String)HoodieTableConfig.TIMELINE_HISTORY_PATH.defaultValue()));
        this.metaClient.getRawStorage().exists(new StoragePath(basePath, ".hoodie/hoodie.properties"));
    }

    @Test
    public void testGetIndexDefinitionPath() throws IOException {
        String basePath = this.tempDir.toAbsolutePath() + "/" + "t7";
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.newTableBuilder().setTableType(HoodieTableType.COPY_ON_WRITE.name()).setTableName("table").initTable(this.metaClient.getStorageConf(), basePath);
        Assertions.assertEquals((Object)(metaClient.getMetaPath() + "/.index_defs/index.json"), (Object)metaClient.getIndexDefinitionPath());
        String randomDefinitionPath = "/a/b/c";
        metaClient.getTableConfig().setValue(HoodieTableConfig.RELATIVE_INDEX_DEFINITION_PATH.key(), "/a/b/c");
        Assertions.assertEquals((Object)randomDefinitionPath, (Object)metaClient.getIndexDefinitionPath());
    }

    @Test
    public void testDeleteDefinition() throws IOException {
        String basePath = this.tempDir.toAbsolutePath() + "/" + "t7";
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.newTableBuilder().setTableType(HoodieTableType.COPY_ON_WRITE.name()).setTableName("table").initTable(this.metaClient.getStorageConf(), basePath);
        HashMap columnsMap = new HashMap();
        columnsMap.put("c1", Collections.emptyMap());
        String indexName = MetadataPartitionType.EXPRESSION_INDEX.getPartitionPath() + "idx";
        HoodieIndexDefinition indexDefinition = HoodieIndexDefinition.newBuilder().withIndexName(indexName).withIndexType("column_stats").withIndexFunction("identity").withSourceFields(new ArrayList(columnsMap.keySet())).withIndexOptions(Collections.emptyMap()).build();
        metaClient.buildIndexDefinition(indexDefinition);
        Assertions.assertTrue((boolean)((HoodieIndexMetadata)metaClient.getIndexMetadata().get()).getIndexDefinitions().containsKey(indexName));
        Assertions.assertTrue((boolean)metaClient.getStorage().exists(new StoragePath(metaClient.getIndexDefinitionPath())));
        metaClient.deleteIndexDefinition(indexName);
        Assertions.assertTrue((boolean)metaClient.getIndexMetadata().isEmpty());
        Assertions.assertTrue((boolean)metaClient.getStorage().exists(new StoragePath(metaClient.getIndexDefinitionPath())));
        HoodieIndexMetadata indexMetadata = HoodieIndexMetadata.fromJson((String)new String((byte[])FileIOUtils.readDataFromPath((HoodieStorage)metaClient.getStorage(), (StoragePath)new StoragePath(metaClient.getIndexDefinitionPath())).get()));
        Assertions.assertTrue((boolean)indexMetadata.getIndexDefinitions().isEmpty());
    }
}

