/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieClusteringStrategy;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.versioning.v2.InstantComparatorV2;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.internal.schema.HoodieSchemaException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestTableSchemaResolver
extends HoodieCommonTestHarness {
    @BeforeEach
    public void setUp() throws Exception {
        this.initMetaClient();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanMetaClient();
    }

    @Test
    public void testRecreateSchemaWhenDropPartitionColumns() {
        Schema originSchema = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
        String[] pts1 = new String[]{};
        Schema s2 = TableSchemaResolver.appendPartitionColumns((Schema)originSchema, (Option)Option.of((Object)pts1));
        Assertions.assertEquals((Object)originSchema, (Object)s2);
        String[] pts2 = new String[]{"partition_path"};
        Schema s3 = TableSchemaResolver.appendPartitionColumns((Schema)originSchema, (Option)Option.of((Object)pts2));
        Assertions.assertEquals((Object)originSchema, (Object)s3);
        String[] pts3 = new String[]{"user_partition"};
        Schema s4 = TableSchemaResolver.appendPartitionColumns((Schema)originSchema, (Option)Option.of((Object)pts3));
        Assertions.assertNotEquals((Object)originSchema, (Object)s4);
        Assertions.assertTrue((boolean)s4.getFields().stream().anyMatch(f -> f.name().equals("user_partition")));
        Schema.Field f2 = s4.getField("user_partition");
        Assertions.assertEquals((Object)f2.schema(), (Object)AvroSchemaUtils.createNullableSchema((Schema.Type)Schema.Type.STRING));
        String[] pts4 = new String[]{"user_partition", "partition_path"};
        try {
            TableSchemaResolver.appendPartitionColumns((Schema)originSchema, (Option)Option.of((Object)pts3));
        }
        catch (HoodieSchemaException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Partial partition fields are still in the schema"));
        }
    }

    @Test
    public void testReadSchemaFromLogFile() throws IOException, URISyntaxException, InterruptedException {
        this.initPath("read_schema_from_log_file");
        StoragePath partitionPath = new StoragePath(this.basePath, "partition1");
        Schema expectedSchema = SchemaTestUtil.getSimpleSchema();
        StoragePath logFilePath = this.writeLogFile(partitionPath, expectedSchema);
        Assertions.assertEquals((Object)expectedSchema, (Object)TableSchemaResolver.readSchemaFromLogFile((HoodieStorage)new HoodieHadoopStorage(logFilePath, HoodieTestUtils.getDefaultStorageConfWithDefaults()), (StoragePath)logFilePath));
    }

    @Test
    public void testGetTableSchemaFromLatestCommitMetadataV2() throws Exception {
        Schema originalSchema = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
        HoodieActiveTimeline activeTimeline = this.metaClient.getActiveTimeline();
        String commitTime1 = "001";
        HoodieInstant instant1 = new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", commitTime1, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
        activeTimeline.createNewInstant(instant1);
        HashMap<String, String> extraMetadata = new HashMap<String, String>();
        extraMetadata.put("schema", originalSchema.toString());
        activeTimeline.saveAsComplete(instant1, Option.of((Object)this.getCommitMetadata(this.basePath, "partition1", commitTime1, 2, extraMetadata)));
        this.metaClient.reloadActiveTimeline();
        TableSchemaResolver resolver = new TableSchemaResolver(this.metaClient);
        Option schemaOption = resolver.getTableAvroSchemaForClustering(false);
        Assertions.assertTrue((boolean)schemaOption.isPresent());
        Assertions.assertEquals((Object)originalSchema, (Object)schemaOption.get());
    }

    @Test
    public void testGetTableCreateSchemaWithMetadata() throws IOException {
        Schema originalSchema = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
        HashMap<String, String> emptyMetadata = new HashMap<String, String>();
        HoodieActiveTimeline activeTimeline = this.metaClient.getActiveTimeline();
        String commitTime1 = "001";
        HoodieInstant instant1 = new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", commitTime1, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
        activeTimeline.createNewInstant(instant1);
        activeTimeline.saveAsComplete(instant1, Option.of((Object)this.getCommitMetadata(this.basePath, "partition1", commitTime1, 2, emptyMetadata)));
        this.metaClient.reloadActiveTimeline();
        this.metaClient.getTableConfig().setValue(HoodieTableConfig.CREATE_SCHEMA, originalSchema.toString());
        TableSchemaResolver resolver = new TableSchemaResolver(this.metaClient);
        Option schemaOption = resolver.getTableAvroSchemaForClustering(false);
        Assertions.assertTrue((boolean)schemaOption.isPresent());
        Assertions.assertEquals((Object)originalSchema, (Object)schemaOption.get());
    }

    @Test
    public void testHandlePartitionColumnsIfNeeded() {
        Schema originalSchema = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
        CharSequence[] partitionFields = new String[]{"partition_path"};
        this.metaClient.getTableConfig().setValue(HoodieTableConfig.PARTITION_FIELDS, String.join((CharSequence)",", partitionFields));
        this.metaClient.getTableConfig().setValue(HoodieTableConfig.DROP_PARTITION_COLUMNS, "true");
        this.metaClient.getTableConfig().setValue(HoodieTableConfig.CREATE_SCHEMA, originalSchema.toString());
        TableSchemaResolver resolver = new TableSchemaResolver(this.metaClient);
        Option schemaOption = resolver.getTableAvroSchemaForClustering(false);
        Assertions.assertTrue((boolean)schemaOption.isPresent());
        Schema resultSchema = (Schema)schemaOption.get();
        Assertions.assertTrue((boolean)resultSchema.getFields().stream().anyMatch(f -> f.name().equals("partition_path")));
    }

    static Stream<SchemaEvolutionTestCase> schemaEvolutionTestCases() {
        return Stream.of(new SchemaEvolutionTestCase("Empty Timeline", HoodieTableType.COPY_ON_WRITE, new ArrayList<HoodieInstant>(), new ArrayList<HoodieInstant>()), new SchemaEvolutionTestCase("Empty Timeline", HoodieTableType.MERGE_ON_READ, new ArrayList<HoodieInstant>(), new ArrayList<HoodieInstant>()), new SchemaEvolutionTestCase("Mixed Actions", HoodieTableType.COPY_ON_WRITE, Arrays.asList(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "001", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR), new HoodieInstant(HoodieInstant.State.COMPLETED, "replacecommit", "002", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "003", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR), new HoodieInstant(HoodieInstant.State.REQUESTED, "clean", "004", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR), new HoodieInstant(HoodieInstant.State.REQUESTED, "rollback", "005", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR), new HoodieInstant(HoodieInstant.State.REQUESTED, "clustering", "006", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR), new HoodieInstant(HoodieInstant.State.INFLIGHT, "clean", "004", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR), new HoodieInstant(HoodieInstant.State.INFLIGHT, "rollback", "005", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR), new HoodieInstant(HoodieInstant.State.INFLIGHT, "clustering", "006", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR), new HoodieInstant(HoodieInstant.State.COMPLETED, "clean", "004", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR), new HoodieInstant(HoodieInstant.State.COMPLETED, "rollback", "005", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR), new HoodieInstant(HoodieInstant.State.COMPLETED, "clustering", "006", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR), new HoodieInstant(HoodieInstant.State.COMPLETED, "replacecommit", "010", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR)), Arrays.asList(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "003", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR), new HoodieInstant(HoodieInstant.State.COMPLETED, "replacecommit", "002", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "001", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR)), new HoodieInstant(HoodieInstant.State.COMPLETED, "replacecommit", "010", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR)), new SchemaEvolutionTestCase("Comprehensive Mixed Timeline", HoodieTableType.COPY_ON_WRITE, Arrays.asList(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "001", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR), new HoodieInstant(HoodieInstant.State.COMPLETED, "replacecommit", "002", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "003", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR), new HoodieInstant(HoodieInstant.State.REQUESTED, "commit", "004", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR), new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", "005", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR), new HoodieInstant(HoodieInstant.State.COMPLETED, "clean", "006", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR), new HoodieInstant(HoodieInstant.State.COMPLETED, "clustering", "007", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR), new HoodieInstant(HoodieInstant.State.COMPLETED, "replacecommit", "010", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR)), Arrays.asList(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "003", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR), new HoodieInstant(HoodieInstant.State.COMPLETED, "replacecommit", "002", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "001", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR)), new HoodieInstant(HoodieInstant.State.COMPLETED, "replacecommit", "010", InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR)));
    }

    private HoodieTableMetaClient prepareMetaClient(List<HoodieInstant> instants, HoodieTableType tableType, Option<HoodieInstant> clusteringInstant) throws IOException {
        HoodieTableMetaClient mockMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        HoodieTableConfig mockTableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        TimelineLayout timelineLayout = TimelineLayout.TIMELINE_LAYOUT_V2;
        HoodieActiveTimeline mockActiveTimeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class);
        Mockito.when((Object)mockMetaClient.getTableType()).thenReturn((Object)tableType);
        Mockito.when((Object)mockMetaClient.getTimelineLayout()).thenReturn((Object)timelineLayout);
        Mockito.when((Object)mockMetaClient.getActiveTimeline()).thenReturn((Object)mockActiveTimeline);
        Mockito.when((Object)mockActiveTimeline.getInstantsAsStream()).thenReturn(instants.stream());
        Mockito.when((Object)mockActiveTimeline.getInstantDetails((HoodieInstant)ArgumentMatchers.any())).thenReturn((Object)Option.of((Object)new byte[0]));
        Mockito.when((Object)mockMetaClient.getBasePath()).thenReturn((Object)new StoragePath("file://dummy/path"));
        Mockito.when((Object)mockMetaClient.scanHoodieInstantsFromFileSystem((StoragePath)ArgumentMatchers.any(), (Set)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true))).thenReturn(instants);
        Mockito.when((Object)mockMetaClient.getMetaPath()).thenReturn((Object)new StoragePath("file://dummy/path/.hoodie"));
        Mockito.when((Object)mockMetaClient.getTableConfig()).thenReturn((Object)mockTableConfig);
        Mockito.when((Object)mockMetaClient.getTableConfig().getTimelinePath()).thenReturn((Object)"timeline");
        Mockito.when((Object)mockMetaClient.getInstantGenerator()).thenReturn((Object)HoodieTestUtils.INSTANT_GENERATOR);
        if (clusteringInstant.isPresent()) {
            HoodieRequestedReplaceMetadata requestedReplaceMetadata = HoodieRequestedReplaceMetadata.newBuilder().setOperationType("CLUSTER").setClusteringPlan(HoodieClusteringPlan.newBuilder().setVersion(Integer.valueOf(1)).setStrategy(HoodieClusteringStrategy.newBuilder().setStrategyClassName("org.apache.hudi.client.clustering.run.strategy.SparkSingleFileSortStrategy").build()).build()).build();
            HoodieInstant requestedInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "clustering", ((HoodieInstant)clusteringInstant.get()).requestedTime(), InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
            Mockito.when((Object)mockActiveTimeline.getInstantDetails(requestedInstant)).thenReturn((Object)TimelineMetadataUtils.serializeRequestedReplaceMetadata((HoodieRequestedReplaceMetadata)requestedReplaceMetadata));
        }
        return mockMetaClient;
    }

    @ParameterizedTest
    @MethodSource(value={"schemaEvolutionTestCases"})
    public void testGetSchemaEvolutionTimelineInReverseOrder(SchemaEvolutionTestCase testCase) throws IOException {
        HoodieTableMetaClient mockMetaClient = this.prepareMetaClient(testCase.inputInstants, testCase.tableType, (Option<HoodieInstant>)testCase.clusteringInstants);
        TableSchemaResolver resolver = new TableSchemaResolver(mockMetaClient);
        HoodieTimeline timeline = resolver.getSchemaEvolutionTimelineInReverseOrder();
        this.verifyTimelineInstants(testCase.expectedInstants, timeline);
    }

    private void verifyTimelineInstants(List<HoodieInstant> expectedInstants, HoodieTimeline timeline) {
        List actualInstants = timeline.getInstantsAsStream().collect(Collectors.toList());
        Assertions.assertEquals((int)expectedInstants.size(), (int)actualInstants.size());
        for (int i = 0; i < expectedInstants.size(); ++i) {
            HoodieInstant expected = expectedInstants.get(i);
            HoodieInstant actual = (HoodieInstant)actualInstants.get(i);
            Assertions.assertEquals((Object)expected.getAction(), (Object)actual.getAction());
            Assertions.assertEquals((Object)expected.getCompletionTime(), (Object)actual.getCompletionTime());
            Assertions.assertEquals((Object)expected.getState(), (Object)actual.getState());
        }
    }

    private StoragePath writeLogFile(StoragePath partitionPath, Schema schema) throws IOException, URISyntaxException, InterruptedException {
        HoodieStorage storage = HoodieTestUtils.getStorage((StoragePath)partitionPath);
        HoodieLogFormat.Writer writer = HoodieLogFormat.newWriterBuilder().onParentPath(partitionPath).withFileExtension(".log").withFileId("test-fileid1").withInstantTime("100").withStorage(storage).build();
        List records = SchemaTestUtil.generateTestRecords((int)0, (int)100);
        HashMap<HoodieLogBlock.HeaderMetadataType, String> header = new HashMap<HoodieLogBlock.HeaderMetadataType, String>();
        header.put(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME, "100");
        header.put(HoodieLogBlock.HeaderMetadataType.SCHEMA, schema.toString());
        HoodieDataBlock dataBlock = TestTableSchemaResolver.getDataBlock(HoodieLogBlock.HoodieLogBlockType.AVRO_DATA_BLOCK, records, header);
        writer.appendBlock((HoodieLogBlock)dataBlock);
        writer.close();
        return writer.getLogFile().getPath();
    }

    @Test
    public void testGetTableAvroSchemaInternalFromCommitMetadata() throws Exception {
        Schema originalSchema = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
        HoodieActiveTimeline activeTimeline = this.metaClient.getActiveTimeline();
        String commitTime = "001";
        HoodieInstant instant = new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", commitTime, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
        activeTimeline.createNewInstant(instant);
        HashMap<String, String> extraMetadata = new HashMap<String, String>();
        extraMetadata.put("schema", originalSchema.toString());
        activeTimeline.saveAsComplete(instant, Option.of((Object)this.getCommitMetadata(this.basePath, "partition1", commitTime, 2, extraMetadata)));
        this.metaClient.reloadActiveTimeline();
        TableSchemaResolver resolver = new TableSchemaResolver(this.metaClient);
        Option schemaWithoutMetadata = resolver.getTableAvroSchemaInternal(false, Option.empty());
        Assertions.assertTrue((boolean)schemaWithoutMetadata.isPresent());
        Assertions.assertNull((Object)((Schema)schemaWithoutMetadata.get()).getField(HoodieRecord.RECORD_KEY_METADATA_FIELD));
    }

    @Test
    public void testGetTableAvroSchemaInternalFromTableConfig() {
        Schema originalSchema = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
        this.metaClient.getTableConfig().setValue(HoodieTableConfig.CREATE_SCHEMA, originalSchema.toString());
        TableSchemaResolver resolver = new TableSchemaResolver(this.metaClient);
        Option schemaWithMetadata = resolver.getTableAvroSchemaInternal(true, Option.empty());
        Assertions.assertTrue((boolean)schemaWithMetadata.isPresent());
        Assertions.assertTrue((((Schema)schemaWithMetadata.get()).getField(HoodieRecord.RECORD_KEY_METADATA_FIELD) != null ? 1 : 0) != 0);
        Option schemaWithoutMetadata = resolver.getTableAvroSchemaInternal(false, Option.empty());
        Assertions.assertTrue((boolean)schemaWithoutMetadata.isPresent());
        Assertions.assertNull((Object)((Schema)schemaWithoutMetadata.get()).getField(HoodieRecord.RECORD_KEY_METADATA_FIELD));
    }

    @Test
    public void testGetTableAvroSchemaInternalWithPartitionFields() throws Exception {
        Schema originalSchema = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
        CharSequence[] partitionFields = new String[]{"partition_path"};
        this.metaClient.getTableConfig().setValue(HoodieTableConfig.PARTITION_FIELDS, String.join((CharSequence)",", partitionFields));
        this.metaClient.getTableConfig().setValue(HoodieTableConfig.DROP_PARTITION_COLUMNS, "true");
        this.metaClient.getTableConfig().setValue(HoodieTableConfig.CREATE_SCHEMA, originalSchema.toString());
        TableSchemaResolver resolver = new TableSchemaResolver(this.metaClient);
        Option schemaOption = resolver.getTableAvroSchemaInternal(true, Option.empty());
        Assertions.assertTrue((boolean)schemaOption.isPresent());
        Schema resultSchema = (Schema)schemaOption.get();
        Assertions.assertTrue((boolean)resultSchema.getFields().stream().anyMatch(f -> f.name().equals("partition_path")));
    }

    @Test
    public void testGetTableAvroSchemaInternalNoSchemaFound() throws Exception {
        TableSchemaResolver resolver = new TableSchemaResolver(this.metaClient);
        Option schemaOption = resolver.getTableAvroSchemaInternal(true, Option.empty());
        Assertions.assertFalse((boolean)schemaOption.isPresent());
    }

    @Test
    public void testGetTableAvroSchemaInternalWithSpecificInstant() throws Exception {
        Schema schema1 = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
        Schema schema2 = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}");
        HoodieActiveTimeline activeTimeline = this.metaClient.getActiveTimeline();
        String commitTime1 = "001";
        HoodieInstant instant1 = new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", commitTime1, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
        activeTimeline.createNewInstant(instant1);
        HashMap<String, String> metadata1 = new HashMap<String, String>();
        metadata1.put("schema", schema1.toString());
        activeTimeline.saveAsComplete(instant1, Option.of((Object)this.getCommitMetadata(this.basePath, "partition1", commitTime1, 2, metadata1)));
        String commitTime2 = "002";
        HoodieInstant instant2 = new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", commitTime2, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
        activeTimeline.createNewInstant(instant2);
        HashMap<String, String> metadata2 = new HashMap<String, String>();
        metadata2.put("schema", schema2.toString());
        activeTimeline.saveAsComplete(instant2, Option.of((Object)this.getCommitMetadata(this.basePath, "partition1", commitTime2, 2, metadata2)));
        this.metaClient.reloadActiveTimeline();
        TableSchemaResolver resolver = new TableSchemaResolver(this.metaClient);
        Option schema1Option = resolver.getTableAvroSchemaInternal(false, Option.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", commitTime1, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR)));
        Assertions.assertTrue((boolean)schema1Option.isPresent());
        Assertions.assertEquals((Object)schema1.toString(), (Object)((Schema)schema1Option.get()).toString());
        Option schema2Option = resolver.getTableAvroSchemaInternal(false, Option.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", commitTime2, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR)));
        Assertions.assertTrue((boolean)schema2Option.isPresent());
        Assertions.assertEquals((Object)schema2.toString(), (Object)((Schema)schema2Option.get()).toString());
    }

    static class SchemaEvolutionTestCase {
        private final String name;
        private final HoodieTableType tableType;
        private final List<HoodieInstant> inputInstants;
        private final List<HoodieInstant> expectedInstants;
        private final Option<HoodieInstant> clusteringInstants;

        public SchemaEvolutionTestCase(String name, HoodieTableType tableType, List<HoodieInstant> inputInstants, List<HoodieInstant> expectedInstants) {
            this.name = name;
            this.tableType = tableType;
            this.inputInstants = inputInstants;
            this.expectedInstants = expectedInstants;
            this.clusteringInstants = Option.empty();
        }

        public SchemaEvolutionTestCase(String name, HoodieTableType tableType, List<HoodieInstant> inputInstants, List<HoodieInstant> expectedInstants, HoodieInstant clusteringInstants) {
            this.name = name;
            this.tableType = tableType;
            this.inputInstants = inputInstants;
            this.expectedInstants = expectedInstants;
            this.clusteringInstants = Option.of((Object)clusteringInstants);
        }

        public String toString() {
            return String.format("%s (%s)", this.name, this.tableType);
        }
    }
}

