/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.io.IOException;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

public class TestHoodieLogWriterBuilder {
    HoodieLogFormat.WriterBuilder builder;
    HoodieLogFormat.Writer writer;
    HoodieStorage storage;

    @BeforeEach
    public void setup() {
        this.storage = (HoodieStorage)Mockito.mock(HoodieStorage.class);
        this.builder = HoodieLogFormat.newWriterBuilder().withFileId("test-fileid1").withInstantTime("100").onParentPath(new StoragePath("/tmp")).withFileExtension(".log").withStorage(this.storage);
    }

    @AfterEach
    public void cleanup() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    @ParameterizedTest
    @ValueSource(ints={6, 8})
    public void testLogFileNaming(int tableVersion) throws IOException {
        this.writer = this.builder.withTableVersion(HoodieTableVersion.fromVersionCode((int)tableVersion)).build();
        HoodieLogFile logFile = this.writer.getLogFile();
        Assertions.assertTrue((boolean)logFile.getFileName().contains(".log"));
        Assertions.assertEquals((Integer)HoodieLogFile.LOGFILE_BASE_VERSION, (int)logFile.getLogVersion());
        Assertions.assertEquals((Object)"100", (Object)logFile.getDeltaCommitTime());
        Assertions.assertEquals((Object)"test-fileid1", (Object)logFile.getFileId());
        Assertions.assertEquals((Object)"1-0-1", (Object)logFile.getLogWriteToken());
    }
}

