/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.fs.ConsistencyGuard;
import org.apache.hudi.common.fs.NoOpConsistencyGuard;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.TimelineFactory;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.testutils.Assertions;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.MockHoodieTimeline;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.fs.HoodieWrapperFileSystem;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHoodieActiveTimeline
extends HoodieCommonTestHarness {
    private HoodieActiveTimeline timeline;

    @BeforeEach
    public void setUp() throws Exception {
        this.initMetaClient();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanMetaClient();
    }

    @Test
    public void testLoadingInstantsFromFiles() throws IOException {
        InstantGenerator instantGenerator = HoodieTestUtils.INSTANT_GENERATOR;
        TimelineFactory timelineFactory = HoodieTestUtils.TIMELINE_FACTORY;
        HoodieInstant instant1 = instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, "commit", "1");
        HoodieInstant instant2 = instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, "commit", "3");
        HoodieInstant instant3 = instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, "commit", "5");
        HoodieInstant instant4 = instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, "commit", "8");
        HoodieInstant instant1Complete = instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "1");
        HoodieInstant instant2Complete = instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "3");
        HoodieInstant instant3Complete = instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "5");
        HoodieInstant instant4Complete = instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "8");
        HoodieInstant instant5 = instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", "9");
        this.timeline = timelineFactory.createActiveTimeline(this.metaClient);
        this.timeline.createNewInstant(instant1);
        this.timeline.transitionRequestedToInflight(instant1, Option.empty());
        this.timeline.saveAsComplete(instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, instant1.getAction(), instant1.requestedTime()), Option.empty());
        this.timeline.createNewInstant(instant2);
        this.timeline.transitionRequestedToInflight(instant2, Option.empty());
        this.timeline.saveAsComplete(instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, instant2.getAction(), instant2.requestedTime()), Option.empty());
        this.timeline.createNewInstant(instant3);
        this.timeline.transitionRequestedToInflight(instant3, Option.empty());
        this.timeline.saveAsComplete(instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, instant3.getAction(), instant3.requestedTime()), Option.empty());
        this.timeline.createNewInstant(instant4);
        this.timeline.transitionRequestedToInflight(instant4, Option.empty());
        this.timeline.saveAsComplete(instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, instant4.getAction(), instant4.requestedTime()), Option.empty());
        this.timeline.createNewInstant(instant5);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)this.timeline.countInstants(), (String)"Total instants should be 5");
        Assertions.assertStreamEquals(Stream.of(instant1Complete, instant2Complete, instant3Complete, instant4Complete, instant5), (Stream)this.timeline.getInstantsAsStream(), (String)"Check the instants stream");
        Assertions.assertStreamEquals(Stream.of(instant1Complete, instant2Complete, instant3Complete, instant4Complete, instant5), (Stream)this.timeline.getCommitTimeline().getInstantsAsStream(), (String)"Check the instants stream");
        Assertions.assertStreamEquals(Stream.of(instant1Complete, instant2Complete, instant3Complete, instant4Complete, instant5), (Stream)this.timeline.getCommitAndReplaceTimeline().getInstantsAsStream(), (String)"Check the instants stream");
        Assertions.assertStreamEquals(Stream.of(instant1Complete, instant2Complete, instant3Complete, instant4Complete), (Stream)this.timeline.getCommitAndReplaceTimeline().filterCompletedInstants().getInstantsAsStream(), (String)"Check the instants stream");
        Assertions.assertStreamEquals(Stream.of(instant5), (Stream)this.timeline.getCommitAndReplaceTimeline().filterPendingExcludingCompactionAndLogCompaction().getInstantsAsStream(), (String)"Check the instants stream");
    }

    @Test
    public void testTimelineOperationsBasic() {
        this.timeline = HoodieTestUtils.TIMELINE_FACTORY.createActiveTimeline(this.metaClient);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.empty());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.timeline.countInstants());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Option.empty(), (Object)this.timeline.firstInstant());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Option.empty(), (Object)this.timeline.nthInstant(5));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Option.empty(), (Object)this.timeline.nthInstant(-1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Option.empty(), (Object)this.timeline.lastInstant());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "01")));
    }

    @Test
    public void testTimelineOperations() {
        this.timeline = new MockHoodieTimeline(Stream.of("01", "03", "05", "07", "09", "11", "13", "15", "17", "19"), Stream.of("21", "23"));
        Assertions.assertStreamEquals(Stream.of("05", "07", "09", "11"), this.timeline.getCommitAndReplaceTimeline().filterCompletedInstants().findInstantsInRange("04", "11").getInstantsAsStream().map(HoodieInstant::requestedTime), (String)"findInstantsInRange should return 4 instants");
        Assertions.assertStreamEquals(Stream.of("03", "05", "07", "09", "11"), this.timeline.getCommitAndReplaceTimeline().filterCompletedInstants().findInstantsInClosedRange("03", "11").getInstantsAsStream().map(HoodieInstant::requestedTime), (String)"findInstantsInClosedRange should return 5 instants");
        Assertions.assertStreamEquals(Stream.of("09", "11"), this.timeline.getCommitAndReplaceTimeline().filterCompletedInstants().findInstantsAfter("07", 2).getInstantsAsStream().map(HoodieInstant::requestedTime), (String)"findInstantsAfter 07 should return 2 instants");
        Assertions.assertStreamEquals(Stream.of("01", "03", "05"), this.timeline.getCommitAndReplaceTimeline().filterCompletedInstants().findInstantsBefore("07").getInstantsAsStream().map(HoodieInstant::requestedTime), (String)"findInstantsBefore 07 should return 3 instants");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.empty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.getCommitAndReplaceTimeline().filterPendingExcludingCompactionAndLogCompaction().empty());
        org.junit.jupiter.api.Assertions.assertEquals((int)12, (int)this.timeline.countInstants());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"01", (Object)((HoodieInstant)this.timeline.firstInstant("commit", HoodieInstant.State.COMPLETED).get()).requestedTime());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"21", (Object)((HoodieInstant)this.timeline.firstInstant("commit", HoodieInstant.State.INFLIGHT).get()).requestedTime());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.firstInstant("commit", HoodieInstant.State.REQUESTED).isPresent());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.firstInstant("replacecommit", HoodieInstant.State.COMPLETED).isPresent());
        HoodieTimeline activeCommitTimeline = this.timeline.getCommitAndReplaceTimeline().filterCompletedInstants();
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)activeCommitTimeline.countInstants());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"01", (Object)((HoodieInstant)activeCommitTimeline.firstInstant().get()).requestedTime());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"11", (Object)((HoodieInstant)activeCommitTimeline.nthInstant(5).get()).requestedTime());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"19", (Object)((HoodieInstant)activeCommitTimeline.lastInstant().get()).requestedTime());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"09", (Object)((HoodieInstant)activeCommitTimeline.nthFromLastInstant(5).get()).requestedTime());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)activeCommitTimeline.containsInstant(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "09")));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)activeCommitTimeline.isBeforeTimelineStarts("02"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)activeCommitTimeline.isBeforeTimelineStarts("00"));
    }

    @Test
    public void testAllowTempCommit() {
        this.shouldAllowTempCommit(true, hoodieMetaClient -> {
            this.timeline = HoodieTestUtils.TIMELINE_FACTORY.createActiveTimeline(hoodieMetaClient);
            HoodieInstant instant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", "1");
            this.timeline.createNewInstant(instant1);
            byte[] data = StringUtils.getUTF8Bytes((String)"commit");
            this.timeline.saveAsComplete(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, instant1.getAction(), instant1.requestedTime()), Option.of((Object)data));
            this.timeline = this.timeline.reload();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.getContiguousCompletedWriteTimeline().lastInstant().isPresent());
            org.junit.jupiter.api.Assertions.assertEquals((Object)instant1.requestedTime(), (Object)((HoodieInstant)this.timeline.getContiguousCompletedWriteTimeline().lastInstant().get()).requestedTime());
        });
    }

    @Test
    public void testGetContiguousCompletedWriteTimeline() {
        this.timeline = new MockHoodieTimeline(Stream.of("01", "03", "05", "07", "13", "15", "17"), Stream.of("09", "11", "19"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.getContiguousCompletedWriteTimeline().lastInstant().isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"07", (Object)((HoodieInstant)this.timeline.getContiguousCompletedWriteTimeline().lastInstant().get()).requestedTime());
        HoodieInstant instant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "1");
        HoodieInstant instant2 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "2");
        HoodieInstant instant3 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "3");
        HoodieInstant instant4 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "4");
        HoodieInstant instant5 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", "5");
        HoodieInstant instant6 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "6");
        HoodieInstant instant7 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "7");
        HoodieInstant instant8 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "restore", "8");
        this.timeline = HoodieTestUtils.TIMELINE_FACTORY.createActiveTimeline(this.metaClient);
        this.timeline.createCompleteInstant(instant1);
        this.timeline.createCompleteInstant(instant2);
        this.timeline.createCompleteInstant(instant3);
        this.timeline.createCompleteInstant(instant4);
        this.timeline.createNewInstant(instant5);
        this.timeline.createCompleteInstant(instant6);
        this.timeline.createCompleteInstant(instant7);
        this.timeline.createNewInstant(instant8);
        this.timeline.setInstants(Stream.of(instant1, instant2, instant3, instant4, instant5, instant6, instant7, instant8).collect(Collectors.toList()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.getContiguousCompletedWriteTimeline().lastInstant().isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)instant4.requestedTime(), (Object)((HoodieInstant)this.timeline.getContiguousCompletedWriteTimeline().lastInstant().get()).requestedTime());
        this.timeline.saveAsComplete(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, instant5.getAction(), instant5.requestedTime()), Option.empty());
        this.timeline.saveAsComplete(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, instant8.getAction(), instant8.requestedTime()), Option.empty());
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.getContiguousCompletedWriteTimeline().lastInstant().isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)instant7.requestedTime(), (Object)((HoodieInstant)this.timeline.getContiguousCompletedWriteTimeline().lastInstant().get()).requestedTime());
    }

    @Test
    public void testTimelineWithSavepointAndHoles() {
        this.timeline = new MockHoodieTimeline(Stream.of(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "01"), HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "savepoint", "01"), HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "03"), HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "savepoint", "03"), HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "05")).collect(Collectors.toList()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("00"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("01"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("02"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("03"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("04"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.isBeforeTimelineStarts("05"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.isBeforeTimelineStarts("06"));
        this.timeline = new MockHoodieTimeline(Stream.of(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "01"), HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "savepoint", "01"), HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "03"), HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "savepoint", "03"), HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "05")).collect(Collectors.toList()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("00"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("01"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("02"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("03"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("04"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.isBeforeTimelineStarts("05"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.isBeforeTimelineStarts("06"));
        this.timeline = new MockHoodieTimeline(Stream.of(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "01"), HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "savepoint", "01"), HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "03"), HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "savepoint", "03"), HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "05"), HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "replacecommit", "06"), HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "clustering", "07")).collect(Collectors.toList()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("00"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("01"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("02"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("03"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("04"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.isBeforeTimelineStarts("05"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.isBeforeTimelineStarts("06"));
    }

    @Test
    public void testTimelineGetOperations() {
        List<HoodieInstant> allInstants = this.getAllInstants();
        Supplier<Stream> allInstantsSup = allInstants::stream;
        this.timeline = HoodieTestUtils.TIMELINE_FACTORY.createActiveTimeline(this.metaClient, true);
        this.timeline.setInstants(allInstants);
        BiConsumer<HoodieTimeline, Set> checkTimeline = (timeline, actions) -> {
            List<HoodieInstant> expectedInstants = ((Stream)allInstantsSup.get()).filter(i -> actions.contains(i.getAction())).collect(Collectors.toList());
            List<HoodieInstant> unexpectedInstants = ((Stream)allInstantsSup.get()).filter(i -> !actions.contains(i.getAction())).collect(Collectors.toList());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)expectedInstants.isEmpty());
            expectedInstants.forEach(i -> org.junit.jupiter.api.Assertions.assertTrue((boolean)timeline.containsInstant(i)));
            unexpectedInstants.forEach(i -> org.junit.jupiter.api.Assertions.assertFalse((boolean)timeline.containsInstant(i)));
        };
        checkTimeline.accept(this.timeline.getCommitsTimeline(), CollectionUtils.createSet((Object[])new String[]{"commit", "deltacommit", "replacecommit", "clustering"}));
        checkTimeline.accept(this.timeline.getWriteTimeline(), CollectionUtils.createSet((Object[])new String[]{"commit", "deltacommit", "compaction", "logcompaction", "replacecommit", "clustering"}));
        checkTimeline.accept(this.timeline.getCommitAndReplaceTimeline(), CollectionUtils.createSet((Object[])new String[]{"commit", "replacecommit", "clustering"}));
        checkTimeline.accept(this.timeline.getDeltaCommitTimeline(), Collections.singleton("deltacommit"));
        checkTimeline.accept(this.timeline.getCleanerTimeline(), Collections.singleton("clean"));
        checkTimeline.accept(this.timeline.getRollbackTimeline(), Collections.singleton("rollback"));
        checkTimeline.accept(this.timeline.getRestoreTimeline(), Collections.singleton("restore"));
        checkTimeline.accept(this.timeline.getSavePointTimeline(), Collections.singleton("savepoint"));
        checkTimeline.accept(this.timeline.getAllCommitsTimeline(), CollectionUtils.createSet((Object[])new String[]{"commit", "deltacommit", "clean", "compaction", "logcompaction", "replacecommit", "clustering", "savepoint", "rollback", "indexing"}));
        Random rand = new Random();
        Set randomActions = allInstantsSup.get().filter(i -> rand.nextBoolean()).map(HoodieInstant::getAction).collect(Collectors.toSet());
        checkTimeline.accept(this.timeline.getTimelineOfActions(randomActions), randomActions);
    }

    @Test
    public void testTimelineInstantOperations() {
        this.timeline = HoodieTestUtils.TIMELINE_FACTORY.createActiveTimeline(this.metaClient, true);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.timeline.countInstants(), (String)"No instant present");
        HoodieInstant commit = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "1");
        this.timeline.createCompleteInstant(commit);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.timeline.countInstants());
        commit = (HoodieInstant)this.timeline.getInstantsAsStream().findFirst().get();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(commit));
        HoodieInstant inflight = this.timeline.revertToInflight(commit);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.timeline.countInstants());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(inflight));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(commit));
        this.timeline.deleteInflight(inflight);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.timeline.countInstants());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(inflight));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(commit));
        this.timeline.createCompleteInstant(commit);
        this.timeline.createNewInstant(inflight);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.timeline.countInstants());
        this.timeline.deletePending(inflight);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.timeline.countInstants());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(inflight));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(commit));
        HoodieInstant compaction = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "compaction", "2");
        this.timeline.createNewInstant(compaction);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.timeline.countInstants());
        this.timeline.deleteCompactionRequested(compaction);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.timeline.countInstants());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(inflight));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(compaction));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(commit));
        compaction = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "compaction", "3");
        this.timeline.createNewInstant(compaction);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(compaction));
        inflight = this.timeline.transitionCompactionRequestedToInflight(compaction);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(compaction));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(inflight));
        compaction = this.timeline.revertInstantFromInflightToRequested(inflight);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(compaction));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(inflight));
        inflight = this.timeline.transitionCompactionRequestedToInflight(compaction);
        compaction = this.timeline.transitionCompactionInflightToComplete(true, inflight, Option.empty());
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(compaction));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(inflight));
        HoodieInstant clean = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "clean", "4");
        this.timeline.saveToCleanRequested(clean, Option.empty());
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(clean));
        inflight = this.timeline.transitionCleanRequestedToInflight(clean, Option.empty());
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(clean));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(inflight));
        clean = this.timeline.transitionCleanInflightToComplete(true, inflight, Option.empty());
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(clean));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(inflight));
        HoodieInstant srcInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "restore", "5");
        HoodieInstant otherInstant = HoodieTestUtils.INSTANT_GENERATOR.getRequestedInstant(srcInstant);
        org.junit.jupiter.api.Assertions.assertEquals((Object)otherInstant, (Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "restore", "5"));
        otherInstant = HoodieTestUtils.INSTANT_GENERATOR.getCleanRequestedInstant("5");
        org.junit.jupiter.api.Assertions.assertEquals((Object)otherInstant, (Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "clean", "5"));
        otherInstant = HoodieTestUtils.INSTANT_GENERATOR.getCleanInflightInstant("5");
        org.junit.jupiter.api.Assertions.assertEquals((Object)otherInstant, (Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "clean", "5"));
        otherInstant = HoodieTestUtils.INSTANT_GENERATOR.getCompactionRequestedInstant("5");
        org.junit.jupiter.api.Assertions.assertEquals((Object)otherInstant, (Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "compaction", "5"));
        otherInstant = HoodieTestUtils.INSTANT_GENERATOR.getCompactionInflightInstant("5");
        org.junit.jupiter.api.Assertions.assertEquals((Object)otherInstant, (Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "compaction", "5"));
        List<HoodieInstant> allInstants = this.getAllInstants();
        this.timeline = HoodieTestUtils.TIMELINE_FACTORY.createActiveTimeline(this.metaClient, true);
        this.timeline.setInstants(allInstants);
        this.timeline.setInstants(allInstants);
        this.timeline.createNewInstant(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "commit", "2"));
        allInstants.stream().map(HoodieInstant::requestedTime).forEach(s -> org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsOrBeforeTimelineStarts(s)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsOrBeforeTimelineStarts("0"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsOrBeforeTimelineStarts(String.valueOf(System.currentTimeMillis() + 1000L)));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.getTimelineHash().isEmpty());
    }

    @Test
    public void testCreateInstants() {
        List<HoodieInstant> allInstants = this.getAllInstants();
        for (HoodieInstant instant : allInstants) {
            if (instant.isCompleted()) {
                this.timeline.createCompleteInstant(instant);
                continue;
            }
            this.timeline.createNewInstant(instant);
        }
        this.timeline = this.timeline.reload();
        for (HoodieInstant instant : allInstants) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(instant));
        }
    }

    @Test
    public void testInstantFilenameOperations() {
        HoodieInstant instantRequested = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "restore", "5");
        HoodieInstant instantInflight = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "restore", "5");
        HoodieInstant instantComplete = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "restore", "5", "6");
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.getCommitFromCommitFile(HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.getFileName(instantRequested)), (Object)"5");
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.getCommitFromCommitFile(HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.getFileName(instantInflight)), (Object)"5");
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.getCommitFromCommitFile(HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.getFileName(instantComplete)), (Object)"5_6");
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.makeInflightRestoreFileName(HoodieTestUtils.INSTANT_FILE_NAME_PARSER.extractTimestamp(HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.getFileName(instantComplete))), (Object)HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.getFileName(instantInflight));
    }

    @Test
    public void testFiltering() {
        List<HoodieInstant> allInstants = this.getAllInstants();
        Supplier<Stream> sup = allInstants::stream;
        this.timeline = HoodieTestUtils.TIMELINE_FACTORY.createActiveTimeline(this.metaClient);
        this.timeline.setInstants(allInstants);
        Stream instants = this.timeline.getReverseOrderedInstants();
        List v1 = instants.collect(Collectors.toList());
        List v2 = sup.get().collect(Collectors.toList());
        Collections.reverse(v2);
        org.junit.jupiter.api.Assertions.assertEquals(v1, v2);
        BiConsumer<HoodieTimeline, Set> checkFilter = (timeline, states) -> {
            ((Stream)sup.get()).filter(i -> states.contains(i.getState())).forEach(i -> org.junit.jupiter.api.Assertions.assertTrue((boolean)timeline.containsInstant(i)));
            ((Stream)sup.get()).filter(i -> !states.contains(i.getState())).forEach(i -> org.junit.jupiter.api.Assertions.assertFalse((boolean)timeline.containsInstant(i)));
        };
        checkFilter.accept(this.timeline.filter(i -> false), new HashSet());
        checkFilter.accept(this.timeline.filterInflights(), Collections.singleton(HoodieInstant.State.INFLIGHT));
        checkFilter.accept(this.timeline.filterInflightsAndRequested(), CollectionUtils.createSet((Object[])new HoodieInstant.State[]{HoodieInstant.State.INFLIGHT, HoodieInstant.State.REQUESTED}));
        HoodieTimeline t1 = this.timeline.filterCompletedAndCompactionInstants();
        Set states2 = CollectionUtils.createSet((Object[])new HoodieInstant.State[]{HoodieInstant.State.COMPLETED});
        Set<String> actions = Collections.singleton("compaction");
        sup.get().filter(i -> states2.contains(i.getState()) || actions.contains(i.getAction())).forEach(i -> org.junit.jupiter.api.Assertions.assertTrue((boolean)t1.containsInstant(i)));
        sup.get().filter(i -> !states2.contains(i.getState()) && !actions.contains(i.getAction())).forEach(i -> org.junit.jupiter.api.Assertions.assertFalse((boolean)t1.containsInstant(i)));
        HoodieTimeline t2 = this.timeline.filterPendingCompactionTimeline();
        sup.get().filter(i -> i.getAction().equals("compaction")).forEach(i -> org.junit.jupiter.api.Assertions.assertTrue((boolean)t2.containsInstant(i)));
        sup.get().filter(i -> !i.getAction().equals("compaction")).forEach(i -> org.junit.jupiter.api.Assertions.assertFalse((boolean)t2.containsInstant(i)));
    }

    @Test
    public void testReplaceActionsTimeline() {
        int instantTime = 1;
        ArrayList<HoodieInstant> allInstants = new ArrayList<HoodieInstant>();
        HoodieInstant instant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", String.format("%03d", instantTime++));
        allInstants.add(instant1);
        HoodieInstant instant2 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", String.format("%03d", instantTime++));
        allInstants.add(instant2);
        HoodieInstant instant3 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "replacecommit", String.format("%03d", instantTime++));
        allInstants.add(instant3);
        this.timeline = HoodieTestUtils.TIMELINE_FACTORY.createActiveTimeline(this.metaClient);
        this.timeline.setInstants(allInstants);
        List validReplaceInstants = this.timeline.getCompletedReplaceTimeline().getInstants();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)validReplaceInstants.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)instant3.requestedTime(), (Object)((HoodieInstant)validReplaceInstants.get(0)).requestedTime());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"replacecommit", (Object)((HoodieInstant)validReplaceInstants.get(0)).getAction());
        Assertions.assertStreamEquals(Stream.of(instant1, instant2, instant3), (Stream)this.timeline.getCommitAndReplaceTimeline().getInstantsAsStream(), (String)"Check the instants stream");
        Assertions.assertStreamEquals(Stream.of(instant1, instant2), (Stream)this.timeline.getCommitTimeline().getInstantsAsStream(), (String)"Check the instants stream");
    }

    @Test
    public void testCreateNewInstantTime() throws Exception {
        String lastInstantTime = this.metaClient.createNewInstantTime(false);
        for (int i = 0; i < 3; ++i) {
            String newInstantTime = this.metaClient.createNewInstantTime(false);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)InstantComparison.compareTimestamps((String)lastInstantTime, (BiPredicate)InstantComparison.LESSER_THAN, (String)newInstantTime));
            lastInstantTime = newInstantTime;
        }
        int numChecks = 100000;
        int numThreads = 100;
        long milliSecondsInYear = 1471228928L;
        ExecutorService executorService = Executors.newFixedThreadPool(100);
        ArrayList futures = new ArrayList(100);
        for (int idx = 0; idx < 100; ++idx) {
            futures.add(executorService.submit(() -> {
                Date date = new Date(System.currentTimeMillis() + (long)((int)(Math.random() * 100.0)) * 1471228928L);
                String expectedFormat = TimelineUtils.formatDate((Date)date);
                for (int tidx = 0; tidx < 100000; ++tidx) {
                    String curFormat = TimelineUtils.formatDate((Date)date);
                    if (curFormat.equals(expectedFormat)) continue;
                    throw new HoodieException("Format error: expected=" + expectedFormat + ", curFormat=" + curFormat);
                }
            }));
        }
        executorService.shutdown();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)executorService.awaitTermination(60L, TimeUnit.SECONDS));
        for (Future future : futures) {
            future.get();
        }
    }

    @Test
    public void testMinTimestamp() {
        String timestamp1 = "20240601040632402";
        String timestamp2 = "20250601040632402";
        org.junit.jupiter.api.Assertions.assertEquals((Object)timestamp1, (Object)InstantComparison.minTimestamp(null, (String)timestamp1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)timestamp1, (Object)InstantComparison.minTimestamp((String)"", (String)timestamp1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)timestamp1, (Object)InstantComparison.minTimestamp((String)timestamp1, null));
        org.junit.jupiter.api.Assertions.assertEquals((Object)timestamp1, (Object)InstantComparison.minTimestamp((String)timestamp1, (String)""));
        org.junit.jupiter.api.Assertions.assertEquals((Object)timestamp1, (Object)InstantComparison.minTimestamp((String)timestamp1, (String)timestamp2));
    }

    @Test
    public void testParseDateFromInstantTime() throws ParseException {
        String secondGranularityInstant = "20210101120101123";
        Date defaultSecsGranularityDate = TimelineUtils.parseDateFromInstantTime((String)secondGranularityInstant);
        System.out.println(defaultSecsGranularityDate.getTime());
    }

    @Test
    public void testMetadataCompactionInstantDateParsing() throws ParseException {
        String secondGranularityInstant = "20210101120101123";
        Date defaultSecsGranularityDate = TimelineUtils.parseDateFromInstantTime((String)secondGranularityInstant);
        String compactionInstant = secondGranularityInstant + "001";
        Date defaultMsGranularityDate = TimelineUtils.parseDateFromInstantTime((String)compactionInstant);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)(defaultMsGranularityDate.getTime() - defaultSecsGranularityDate.getTime()), (String)"Expected the ms part to be 0");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)InstantComparison.compareTimestamps((String)secondGranularityInstant, (BiPredicate)InstantComparison.LESSER_THAN, (String)compactionInstant));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)InstantComparison.compareTimestamps((String)compactionInstant, (BiPredicate)InstantComparison.GREATER_THAN, (String)secondGranularityInstant));
    }

    @Test
    public void testMillisGranularityInstantDateParsing() throws ParseException {
        String secondGranularityInstant = "20210101120101";
        Date defaultMsGranularityDate = TimelineUtils.parseDateFromInstantTime((String)secondGranularityInstant);
        String specificMsGranularityInstant = secondGranularityInstant + "009";
        Date msGranularityDate = TimelineUtils.parseDateFromInstantTime((String)specificMsGranularityInstant);
        org.junit.jupiter.api.Assertions.assertEquals((long)999L, (long)(defaultMsGranularityDate.getTime() % 1000L), (String)"Expected the ms part to be 999");
        org.junit.jupiter.api.Assertions.assertEquals((long)9L, (long)(msGranularityDate.getTime() % 1000L), (String)"Expected the ms part to be 9");
        String laterDateInstant = "20210101120111";
        org.junit.jupiter.api.Assertions.assertEquals((long)10L, (long)(TimelineUtils.parseDateFromInstantTime((String)laterDateInstant).getTime() / 1000L - TimelineUtils.parseDateFromInstantTime((String)secondGranularityInstant).getTime() / 1000L), (String)"Expected the difference between later instant and previous instant to be 10 seconds");
    }

    @Test
    public void testInvalidInstantDateParsing() throws ParseException {
        org.junit.jupiter.api.Assertions.assertEquals((long)Long.parseLong("00000000000000"), (long)((Date)TimelineUtils.parseDateFromInstantTimeSafely((String)"00000000000000").get()).getTime());
        org.junit.jupiter.api.Assertions.assertEquals((long)Long.parseLong("00000000000001"), (long)((Date)TimelineUtils.parseDateFromInstantTimeSafely((String)"00000000000001").get()).getTime());
        org.junit.jupiter.api.Assertions.assertEquals((long)Long.parseLong("00000000000002"), (long)((Date)TimelineUtils.parseDateFromInstantTimeSafely((String)"00000000000002").get()).getTime());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Option.empty(), (Object)TimelineUtils.parseDateFromInstantTimeSafely((String)"00000000000000001"));
        String testInstant = "20210101120101";
        org.junit.jupiter.api.Assertions.assertEquals((long)TimelineUtils.parseDateFromInstantTime((String)testInstant).getTime(), (long)((Date)TimelineUtils.parseDateFromInstantTimeSafely((String)testInstant).get()).getTime());
    }

    @Test
    public void testInstantCompletionTimeBackwardCompatibility() {
        HoodieInstant requestedInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "commit", "1");
        HoodieInstant inflightInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", "2");
        HoodieInstant completeInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "3");
        this.timeline = HoodieTestUtils.TIMELINE_FACTORY.createActiveTimeline(this.metaClient);
        this.timeline.createNewInstant(requestedInstant);
        this.timeline.createNewInstant(inflightInstant);
        String legacyCompletedFileName = HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.makeCommitFileName(completeInstant.requestedTime());
        this.metaClient.getStorage().createImmutableFileInPath(new StoragePath(this.metaClient.getTimelinePath().toString(), legacyCompletedFileName), Option.empty());
        this.timeline = this.timeline.reload();
        MatcherAssert.assertThat((String)"Some instants might be missing", (Object)this.timeline.countInstants(), (Matcher)CoreMatchers.is((Object)3));
        List instants = this.timeline.getInstants();
        org.junit.jupiter.api.Assertions.assertNull((Object)((HoodieInstant)instants.get(0)).getCompletionTime(), (String)"Requested instant does not have completion time");
        org.junit.jupiter.api.Assertions.assertNull((Object)((HoodieInstant)instants.get(1)).getCompletionTime(), (String)"Inflight instant does not have completion time");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)((HoodieInstant)instants.get(2)).getCompletionTime(), (String)"Completed instant has modification time as completion time for 0.x release");
        org.junit.jupiter.api.Assertions.assertEquals((Object)(((HoodieInstant)instants.get(2)).requestedTime() + ".commit"), (Object)HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.getFileName((HoodieInstant)instants.get(2)), (String)"Instant file name should not have completion time");
    }

    private List<HoodieInstant> getAllInstants() {
        this.timeline = HoodieTestUtils.TIMELINE_FACTORY.createActiveTimeline(this.metaClient);
        ArrayList<HoodieInstant> allInstants = new ArrayList<HoodieInstant>();
        long instantTime = 1L;
        for (HoodieInstant.State state : HoodieInstant.State.values()) {
            if (state == HoodieInstant.State.NIL) continue;
            for (String action : HoodieTimeline.VALID_ACTIONS_IN_TIMELINE) {
                if (state == HoodieInstant.State.REQUESTED && (action.equals("savepoint") || action.equals("restore"))) continue;
                if (state == HoodieInstant.State.COMPLETED && action.equals("compaction")) {
                    action = "commit";
                }
                if (state == HoodieInstant.State.COMPLETED && action.equals("logcompaction")) {
                    action = "deltacommit";
                }
                if (state == HoodieInstant.State.COMPLETED && action.equals("clustering")) {
                    action = "replacecommit";
                }
                allInstants.add(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(state, action, String.format("%03d", instantTime++)));
            }
        }
        return allInstants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shouldAllowTempCommit(boolean allowTempCommit, Consumer<HoodieTableMetaClient> fun) {
        if (allowTempCommit) {
            HoodieStorage storage = this.metaClient.getStorage();
            FileSystem fs = (FileSystem)storage.getFileSystem();
            HoodieWrapperFileSystem newFs = new HoodieWrapperFileSystem(fs, (ConsistencyGuard)new NoOpConsistencyGuard());
            this.metaClient.setStorage((HoodieStorage)new HoodieHadoopStorage((FileSystem)newFs));
            try {
                fun.accept(this.metaClient);
            }
            finally {
                this.metaClient.setStorage(storage);
            }
            return;
        }
        fun.accept(this.metaClient);
    }
}

