/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.IOException;
import java.util.stream.Stream;
import org.apache.hudi.common.model.HoodieTimelineTimeZone;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieInstant
extends HoodieCommonTestHarness {
    @Test
    public void testExtractTimestamp() {
        String fileName = "20230104152218702.inflight";
        Assertions.assertEquals((Object)"20230104152218702", (Object)HoodieTestUtils.INSTANT_FILE_NAME_PARSER.extractTimestamp(fileName));
        fileName = "20230104152218702.commit.request";
        Assertions.assertEquals((Object)"20230104152218702", (Object)HoodieTestUtils.INSTANT_FILE_NAME_PARSER.extractTimestamp(fileName));
        fileName = "20230104152218702_20230104152219346.commit";
        Assertions.assertEquals((Object)"20230104152218702", (Object)HoodieTestUtils.INSTANT_FILE_NAME_PARSER.extractTimestamp(fileName));
        String illegalFileName = "hoodie.properties";
        Assertions.assertThrows(IllegalArgumentException.class, () -> HoodieTestUtils.INSTANT_FILE_NAME_PARSER.extractTimestamp(illegalFileName));
    }

    @Test
    public void testGetTimelineFileExtension() {
        String fileName = "20230104152218702.inflight";
        Assertions.assertEquals((Object)".inflight", (Object)HoodieTestUtils.INSTANT_FILE_NAME_PARSER.getTimelineFileExtension(fileName));
        fileName = "20230104152218702.commit.request";
        Assertions.assertEquals((Object)".commit.request", (Object)HoodieTestUtils.INSTANT_FILE_NAME_PARSER.getTimelineFileExtension(fileName));
        fileName = "20230104152218702_20230104152219346.commit";
        Assertions.assertEquals((Object)".commit", (Object)HoodieTestUtils.INSTANT_FILE_NAME_PARSER.getTimelineFileExtension(fileName));
        fileName = "hoodie.properties";
        Assertions.assertEquals((Object)"", (Object)HoodieTestUtils.INSTANT_FILE_NAME_PARSER.getTimelineFileExtension(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateHoodieInstantByFileStatus() throws IOException {
        try {
            this.initMetaClient();
            HoodieInstant instantRequested = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "commit", "001");
            HoodieInstant instantCommitted = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "001");
            HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
            timeline.createNewInstant(instantRequested);
            timeline.transitionRequestedToInflight(instantRequested, Option.empty());
            timeline.saveAsComplete(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, instantRequested.getAction(), instantRequested.requestedTime()), Option.empty());
            this.metaClient.reloadActiveTimeline();
            timeline = this.metaClient.getActiveTimeline();
            Assertions.assertEquals((int)1, (int)timeline.countInstants());
            org.apache.hudi.common.testutils.Assertions.assertStreamEquals(Stream.of(instantCommitted), (Stream)timeline.getInstantsAsStream(), (String)"Instants in timeline is not matched");
            Assertions.assertEquals((long)0L, (long)timeline.getInstantsAsStream().filter(s -> s.getCompletionTime().isEmpty()).count());
        }
        finally {
            this.cleanMetaClient();
        }
    }

    @Test
    public void testHoodieTimelineTimeZone() {
        for (HoodieTimelineTimeZone timeZone : HoodieTimelineTimeZone.values()) {
            Assertions.assertNotNull((Object)timeZone.getZoneId());
        }
    }
}

