/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.view.IncrementalTimelineSyncFileSystemView;
import org.apache.hudi.common.table.view.TableFileSystemView;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHoodieTableFSViewWithClustering
extends HoodieCommonTestHarness {
    private static final String TEST_WRITE_TOKEN = "1-0-1";
    private static final String BOOTSTRAP_SOURCE_PATH = "/usr/warehouse/hive/data/tables/src1/";
    private IncrementalTimelineSyncFileSystemView fsView;
    private TableFileSystemView.BaseFileOnlyView roView;

    @BeforeEach
    public void setup() throws IOException {
        this.metaClient = HoodieTestUtils.init((String)this.tempDir.toAbsolutePath().toString(), (HoodieTableType)this.getTableType(), (String)BOOTSTRAP_SOURCE_PATH, (boolean)false);
        this.basePath = this.metaClient.getBasePath().toString();
        this.refreshFsView();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.closeFsView();
        this.cleanMetaClient();
    }

    @Override
    protected void refreshFsView() throws IOException {
        super.refreshFsView();
        this.closeFsView();
        this.fsView = (IncrementalTimelineSyncFileSystemView)this.getFileSystemView(this.metaClient.getActiveTimeline().filterCompletedAndCompactionInstants());
        this.roView = this.fsView;
    }

    private void closeFsView() {
        if (null != this.fsView) {
            this.fsView.close();
            this.fsView = null;
        }
    }

    @AfterEach
    public void close() {
        this.closeFsView();
    }

    @Test
    public void testReplaceFileIdIsExcludedInView() throws IOException {
        String partitionPath1 = "2020/06/27";
        String partitionPath2 = "2020/07/14";
        new File(this.basePath + "/" + partitionPath1).mkdirs();
        new File(this.basePath + "/" + partitionPath2).mkdirs();
        String fileId1 = UUID.randomUUID().toString();
        String fileId2 = UUID.randomUUID().toString();
        String fileId3 = UUID.randomUUID().toString();
        String fileId4 = UUID.randomUUID().toString();
        Assertions.assertFalse((boolean)this.roView.getLatestBaseFiles(partitionPath1).anyMatch(dfile -> dfile.getFileId().equals(fileId1) || dfile.getFileId().equals(fileId2)), (String)"No commit, should not find any data file");
        Assertions.assertFalse((boolean)this.roView.getLatestBaseFiles(partitionPath2).anyMatch(dfile -> dfile.getFileId().equals(fileId3) || dfile.getFileId().equals(fileId4)), (String)"No commit, should not find any data file");
        Assertions.assertFalse((boolean)this.fsView.fetchLatestBaseFiles(partitionPath1).anyMatch(dfile -> dfile.getFileId().equals(fileId1) || dfile.getFileId().equals(fileId2)), (String)"No commit, should not find any data file");
        Assertions.assertFalse((boolean)this.fsView.fetchLatestBaseFiles(partitionPath2).anyMatch(dfile -> dfile.getFileId().equals(fileId3) || dfile.getFileId().equals(fileId4)), (String)"No commit, should not find any data file");
        String commitTime1 = "1";
        String fileName1 = FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId1, (String)BASE_FILE_EXTENSION);
        String fileName2 = FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId2, (String)BASE_FILE_EXTENSION);
        String fileName3 = FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId3, (String)BASE_FILE_EXTENSION);
        String fileName4 = FSUtils.makeBaseFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId4, (String)BASE_FILE_EXTENSION);
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName1).createNewFile();
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName2).createNewFile();
        new File(this.basePath + "/" + partitionPath2 + "/" + fileName3).createNewFile();
        new File(this.basePath + "/" + partitionPath2 + "/" + fileName4).createNewFile();
        HashMap partitionToReplaceFileIds = new HashMap();
        ArrayList<String> replacedFileIdsP1 = new ArrayList<String>();
        replacedFileIdsP1.add(fileId1);
        partitionToReplaceFileIds.put(partitionPath1, replacedFileIdsP1);
        ArrayList<String> replacedFileIdsP2 = new ArrayList<String>();
        replacedFileIdsP2.add(fileId3);
        replacedFileIdsP2.add(fileId4);
        partitionToReplaceFileIds.put(partitionPath2, replacedFileIdsP2);
        HoodieCommitMetadata commitMetadata = CommitUtils.buildMetadata(Collections.emptyList(), partitionToReplaceFileIds, (Option)Option.empty(), (WriteOperationType)WriteOperationType.INSERT_OVERWRITE, (String)"", (String)"replacecommit");
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "clustering", commitTime1);
        this.saveAsComplete(commitTimeline, instant1, (Option<byte[]>)TimelineMetadataUtils.serializeCommitMetadata((CommitMetadataSerDe)this.metaClient.getCommitMetadataSerDe(), (HoodieCommitMetadata)commitMetadata));
        this.refreshFsView();
        Assertions.assertEquals((long)0L, (long)this.roView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId1)).count());
        Assertions.assertEquals((Object)fileName2, (Object)this.roView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId2)).findFirst().get().getFileName());
        Assertions.assertEquals((long)0L, (long)this.roView.getLatestBaseFiles(partitionPath2).filter(dfile -> dfile.getFileId().equals(fileId3)).count());
        Assertions.assertEquals((long)0L, (long)this.roView.getLatestBaseFiles(partitionPath2).filter(dfile -> dfile.getFileId().equals(fileId4)).count());
        Assertions.assertEquals((long)0L, (long)this.fsView.fetchLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId1)).count());
        Assertions.assertEquals((Object)fileName2, (Object)this.fsView.fetchLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId2)).findFirst().get().getFileName());
        Assertions.assertEquals((long)0L, (long)this.fsView.fetchLatestBaseFiles(partitionPath2).filter(dfile -> dfile.getFileId().equals(fileId3)).count());
        Assertions.assertEquals((long)0L, (long)this.fsView.fetchLatestBaseFiles(partitionPath2).filter(dfile -> dfile.getFileId().equals(fileId4)).count());
        List replacedOnInstant1 = this.fsView.getReplacedFileGroupsBeforeOrOn("0", partitionPath1).collect(Collectors.toList());
        Assertions.assertEquals((int)0, (int)replacedOnInstant1.size());
        List allReplaced = this.fsView.getReplacedFileGroupsBeforeOrOn("2", partitionPath1).collect(Collectors.toList());
        allReplaced.addAll(this.fsView.getReplacedFileGroupsBeforeOrOn("2", partitionPath2).collect(Collectors.toList()));
        Assertions.assertEquals((int)3, (int)allReplaced.size());
        Set allReplacedFileIds = allReplaced.stream().map(fg -> fg.getFileGroupId().getFileId()).collect(Collectors.toSet());
        Set actualReplacedFileIds = Stream.of(fileId1, fileId3, fileId4).collect(Collectors.toSet());
        Assertions.assertEquals(actualReplacedFileIds, allReplacedFileIds);
    }

    private void saveAsComplete(HoodieActiveTimeline timeline, HoodieInstant inflight, Option<byte[]> data) {
        if (inflight.getAction().equals("compaction")) {
            timeline.transitionCompactionInflightToComplete(true, inflight, data);
        } else {
            HoodieInstant requested = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, inflight.getAction(), inflight.requestedTime());
            timeline.createNewInstant(requested);
            timeline.transitionRequestedToInflight(requested, Option.empty());
            if (inflight.getAction().equals("clustering")) {
                timeline.transitionClusterInflightToComplete(true, inflight, data);
            } else {
                timeline.saveAsComplete(inflight, data);
            }
        }
    }
}

