/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hudi.avro.model.HoodieActionInstant;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieClusteringStrategy;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieInstantInfo;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPartitionMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.avro.model.HoodieRollbackRequest;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.avro.model.HoodieSavepointPartitionMetadata;
import org.apache.hudi.avro.model.HoodieSliceInfo;
import org.apache.hudi.common.HoodieCleanStat;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.TestLogReaderUtils;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.table.timeline.versioning.DefaultInstantGenerator;
import org.apache.hudi.common.table.timeline.versioning.clean.CleanPlanV2MigrationHandler;
import org.apache.hudi.common.testutils.FileCreateUtils;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieTestTable
implements AutoCloseable {
    public static final String PHONY_TABLE_SCHEMA = "{\"namespace\": \"org.apache.hudi.avro.model\", \"type\": \"record\", \"name\": \"PhonyRecord\", \"fields\": []}";
    private static final Logger LOG = LoggerFactory.getLogger(HoodieTestTable.class);
    private static final Random RANDOM = new Random();
    protected static HoodieTestTableState testTableState;
    private final List<String> inflightCommits = new ArrayList<String>();
    protected final String basePath;
    protected final HoodieStorage storage;
    protected final FileSystem fs;
    protected HoodieTableMetaClient metaClient;
    protected String currentInstantTime;
    private boolean isNonPartitioned = false;
    protected Option<HoodieEngineContext> context;
    protected final InstantGenerator instantGenerator = new DefaultInstantGenerator();

    protected HoodieTestTable(String basePath, HoodieStorage storage, HoodieTableMetaClient metaClient) {
        this(basePath, storage, metaClient, (Option<HoodieEngineContext>)Option.empty());
    }

    protected HoodieTestTable(String basePath, HoodieStorage storage, HoodieTableMetaClient metaClient, Option<HoodieEngineContext> context) {
        ValidationUtils.checkArgument((boolean)Objects.equals(basePath, metaClient.getBasePath().toString()));
        ValidationUtils.checkArgument((boolean)Objects.equals(storage.getFileSystem(), metaClient.getRawStorage().getFileSystem()));
        this.basePath = basePath;
        this.storage = storage;
        this.fs = (FileSystem)storage.getFileSystem();
        this.metaClient = metaClient;
        testTableState = HoodieTestTableState.of();
        this.context = context;
    }

    public static HoodieTestTable of(HoodieTableMetaClient metaClient) {
        testTableState = HoodieTestTableState.of();
        return new HoodieTestTable(metaClient.getBasePath().toString(), metaClient.getRawStorage(), metaClient);
    }

    public void setNonPartitioned() {
        this.isNonPartitioned = true;
    }

    public boolean isNonPartitioned() {
        return this.isNonPartitioned;
    }

    public static String makeNewCommitTime(int sequence, String instantFormat) {
        return String.format(instantFormat, sequence);
    }

    public static String makeNewCommitTime() {
        return HoodieTestTable.makeNewCommitTime(Instant.now());
    }

    public static String makeNewCommitTime(Instant dateTime) {
        return TimelineUtils.formatDate((Date)Date.from(dateTime));
    }

    public static List<String> makeIncrementalCommitTimes(int num, int firstOffsetSeconds, int deltaSecs) {
        Instant now = Instant.now();
        return IntStream.range(0, num).mapToObj(i -> HoodieTestTable.makeNewCommitTime(now.plus(deltaSecs == 0 ? (long)(firstOffsetSeconds + i) : (long)(i == 0 ? firstOffsetSeconds : i * deltaSecs + i), ChronoUnit.SECONDS))).collect(Collectors.toList());
    }

    public HoodieTestTable addRequestedCommit(String instantTime) throws Exception {
        FileCreateUtils.createRequestedCommit((HoodieTableMetaClient)this.metaClient, (String)instantTime);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addInflightCommit(String instantTime) throws Exception {
        FileCreateUtils.createRequestedCommit((HoodieTableMetaClient)this.metaClient, (String)instantTime);
        FileCreateUtils.createInflightCommit((HoodieTableMetaClient)this.metaClient, (String)instantTime);
        this.inflightCommits.add(instantTime);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addInflightDeltaCommit(String instantTime) throws Exception {
        FileCreateUtils.createRequestedDeltaCommit((HoodieTableMetaClient)this.metaClient, (String)instantTime);
        FileCreateUtils.createInflightDeltaCommit((HoodieTableMetaClient)this.metaClient, (String)instantTime);
        this.inflightCommits.add(instantTime);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addCommit(String instantTime) throws Exception {
        return this.addCommit(instantTime, (Option<HoodieCommitMetadata>)Option.empty());
    }

    public HoodieTestTable addCommit(String instantTime, Option<HoodieCommitMetadata> metadata) throws Exception {
        return this.addCommit(instantTime, (Option<String>)Option.empty(), metadata);
    }

    public HoodieTestTable addCommit(String instantTime, Option<String> completionTime, Option<HoodieCommitMetadata> metadata) throws Exception {
        FileCreateUtils.createRequestedCommit((HoodieTableMetaClient)this.metaClient, (String)instantTime);
        FileCreateUtils.createInflightCommit((HoodieTableMetaClient)this.metaClient, (String)instantTime);
        FileCreateUtils.createCommit((HoodieTableMetaClient)this.metaClient, (CommitMetadataSerDe)HoodieTestUtils.COMMIT_METADATA_SER_DE, (String)instantTime, completionTime, metadata);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addSavepointCommit(String instantTime, HoodieSavepointMetadata savepointMetadata) throws IOException {
        FileCreateUtils.createInflightSavepoint((HoodieTableMetaClient)this.metaClient, (String)instantTime);
        FileCreateUtils.createSavepointCommit((HoodieTableMetaClient)this.metaClient, (String)instantTime, (HoodieSavepointMetadata)savepointMetadata);
        return this;
    }

    public HoodieCommitMetadata createCommitMetadata(String commitTime, WriteOperationType operationType, List<String> partitions, int filesPerPartition, boolean bootstrap) {
        Map<String, List<Pair<String, Integer>>> partitionToFilesNameLengthMap = HoodieTestTable.getPartitionFiles(partitions, filesPerPartition);
        HoodieTestTableState testTableState = HoodieTestTable.getTestTableStateWithPartitionFileInfo(operationType, this.metaClient.getTableType(), commitTime, partitionToFilesNameLengthMap);
        return this.createCommitMetadata(operationType, commitTime, testTableState, bootstrap);
    }

    public HoodieCommitMetadata createCommitMetadata(WriteOperationType operationType, String commitTime, HoodieTestTableState testTableState) {
        String actionType = CommitUtils.getCommitActionType((WriteOperationType)operationType, (HoodieTableType)this.metaClient.getTableType());
        return this.createCommitMetadata(operationType, commitTime, Collections.emptyMap(), testTableState, false, actionType);
    }

    public HoodieCommitMetadata createCommitMetadata(WriteOperationType operationType, String commitTime, HoodieTestTableState testTableState, boolean bootstrap) {
        String actionType = CommitUtils.getCommitActionType((WriteOperationType)operationType, (HoodieTableType)this.metaClient.getTableType());
        return this.createCommitMetadata(operationType, commitTime, Collections.emptyMap(), testTableState, bootstrap, actionType);
    }

    public HoodieCommitMetadata createCommitMetadata(WriteOperationType operationType, String commitTime, Map<String, List<String>> partitionToReplaceFileIds, HoodieTestTableState testTableState, boolean bootstrap, String action) {
        List<HoodieWriteStat> writeStats = HoodieTestTable.generateHoodieWriteStatForPartition(testTableState.getPartitionToBaseFileInfoMap(commitTime), commitTime, bootstrap);
        if (HoodieTableType.MERGE_ON_READ.equals((Object)this.metaClient.getTableType()) && WriteOperationType.UPSERT.equals((Object)operationType)) {
            writeStats.addAll(HoodieTestTable.generateHoodieWriteStatForPartitionLogFiles(testTableState.getPartitionToLogFileInfoMap(commitTime), commitTime, bootstrap));
        }
        Map<String, String> extraMetadata = Collections.singletonMap("test", "test");
        return CommitUtils.buildMetadata(writeStats, partitionToReplaceFileIds, (Option)Option.of(extraMetadata), (WriteOperationType)operationType, (String)PHONY_TABLE_SCHEMA, (String)action);
    }

    public HoodieTestTable moveInflightCommitToComplete(String instantTime, HoodieCommitMetadata metadata) throws IOException {
        if (this.metaClient.getTableType() == HoodieTableType.COPY_ON_WRITE) {
            FileCreateUtils.createCommit((HoodieTableMetaClient)this.metaClient, (CommitMetadataSerDe)HoodieTestUtils.COMMIT_METADATA_SER_DE, (String)instantTime, (Option)Option.of((Object)metadata));
        } else {
            FileCreateUtils.createDeltaCommit((HoodieTableMetaClient)this.metaClient, (CommitMetadataSerDe)HoodieTestUtils.COMMIT_METADATA_SER_DE, (String)instantTime, (HoodieCommitMetadata)metadata);
        }
        this.inflightCommits.remove(instantTime);
        this.currentInstantTime = instantTime;
        return this;
    }

    public void moveCompleteCommitToInflight(String instantTime) throws IOException {
        if (this.metaClient.getTableType() == HoodieTableType.COPY_ON_WRITE) {
            FileCreateUtils.deleteCommit((HoodieTableMetaClient)this.metaClient, (String)instantTime);
        } else {
            FileCreateUtils.deleteDeltaCommit((HoodieTableMetaClient)this.metaClient, (String)instantTime);
        }
    }

    public HoodieTestTable addDeltaCommit(String instantTime) throws Exception {
        FileCreateUtils.createRequestedDeltaCommit((HoodieTableMetaClient)this.metaClient, (String)instantTime);
        FileCreateUtils.createInflightDeltaCommit((HoodieTableMetaClient)this.metaClient, (String)instantTime);
        FileCreateUtils.createDeltaCommit((HoodieTableMetaClient)this.metaClient, (String)instantTime);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addDeltaCommit(String instantTime, HoodieCommitMetadata metadata) throws Exception {
        FileCreateUtils.createRequestedDeltaCommit((HoodieTableMetaClient)this.metaClient, (String)instantTime);
        FileCreateUtils.createInflightDeltaCommit((HoodieTableMetaClient)this.metaClient, (String)instantTime);
        FileCreateUtils.createDeltaCommit((HoodieTableMetaClient)this.metaClient, (CommitMetadataSerDe)HoodieTestUtils.COMMIT_METADATA_SER_DE, (String)instantTime, (HoodieCommitMetadata)metadata);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addReplaceCommit(String instantTime, Option<HoodieRequestedReplaceMetadata> requestedReplaceMetadata, Option<HoodieCommitMetadata> inflightReplaceMetadata, HoodieReplaceCommitMetadata completeReplaceMetadata) throws Exception {
        FileCreateUtils.createRequestedReplaceCommit((HoodieTableMetaClient)this.metaClient, (String)instantTime, requestedReplaceMetadata);
        FileCreateUtils.createInflightReplaceCommit((HoodieTableMetaClient)this.metaClient, (CommitMetadataSerDe)HoodieTestUtils.COMMIT_METADATA_SER_DE, (String)instantTime, inflightReplaceMetadata);
        FileCreateUtils.createReplaceCommit((HoodieTableMetaClient)this.metaClient, (CommitMetadataSerDe)HoodieTestUtils.COMMIT_METADATA_SER_DE, (String)instantTime, (HoodieReplaceCommitMetadata)completeReplaceMetadata);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addPendingReplace(String instantTime, Option<HoodieRequestedReplaceMetadata> requestedReplaceMetadata, Option<HoodieCommitMetadata> inflightReplaceMetadata) throws Exception {
        FileCreateUtils.createRequestedReplaceCommit((HoodieTableMetaClient)this.metaClient, (String)instantTime, requestedReplaceMetadata);
        FileCreateUtils.createInflightReplaceCommit((HoodieTableMetaClient)this.metaClient, (CommitMetadataSerDe)HoodieTestUtils.COMMIT_METADATA_SER_DE, (String)instantTime, inflightReplaceMetadata);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addPendingCluster(String instantTime, HoodieRequestedReplaceMetadata requestedReplaceMetadata, Option<HoodieCommitMetadata> inflightReplaceMetadata) throws Exception {
        FileCreateUtils.createRequestedClusterCommit((HoodieTableMetaClient)this.metaClient, (String)instantTime, (HoodieRequestedReplaceMetadata)requestedReplaceMetadata);
        FileCreateUtils.createInflightClusterCommit((HoodieTableMetaClient)this.metaClient, (CommitMetadataSerDe)HoodieTestUtils.COMMIT_METADATA_SER_DE, (String)instantTime, inflightReplaceMetadata);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addRequestedCluster(String instantTime, HoodieRequestedReplaceMetadata requestedReplaceMetadata) throws Exception {
        FileCreateUtils.createRequestedClusterCommit((HoodieTableMetaClient)this.metaClient, (String)instantTime, (HoodieRequestedReplaceMetadata)requestedReplaceMetadata);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addInflightCluster(String instantTime, Option<HoodieCommitMetadata> inflightReplaceMetadata) throws Exception {
        FileCreateUtils.createInflightClusterCommit((HoodieTableMetaClient)this.metaClient, (CommitMetadataSerDe)HoodieTestUtils.COMMIT_METADATA_SER_DE, (String)instantTime, inflightReplaceMetadata);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addCluster(String instantTime, HoodieRequestedReplaceMetadata requestedReplaceMetadata, Option<HoodieCommitMetadata> inflightReplaceMetadata, HoodieReplaceCommitMetadata completeReplaceMetadata) throws Exception {
        FileCreateUtils.createRequestedClusterCommit((HoodieTableMetaClient)this.metaClient, (String)instantTime, (HoodieRequestedReplaceMetadata)requestedReplaceMetadata);
        FileCreateUtils.createInflightClusterCommit((HoodieTableMetaClient)this.metaClient, (CommitMetadataSerDe)HoodieTestUtils.COMMIT_METADATA_SER_DE, (String)instantTime, inflightReplaceMetadata);
        FileCreateUtils.createReplaceCommit((HoodieTableMetaClient)this.metaClient, (CommitMetadataSerDe)HoodieTestUtils.COMMIT_METADATA_SER_DE, (String)instantTime, (HoodieReplaceCommitMetadata)completeReplaceMetadata);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addCluster(String instantTime, HoodieRequestedReplaceMetadata requestedReplaceMetadata, Option<HoodieCommitMetadata> inflightReplaceMetadata, HoodieReplaceCommitMetadata completeReplaceMetadata, String completionTime) throws Exception {
        FileCreateUtils.createRequestedClusterCommit((HoodieTableMetaClient)this.metaClient, (String)instantTime, (HoodieRequestedReplaceMetadata)requestedReplaceMetadata);
        FileCreateUtils.createInflightClusterCommit((HoodieTableMetaClient)this.metaClient, (CommitMetadataSerDe)HoodieTestUtils.COMMIT_METADATA_SER_DE, (String)instantTime, inflightReplaceMetadata);
        FileCreateUtils.createReplaceCommit((HoodieTableMetaClient)this.metaClient, (CommitMetadataSerDe)HoodieTestUtils.COMMIT_METADATA_SER_DE, (String)instantTime, (String)completionTime, (HoodieReplaceCommitMetadata)completeReplaceMetadata);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addRequestedReplace(String instantTime, Option<HoodieRequestedReplaceMetadata> requestedReplaceMetadata) throws Exception {
        FileCreateUtils.createRequestedReplaceCommit((HoodieTableMetaClient)this.metaClient, (String)instantTime, requestedReplaceMetadata);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addInflightReplace(String instantTime, Option<HoodieCommitMetadata> inflightReplaceMetadata) throws Exception {
        FileCreateUtils.createInflightReplaceCommit((HoodieTableMetaClient)this.metaClient, (CommitMetadataSerDe)HoodieTestUtils.COMMIT_METADATA_SER_DE, (String)instantTime, inflightReplaceMetadata);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addInflightClean(String instantTime, HoodieCleanerPlan cleanerPlan) throws IOException {
        FileCreateUtils.createRequestedCleanFile((HoodieTableMetaClient)this.metaClient, (String)instantTime, (HoodieCleanerPlan)cleanerPlan);
        FileCreateUtils.createInflightCleanFile((HoodieTableMetaClient)this.metaClient, (String)instantTime, (HoodieCleanerPlan)cleanerPlan);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addClean(String instantTime, HoodieCleanerPlan cleanerPlan, HoodieCleanMetadata metadata) throws IOException {
        return this.addClean(instantTime, cleanerPlan, metadata, false, false);
    }

    public HoodieTestTable addClean(String instantTime, HoodieCleanerPlan cleanerPlan, HoodieCleanMetadata metadata, boolean isEmptyForAll, boolean isEmptyCompleted) throws IOException {
        FileCreateUtils.createRequestedCleanFile((HoodieTableMetaClient)this.metaClient, (String)instantTime, (HoodieCleanerPlan)cleanerPlan, (boolean)isEmptyForAll);
        FileCreateUtils.createInflightCleanFile((HoodieTableMetaClient)this.metaClient, (String)instantTime, (HoodieCleanerPlan)cleanerPlan, (boolean)isEmptyForAll);
        FileCreateUtils.createCleanFile((HoodieTableMetaClient)this.metaClient, (String)instantTime, (HoodieCleanMetadata)metadata, (boolean)isEmptyCompleted);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addClean(String instantTime) throws IOException {
        HoodieCleanerPlan cleanerPlan = new HoodieCleanerPlan(new HoodieActionInstant("", "", ""), "", "", new HashMap(), CleanPlanV2MigrationHandler.VERSION, new HashMap(), new ArrayList(), Collections.EMPTY_MAP);
        HoodieCleanStat cleanStats = new HoodieCleanStat(HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS, HoodieTestUtils.DEFAULT_PARTITION_PATHS[RANDOM.nextInt(HoodieTestUtils.DEFAULT_PARTITION_PATHS.length)], Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), instantTime, "");
        HoodieCleanMetadata cleanMetadata = CleanerUtils.convertCleanMetadata((String)instantTime, (Option)Option.of((Object)0L), Collections.singletonList(cleanStats), (Map)Collections.EMPTY_MAP);
        return HoodieTestTable.of(this.metaClient).addClean(instantTime, cleanerPlan, cleanMetadata);
    }

    public Pair<HoodieCleanerPlan, HoodieCleanMetadata> getHoodieCleanMetadata(String commitTime, HoodieTestTableState testTableState) {
        HoodieCleanerPlan cleanerPlan = new HoodieCleanerPlan(new HoodieActionInstant(commitTime, "clean", ""), "", "", new HashMap(), CleanPlanV2MigrationHandler.VERSION, new HashMap(), new ArrayList(), Collections.EMPTY_MAP);
        ArrayList<HoodieCleanStat> cleanStats = new ArrayList<HoodieCleanStat>();
        for (Map.Entry<String, List<String>> entry : testTableState.getPartitionToFileIdMapForCleaner(commitTime).entrySet()) {
            cleanStats.add(new HoodieCleanStat(HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS, entry.getKey(), entry.getValue(), entry.getValue(), Collections.emptyList(), commitTime, ""));
        }
        return Pair.of((Object)cleanerPlan, (Object)CleanerUtils.convertCleanMetadata((String)commitTime, (Option)Option.of((Object)0L), cleanStats, (Map)Collections.EMPTY_MAP));
    }

    public HoodieTestTable addRequestedRollback(String instantTime, HoodieRollbackPlan plan) throws IOException {
        FileCreateUtils.createRequestedRollbackFile((HoodieTableMetaClient)this.metaClient, (String)instantTime, (HoodieRollbackPlan)plan);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addInflightRollback(String instantTime) throws IOException {
        FileCreateUtils.createInflightRollbackFile((HoodieTableMetaClient)this.metaClient, (String)instantTime);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addRollback(String instantTime, HoodieRollbackMetadata rollbackMetadata, HoodieRollbackPlan rollbackPlan) throws IOException {
        return this.addRollback(instantTime, rollbackMetadata, false, rollbackPlan);
    }

    public HoodieTestTable addRollback(String instantTime, HoodieRollbackMetadata rollbackMetadata, boolean isEmpty, HoodieRollbackPlan rollbackPlan) throws IOException {
        if (rollbackPlan != null) {
            FileCreateUtils.createRequestedRollbackFile((HoodieTableMetaClient)this.metaClient, (String)instantTime, (HoodieRollbackPlan)rollbackPlan);
        } else {
            FileCreateUtils.createRequestedRollbackFile((HoodieTableMetaClient)this.metaClient, (String)instantTime);
        }
        FileCreateUtils.createInflightRollbackFile((HoodieTableMetaClient)this.metaClient, (String)instantTime);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addRollbackCompleted(String instantTime, HoodieRollbackMetadata rollbackMetadata, boolean isEmpty) throws IOException {
        FileCreateUtils.createRollbackFile((HoodieTableMetaClient)this.metaClient, (String)instantTime, (HoodieRollbackMetadata)rollbackMetadata, (boolean)isEmpty);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addRestore(String instantTime, HoodieRestoreMetadata restoreMetadata) throws IOException {
        FileCreateUtils.createRestoreFile((HoodieTableMetaClient)this.metaClient, (String)instantTime, (HoodieRestoreMetadata)restoreMetadata);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieRollbackMetadata getRollbackMetadata(String instantTimeToDelete, Map<String, List<String>> partitionToFilesMeta, boolean shouldAddRollbackLogFile) throws Exception {
        HoodieRollbackMetadata rollbackMetadata = new HoodieRollbackMetadata();
        rollbackMetadata.setCommitsRollback(Collections.singletonList(instantTimeToDelete));
        rollbackMetadata.setStartRollbackTime(instantTimeToDelete);
        HashMap<String, HoodieRollbackPartitionMetadata> partitionMetadataMap = new HashMap<String, HoodieRollbackPartitionMetadata>();
        for (Map.Entry<String, List<String>> entry : partitionToFilesMeta.entrySet()) {
            HoodieRollbackPartitionMetadata rollbackPartitionMetadata = new HoodieRollbackPartitionMetadata();
            rollbackPartitionMetadata.setPartitionPath(entry.getKey());
            rollbackPartitionMetadata.setSuccessDeleteFiles(entry.getValue());
            rollbackPartitionMetadata.setFailedDeleteFiles(new ArrayList());
            if (shouldAddRollbackLogFile) {
                long rollbackLogFileSize = 50 + RANDOM.nextInt(500);
                String fileId = UUID.randomUUID().toString();
                String logFileName = FileCreateUtils.logFileName((String)instantTimeToDelete, (String)fileId, (int)0);
                FileCreateUtils.createLogFile((HoodieTableMetaClient)this.metaClient, (String)entry.getKey(), (String)instantTimeToDelete, (String)fileId, (int)0, (int)((int)rollbackLogFileSize));
                rollbackPartitionMetadata.setRollbackLogFiles(Collections.singletonMap(logFileName, rollbackLogFileSize));
            }
            partitionMetadataMap.put(entry.getKey(), rollbackPartitionMetadata);
        }
        rollbackMetadata.setPartitionMetadata(partitionMetadataMap);
        rollbackMetadata.setInstantsRollback(Collections.singletonList(new HoodieInstantInfo(instantTimeToDelete, "rollback")));
        return rollbackMetadata;
    }

    private Map<String, Long> getWrittenLogFiles(String instant, Map.Entry<String, List<String>> entry) {
        HashMap<String, Long> writtenLogFiles = new HashMap<String, Long>();
        for (String fileName : entry.getValue()) {
            if (!HadoopFSUtils.isLogFile((org.apache.hadoop.fs.Path)new org.apache.hadoop.fs.Path(fileName)) || testTableState.getPartitionToLogFileInfoMap(instant) == null || !testTableState.getPartitionToLogFileInfoMap(instant).containsKey(entry.getKey())) continue;
            List<Pair<String, Integer[]>> fileInfos = testTableState.getPartitionToLogFileInfoMap(instant).get(entry.getKey());
            for (Pair<String, Integer[]> fileInfo : fileInfos) {
                if (!fileName.equals(FileCreateUtils.logFileName((String)instant, (String)((String)fileInfo.getLeft()), (int)((Integer[])fileInfo.getRight())[0]))) continue;
                writtenLogFiles.put(fileName, (long)((Integer[])fileInfo.getRight())[1]);
            }
        }
        return writtenLogFiles;
    }

    public HoodieSavepointMetadata getSavepointMetadata(String instant, Map<String, List<String>> partitionToFilesMeta) {
        HoodieSavepointMetadata savepointMetadata = new HoodieSavepointMetadata();
        savepointMetadata.setSavepointedAt(12345L);
        HashMap<String, HoodieSavepointPartitionMetadata> partitionMetadataMap = new HashMap<String, HoodieSavepointPartitionMetadata>();
        for (Map.Entry<String, List<String>> entry : partitionToFilesMeta.entrySet()) {
            HoodieSavepointPartitionMetadata savepointPartitionMetadata = new HoodieSavepointPartitionMetadata();
            savepointPartitionMetadata.setPartitionPath(entry.getKey());
            savepointPartitionMetadata.setSavepointDataFile(entry.getValue());
            partitionMetadataMap.put(entry.getKey(), savepointPartitionMetadata);
        }
        savepointMetadata.setPartitionMetadata(partitionMetadataMap);
        savepointMetadata.setSavepointedBy("test");
        savepointMetadata.setComments("test_comment");
        return savepointMetadata;
    }

    public HoodieTestTable addRequestedCompaction(String instantTime) throws IOException {
        ArrayList<FileSlice> fileSlices = new ArrayList<FileSlice>();
        fileSlices.add(new FileSlice("par1", instantTime, "fg-1"));
        fileSlices.add(new FileSlice("par2", instantTime, "fg-2"));
        HoodieCompactionPlan compactionPlan = CompactionUtils.buildFromFileSlices(fileSlices.stream().map(fs -> Pair.of((Object)fs.getPartitionPath(), (Object)fs)).collect(Collectors.toList()), (Option)Option.empty(), (Option)Option.empty());
        HoodieInstant compactionInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, "compaction", instantTime);
        this.metaClient.getActiveTimeline().saveToCompactionRequested(compactionInstant, TimelineMetadataUtils.serializeCompactionPlan((HoodieCompactionPlan)compactionPlan));
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addRequestedCompaction(String instantTime, HoodieCompactionPlan compactionPlan) throws IOException {
        HoodieInstant compactionInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, "compaction", instantTime);
        this.metaClient.getActiveTimeline().saveToCompactionRequested(compactionInstant, TimelineMetadataUtils.serializeCompactionPlan((HoodieCompactionPlan)compactionPlan));
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addRequestedCompaction(String instantTime, FileSlice ... fileSlices) throws IOException {
        HoodieCompactionPlan plan = CompactionUtils.buildFromFileSlices(Arrays.stream(fileSlices).map(fs -> Pair.of((Object)fs.getPartitionPath(), (Object)fs)).collect(Collectors.toList()), (Option)Option.empty(), (Option)Option.empty());
        return this.addRequestedCompaction(instantTime, plan);
    }

    public HoodieTestTable addInflightCompaction(String instantTime, HoodieCommitMetadata commitMetadata) throws Exception {
        ArrayList<FileSlice> fileSlices = new ArrayList<FileSlice>();
        for (Map.Entry entry : commitMetadata.getPartitionToWriteStats().entrySet()) {
            for (HoodieWriteStat stat : (List)entry.getValue()) {
                fileSlices.add(new FileSlice((String)entry.getKey(), instantTime, stat.getPath()));
            }
        }
        this.addRequestedCompaction(instantTime, fileSlices.toArray(new FileSlice[0]));
        FileCreateUtils.createInflightCompaction((HoodieTableMetaClient)this.metaClient, (String)instantTime);
        this.inflightCommits.add(instantTime);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addCompaction(String instantTime, HoodieCommitMetadata commitMetadata) throws Exception {
        this.addInflightCompaction(instantTime, commitMetadata);
        this.inflightCommits.remove(instantTime);
        FileCreateUtils.createCommit((HoodieTableMetaClient)this.metaClient, (CommitMetadataSerDe)HoodieTestUtils.COMMIT_METADATA_SER_DE, (String)instantTime, (Option)Option.of((Object)commitMetadata));
        return this;
    }

    public HoodieTestTable addDeletePartitionCommit(String instantTime, String partition, List<String> fileIds) throws Exception {
        this.forReplaceCommit(instantTime);
        WriteOperationType operationType = WriteOperationType.DELETE_PARTITION;
        Pair<HoodieRequestedReplaceMetadata, HoodieReplaceCommitMetadata> metas = this.generateReplaceCommitMetadata(instantTime, partition, fileIds, (Option<String>)Option.empty(), operationType);
        return this.addReplaceCommit(instantTime, (Option<HoodieRequestedReplaceMetadata>)Option.of((Object)metas.getLeft()), (Option<HoodieCommitMetadata>)Option.empty(), (HoodieReplaceCommitMetadata)metas.getRight());
    }

    private Pair<HoodieRequestedReplaceMetadata, HoodieReplaceCommitMetadata> generateReplaceCommitMetadata(String instantTime, String partition, List<String> replacedFileIds, Option<String> newFileId, WriteOperationType operationType) {
        HoodieRequestedReplaceMetadata requestedReplaceMetadata = new HoodieRequestedReplaceMetadata();
        requestedReplaceMetadata.setOperationType(operationType.toString());
        requestedReplaceMetadata.setVersion(Integer.valueOf(1));
        List sliceInfos = replacedFileIds.stream().map(replacedFileId -> HoodieSliceInfo.newBuilder().setFileId(replacedFileId).build()).collect(Collectors.toList());
        ArrayList<HoodieClusteringGroup> clusteringGroups = new ArrayList<HoodieClusteringGroup>();
        clusteringGroups.add(HoodieClusteringGroup.newBuilder().setVersion(Integer.valueOf(1)).setNumOutputFileGroups(Integer.valueOf(1)).setMetrics(Collections.emptyMap()).setSlices(sliceInfos).build());
        requestedReplaceMetadata.setExtraMetadata(Collections.emptyMap());
        requestedReplaceMetadata.setClusteringPlan(HoodieClusteringPlan.newBuilder().setVersion(Integer.valueOf(1)).setExtraMetadata(Collections.emptyMap()).setStrategy(HoodieClusteringStrategy.newBuilder().setStrategyClassName("").setVersion(Integer.valueOf(1)).build()).setInputGroups(clusteringGroups).build());
        HoodieReplaceCommitMetadata replaceMetadata = new HoodieReplaceCommitMetadata();
        replacedFileIds.forEach(replacedFileId -> replaceMetadata.addReplaceFileId(partition, replacedFileId));
        replaceMetadata.setOperationType(operationType);
        if (newFileId.isPresent() && !StringUtils.isNullOrEmpty((String)((String)newFileId.get()))) {
            HoodieWriteStat writeStat = new HoodieWriteStat();
            writeStat.setPartitionPath(partition);
            writeStat.setPath(partition + "/" + FSUtils.makeBaseFileName((String)instantTime, (String)"1-0-1", (String)((String)newFileId.get()), (String)HoodieCommonTestHarness.BASE_FILE_EXTENSION));
            writeStat.setFileId((String)newFileId.get());
            writeStat.setTotalWriteBytes(1L);
            writeStat.setFileSizeInBytes(1L);
            replaceMetadata.addWriteStat(partition, writeStat);
        }
        return Pair.of((Object)requestedReplaceMetadata, (Object)replaceMetadata);
    }

    public HoodieTestTable moveInflightCompactionToComplete(String instantTime, HoodieCommitMetadata metadata) throws IOException {
        FileCreateUtils.createCommit((HoodieTableMetaClient)this.metaClient, (CommitMetadataSerDe)HoodieTestUtils.COMMIT_METADATA_SER_DE, (String)instantTime, (Option)Option.of((Object)metadata));
        this.inflightCommits.remove(instantTime);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addSavepoint(String instantTime, HoodieSavepointMetadata savepointMetadata) throws IOException {
        FileCreateUtils.createInflightSavepoint((HoodieTableMetaClient)this.metaClient, (String)instantTime);
        FileCreateUtils.createSavepointCommit((HoodieTableMetaClient)this.metaClient, (String)instantTime, (HoodieSavepointMetadata)savepointMetadata);
        return this;
    }

    public HoodieTestTable deleteSavepoint(String instantTime) throws IOException {
        FileCreateUtils.deleteSavepointCommit((HoodieTableMetaClient)this.metaClient, (String)instantTime, (HoodieStorage)this.storage);
        return this;
    }

    public HoodieTestTable forCommit(String instantTime) {
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable forDeltaCommit(String instantTime) {
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable forReplaceCommit(String instantTime) {
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable withPartitionMetaFiles(String ... partitionPaths) throws IOException {
        for (String partitionPath : partitionPaths) {
            FileCreateUtils.createPartitionMetaFile((String)this.basePath, (String)partitionPath);
        }
        return this;
    }

    public HoodieTestTable withPartitionMetaFiles(List<String> partitionPaths) throws IOException {
        for (String partitionPath : partitionPaths) {
            FileCreateUtils.createPartitionMetaFile((String)this.basePath, (String)partitionPath);
        }
        return this;
    }

    public HoodieTestTable withMarkerFile(String partitionPath, String fileId, IOType ioType) throws IOException {
        FileCreateUtils.createMarkerFile((HoodieTableMetaClient)this.metaClient, (String)partitionPath, (String)this.currentInstantTime, (String)fileId, (IOType)ioType);
        return this;
    }

    public HoodieTestTable withMarkerFiles(String partitionPath, int num, IOType ioType) throws IOException {
        String[] fileIds = (String[])IntStream.range(0, num).mapToObj(i -> UUID.randomUUID().toString()).toArray(String[]::new);
        return this.withMarkerFiles(partitionPath, fileIds, ioType);
    }

    public HoodieTestTable withMarkerFiles(String partitionPath, String[] fileIds, IOType ioType) throws IOException {
        for (String fileId : fileIds) {
            FileCreateUtils.createMarkerFile((HoodieTableMetaClient)this.metaClient, (String)partitionPath, (String)this.currentInstantTime, (String)fileId, (IOType)ioType);
        }
        return this;
    }

    public HoodieTestTable withLogMarkerFile(String partitionPath, String fileId, IOType ioType) throws IOException {
        String logFileName = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)this.currentInstantTime, (int)HoodieLogFile.LOGFILE_BASE_VERSION, (String)"1-0-1");
        String markerFileName = FileCreateUtils.markerFileName((String)logFileName, (IOType)ioType);
        FileCreateUtils.createMarkerFile((HoodieTableMetaClient)this.metaClient, (String)partitionPath, (String)this.currentInstantTime, (String)markerFileName);
        return this;
    }

    public HoodieTestTable withLogMarkerFile(String partitionPath, String fileName) throws IOException {
        FileCreateUtils.createLogFileMarker((HoodieTableMetaClient)this.metaClient, (String)partitionPath, (String)this.currentInstantTime, (String)fileName);
        return this;
    }

    public Map<String, String> getFileIdsWithBaseFilesInPartitions(String ... partitions) throws Exception {
        HashMap<String, String> partitionFileIdMap = new HashMap<String, String>();
        for (String p : partitions) {
            String fileId = UUID.randomUUID().toString();
            FileCreateUtils.createBaseFile((HoodieTableMetaClient)this.metaClient, (String)p, (String)this.currentInstantTime, (String)fileId);
            partitionFileIdMap.put(p, fileId);
        }
        return partitionFileIdMap;
    }

    public Pair<HoodieTestTable, List<String>> withBaseFilesInPartitions(Map<String, String> partitionAndFileId) throws Exception {
        ArrayList files = new ArrayList();
        for (Map.Entry<String, String> pair : partitionAndFileId.entrySet()) {
            files.addAll((Collection)this.withBaseFilesInPartition(pair.getKey(), pair.getValue()).getValue());
        }
        return Pair.of((Object)this, files);
    }

    public Pair<HoodieTestTable, List<String>> withBaseFilesInPartition(String partition, String ... fileIds) throws Exception {
        ArrayList<String> files = new ArrayList<String>();
        for (String f : fileIds) {
            files.add(FileCreateUtils.createBaseFile((HoodieTableMetaClient)this.metaClient, (String)partition, (String)this.currentInstantTime, (String)f));
        }
        return Pair.of((Object)this, files);
    }

    public HoodieTestTable withBaseFilesInPartition(String partition, int ... lengths) throws Exception {
        for (int l : lengths) {
            String fileId = UUID.randomUUID().toString();
            FileCreateUtils.createBaseFile((HoodieTableMetaClient)this.metaClient, (String)partition, (String)this.currentInstantTime, (String)fileId, (long)l);
        }
        return this;
    }

    public HoodieTestTable withBaseFilesInPartition(String partition, List<Pair<String, Integer>> fileInfos) throws Exception {
        for (Pair<String, Integer> fileInfo : fileInfos) {
            FileCreateUtils.createBaseFile((HoodieTableMetaClient)this.metaClient, (String)partition, (String)this.currentInstantTime, (String)((String)fileInfo.getKey()), (long)((Integer)fileInfo.getValue()).intValue());
        }
        return this;
    }

    public String getFileIdWithLogFile(String partitionPath) throws Exception {
        String fileId = UUID.randomUUID().toString();
        this.withLogFile(partitionPath, fileId);
        return fileId;
    }

    public Pair<HoodieTestTable, List<String>> withLogFile(String partitionPath, String fileId) throws Exception {
        return this.withLogFile(partitionPath, fileId, 0);
    }

    public Pair<HoodieTestTable, List<String>> withLogFile(String partitionPath, String fileId, int ... versions) throws Exception {
        return this.withLogFile(partitionPath, fileId, this.currentInstantTime, versions);
    }

    public Pair<HoodieTestTable, List<String>> withLogFile(String partitionPath, String fileId, String instantTime, int ... versions) throws Exception {
        ArrayList<String> logFiles = new ArrayList<String>();
        for (int version : versions) {
            logFiles.add(FileCreateUtils.createLogFile((HoodieTableMetaClient)this.metaClient, (String)partitionPath, (String)instantTime, (String)fileId, (int)version));
        }
        return Pair.of((Object)this, logFiles);
    }

    public HoodieTestTable withLogFilesInPartition(String partition, List<Pair<String, Integer[]>> fileInfos) throws Exception {
        for (Pair<String, Integer[]> fileInfo : fileInfos) {
            FileCreateUtils.createLogFile((HoodieTableMetaClient)this.metaClient, (String)partition, (String)this.currentInstantTime, (String)((String)fileInfo.getKey()), (int)((Integer[])fileInfo.getValue())[0], (int)((Integer[])fileInfo.getValue())[1]);
        }
        return this;
    }

    public boolean inflightCommitExists(String instantTime) {
        try {
            return this.fs.exists(this.getInflightCommitFilePath(instantTime));
        }
        catch (IOException e) {
            throw new HoodieTestTableException(e);
        }
    }

    public boolean commitExists(String instantTime) {
        try {
            this.getCommitFilePath(instantTime);
            return true;
        }
        catch (HoodieIOException e) {
            return false;
        }
    }

    public boolean baseFilesExist(Map<String, String> partitionAndFileId, String instantTime) {
        return partitionAndFileId.entrySet().stream().allMatch(entry -> {
            String partition = (String)entry.getKey();
            String fileId = (String)entry.getValue();
            return this.baseFileExists(partition, instantTime, fileId);
        });
    }

    public boolean baseFileExists(String partition, String instantTime, String fileId) {
        try {
            return this.fs.exists(new org.apache.hadoop.fs.Path(Paths.get(this.basePath, partition, FileCreateUtils.baseFileName((String)instantTime, (String)fileId)).toString()));
        }
        catch (IOException e) {
            throw new HoodieTestTableException(e);
        }
    }

    public boolean logFilesExist(String partition, String instantTime, String fileId, int ... versions) {
        return Arrays.stream(versions).allMatch(v -> this.logFileExists(partition, instantTime, fileId, v));
    }

    public boolean logFileExists(String partition, String instantTime, String fileId, int version) {
        try {
            return this.fs.exists(new org.apache.hadoop.fs.Path(Paths.get(this.basePath, partition, FileCreateUtils.logFileName((String)instantTime, (String)fileId, (int)version)).toString()));
        }
        catch (IOException e) {
            throw new HoodieTestTableException(e);
        }
    }

    public org.apache.hadoop.fs.Path getInflightCommitFilePath(String instantTime) {
        return new org.apache.hadoop.fs.Path(Paths.get(this.metaClient.getTimelinePath().toUri().getPath(), instantTime + ".inflight").toUri());
    }

    public StoragePath getCommitFilePath(String instantTime) {
        return HoodieTestUtils.getCompleteInstantPath((HoodieStorage)this.storage, (StoragePath)this.metaClient.getTimelinePath(), (String)instantTime, (String)"commit");
    }

    public org.apache.hadoop.fs.Path getRequestedCompactionFilePath(String instantTime) {
        return new org.apache.hadoop.fs.Path(Paths.get(this.metaClient.getMetaAuxiliaryPath(), instantTime + HoodieTimeline.REQUESTED_COMPACTION_EXTENSION).toUri());
    }

    public org.apache.hadoop.fs.Path getPartitionPath(String partition) {
        return new org.apache.hadoop.fs.Path(Paths.get(this.basePath, partition).toUri());
    }

    public List<Path> getAllPartitionPaths() throws IOException {
        Path basePathPath = Paths.get(this.basePath, new String[0]);
        return FileCreateUtils.getPartitionPaths((Path)basePathPath);
    }

    public org.apache.hadoop.fs.Path getBaseFilePath(String partition, String fileId) {
        return new org.apache.hadoop.fs.Path(Paths.get(this.basePath, partition, this.getBaseFileNameById(fileId)).toUri());
    }

    public String getBaseFileNameById(String fileId) {
        return FileCreateUtils.baseFileName((String)this.currentInstantTime, (String)fileId);
    }

    public org.apache.hadoop.fs.Path getLogFilePath(String partition, String fileId, int version) {
        return new org.apache.hadoop.fs.Path(Paths.get(this.basePath, partition, this.getLogFileNameById(fileId, version)).toString());
    }

    public String getLogFileNameById(String fileId, int version) {
        return FileCreateUtils.logFileName((String)this.currentInstantTime, (String)fileId, (int)version);
    }

    public List<String> getEarliestFilesInPartition(String partition, int count) throws IOException {
        List<FileStatus> fileStatuses = Arrays.asList(this.listAllFilesInPartition(partition));
        fileStatuses.sort(Comparator.comparing(FileStatus::getModificationTime));
        return fileStatuses.subList(0, count).stream().map(entry -> entry.getPath().getName()).collect(Collectors.toList());
    }

    public List<String> inflightCommits() {
        return this.inflightCommits;
    }

    public List<StoragePathInfo> listAllBaseFiles() throws IOException {
        return this.listAllBaseFiles(HoodieFileFormat.PARQUET.getFileExtension());
    }

    public List<StoragePathInfo> listAllBaseFiles(String fileExtension) throws IOException {
        return HoodieTestTable.listRecursive(this.storage, new StoragePath(this.basePath)).stream().filter(fileInfo -> fileInfo.getPath().getName().endsWith(fileExtension)).collect(Collectors.toList());
    }

    public static List<FileStatus> listRecursive(FileSystem fs, org.apache.hadoop.fs.Path path) throws IOException {
        return HoodieTestTable.listFiles(fs, path, true);
    }

    public static List<FileStatus> listFiles(FileSystem fs, org.apache.hadoop.fs.Path path, boolean recursive) throws IOException {
        RemoteIterator itr = fs.listFiles(path, recursive);
        ArrayList<FileStatus> statuses = new ArrayList<FileStatus>();
        while (itr.hasNext()) {
            statuses.add((FileStatus)itr.next());
        }
        return statuses;
    }

    public static List<StoragePathInfo> listRecursive(HoodieStorage storage, StoragePath path) throws IOException {
        return HoodieTestTable.listFiles(storage, path);
    }

    public static List<StoragePathInfo> listFiles(HoodieStorage storage, StoragePath path) throws IOException {
        return storage.listFiles(path);
    }

    public static String readLastLineFromResourceFile(String resourceName) throws IOException {
        try (InputStream inputStream = TestLogReaderUtils.class.getResourceAsStream(resourceName);){
            List lines = FileIOUtils.readAsUTFStringLines((InputStream)inputStream);
            String string = (String)lines.get(lines.size() - 1);
            return string;
        }
    }

    public List<StoragePathInfo> listAllLogFiles() throws IOException {
        return this.listAllLogFiles(HoodieFileFormat.HOODIE_LOG.getFileExtension());
    }

    public List<StoragePathInfo> listAllLogFiles(String fileExtension) throws IOException {
        return HoodieTestTable.listRecursive(this.storage, new StoragePath(this.basePath)).stream().filter(fileInfo -> !fileInfo.getPath().toString().contains(".hoodie")).filter(fileInfo -> fileInfo.getPath().getName().contains(fileExtension)).collect(Collectors.toList());
    }

    public List<StoragePathInfo> listAllBaseAndLogFiles() throws IOException {
        ArrayList<StoragePathInfo> result = new ArrayList<StoragePathInfo>(this.listAllBaseFiles());
        result.addAll(this.listAllLogFiles());
        return result;
    }

    public FileStatus[] listAllFilesInPartition(String partitionPath) throws IOException {
        return (FileStatus[])HoodieTestTable.listRecursive(this.fs, new org.apache.hadoop.fs.Path(Paths.get(this.basePath, partitionPath).toString())).stream().filter(entry -> {
            boolean toReturn = true;
            String filePath = entry.getPath().toString();
            String fileName = entry.getPath().getName();
            if (fileName.startsWith(".hoodie_partition_metadata") || !FileCreateUtils.isBaseOrLogFilename((String)fileName) || filePath.contains("metadata")) {
                toReturn = false;
            } else {
                for (String inflight : this.inflightCommits) {
                    if (!fileName.contains(inflight)) continue;
                    toReturn = false;
                    break;
                }
            }
            return toReturn;
        }).toArray(FileStatus[]::new);
    }

    public FileStatus[] listAllFilesInTempFolder() throws IOException {
        return HoodieTestTable.listRecursive(this.fs, new org.apache.hadoop.fs.Path(this.metaClient.getTempFolderPath())).toArray(new FileStatus[0]);
    }

    public void deleteFilesInPartition(String partitionPath, List<String> filesToDelete) throws IOException {
        FileStatus[] allFiles = this.listAllFilesInPartition(partitionPath);
        Arrays.stream(allFiles).filter(entry -> filesToDelete.contains(entry.getPath().getName())).forEach(entry -> {
            try {
                Files.delete(Paths.get(this.basePath, partitionPath, entry.getPath().getName()));
            }
            catch (IOException e) {
                throw new HoodieTestTableException(e);
            }
        });
    }

    public HoodieTestTable doRollback(String commitTimeToRollback, String commitTime) throws Exception {
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        Option<HoodieCommitMetadata> commitMetadata = this.getMetadataForInstant(commitTimeToRollback);
        if (!commitMetadata.isPresent()) {
            throw new IllegalArgumentException("Instant to rollback not present in timeline: " + commitTimeToRollback);
        }
        Map<String, List<String>> partitionFiles = HoodieTestTable.getPartitionFiles((HoodieCommitMetadata)commitMetadata.get());
        HoodieRollbackMetadata rollbackMetadata = this.getRollbackMetadata(commitTimeToRollback, partitionFiles, false);
        for (Map.Entry<String, List<String>> entry : partitionFiles.entrySet()) {
            this.deleteFilesInPartition(entry.getKey(), entry.getValue());
        }
        HoodieRollbackPlan rollbackPlan = this.getHoodieRollbackPlan(commitTime, partitionFiles);
        HoodieTestTable testTable = this.addRollback(commitTime, rollbackMetadata, rollbackPlan);
        return testTable.addRollbackCompleted(commitTime, rollbackMetadata, false);
    }

    private HoodieRollbackPlan getHoodieRollbackPlan(String commitTime, Map<String, List<String>> partitionFiles) {
        HoodieRollbackPlan rollbackPlan = new HoodieRollbackPlan();
        List rollbackRequestList = partitionFiles.keySet().stream().map(partition -> new HoodieRollbackRequest(partition, "", "", (List)partitionFiles.get(partition), Collections.emptyMap())).collect(Collectors.toList());
        rollbackPlan.setRollbackRequests(rollbackRequestList);
        rollbackPlan.setInstantToRollback(new HoodieInstantInfo(commitTime, "commit"));
        return rollbackPlan;
    }

    public HoodieTestTable doRollbackWithExtraFiles(String commitTimeToRollback, String commitTime, Map<String, List<String>> extraFiles) throws Exception {
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        Option<HoodieCommitMetadata> commitMetadata = this.getMetadataForInstant(commitTimeToRollback);
        if (!commitMetadata.isPresent()) {
            throw new IllegalArgumentException("Instant to rollback not present in timeline: " + commitTimeToRollback);
        }
        Map<String, List<String>> partitionFiles = HoodieTestTable.getPartitionFiles((HoodieCommitMetadata)commitMetadata.get());
        for (Map.Entry<String, List<String>> entry : partitionFiles.entrySet()) {
            this.deleteFilesInPartition(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, List<String>> entry : extraFiles.entrySet()) {
            if (!partitionFiles.containsKey(entry.getKey())) continue;
            partitionFiles.get(entry.getKey()).addAll((Collection<String>)entry.getValue());
        }
        HoodieRollbackMetadata rollbackMetadata = this.getRollbackMetadata(commitTimeToRollback, partitionFiles, false);
        HoodieRollbackPlan rollbackPlan = this.getHoodieRollbackPlan(commitTime, partitionFiles);
        HoodieTestTable testTable = this.addRollback(commitTime, rollbackMetadata, rollbackPlan);
        return testTable.addRollbackCompleted(commitTime, rollbackMetadata, false);
    }

    public HoodieTestTable doRestore(String commitToRestoreTo, String restoreTime) throws Exception {
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        List commitsToRollback = this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().findInstantsAfter(commitToRestoreTo).getReverseOrderedInstants().collect(Collectors.toList());
        HashMap<String, List<HoodieRollbackMetadata>> rollbackMetadataMap = new HashMap<String, List<HoodieRollbackMetadata>>();
        for (HoodieInstant commitInstantToRollback : commitsToRollback) {
            Option<HoodieCommitMetadata> commitMetadata = this.getCommitMeta(commitInstantToRollback);
            if (!commitMetadata.isPresent()) {
                throw new IllegalArgumentException("Instant to rollback not present in timeline: " + commitInstantToRollback.requestedTime());
            }
            Map<String, List<String>> partitionFiles = HoodieTestTable.getPartitionFiles((HoodieCommitMetadata)commitMetadata.get());
            rollbackMetadataMap.put(commitInstantToRollback.requestedTime(), Collections.singletonList(this.getRollbackMetadata(commitInstantToRollback.requestedTime(), partitionFiles, false)));
            for (Map.Entry<String, List<String>> entry : partitionFiles.entrySet()) {
                this.deleteFilesInPartition(entry.getKey(), entry.getValue());
            }
        }
        HoodieRestoreMetadata restoreMetadata = TimelineMetadataUtils.convertRestoreMetadata((String)restoreTime, (long)1000L, commitsToRollback, rollbackMetadataMap);
        return this.addRestore(restoreTime, restoreMetadata);
    }

    public HoodieReplaceCommitMetadata doCluster(String commitTime, Map<String, List<String>> partitionToReplaceFileIds, List<String> partitions, int filesPerPartition) throws Exception {
        HoodieTestTableState testTableState = HoodieTestTable.getTestTableStateWithPartitionFileInfo(WriteOperationType.CLUSTER, this.metaClient.getTableType(), commitTime, partitions, filesPerPartition);
        this.currentInstantTime = commitTime;
        HashMap partitionToReplaceFileIdsWithLength = new HashMap();
        for (Map.Entry<String, List<String>> entry : partitionToReplaceFileIds.entrySet()) {
            String partition = entry.getKey();
            partitionToReplaceFileIdsWithLength.put(entry.getKey(), new ArrayList());
            for (String fileId : entry.getValue()) {
                int length = 100 + RANDOM.nextInt(500);
                ((List)partitionToReplaceFileIdsWithLength.get(partition)).add(Pair.of((Object)fileId, (Object)length));
            }
        }
        List<HoodieWriteStat> writeStats = HoodieTestTable.generateHoodieWriteStatForPartition(testTableState.getPartitionToBaseFileInfoMap(commitTime), commitTime, false);
        for (String partition : testTableState.getPartitionToBaseFileInfoMap(commitTime).keySet()) {
            this.withBaseFilesInPartition(partition, testTableState.getPartitionToBaseFileInfoMap(commitTime).get(partition));
        }
        HoodieReplaceCommitMetadata hoodieReplaceCommitMetadata = (HoodieReplaceCommitMetadata)CommitUtils.buildMetadata(writeStats, partitionToReplaceFileIds, (Option)Option.empty(), (WriteOperationType)WriteOperationType.CLUSTER, (String)PHONY_TABLE_SCHEMA, (String)"replacecommit");
        HoodieRequestedReplaceMetadata requestedReplaceMetadata = HoodieRequestedReplaceMetadata.newBuilder().setOperationType(WriteOperationType.CLUSTER.name()).setExtraMetadata(Collections.emptyMap()).setClusteringPlan(new HoodieClusteringPlan()).build();
        this.addCluster(commitTime, requestedReplaceMetadata, (Option<HoodieCommitMetadata>)Option.empty(), hoodieReplaceCommitMetadata);
        return hoodieReplaceCommitMetadata;
    }

    public HoodieCleanMetadata doClean(String commitTime, Map<String, Integer> partitionFileCountsToDelete) throws IOException {
        return this.doClean(commitTime, partitionFileCountsToDelete, Collections.emptyMap());
    }

    public HoodieCleanMetadata doClean(String commitTime, Map<String, Integer> partitionFileCountsToDelete, Map<String, String> extraMetadata) throws IOException {
        HashMap<String, List<String>> partitionFilesToDelete = new HashMap<String, List<String>>();
        for (Map.Entry<String, Integer> entry : partitionFileCountsToDelete.entrySet()) {
            partitionFilesToDelete.put(entry.getKey(), this.getEarliestFilesInPartition(entry.getKey(), entry.getValue()));
        }
        HoodieTestTableState testTableState = new HoodieTestTableState();
        for (Map.Entry entry : partitionFilesToDelete.entrySet()) {
            testTableState = testTableState.createTestTableStateForCleaner(commitTime, (String)entry.getKey(), (List)entry.getValue());
            this.deleteFilesInPartition((String)entry.getKey(), (List)entry.getValue());
        }
        Pair<HoodieCleanerPlan, HoodieCleanMetadata> pair = this.getHoodieCleanMetadata(commitTime, testTableState);
        HoodieCleanMetadata hoodieCleanMetadata = (HoodieCleanMetadata)pair.getValue();
        ((HoodieCleanerPlan)pair.getKey()).setExtraMetadata(extraMetadata);
        hoodieCleanMetadata.setExtraMetadata(extraMetadata);
        this.addClean(commitTime, (HoodieCleanerPlan)pair.getKey(), hoodieCleanMetadata);
        return hoodieCleanMetadata;
    }

    public void repeatClean(String cleanCommitTime, HoodieCleanerPlan cleanerPlan, HoodieCleanMetadata cleanMetadata) throws IOException {
        this.addClean(cleanCommitTime, cleanerPlan, cleanMetadata);
    }

    public HoodieCleanMetadata doCleanBasedOnCommits(String cleanCommitTime, List<String> commitsToClean) throws IOException {
        HashMap<String, Integer> partitionFileCountsToDelete = new HashMap<String, Integer>();
        for (String commitTime : commitsToClean) {
            Option<HoodieCommitMetadata> commitMetadata = this.getMetadataForInstant(commitTime);
            if (!commitMetadata.isPresent()) continue;
            Map<String, List<String>> partitionFiles = HoodieTestTable.getPartitionFiles((HoodieCommitMetadata)commitMetadata.get());
            for (String partition : partitionFiles.keySet()) {
                partitionFileCountsToDelete.put(partition, partitionFiles.get(partition).size() + partitionFileCountsToDelete.getOrDefault(partition, 0));
            }
        }
        return this.doClean(cleanCommitTime, partitionFileCountsToDelete);
    }

    public HoodieSavepointMetadata doSavepoint(String commitTime) throws IOException {
        Option<HoodieCommitMetadata> commitMetadata = this.getMetadataForInstant(commitTime);
        if (!commitMetadata.isPresent()) {
            throw new IllegalArgumentException("Instant to rollback not present in timeline: " + commitTime);
        }
        Map<String, List<String>> partitionFiles = HoodieTestTable.getPartitionFiles((HoodieCommitMetadata)commitMetadata.get());
        HoodieSavepointMetadata savepointMetadata = this.getSavepointMetadata(commitTime, partitionFiles);
        for (Map.Entry<String, List<String>> entry : partitionFiles.entrySet()) {
            this.deleteFilesInPartition(entry.getKey(), entry.getValue());
        }
        return savepointMetadata;
    }

    public HoodieCommitMetadata doCompaction(String commitTime, List<String> partitions) throws Exception {
        return this.doCompaction(commitTime, partitions, false);
    }

    public HoodieCommitMetadata doCompaction(String commitTime, List<String> partitions, boolean inflight) throws Exception {
        this.currentInstantTime = commitTime;
        if (partitions.isEmpty()) {
            partitions = Collections.singletonList("");
        }
        HoodieTestTableState testTableState = HoodieTestTable.getTestTableStateWithPartitionFileInfo(WriteOperationType.COMPACT, this.metaClient.getTableType(), commitTime, partitions, 1);
        HoodieCommitMetadata commitMetadata = this.createCommitMetadata(WriteOperationType.COMPACT, commitTime, testTableState);
        for (String partition : partitions) {
            this.withBaseFilesInPartition(partition, testTableState.getPartitionToBaseFileInfoMap(commitTime).get(partition));
        }
        if (inflight) {
            this.addInflightCompaction(commitTime, commitMetadata);
        } else {
            this.addCompaction(commitTime, commitMetadata);
        }
        return commitMetadata;
    }

    public HoodieCommitMetadata doWriteOperation(String commitTime, WriteOperationType operationType, List<String> partitions, int filesPerPartition) throws Exception {
        return this.doWriteOperation(commitTime, operationType, Collections.emptyList(), partitions, filesPerPartition, false);
    }

    public HoodieCommitMetadata doWriteOperation(String commitTime, WriteOperationType operationType, List<String> newPartitionsToAdd, List<String> partitions, int filesPerPartition) throws Exception {
        return this.doWriteOperation(commitTime, operationType, newPartitionsToAdd, partitions, filesPerPartition, false);
    }

    public HoodieCommitMetadata doWriteOperation(String commitTime, WriteOperationType operationType, List<String> newPartitionsToAdd, List<String> partitions, int filesPerPartition, boolean bootstrap) throws Exception {
        return this.doWriteOperation(commitTime, operationType, newPartitionsToAdd, partitions, filesPerPartition, bootstrap, false);
    }

    public HoodieCommitMetadata doWriteOperation(String commitTime, WriteOperationType operationType, List<String> partitions, int filesPerPartition, boolean bootstrap) throws Exception {
        return this.doWriteOperation(commitTime, operationType, Collections.emptyList(), partitions, filesPerPartition, bootstrap, false);
    }

    public HoodieCommitMetadata doWriteOperation(String commitTime, WriteOperationType operationType, List<String> newPartitionsToAdd, List<String> partitions, int filesPerPartition, boolean bootstrap, boolean createInflightCommit) throws Exception {
        if (partitions.isEmpty()) {
            partitions = Collections.singletonList("");
        }
        Map<String, List<Pair<String, Integer>>> partitionToFilesNameLengthMap = HoodieTestTable.getPartitionFiles(partitions, filesPerPartition);
        return this.doWriteOperation(commitTime, operationType, newPartitionsToAdd, partitionToFilesNameLengthMap, bootstrap, createInflightCommit);
    }

    public HoodieCommitMetadata doWriteOperation(String commitTime, WriteOperationType operationType, List<String> newPartitionsToAdd, Map<String, List<Pair<String, Integer>>> partitionToFilesNameLengthMap, boolean bootstrap, boolean createInflightCommit) throws Exception {
        if (partitionToFilesNameLengthMap.isEmpty()) {
            partitionToFilesNameLengthMap = Collections.singletonMap("", Collections.emptyList());
        }
        HoodieTestTableState testTableState = HoodieTestTable.getTestTableStateWithPartitionFileInfo(operationType, this.metaClient.getTableType(), commitTime, partitionToFilesNameLengthMap);
        HoodieCommitMetadata commitMetadata = this.createCommitMetadata(operationType, commitTime, testTableState, bootstrap);
        for (String string : newPartitionsToAdd) {
            this.withPartitionMetaFiles(string);
        }
        if (createInflightCommit) {
            if (this.metaClient.getTableType() == HoodieTableType.COPY_ON_WRITE) {
                this.addInflightCommit(commitTime);
            } else {
                this.addInflightDeltaCommit(commitTime);
            }
        } else if (this.metaClient.getTableType() == HoodieTableType.COPY_ON_WRITE) {
            this.addCommit(commitTime, (Option<HoodieCommitMetadata>)Option.of((Object)commitMetadata));
        } else {
            this.addDeltaCommit(commitTime, commitMetadata);
        }
        for (Map.Entry entry : partitionToFilesNameLengthMap.entrySet()) {
            String partition = (String)entry.getKey();
            this.withPartitionMetaFiles(partition);
            this.withBaseFilesInPartition(partition, testTableState.getPartitionToBaseFileInfoMap(commitTime).get(partition));
            if (!HoodieTableType.MERGE_ON_READ.equals((Object)this.metaClient.getTableType()) || !WriteOperationType.UPSERT.equals((Object)operationType)) continue;
            this.withLogFilesInPartition(partition, testTableState.getPartitionToLogFileInfoMap(commitTime).get(partition));
        }
        return commitMetadata;
    }

    private Option<HoodieCommitMetadata> getMetadataForInstant(String instantTime) {
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        Option hoodieInstant = this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().filter(i -> i.requestedTime().equals(instantTime)).firstInstant();
        try {
            if (hoodieInstant.isPresent()) {
                return this.getCommitMeta((HoodieInstant)hoodieInstant.get());
            }
            return Option.empty();
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to read metadata for instant " + hoodieInstant.get(), io);
        }
    }

    private Option<HoodieCommitMetadata> getCommitMeta(HoodieInstant hoodieInstant) throws IOException {
        switch (hoodieInstant.getAction()) {
            case "replacecommit": 
            case "clustering": {
                HoodieReplaceCommitMetadata replaceCommitMetadata = (HoodieReplaceCommitMetadata)HoodieReplaceCommitMetadata.fromBytes((byte[])((byte[])this.metaClient.getActiveTimeline().getInstantDetails(hoodieInstant).get()), HoodieReplaceCommitMetadata.class);
                return Option.of((Object)replaceCommitMetadata);
            }
            case "deltacommit": 
            case "commit": {
                HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)this.metaClient.getCommitMetadataSerDe().deserialize(hoodieInstant, (byte[])this.metaClient.getActiveTimeline().getInstantDetails(hoodieInstant).get(), HoodieCommitMetadata.class);
                return Option.of((Object)commitMetadata);
            }
        }
        throw new IllegalArgumentException("Unknown instant action" + hoodieInstant.getAction());
    }

    private static Map<String, List<String>> getPartitionFiles(HoodieCommitMetadata commitMetadata) {
        HashMap<String, List<String>> partitionFilesToDelete = new HashMap<String, List<String>>();
        Map partitionToWriteStats = commitMetadata.getPartitionToWriteStats();
        for (Map.Entry entry : partitionToWriteStats.entrySet()) {
            partitionFilesToDelete.put((String)entry.getKey(), new ArrayList());
            ((List)entry.getValue()).forEach(writeStat -> ((List)partitionFilesToDelete.get(entry.getKey())).add(writeStat.getFileId()));
        }
        return partitionFilesToDelete;
    }

    protected static Map<String, List<Pair<String, Integer>>> getPartitionFiles(List<String> partitions, int filesPerPartition) {
        HashMap<String, List<Pair<String, Integer>>> partitionToFilesNameLengthMap = new HashMap<String, List<Pair<String, Integer>>>();
        for (String partition : partitions) {
            Stream<Integer> fileLengths = IntStream.range(0, filesPerPartition).map(i -> 100 + RANDOM.nextInt(500)).boxed();
            List fileNameAndLengthList = fileLengths.map(len -> Pair.of((Object)UUID.randomUUID().toString(), (Object)len)).collect(Collectors.toList());
            partitionToFilesNameLengthMap.put(partition, fileNameAndLengthList);
        }
        return partitionToFilesNameLengthMap;
    }

    private static HoodieTestTableState getTestTableStateWithPartitionFileInfo(WriteOperationType operationType, HoodieTableType tableType, String commitTime, List<String> partitions, int filesPerPartition) {
        Map<String, List<Pair<String, Integer>>> partitionToFilesNameLengthMap = HoodieTestTable.getPartitionFiles(partitions, filesPerPartition);
        return HoodieTestTable.getTestTableStateWithPartitionFileInfo(operationType, tableType, commitTime, partitionToFilesNameLengthMap);
    }

    private static HoodieTestTableState getTestTableStateWithPartitionFileInfo(WriteOperationType operationType, HoodieTableType tableType, String commitTime, Map<String, List<Pair<String, Integer>>> partitionToFilesNameLengthMap) {
        if (partitionToFilesNameLengthMap.isEmpty()) {
            return testTableState;
        }
        for (Map.Entry<String, List<Pair<String, Integer>>> partitionEntry : partitionToFilesNameLengthMap.entrySet()) {
            String partitionName = partitionEntry.getKey();
            List<Pair<String, Integer>> fileNameAndLengthList = partitionEntry.getValue();
            if (HoodieTableType.MERGE_ON_READ.equals((Object)tableType) && WriteOperationType.UPSERT.equals((Object)operationType)) {
                List<Pair<Integer, Integer>> fileVersionAndLength = fileNameAndLengthList.stream().map(nameLengthPair -> Pair.of((Object)0, (Object)nameLengthPair.getRight())).collect(Collectors.toList());
                testTableState = testTableState.createTestTableStateForBaseAndLogFiles(commitTime, partitionName, fileVersionAndLength);
                continue;
            }
            testTableState = testTableState.createTestTableStateForBaseFilesOnly(commitTime, partitionName, fileNameAndLengthList);
        }
        return testTableState;
    }

    public static List<HoodieWriteStat> generateHoodieWriteStatForPartition(Map<String, List<Pair<String, Integer>>> partitionToFileIdMap, String commitTime, boolean bootstrap) {
        ArrayList<HoodieWriteStat> writeStats = new ArrayList<HoodieWriteStat>();
        if (partitionToFileIdMap == null || partitionToFileIdMap.isEmpty()) {
            return writeStats;
        }
        for (Map.Entry<String, List<Pair<String, Integer>>> entry : partitionToFileIdMap.entrySet()) {
            String partition = entry.getKey();
            for (Pair<String, Integer> fileIdInfo : entry.getValue()) {
                HoodieWriteStat writeStat = new HoodieWriteStat();
                String fileName = bootstrap ? (String)fileIdInfo.getKey() : FileCreateUtils.baseFileName((String)commitTime, (String)((String)fileIdInfo.getKey()));
                writeStat.setFileId(fileName);
                writeStat.setPartitionPath(partition);
                writeStat.setPath(StringUtils.isNullOrEmpty((String)partition) ? fileName : partition + "/" + fileName);
                writeStat.setTotalWriteBytes((long)((Integer)fileIdInfo.getValue()).intValue());
                writeStat.setFileSizeInBytes((long)((Integer)fileIdInfo.getValue()).intValue());
                writeStats.add(writeStat);
            }
        }
        return writeStats;
    }

    private static List<HoodieWriteStat> generateHoodieWriteStatForPartitionLogFiles(Map<String, List<Pair<String, Integer[]>>> partitionToFileIdMap, String commitTime, boolean bootstrap) {
        ArrayList<HoodieWriteStat> writeStats = new ArrayList<HoodieWriteStat>();
        if (partitionToFileIdMap == null) {
            return writeStats;
        }
        for (Map.Entry<String, List<Pair<String, Integer[]>>> entry : partitionToFileIdMap.entrySet()) {
            String partition = entry.getKey();
            for (Pair<String, Integer[]> fileIdInfo : entry.getValue()) {
                HoodieWriteStat writeStat = new HoodieWriteStat();
                String fileName = bootstrap ? (String)fileIdInfo.getKey() : FileCreateUtils.logFileName((String)commitTime, (String)((String)fileIdInfo.getKey()), (int)((Integer[])fileIdInfo.getValue())[0]);
                writeStat.setFileId(fileName);
                writeStat.setPartitionPath(partition);
                writeStat.setPath(StringUtils.isNullOrEmpty((String)partition) ? fileName : partition + "/" + fileName);
                writeStat.setTotalWriteBytes((long)((Integer[])fileIdInfo.getValue())[1].intValue());
                writeStat.setFileSizeInBytes((long)((Integer[])fileIdInfo.getValue())[1].intValue());
                writeStats.add(writeStat);
            }
        }
        return writeStats;
    }

    @Override
    public void close() throws Exception {
    }

    static class HoodieTestTableState {
        Map<String, Map<String, List<String>>> commitsToPartitionToFileIdForCleaner = new HashMap<String, Map<String, List<String>>>();
        Map<String, Map<String, List<Pair<String, Integer>>>> commitsToPartitionToBaseFileInfoStats = new HashMap<String, Map<String, List<Pair<String, Integer>>>>();
        Map<String, Map<String, List<Pair<String, Integer[]>>>> commitsToPartitionToLogFileInfoStats = new HashMap<String, Map<String, List<Pair<String, Integer[]>>>>();

        HoodieTestTableState() {
        }

        static HoodieTestTableState of() {
            return new HoodieTestTableState();
        }

        HoodieTestTableState createTestTableStateForCleaner(String commitTime, String partitionPath, List<String> filesToClean) {
            if (!this.commitsToPartitionToFileIdForCleaner.containsKey(commitTime)) {
                this.commitsToPartitionToFileIdForCleaner.put(commitTime, new HashMap());
            }
            if (!this.commitsToPartitionToFileIdForCleaner.get(commitTime).containsKey(partitionPath)) {
                this.commitsToPartitionToFileIdForCleaner.get(commitTime).put(partitionPath, new ArrayList());
            }
            this.commitsToPartitionToFileIdForCleaner.get(commitTime).get(partitionPath).addAll(filesToClean);
            return this;
        }

        Map<String, List<String>> getPartitionToFileIdMapForCleaner(String commitTime) {
            return this.commitsToPartitionToFileIdForCleaner.get(commitTime);
        }

        HoodieTestTableState createTestTableStateForBaseFileLengthsOnly(String commitTime, String partitionPath, List<Integer> lengths) {
            ArrayList<Pair<String, Integer>> fileNameLengthList = new ArrayList<Pair<String, Integer>>();
            for (int length : lengths) {
                fileNameLengthList.add((Pair<String, Integer>)Pair.of((Object)UUID.randomUUID().toString(), (Object)length));
            }
            return this.createTestTableStateForBaseFilesOnly(commitTime, partitionPath, fileNameLengthList);
        }

        HoodieTestTableState createTestTableStateForBaseFilesOnly(String commitTime, String partitionPath, List<Pair<String, Integer>> fileNameAndLengthList) {
            if (!this.commitsToPartitionToBaseFileInfoStats.containsKey(commitTime)) {
                this.commitsToPartitionToBaseFileInfoStats.put(commitTime, new HashMap());
            }
            if (!this.commitsToPartitionToBaseFileInfoStats.get(commitTime).containsKey(partitionPath)) {
                this.commitsToPartitionToBaseFileInfoStats.get(commitTime).put(partitionPath, new ArrayList());
            }
            this.commitsToPartitionToBaseFileInfoStats.get(commitTime).get(partitionPath).addAll(fileNameAndLengthList);
            return this;
        }

        HoodieTestTableState createTestTableStateForBaseAndLogFiles(String commitTime, String partitionPath, List<Pair<Integer, Integer>> versionsAndLengths) {
            if (!this.commitsToPartitionToBaseFileInfoStats.containsKey(commitTime)) {
                this.createTestTableStateForBaseFileLengthsOnly(commitTime, partitionPath, versionsAndLengths.stream().map(Pair::getRight).collect(Collectors.toList()));
            }
            if (!this.commitsToPartitionToBaseFileInfoStats.get(commitTime).containsKey(partitionPath)) {
                this.createTestTableStateForBaseFileLengthsOnly(commitTime, partitionPath, versionsAndLengths.stream().map(Pair::getRight).collect(Collectors.toList()));
            }
            if (!this.commitsToPartitionToLogFileInfoStats.containsKey(commitTime)) {
                this.commitsToPartitionToLogFileInfoStats.put(commitTime, new HashMap());
            }
            if (!this.commitsToPartitionToLogFileInfoStats.get(commitTime).containsKey(partitionPath)) {
                this.commitsToPartitionToLogFileInfoStats.get(commitTime).put(partitionPath, new ArrayList());
            }
            ArrayList<Pair> fileInfos = new ArrayList<Pair>();
            for (int i = 0; i < versionsAndLengths.size(); ++i) {
                Pair<Integer, Integer> versionAndLength = versionsAndLengths.get(i);
                String fileId = FSUtils.getFileId((String)((String)this.commitsToPartitionToBaseFileInfoStats.get(commitTime).get(partitionPath).get(i).getLeft()));
                fileInfos.add(Pair.of((Object)fileId, (Object)new Integer[]{(Integer)versionAndLength.getLeft(), (Integer)versionAndLength.getRight()}));
            }
            this.commitsToPartitionToLogFileInfoStats.get(commitTime).get(partitionPath).addAll(fileInfos);
            return this;
        }

        Map<String, List<Pair<String, Integer>>> getPartitionToBaseFileInfoMap(String commitTime) {
            return this.commitsToPartitionToBaseFileInfoStats.get(commitTime);
        }

        Map<String, List<Pair<String, Integer[]>>> getPartitionToLogFileInfoMap(String commitTime) {
            return this.commitsToPartitionToLogFileInfoStats.get(commitTime);
        }
    }

    public static class HoodieTestTableException
    extends RuntimeException {
        public HoodieTestTableException(Throwable t) {
            super(t);
        }
    }
}

