/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFileIOUtils
extends HoodieCommonTestHarness {
    @Test
    public void testMkdirAndDelete() throws IOException {
        try {
            FileIOUtils.mkdir((File)this.tempDir.toFile());
        }
        catch (IOException e) {
            Assertions.fail((String)"Should not error out if dir exists already");
        }
        File dir = this.tempDir.resolve("dir").toFile();
        FileIOUtils.mkdir((File)dir);
        Assertions.assertTrue((boolean)dir.exists());
        new File(dir, "t.txt").createNewFile();
        new File(dir, "subdir").mkdirs();
        new File(dir, "subdir" + File.pathSeparator + "z.txt").createNewFile();
        FileIOUtils.deleteDirectory((File)dir);
        Assertions.assertFalse((boolean)dir.exists());
    }

    @Test
    public void testInputStreamReads() throws IOException {
        String msg = "hudi rocks!";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(StringUtils.getUTF8Bytes((String)msg));
        Assertions.assertEquals((Object)msg, (Object)FileIOUtils.readAsUTFString((InputStream)inputStream));
        inputStream = new ByteArrayInputStream(StringUtils.getUTF8Bytes((String)msg));
        Assertions.assertEquals((int)msg.length(), (int)FileIOUtils.readAsByteArray((InputStream)inputStream).length);
    }

    @Test
    public void testReadAsUTFStringLines() {
        String content = "a\nb\nc";
        List expectedLines = Arrays.stream(new String[]{"a", "b", "c"}).collect(Collectors.toList());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(StringUtils.getUTF8Bytes((String)content));
        Assertions.assertEquals(expectedLines, (Object)FileIOUtils.readAsUTFStringLines((InputStream)inputStream));
    }

    @Test
    public void testGetConfiguredLocalDirs() {
        Map<String, String> env = System.getenv();
        Class<?> clazz = env.getClass();
        Map envMaps = null;
        try {
            Field field = clazz.getDeclaredField("m");
            field.setAccessible(true);
            envMaps = (Map)field.get(env);
            envMaps.put("CONTAINER_ID", "xxxxx");
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
        Assertions.assertEquals((Object)String.join((CharSequence)"", FileIOUtils.getConfiguredLocalDirs()), (Object)System.getProperty("java.io.tmpdir"));
        envMaps.put("LOCAL_DIRS", "/xxx");
        Assertions.assertEquals((Object)String.join((CharSequence)"", FileIOUtils.getConfiguredLocalDirs()), envMaps.get("LOCAL_DIRS"));
    }

    @Test
    public void testGetDefaultSpillableMapBasePath() {
        String originalTmpDir = System.getProperty("java.io.tmpdir");
        System.setProperty("java.io.tmpdir", "dir1,dir2,dir3");
        String result = FileIOUtils.getDefaultSpillableMapBasePath();
        Assertions.assertTrue((result.equals("dir1") || result.equals("dir2") || result.equals("dir3") ? 1 : 0) != 0);
        System.clearProperty("java.io.tmpdir");
        result = FileIOUtils.getDefaultSpillableMapBasePath();
        Assertions.assertEquals((Object)"/tmp/", (Object)result);
        if (originalTmpDir != null) {
            System.setProperty("java.io.tmpdir", originalTmpDir);
        } else {
            System.clearProperty("java.io.tmpdir");
        }
    }
}

