/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.io;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.internal.schema.io.FileBasedInternalSchemaStorageManager;
import org.apache.hudi.internal.schema.utils.SerDeHelper;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestFileBasedInternalSchemaStorageManager
extends HoodieCommonTestHarness {
    private HoodieActiveTimeline timeline;

    @BeforeEach
    public void setUp() throws Exception {
        this.initMetaClient();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanMetaClient();
    }

    @Test
    public void testPersistAndReadHistorySchemaStr() throws IOException {
        this.timeline = HoodieTestUtils.TIMELINE_FACTORY.createActiveTimeline(this.metaClient);
        FileBasedInternalSchemaStorageManager fm = new FileBasedInternalSchemaStorageManager(this.metaClient);
        InternalSchema currentSchema = this.getSimpleSchema();
        currentSchema.setSchemaId(0L);
        fm.persistHistorySchemaStr("0000", SerDeHelper.inheritSchemas((InternalSchema)currentSchema, (String)""));
        this.simulateCommit("0000");
        this.metaClient.reloadActiveTimeline();
        InternalSchema readSchema = (InternalSchema)fm.getSchemaByKey("0").get();
        Assertions.assertEquals((Object)currentSchema, (Object)readSchema);
        InternalSchema secondSchema = this.getSimpleSchema();
        secondSchema.setSchemaId(1L);
        fm.persistHistorySchemaStr("0001", SerDeHelper.inheritSchemas((InternalSchema)secondSchema, (String)fm.getHistorySchemaStr()));
        this.simulateCommit("0001");
        this.metaClient.reloadActiveTimeline();
        Assertions.assertEquals((Object)secondSchema, (Object)fm.getSchemaByKey("1").get());
        InternalSchema thirdSchema = this.getSimpleSchema();
        thirdSchema.setSchemaId(2L);
        fm.persistHistorySchemaStr("0002", SerDeHelper.inheritSchemas((InternalSchema)thirdSchema, (String)fm.getHistorySchemaStr()));
        InternalSchema lastSchema = this.getSimpleSchema();
        lastSchema.setSchemaId(3L);
        fm.persistHistorySchemaStr("0004", SerDeHelper.inheritSchemas((InternalSchema)lastSchema, (String)fm.getHistorySchemaStr()));
        this.simulateCommit("0004");
        this.metaClient.reloadActiveTimeline();
        File f = new File(this.metaClient.getSchemaFolderName() + File.separator + "0002.schemacommit");
        Assertions.assertTrue((!f.exists() ? 1 : 0) != 0);
        Assertions.assertEquals((Object)lastSchema, (Object)fm.getSchemaByKey("3").get());
    }

    private void simulateCommit(String commitTime) {
        if (this.timeline == null) {
            this.timeline = HoodieTestUtils.TIMELINE_FACTORY.createActiveTimeline(this.metaClient);
        }
        HoodieInstant instant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "commit", commitTime);
        this.timeline.createNewInstant(instant);
        this.timeline.transitionRequestedToInflight(instant, Option.empty());
        this.timeline.saveAsComplete(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, instant.getAction(), instant.requestedTime()), Option.empty());
    }

    private InternalSchema getSimpleSchema() {
        Types.RecordType record = Types.RecordType.get(Arrays.asList(Types.Field.get((int)0, (String)"bool", (Type)Types.BooleanType.get()), Types.Field.get((int)1, (String)"int", (Type)Types.IntType.get())));
        return new InternalSchema(record);
    }
}

