/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hudi.common.testutils.FileSystemTestUtils;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.io.hadoop.HoodieAvroHFileWriter;
import org.apache.hudi.io.hadoop.HoodieHBaseAvroHFileReader;
import org.apache.hudi.io.hadoop.HoodieHFileUtils;
import org.apache.hudi.io.hadoop.TestHoodieHFileReaderWriterBase;
import org.apache.hudi.io.hadoop.TestHoodieOrcReaderWriter;
import org.apache.hudi.io.hadoop.TestHoodieReaderWriterBase;
import org.apache.hudi.io.hfile.TestHFileReader;
import org.apache.hudi.io.storage.HoodieAvroFileReader;
import org.apache.hudi.io.storage.HoodieAvroHFileReaderImplBase;
import org.apache.hudi.io.storage.TestHoodieReaderWriterUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class TestHoodieHBaseHFileReaderWriter
extends TestHoodieHFileReaderWriterBase {
    @Override
    protected HoodieAvroFileReader createReader(HoodieStorage storage) throws Exception {
        return new HoodieHBaseAvroHFileReader(storage.getConf(), this.getFilePath(), Option.empty());
    }

    @Override
    protected HoodieAvroHFileReaderImplBase createHFileReader(HoodieStorage storage, byte[] content) throws IOException {
        FileSystem fs = HadoopFSUtils.getFs((String)this.getFilePath().toString(), (Configuration)new Configuration());
        return new HoodieHBaseAvroHFileReader(storage.getConf(), new StoragePath("dummy_base_path"), storage, content, Option.empty());
    }

    @Override
    protected void verifyHFileReader(byte[] content, String hfileName, boolean mayUseDefaultComparator, Class<?> expectedComparatorClazz, int count) throws IOException {
        HoodieStorage storage = HoodieTestUtils.getStorage((StoragePath)this.getFilePath());
        try (HFile.Reader reader = HoodieHFileUtils.createHFileReader((HoodieStorage)storage, (StoragePath)new StoragePath("dummy_base_path"), (byte[])content);){
            Assertions.assertEquals((int)3, (int)reader.getTrailer().getMajorVersion());
            if (mayUseDefaultComparator && hfileName.contains("hudi_0_9")) {
                Assertions.assertEquals(CellComparatorImpl.class, reader.getComparator().getClass());
            } else {
                Assertions.assertEquals(expectedComparatorClazz, reader.getComparator().getClass());
            }
            Assertions.assertEquals((long)count, (long)reader.getEntries());
        }
    }

    @Test
    public void testReaderGetRecordIteratorByKeysWithBackwardSeek() throws Exception {
        this.writeFileWithSimpleSchema();
        try (HoodieAvroHFileReaderImplBase hfileReader = (HoodieAvroHFileReaderImplBase)this.createReader(HoodieTestUtils.getStorage((StoragePath)this.getFilePath()));){
            Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieReaderWriterBase.class, (String)"/exampleSchema.avsc");
            List allRecords = CollectionUtils.toStream((Iterator)hfileReader.getRecordIterator()).map(r -> (GenericRecord)r.getData()).collect(Collectors.toList());
            List expectedKey1s = allRecords.stream().filter(entry -> entry.get("_row_key").toString().contains("key05") || entry.get("_row_key").toString().contains("key24") || entry.get("_row_key").toString().contains("key31")).collect(Collectors.toList());
            ClosableIterator iterator = hfileReader.getIndexedRecordsByKeysIterator(Arrays.asList("key00001", "key05", "key24", "key16", "key31", "key61"), avroSchema);
            List recordsByKeys = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(r -> (GenericRecord)r).collect(Collectors.toList());
            Assertions.assertEquals(expectedKey1s, recordsByKeys);
        }
    }

    @Disabled(value="This is used for generating testing HFile only")
    @ParameterizedTest
    @CsvSource(value={"512,GZ,20000,true", "16,GZ,20000,true", "64,NONE,5000,true", "16,NONE,5000,true", "16,GZ,200,false"})
    void generateHFileForTesting(int blockSizeKB, String compressionCodec, int numEntries, boolean uniqueKeys) throws IOException {
        TestHoodieReaderWriterUtils.writeHFileForTesting((String)String.format("/tmp/hudi_1_0_hbase_2_4_9_%sKB_%s_%s.hfile", blockSizeKB, compressionCodec, numEntries), (int)(blockSizeKB * 1024), (Compression.Algorithm)Compression.Algorithm.valueOf((String)compressionCodec), (int)numEntries, (Function)TestHFileReader.KEY_CREATOR, (Function)TestHFileReader.VALUE_CREATOR, (boolean)uniqueKeys);
    }

    @Test
    public void testHFileReaderWriterWithDuplicates() throws Exception {
        Object key;
        Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieOrcReaderWriter.class, (String)"/exampleSchema.avsc");
        HoodieAvroHFileWriter writer = this.createWriter(avroSchema, false);
        ArrayList<String> keys = new ArrayList<String>();
        TreeMap recordMap = new TreeMap();
        for (int i = 0; i < 50; ++i) {
            Object object = key = i != 0 && i % 10 == 0 ? String.format("%s%04d", "key", i - 1) : String.format("%s%04d", "key", i);
            if (!recordMap.containsKey(key)) {
                recordMap.put(key, new ArrayList());
            }
            GenericData.Record record = new GenericData.Record(avroSchema);
            record.put("_row_key", key);
            record.put("time", (Object)Integer.toString(FileSystemTestUtils.RANDOM.nextInt()));
            record.put("number", (Object)i);
            writer.writeAvro((String)key, (IndexedRecord)record);
            ((List)recordMap.get(key)).add(record);
            keys.add((String)key);
        }
        writer.close();
        HoodieAvroHFileReaderImplBase hFileReader = (HoodieAvroHFileReaderImplBase)this.createReader(HoodieTestUtils.getStorage((StoragePath)this.getFilePath()));
        key = null;
        try {
            List records = HoodieAvroHFileReaderImplBase.readAllRecords((HoodieAvroFileReader)hFileReader);
            Assertions.assertEquals(recordMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()), (Object)records);
        }
        catch (Throwable records) {
            key = records;
            throw records;
        }
        finally {
            if (hFileReader != null) {
                if (key != null) {
                    try {
                        hFileReader.close();
                    }
                    catch (Throwable records) {
                        ((Throwable)key).addSuppressed(records);
                    }
                } else {
                    hFileReader.close();
                }
            }
        }
        for (int i = 0; i < 2; ++i) {
            int randomRowstoFetch = 5 + FileSystemTestUtils.RANDOM.nextInt(10);
            Set<String> rowsToFetch = this.getRandomKeys(randomRowstoFetch, keys);
            ArrayList<String> rowsList = new ArrayList<String>(rowsToFetch);
            Collections.sort(rowsList);
            List expectedRecords = rowsList.stream().flatMap(row -> ((List)recordMap.get(row)).stream()).collect(Collectors.toList());
            try (HoodieAvroHFileReaderImplBase hFileReader2 = (HoodieAvroHFileReaderImplBase)this.createReader(HoodieTestUtils.getStorage((StoragePath)this.getFilePath()));){
                List result = HoodieAvroHFileReaderImplBase.readRecords((HoodieAvroHFileReaderImplBase)hFileReader2, rowsList).stream().map(r -> (GenericRecord)r).collect(Collectors.toList());
                Assertions.assertEquals(expectedRecords, result);
                continue;
            }
        }
    }
}

