/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.metadata.FileSystemBackedTableMetadata;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestFileSystemBackedTableMetadata
extends HoodieCommonTestHarness {
    private static final String DEFAULT_PARTITION = "";
    private static final List<String> DATE_PARTITIONS = Arrays.asList("2019/01/01", "2020/01/02", "2021/03/01");
    private static final List<String> ONE_LEVEL_PARTITIONS = Arrays.asList("2019", "2020", "2021");
    private static final List<String> MULTI_LEVEL_PARTITIONS = Arrays.asList("2019/01", "2020/01", "2021/01");
    private static HoodieTestTable hoodieTestTable;

    @BeforeEach
    public void setUp() throws IOException {
        this.initMetaClient();
        hoodieTestTable = HoodieTestTable.of(this.metaClient);
    }

    @AfterEach
    public void tearDown() throws IOException {
        this.metaClient.getStorage().deleteDirectory(this.metaClient.getBasePath());
        this.cleanMetaClient();
    }

    @Test
    public void testNonPartitionedTable() throws Exception {
        hoodieTestTable.addCommit("100").withBaseFilesInPartition(DEFAULT_PARTITION, IntStream.range(0, 10).toArray());
        HoodieLocalEngineContext localEngineContext = new HoodieLocalEngineContext(this.metaClient.getStorageConf());
        FileSystemBackedTableMetadata fileSystemBackedTableMetadata = new FileSystemBackedTableMetadata((HoodieEngineContext)localEngineContext, this.metaClient.getTableConfig(), this.metaClient.getStorage(), this.basePath);
        Assertions.assertEquals((int)0, (int)fileSystemBackedTableMetadata.getAllPartitionPaths().size());
        Assertions.assertEquals((int)10, (int)fileSystemBackedTableMetadata.getAllFilesInPartition(new StoragePath(this.basePath)).size());
        Assertions.assertEquals((int)10, (int)((List)fileSystemBackedTableMetadata.getAllFilesInPartitions(Collections.singletonList(this.basePath)).get(this.basePath)).size());
    }

    @Test
    public void testDatePartitionedTableWithAssumeDateIsFalse() throws Exception {
        String instant = "100";
        hoodieTestTable = hoodieTestTable.addCommit(instant);
        DATE_PARTITIONS.stream().forEach(p -> {
            try {
                hoodieTestTable = hoodieTestTable.withPartitionMetaFiles((String)p).withBaseFilesInPartition((String)p, IntStream.range(0, 10).toArray());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        HoodieLocalEngineContext localEngineContext = new HoodieLocalEngineContext(this.metaClient.getStorageConf());
        FileSystemBackedTableMetadata fileSystemBackedTableMetadata = new FileSystemBackedTableMetadata((HoodieEngineContext)localEngineContext, this.metaClient.getTableConfig(), this.metaClient.getStorage(), this.basePath);
        Assertions.assertEquals((int)3, (int)fileSystemBackedTableMetadata.getAllPartitionPaths().size());
        List fullPartitionPaths = DATE_PARTITIONS.stream().map(p -> this.basePath + "/" + p).collect(Collectors.toList());
        Map partitionToFilesMap = fileSystemBackedTableMetadata.getAllFilesInPartitions(fullPartitionPaths);
        for (String p2 : fullPartitionPaths) {
            Assertions.assertEquals((int)10, (int)((List)partitionToFilesMap.get(p2)).size());
        }
    }

    @Test
    public void testOneLevelPartitionedTable() throws Exception {
        String instant = "100";
        hoodieTestTable = hoodieTestTable.addCommit(instant);
        ONE_LEVEL_PARTITIONS.stream().forEach(p -> {
            try {
                hoodieTestTable = hoodieTestTable.withPartitionMetaFiles((String)p).withBaseFilesInPartition((String)p, IntStream.range(0, 10).toArray());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        HoodieLocalEngineContext localEngineContext = new HoodieLocalEngineContext(this.metaClient.getStorageConf());
        FileSystemBackedTableMetadata fileSystemBackedTableMetadata = new FileSystemBackedTableMetadata((HoodieEngineContext)localEngineContext, this.metaClient.getTableConfig(), this.metaClient.getStorage(), this.basePath);
        Assertions.assertEquals((int)3, (int)fileSystemBackedTableMetadata.getAllPartitionPaths().size());
        Assertions.assertEquals((int)10, (int)fileSystemBackedTableMetadata.getAllFilesInPartition(new StoragePath(this.basePath + "/" + ONE_LEVEL_PARTITIONS.get(0))).size());
        List fullPartitionPaths = ONE_LEVEL_PARTITIONS.stream().map(p -> this.basePath + "/" + p).collect(Collectors.toList());
        Map partitionToFilesMap = fileSystemBackedTableMetadata.getAllFilesInPartitions(fullPartitionPaths);
        for (String p2 : fullPartitionPaths) {
            Assertions.assertEquals((int)10, (int)((List)partitionToFilesMap.get(p2)).size());
        }
    }

    @Test
    public void testMultiLevelPartitionedTable() throws Exception {
        String instant = "100";
        hoodieTestTable = hoodieTestTable.addCommit(instant);
        MULTI_LEVEL_PARTITIONS.stream().forEach(p -> {
            try {
                hoodieTestTable = hoodieTestTable.withPartitionMetaFiles((String)p).withBaseFilesInPartition((String)p, IntStream.range(0, 10).toArray());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        HoodieLocalEngineContext localEngineContext = new HoodieLocalEngineContext(this.metaClient.getStorageConf());
        FileSystemBackedTableMetadata fileSystemBackedTableMetadata = new FileSystemBackedTableMetadata((HoodieEngineContext)localEngineContext, this.metaClient.getTableConfig(), this.metaClient.getStorage(), this.basePath);
        Assertions.assertEquals((int)3, (int)fileSystemBackedTableMetadata.getAllPartitionPaths().size());
        Assertions.assertEquals((int)10, (int)fileSystemBackedTableMetadata.getAllFilesInPartition(new StoragePath(this.basePath + "/" + MULTI_LEVEL_PARTITIONS.get(0))).size());
        List fullPartitionPaths = MULTI_LEVEL_PARTITIONS.stream().map(p -> this.basePath + "/" + p).collect(Collectors.toList());
        Map partitionToFilesMap = fileSystemBackedTableMetadata.getAllFilesInPartitions(fullPartitionPaths);
        for (String p2 : fullPartitionPaths) {
            Assertions.assertEquals((int)10, (int)((List)partitionToFilesMap.get(p2)).size());
        }
    }

    @Test
    public void testMultiLevelEmptyPartitionTable() throws Exception {
        String instant = "100";
        hoodieTestTable = hoodieTestTable.addCommit(instant);
        MULTI_LEVEL_PARTITIONS.stream().forEach(p -> {
            try {
                hoodieTestTable = hoodieTestTable.withPartitionMetaFiles((String)p);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        HoodieLocalEngineContext localEngineContext = new HoodieLocalEngineContext(this.metaClient.getStorageConf());
        FileSystemBackedTableMetadata fileSystemBackedTableMetadata = new FileSystemBackedTableMetadata((HoodieEngineContext)localEngineContext, this.metaClient.getTableConfig(), this.metaClient.getStorage(), this.basePath);
        Assertions.assertEquals((int)3, (int)fileSystemBackedTableMetadata.getAllPartitionPaths().size());
        Assertions.assertEquals((int)0, (int)fileSystemBackedTableMetadata.getAllFilesInPartition(new StoragePath(this.basePath + "/" + MULTI_LEVEL_PARTITIONS.get(0))).size());
        List fullPartitionPaths = MULTI_LEVEL_PARTITIONS.stream().map(p -> this.basePath + "/" + p).collect(Collectors.toList());
        Map partitionToFilesMap = fileSystemBackedTableMetadata.getAllFilesInPartitions(fullPartitionPaths);
        for (String p2 : fullPartitionPaths) {
            Assertions.assertEquals((int)0, (int)((List)partitionToFilesMap.get(p2)).size());
        }
    }
}

