/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.model.HoodieColumnRangeMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.metadata.SecondaryIndexKeyUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieMetadataPayload
extends HoodieCommonTestHarness {
    public static final String PARTITION_NAME = "2022/10/01";
    public static final String PARTITION_NAME2 = "2023/10/01";
    public static final String PARTITION_NAME3 = "2024/10/01";

    @Test
    public void testFileSystemMetadataPayloadMerging() {
        Map firstCommitAddedFiles = CollectionUtils.createImmutableMap((Pair[])new Pair[]{Pair.of((Object)"file1.parquet", (Object)1000L), Pair.of((Object)"file2.parquet", (Object)2000L), Pair.of((Object)"file3.parquet", (Object)3000L)});
        HoodieRecord firstPartitionFilesRecord = HoodieMetadataPayload.createPartitionFilesRecord((String)PARTITION_NAME, (Map)firstCommitAddedFiles, Collections.emptyList());
        Map secondCommitAddedFiles = CollectionUtils.createImmutableMap((Pair[])new Pair[]{Pair.of((Object)"file3.parquet", (Object)3333L), Pair.of((Object)"file4.parquet", (Object)4000L), Pair.of((Object)"file5.parquet", (Object)5000L)});
        List<String> secondCommitDeletedFiles = Collections.singletonList("file1.parquet");
        HoodieRecord secondPartitionFilesRecord = HoodieMetadataPayload.createPartitionFilesRecord((String)PARTITION_NAME, (Map)secondCommitAddedFiles, secondCommitDeletedFiles);
        HoodieMetadataPayload combinedPartitionFilesRecordPayload = ((HoodieMetadataPayload)secondPartitionFilesRecord.getData()).preCombine((HoodieMetadataPayload)firstPartitionFilesRecord.getData());
        HoodieMetadataPayload expectedCombinedPartitionedFilesRecordPayload = (HoodieMetadataPayload)HoodieMetadataPayload.createPartitionFilesRecord((String)PARTITION_NAME, (Map)CollectionUtils.createImmutableMap((Pair[])new Pair[]{Pair.of((Object)"file2.parquet", (Object)2000L), Pair.of((Object)"file3.parquet", (Object)3333L), Pair.of((Object)"file4.parquet", (Object)4000L), Pair.of((Object)"file5.parquet", (Object)5000L)}), Collections.emptyList()).getData();
        Assertions.assertEquals((Object)expectedCombinedPartitionedFilesRecordPayload, (Object)combinedPartitionFilesRecordPayload);
    }

    @Test
    public void testFileSystemMetadataPayloadMergingWithDeletions() {
        Map addedFileMap = CollectionUtils.createImmutableMap((Pair[])new Pair[]{Pair.of((Object)"file1.parquet", (Object)1000L), Pair.of((Object)"file2.parquet", (Object)2000L), Pair.of((Object)"file3.parquet", (Object)3000L), Pair.of((Object)"file4.parquet", (Object)4000L)});
        HoodieRecord additionRecord = HoodieMetadataPayload.createPartitionFilesRecord((String)PARTITION_NAME, (Map)addedFileMap, Collections.emptyList());
        ArrayList<String> deletedFileList1 = new ArrayList<String>();
        deletedFileList1.add("file1.parquet");
        deletedFileList1.add("file3.parquet");
        HoodieRecord deletionRecord1 = HoodieMetadataPayload.createPartitionFilesRecord((String)PARTITION_NAME, Collections.emptyMap(), deletedFileList1);
        ArrayList<String> deletedFileList2 = new ArrayList<String>();
        deletedFileList2.add("file1.parquet");
        deletedFileList2.add("file4.parquet");
        HoodieRecord deletionRecord2 = HoodieMetadataPayload.createPartitionFilesRecord((String)PARTITION_NAME, Collections.emptyMap(), deletedFileList2);
        Assertions.assertEquals((Object)HoodieMetadataPayload.createPartitionFilesRecord((String)PARTITION_NAME, (Map)CollectionUtils.createImmutableMap((Pair[])new Pair[]{Pair.of((Object)"file2.parquet", (Object)2000L), Pair.of((Object)"file4.parquet", (Object)4000L)}), Collections.emptyList()).getData(), (Object)((HoodieMetadataPayload)deletionRecord1.getData()).preCombine((HoodieMetadataPayload)additionRecord.getData()));
        ArrayList<String> expectedDeleteFileList = new ArrayList<String>();
        expectedDeleteFileList.add("file1.parquet");
        expectedDeleteFileList.add("file3.parquet");
        expectedDeleteFileList.add("file4.parquet");
        Assertions.assertEquals((Object)HoodieMetadataPayload.createPartitionFilesRecord((String)PARTITION_NAME, Collections.emptyMap(), expectedDeleteFileList).getData(), (Object)((HoodieMetadataPayload)deletionRecord2.getData()).preCombine((HoodieMetadataPayload)deletionRecord1.getData()));
        Assertions.assertEquals((Object)HoodieMetadataPayload.createPartitionFilesRecord((String)PARTITION_NAME, (Map)CollectionUtils.createImmutableMap((Pair[])new Pair[]{Pair.of((Object)"file2.parquet", (Object)2000L)}), Collections.emptyList()).getData(), (Object)((HoodieMetadataPayload)deletionRecord2.getData()).preCombine((HoodieMetadataPayload)deletionRecord1.getData()).preCombine((HoodieMetadataPayload)additionRecord.getData()));
        Assertions.assertEquals((Object)HoodieMetadataPayload.createPartitionFilesRecord((String)PARTITION_NAME, (Map)CollectionUtils.createImmutableMap((Pair[])new Pair[]{Pair.of((Object)"file2.parquet", (Object)2000L)}), Collections.singletonList("file1.parquet")).getData(), (Object)((HoodieMetadataPayload)deletionRecord2.getData()).preCombine(((HoodieMetadataPayload)deletionRecord1.getData()).preCombine((HoodieMetadataPayload)additionRecord.getData())));
        ArrayList<String> allDeletedFileList = new ArrayList<String>();
        allDeletedFileList.add("file1.parquet");
        allDeletedFileList.add("file2.parquet");
        allDeletedFileList.add("file3.parquet");
        allDeletedFileList.add("file4.parquet");
        HoodieRecord allDeletionRecord = HoodieMetadataPayload.createPartitionFilesRecord((String)PARTITION_NAME, Collections.emptyMap(), allDeletedFileList);
        HoodieMetadataPayload combinedPayload = ((HoodieMetadataPayload)allDeletionRecord.getData()).preCombine((HoodieMetadataPayload)additionRecord.getData());
        Assertions.assertEquals((Object)HoodieMetadataPayload.createPartitionFilesRecord((String)PARTITION_NAME, Collections.emptyMap(), Collections.emptyList()).getData(), (Object)combinedPayload);
        Assertions.assertTrue((boolean)combinedPayload.filesystemMetadata.isEmpty());
        HoodieRecord allPartitionsRecord = HoodieMetadataPayload.createPartitionListRecord(Arrays.asList(PARTITION_NAME, PARTITION_NAME2, PARTITION_NAME3), (boolean)false);
        HoodieRecord partitionDeletedRecord = HoodieMetadataPayload.createPartitionListRecord(Collections.singletonList(PARTITION_NAME), (boolean)true);
        HoodieMetadataPayload payload = ((HoodieMetadataPayload)partitionDeletedRecord.getData()).preCombine((HoodieMetadataPayload)allPartitionsRecord.getData());
        Assertions.assertEquals((Object)HoodieMetadataPayload.createPartitionListRecord(Arrays.asList(PARTITION_NAME2, PARTITION_NAME3), (boolean)false).getData(), (Object)payload);
    }

    @Test
    public void testColumnStatsPayloadMerging() throws IOException {
        String fileName = "file.parquet";
        String targetColName = "c1";
        HoodieColumnRangeMetadata c1Metadata = HoodieColumnRangeMetadata.create((String)fileName, (String)targetColName, (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(1000), (long)5L, (long)1000L, (long)123456L, (long)123456L);
        HoodieRecord columnStatsRecord = (HoodieRecord)HoodieMetadataPayload.createColumnStatsRecords((String)PARTITION_NAME, Collections.singletonList(c1Metadata), (boolean)false).findFirst().get();
        HoodieColumnRangeMetadata c1AppendedBlockMetadata = HoodieColumnRangeMetadata.create((String)fileName, (String)targetColName, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(500), (long)0L, (long)100L, (long)12345L, (long)12345L);
        HoodieRecord updatedColumnStatsRecord = (HoodieRecord)HoodieMetadataPayload.createColumnStatsRecords((String)PARTITION_NAME, Collections.singletonList(c1AppendedBlockMetadata), (boolean)false).findFirst().get();
        HoodieMetadataPayload combinedMetadataPayload = ((HoodieMetadataPayload)columnStatsRecord.getData()).preCombine((HoodieMetadataPayload)updatedColumnStatsRecord.getData());
        HoodieColumnRangeMetadata expectedColumnRangeMetadata = HoodieColumnRangeMetadata.create((String)fileName, (String)targetColName, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1000), (long)5L, (long)1100L, (long)135801L, (long)135801L);
        HoodieRecord expectedColumnStatsRecord = (HoodieRecord)HoodieMetadataPayload.createColumnStatsRecords((String)PARTITION_NAME, Collections.singletonList(expectedColumnRangeMetadata), (boolean)false).findFirst().get();
        Assertions.assertEquals((Object)combinedMetadataPayload, (Object)expectedColumnStatsRecord.getData());
        Option alternativelyCombinedMetadataPayloadAvro = ((HoodieMetadataPayload)columnStatsRecord.getData()).combineAndGetUpdateValue((IndexedRecord)((HoodieMetadataPayload)updatedColumnStatsRecord.getData()).getInsertValue(null).get(), null);
        Assertions.assertEquals((Object)combinedMetadataPayload.getInsertValue(null), (Object)alternativelyCombinedMetadataPayloadAvro);
        HoodieColumnRangeMetadata c1StubbedMetadata = HoodieColumnRangeMetadata.stub((String)fileName, (String)targetColName);
        HoodieRecord deletedColumnStatsRecord = (HoodieRecord)HoodieMetadataPayload.createColumnStatsRecords((String)PARTITION_NAME, Collections.singletonList(c1StubbedMetadata), (boolean)true).findFirst().get();
        HoodieMetadataPayload deletedCombinedMetadataPayload = ((HoodieMetadataPayload)deletedColumnStatsRecord.getData()).preCombine((HoodieMetadataPayload)columnStatsRecord.getData());
        Assertions.assertEquals((Object)deletedColumnStatsRecord.getData(), (Object)deletedCombinedMetadataPayload);
        Assertions.assertFalse((boolean)deletedCombinedMetadataPayload.getInsertValue(null).isPresent());
        Assertions.assertTrue((boolean)deletedCombinedMetadataPayload.isDeleted());
        HoodieMetadataPayload overwrittenCombinedMetadataPayload = ((HoodieMetadataPayload)columnStatsRecord.getData()).preCombine((HoodieMetadataPayload)deletedColumnStatsRecord.getData());
        Assertions.assertEquals((Object)columnStatsRecord.getData(), (Object)overwrittenCombinedMetadataPayload);
    }

    @Test
    public void testPartitionStatsPayloadMerging() {
        HoodieColumnRangeMetadata fileColumnRange1 = HoodieColumnRangeMetadata.create((String)"path/to/file", (String)"columnName", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5), (long)0L, (long)10L, (long)100L, (long)200L);
        HoodieRecord firstPartitionStatsRecord = (HoodieRecord)HoodieMetadataPayload.createPartitionStatsRecords((String)PARTITION_NAME, Collections.singletonList(fileColumnRange1), (boolean)false, (boolean)false, (Option)Option.empty()).findFirst().get();
        HoodieColumnRangeMetadata fileColumnRange2 = HoodieColumnRangeMetadata.create((String)"path/to/file", (String)"columnName", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(8), (long)1L, (long)15L, (long)120L, (long)250L);
        HoodieRecord updatedPartitionStatsRecord = (HoodieRecord)HoodieMetadataPayload.createPartitionStatsRecords((String)PARTITION_NAME, Collections.singletonList(fileColumnRange2), (boolean)false, (boolean)false, (Option)Option.empty()).findFirst().get();
        HoodieMetadataPayload combinedPartitionStatsRecordPayload = ((HoodieMetadataPayload)updatedPartitionStatsRecord.getData()).preCombine((HoodieMetadataPayload)firstPartitionStatsRecord.getData());
        HoodieColumnRangeMetadata expectedColumnRange = HoodieColumnRangeMetadata.create((String)"path/to/file", (String)"columnName", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(8), (long)1L, (long)25L, (long)220L, (long)450L);
        HoodieMetadataPayload expectedColumnRangeMetadata = (HoodieMetadataPayload)((HoodieRecord)HoodieMetadataPayload.createPartitionStatsRecords((String)PARTITION_NAME, Collections.singletonList(expectedColumnRange), (boolean)false, (boolean)false, (Option)Option.empty()).findFirst().get()).getData();
        Assertions.assertEquals((Object)expectedColumnRangeMetadata, (Object)combinedPartitionStatsRecordPayload);
    }

    @Test
    public void testPartitionStatsPayloadMergingWithDelete() {
        HoodieColumnRangeMetadata fileColumnRange1 = HoodieColumnRangeMetadata.create((String)"path/to/file", (String)"columnName", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5), (long)0L, (long)10L, (long)100L, (long)200L);
        HoodieRecord firstPartitionStatsRecord = (HoodieRecord)HoodieMetadataPayload.createPartitionStatsRecords((String)PARTITION_NAME, Collections.singletonList(fileColumnRange1), (boolean)false, (boolean)false, (Option)Option.empty()).findFirst().get();
        HoodieColumnRangeMetadata fileColumnRange2 = HoodieColumnRangeMetadata.create((String)"path/to/file", (String)"columnName", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(8), (long)1L, (long)15L, (long)120L, (long)250L);
        HoodieRecord deletedPartitionStatsRecord = (HoodieRecord)HoodieMetadataPayload.createPartitionStatsRecords((String)PARTITION_NAME, Collections.singletonList(fileColumnRange2), (boolean)true, (boolean)false, (Option)Option.empty()).findFirst().get();
        HoodieMetadataPayload combinedPartitionStatsRecordPayload = ((HoodieMetadataPayload)deletedPartitionStatsRecord.getData()).preCombine((HoodieMetadataPayload)firstPartitionStatsRecord.getData());
        HoodieColumnRangeMetadata expectedColumnRange = HoodieColumnRangeMetadata.create((String)"path/to/file", (String)"columnName", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(8), (long)1L, (long)15L, (long)120L, (long)250L);
        HoodieMetadataPayload expectedColumnRangeMetadata = (HoodieMetadataPayload)((HoodieRecord)HoodieMetadataPayload.createPartitionStatsRecords((String)PARTITION_NAME, Collections.singletonList(expectedColumnRange), (boolean)true, (boolean)false, (Option)Option.empty()).findFirst().get()).getData();
        Assertions.assertEquals((Object)expectedColumnRangeMetadata, (Object)combinedPartitionStatsRecordPayload);
        HoodieMetadataPayload overwrittenCombinedPartitionStatsRecordPayload = ((HoodieMetadataPayload)firstPartitionStatsRecord.getData()).preCombine((HoodieMetadataPayload)deletedPartitionStatsRecord.getData());
        Assertions.assertEquals((Object)firstPartitionStatsRecord.getData(), (Object)overwrittenCombinedPartitionStatsRecordPayload);
    }

    @Test
    public void testSecondaryIndexPayloadMerging() {
        String secondaryIndexPartition = MetadataPartitionType.SECONDARY_INDEX.getPartitionPath() + "secondaryCol";
        String recordKey = "rk1";
        String initialSecondaryKey = "sk1";
        String updatedSecondaryKey = "sk2";
        String expectedPayloadKey = initialSecondaryKey + "$" + recordKey;
        HoodieRecord oldSecondaryIndexRecord = HoodieMetadataPayload.createSecondaryIndexRecord((String)recordKey, (String)initialSecondaryKey, (String)secondaryIndexPartition, (Boolean)false);
        Assertions.assertEquals((Object)expectedPayloadKey, (Object)oldSecondaryIndexRecord.getRecordKey());
        HoodieRecord oldSecondaryIndexRecordDeleted = HoodieMetadataPayload.createSecondaryIndexRecord((String)recordKey, (String)initialSecondaryKey, (String)secondaryIndexPartition, (Boolean)true);
        Option combinedSecondaryIndexRecord = HoodieMetadataPayload.combineSecondaryIndexRecord((HoodieRecord)oldSecondaryIndexRecord, (HoodieRecord)oldSecondaryIndexRecordDeleted);
        Assertions.assertFalse((boolean)combinedSecondaryIndexRecord.isPresent());
        HoodieRecord newSecondaryIndexRecord = HoodieMetadataPayload.createSecondaryIndexRecord((String)recordKey, (String)updatedSecondaryKey, (String)secondaryIndexPartition, (Boolean)false);
        expectedPayloadKey = updatedSecondaryKey + "$" + recordKey;
        Assertions.assertEquals((Object)expectedPayloadKey, (Object)newSecondaryIndexRecord.getRecordKey());
        combinedSecondaryIndexRecord = HoodieMetadataPayload.combineSecondaryIndexRecord((HoodieRecord)oldSecondaryIndexRecord, (HoodieRecord)newSecondaryIndexRecord);
        Assertions.assertTrue((boolean)combinedSecondaryIndexRecord.isPresent());
        Assertions.assertEquals((Object)newSecondaryIndexRecord.getData(), (Object)((HoodieRecord)combinedSecondaryIndexRecord.get()).getData());
    }

    @Test
    public void testConstructSecondaryIndexKey() {
        String secondaryKey = "part1";
        String recordKey = "key1";
        String constructedKey = SecondaryIndexKeyUtils.constructSecondaryIndexKey((String)secondaryKey, (String)recordKey);
        Assertions.assertEquals((Object)"part1$key1", (Object)constructedKey);
        Assertions.assertEquals((Object)secondaryKey, (Object)SecondaryIndexKeyUtils.getSecondaryKeyFromSecondaryIndexKey((String)constructedKey));
        Assertions.assertEquals((Object)recordKey, (Object)SecondaryIndexKeyUtils.getRecordKeyFromSecondaryIndexKey((String)constructedKey));
        secondaryKey = "part\\one";
        recordKey = "key$two";
        constructedKey = SecondaryIndexKeyUtils.constructSecondaryIndexKey((String)secondaryKey, (String)recordKey);
        Assertions.assertEquals((Object)"part\\\\one$key\\$two", (Object)constructedKey);
        Assertions.assertEquals((Object)secondaryKey, (Object)SecondaryIndexKeyUtils.getSecondaryKeyFromSecondaryIndexKey((String)constructedKey));
        Assertions.assertEquals((Object)recordKey, (Object)SecondaryIndexKeyUtils.getRecordKeyFromSecondaryIndexKey((String)constructedKey));
        secondaryKey = "comp\\lex$sec";
        recordKey = "prim\\ary$k\\ey";
        constructedKey = SecondaryIndexKeyUtils.constructSecondaryIndexKey((String)secondaryKey, (String)recordKey);
        Assertions.assertEquals((Object)"comp\\\\lex\\$sec$prim\\\\ary\\$k\\\\ey", (Object)constructedKey);
        String extractedSecondaryKey = SecondaryIndexKeyUtils.getSecondaryKeyFromSecondaryIndexKey((String)constructedKey);
        String extractedPrimaryKey = SecondaryIndexKeyUtils.getRecordKeyFromSecondaryIndexKey((String)constructedKey);
        Assertions.assertEquals((Object)secondaryKey, (Object)extractedSecondaryKey);
        Assertions.assertEquals((Object)recordKey, (Object)extractedPrimaryKey);
        String key = "secondaryOnly$";
        recordKey = SecondaryIndexKeyUtils.getRecordKeyFromSecondaryIndexKey((String)key);
        Assertions.assertEquals((Object)"", (Object)recordKey);
        key = "$primaryOnly";
        secondaryKey = SecondaryIndexKeyUtils.getSecondaryKeyFromSecondaryIndexKey((String)key);
        Assertions.assertEquals((Object)"", (Object)secondaryKey);
        Assertions.assertThrows(IllegalStateException.class, () -> SecondaryIndexKeyUtils.getSecondaryKeyFromSecondaryIndexKey((String)""));
        Assertions.assertThrows(IllegalStateException.class, () -> SecondaryIndexKeyUtils.getRecordKeyFromSecondaryIndexKey((String)""));
        Assertions.assertThrows(IllegalStateException.class, () -> SecondaryIndexKeyUtils.getSecondaryKeyFromSecondaryIndexKey((String)"invalidKey"));
        Assertions.assertThrows(IllegalStateException.class, () -> SecondaryIndexKeyUtils.getRecordKeyFromSecondaryIndexKey((String)"invalidKey"));
        Assertions.assertThrows(IllegalStateException.class, () -> SecondaryIndexKeyUtils.getSecondaryKeyFromSecondaryIndexKey((String)"part\\one"));
        Assertions.assertThrows(IllegalStateException.class, () -> SecondaryIndexKeyUtils.getRecordKeyFromSecondaryIndexKey((String)"part\\one"));
    }
}

