/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.fs.inline;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hadoop.fs.inline.InLineFileSystem;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.inline.InLineFSUtils;

public class HadoopInLineFSUtils
extends InLineFSUtils {
    public static StorageConfiguration<Configuration> buildInlineConf(StorageConfiguration<Configuration> storageConf) {
        StorageConfiguration inlineConf = storageConf.newInstance();
        inlineConf.set("fs.inlinefs.impl", InLineFileSystem.class.getName());
        ((Configuration)inlineConf.unwrapAs(Configuration.class)).setClassLoader(InLineFileSystem.class.getClassLoader());
        return inlineConf;
    }

    public static Path getOuterFilePathFromInlinePath(Path inlineFSPath) {
        StoragePath storagePath = HadoopFSUtils.convertToStoragePath(inlineFSPath);
        StoragePath outerFilePath = HadoopInLineFSUtils.getOuterFilePathFromInlinePath((StoragePath)storagePath);
        return HadoopFSUtils.convertToHadoopPath(outerFilePath);
    }
}

