/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.inline.InLineFSUtils;

public class FileSystemTestUtils {
    public static final String TEMP = "tmp";
    public static final String FORWARD_SLASH = "/";
    public static final String FILE_SCHEME = "file";
    public static final String COLON = ":";
    public static final Random RANDOM = new Random();

    public static Path getRandomOuterInMemPath() {
        String randomFileName = UUID.randomUUID().toString();
        String fileSuffix = ":/tmp/" + randomFileName;
        return new Path("inmemfs" + fileSuffix);
    }

    public static StoragePath getRandomOuterFSPath() {
        String randomFileName = UUID.randomUUID().toString();
        String fileSuffix = ":/tmp/" + randomFileName;
        return new StoragePath(FILE_SCHEME + fileSuffix);
    }

    public static StoragePath getPhantomFile(StoragePath outerPath, long startOffset, long inlineLength) {
        return InLineFSUtils.getInlineFilePath((StoragePath)outerPath, (String)FILE_SCHEME, (long)startOffset, (long)inlineLength);
    }

    public static void deleteFile(File fileToDelete) throws IOException {
        if (!fileToDelete.exists()) {
            return;
        }
        if (!fileToDelete.delete()) {
            String message = "Unable to delete file " + fileToDelete + ".";
            throw new IOException(message);
        }
    }
}

