/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.util.HFileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class TestHFileUtils {
    @ParameterizedTest
    @EnumSource(value=Compression.Algorithm.class)
    public void testGetHFileCompressionAlgorithm(Compression.Algorithm algo) {
        for (boolean upperCase : new boolean[]{true, false}) {
            Map<String, String> paramsMap = Collections.singletonMap(HoodieStorageConfig.HFILE_COMPRESSION_ALGORITHM_NAME.key(), upperCase ? algo.getName().toUpperCase() : algo.getName().toLowerCase());
            Assertions.assertEquals((Object)algo, (Object)HFileUtils.getHFileCompressionAlgorithm(paramsMap));
        }
    }

    @Test
    public void testGetHFileCompressionAlgorithmWithEmptyString() {
        Assertions.assertEquals((Object)Compression.Algorithm.GZ, (Object)HFileUtils.getHFileCompressionAlgorithm(Collections.singletonMap(HoodieStorageConfig.HFILE_COMPRESSION_ALGORITHM_NAME.key(), "")));
    }

    @Test
    public void testGetDefaultHFileCompressionAlgorithm() {
        Assertions.assertEquals((Object)Compression.Algorithm.GZ, (Object)HFileUtils.getHFileCompressionAlgorithm(Collections.emptyMap()));
    }
}

