/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.util.HadoopConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.TestConfigUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHadoopConfigUtils {
    @Test
    public void testGetRawValueWithAltKeysFromHadoopConf() {
        Configuration conf = new Configuration();
        Assertions.assertEquals((Object)Option.empty(), (Object)HadoopConfigUtils.getRawValueWithAltKeys((Configuration)conf, (ConfigProperty)TestConfigUtils.TEST_BOOLEAN_CONFIG_PROPERTY));
        boolean setValue = !Boolean.parseBoolean((String)TestConfigUtils.TEST_BOOLEAN_CONFIG_PROPERTY.defaultValue());
        conf.setBoolean(TestConfigUtils.TEST_BOOLEAN_CONFIG_PROPERTY.key(), setValue);
        Assertions.assertEquals((Object)Option.of((Object)String.valueOf(setValue)), (Object)HadoopConfigUtils.getRawValueWithAltKeys((Configuration)conf, (ConfigProperty)TestConfigUtils.TEST_BOOLEAN_CONFIG_PROPERTY));
        conf = new Configuration();
        conf.setBoolean((String)TestConfigUtils.TEST_BOOLEAN_CONFIG_PROPERTY.getAlternatives().get(0), setValue);
        Assertions.assertEquals((Object)Option.of((Object)String.valueOf(setValue)), (Object)HadoopConfigUtils.getRawValueWithAltKeys((Configuration)conf, (ConfigProperty)TestConfigUtils.TEST_BOOLEAN_CONFIG_PROPERTY));
    }

    @Test
    public void testGetBooleanWithAltKeysFromHadoopConf() {
        Configuration conf = new Configuration();
        Assertions.assertEquals((Object)Boolean.parseBoolean((String)TestConfigUtils.TEST_BOOLEAN_CONFIG_PROPERTY.defaultValue()), (Object)HadoopConfigUtils.getBooleanWithAltKeys((Configuration)conf, (ConfigProperty)TestConfigUtils.TEST_BOOLEAN_CONFIG_PROPERTY));
        boolean setValue = !Boolean.parseBoolean((String)TestConfigUtils.TEST_BOOLEAN_CONFIG_PROPERTY.defaultValue());
        conf.setBoolean(TestConfigUtils.TEST_BOOLEAN_CONFIG_PROPERTY.key(), setValue);
        Assertions.assertEquals((Object)setValue, (Object)HadoopConfigUtils.getBooleanWithAltKeys((Configuration)conf, (ConfigProperty)TestConfigUtils.TEST_BOOLEAN_CONFIG_PROPERTY));
        conf = new Configuration();
        conf.setBoolean((String)TestConfigUtils.TEST_BOOLEAN_CONFIG_PROPERTY.getAlternatives().get(0), setValue);
        Assertions.assertEquals((Object)setValue, (Object)HadoopConfigUtils.getBooleanWithAltKeys((Configuration)conf, (ConfigProperty)TestConfigUtils.TEST_BOOLEAN_CONFIG_PROPERTY));
    }
}

