/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.TestHoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.FileCreateUtilsLegacy;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.io.storage.HoodieFileWriterFactory;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.util.Lazy;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestHoodieTableMetadataUtil
extends HoodieCommonTestHarness {
    private static HoodieTestTable hoodieTestTable;
    private static final List<String> DATE_PARTITIONS;

    @BeforeEach
    public void setUp() throws IOException {
        this.initMetaClient();
        this.initTestDataGenerator(DATE_PARTITIONS.toArray(new String[0]));
        hoodieTestTable = HoodieTestTable.of(this.metaClient);
    }

    @AfterEach
    public void tearDown() throws IOException {
        this.metaClient.getStorage().deleteDirectory(this.metaClient.getBasePath());
        this.cleanupTestDataGenerator();
        this.cleanMetaClient();
    }

    @Test
    public void testReadRecordKeysFromBaseFilesWithEmptyPartitionBaseFilePairs() {
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(this.metaClient.getStorageConf());
        List partitionFileSlicePairs = Collections.emptyList();
        HoodieData result = HoodieTableMetadataUtil.readRecordKeysFromFileSlices((HoodieEngineContext)engineContext, partitionFileSlicePairs, (boolean)false, (int)1, (String)"activeModule", (HoodieTableMetaClient)this.metaClient, (EngineType)EngineType.SPARK);
        Assertions.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testConvertFilesToPartitionStatsRecords() throws Exception {
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(this.metaClient.getStorageConf());
        String instant1 = "20230918120000000";
        hoodieTestTable = hoodieTestTable.addCommit(instant1);
        String instant2 = "20230918121110000";
        hoodieTestTable = hoodieTestTable.addCommit(instant2);
        ArrayList partitionFileSlicePairs = new ArrayList();
        DATE_PARTITIONS.forEach(p -> {
            try {
                URI partitionMetaFile = FileCreateUtilsLegacy.createPartitionMetaFile((String)this.basePath, (String)p);
                StoragePath partitionMetadataPath = new StoragePath(partitionMetaFile);
                String fileId1 = UUID.randomUUID().toString();
                FileSlice fileSlice1 = new FileSlice(p, instant1, fileId1);
                StoragePath storagePath1 = new StoragePath(hoodieTestTable.getBaseFilePath((String)p, fileId1).toUri());
                TestHoodieTableMetadataUtil.writeParquetFile(instant1, storagePath1, this.dataGen.generateInsertsForPartition(instant1, Integer.valueOf(10), p), this.metaClient, engineContext);
                HoodieBaseFile baseFile1 = new HoodieBaseFile(hoodieTestTable.getBaseFilePath((String)p, fileId1).toString());
                fileSlice1.setBaseFile(baseFile1);
                String fileId2 = UUID.randomUUID().toString();
                FileSlice fileSlice2 = new FileSlice(p, instant2, fileId2);
                StoragePath storagePath2 = new StoragePath(hoodieTestTable.getBaseFilePath((String)p, fileId2).toUri());
                TestHoodieTableMetadataUtil.writeParquetFile(instant2, storagePath2, this.dataGen.generateInsertsForPartition(instant2, Integer.valueOf(10), p), this.metaClient, engineContext);
                HoodieBaseFile baseFile2 = new HoodieBaseFile(hoodieTestTable.getBaseFilePath((String)p, fileId2).toString());
                fileSlice2.setBaseFile(baseFile2);
                partitionFileSlicePairs.add(Pair.of((Object)p, (Object)fileSlice1));
                partitionFileSlicePairs.add(Pair.of((Object)p, (Object)fileSlice2));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        List<String> columnsToIndex = Arrays.asList("rider", "driver");
        HoodieData result = HoodieTableMetadataUtil.convertFilesToPartitionStatsRecords((HoodieEngineContext)engineContext, partitionFileSlicePairs, (HoodieMetadataConfig)HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexColumnStats(true).withMetadataIndexPartitionStats(true).withColumnStatsIndexForColumns("rider,driver").withPartitionStatsIndexParallelism(1).build(), (HoodieTableMetaClient)this.metaClient, (Option)Option.of((Object)HoodieTestDataGenerator.AVRO_SCHEMA_WITH_METADATA_FIELDS), (Option)Option.empty());
        TestHoodieTableMetadataUtil.validatePartitionStats((HoodieData<HoodieRecord>)result, instant1, instant2);
    }

    @Test
    public void testReadRecordKeysFromBaseFilesWithValidRecords() throws Exception {
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(this.metaClient.getStorageConf());
        String instant = "20230918120000000";
        hoodieTestTable = hoodieTestTable.addCommit(instant);
        HashSet recordKeys = new HashSet();
        ArrayList partitionFileSlicePairs = new ArrayList();
        DATE_PARTITIONS.forEach(p -> {
            try {
                List hoodieRecords = this.dataGen.generateInsertsForPartition(instant, Integer.valueOf(10), p);
                String fileId = UUID.randomUUID().toString();
                FileSlice fileSlice = new FileSlice(p, instant, fileId);
                TestHoodieTableMetadataUtil.writeParquetFile(instant, new StoragePath(hoodieTestTable.getBaseFilePath((String)p, fileId).toUri()), hoodieRecords, this.metaClient, engineContext);
                HoodieBaseFile baseFile = new HoodieBaseFile(hoodieTestTable.getBaseFilePath((String)p, fileId).toString(), fileId, instant, null);
                fileSlice.setBaseFile(baseFile);
                partitionFileSlicePairs.add(Pair.of((Object)p, (Object)fileSlice));
                recordKeys.addAll(hoodieRecords.stream().map(HoodieRecord::getRecordKey).collect(Collectors.toSet()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        HoodieData result = HoodieTableMetadataUtil.readRecordKeysFromFileSlices((HoodieEngineContext)engineContext, partitionFileSlicePairs, (boolean)false, (int)1, (String)"activeModule", (HoodieTableMetaClient)this.metaClient, (EngineType)EngineType.SPARK);
        List records = result.collectAsList();
        Assertions.assertEquals((int)30, (int)records.size());
        Assertions.assertEquals((Object)MetadataPartitionType.RECORD_INDEX.getPartitionPath(), (Object)((HoodieRecord)records.get(0)).getPartitionPath());
        for (HoodieRecord record : records) {
            Assertions.assertTrue((boolean)recordKeys.contains(record.getRecordKey()));
        }
    }

    @Test
    public void testGetLogFileColumnRangeMetadata() throws Exception {
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(this.metaClient.getStorageConf());
        String instant1 = "20230918120000000";
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        commitMetadata.addMetadata("test", "test");
        commitMetadata.setOperationType(WriteOperationType.INSERT);
        commitMetadata.addMetadata("schema", HoodieTestDataGenerator.AVRO_SCHEMA_WITH_METADATA_FIELDS.toString());
        hoodieTestTable = hoodieTestTable.addCommit(instant1, (Option<HoodieCommitMetadata>)Option.of((Object)commitMetadata));
        String instant2 = "20230918121110000";
        hoodieTestTable = hoodieTestTable.addCommit(instant2);
        ArrayList partitionFileSlicePairs = new ArrayList();
        List<String> columnsToIndex = Arrays.asList("rider", "driver");
        DATE_PARTITIONS.forEach(p -> {
            try {
                URI partitionMetaFile = FileCreateUtilsLegacy.createPartitionMetaFile((String)this.basePath, (String)p);
                StoragePath partitionMetadataPath = new StoragePath(partitionMetaFile);
                String fileId1 = UUID.randomUUID().toString();
                FileSlice fileSlice1 = new FileSlice(p, instant1, fileId1);
                StoragePath storagePath1 = new StoragePath(hoodieTestTable.getBaseFilePath((String)p, fileId1).toUri());
                TestHoodieTableMetadataUtil.writeParquetFile(instant1, storagePath1, this.dataGen.generateInsertsForPartition(instant1, Integer.valueOf(10), p), this.metaClient, engineContext);
                HoodieBaseFile baseFile1 = new HoodieBaseFile(hoodieTestTable.getBaseFilePath((String)p, fileId1).toString());
                fileSlice1.setBaseFile(baseFile1);
                FileSlice fileSlice2 = new FileSlice(p, instant2, fileId1);
                fileSlice2.setBaseFile(baseFile1);
                StoragePath storagePath2 = new StoragePath(partitionMetadataPath.getParent(), hoodieTestTable.getLogFileNameById(fileId1, 1));
                TestHoodieTableMetadataUtil.writeLogFiles(new StoragePath(this.metaClient.getBasePath(), p), HoodieTestDataGenerator.AVRO_SCHEMA_WITH_METADATA_FIELDS, this.dataGen.generateInsertsForPartition(instant2, Integer.valueOf(10), p), 1, this.metaClient.getStorage(), new Properties(), fileId1, instant2);
                fileSlice2.addLogFile(new HoodieLogFile(storagePath2.toUri().toString()));
                partitionFileSlicePairs.add(Pair.of((Object)p, (Object)fileSlice1));
                partitionFileSlicePairs.add(Pair.of((Object)p, (Object)fileSlice2));
                this.metaClient.getTableConfig().setValue(HoodieTableConfig.POPULATE_META_FIELDS.key(), "false");
                this.metaClient.getTableConfig().setValue(HoodieTableConfig.RECORDKEY_FIELDS.key(), "_row_key");
                this.metaClient.getTableConfig().setValue(HoodieTableConfig.PARTITION_FIELDS.key(), "partition_path");
                List columnRangeMetadataLogFile = HoodieTableMetadataUtil.getLogFileColumnRangeMetadata((String)storagePath2.toString(), (HoodieTableMetaClient)this.metaClient, (List)columnsToIndex, (Option)Option.of((Object)HoodieTestDataGenerator.AVRO_SCHEMA_WITH_METADATA_FIELDS), (int)((Integer)HoodieMetadataConfig.MAX_READER_BUFFER_SIZE_PROP.defaultValue()));
                Assertions.assertEquals((int)2, (int)columnRangeMetadataLogFile.size());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        HoodieData result = HoodieTableMetadataUtil.convertFilesToPartitionStatsRecords((HoodieEngineContext)engineContext, partitionFileSlicePairs, (HoodieMetadataConfig)HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexColumnStats(true).withMetadataIndexPartitionStats(true).withColumnStatsIndexForColumns("rider,driver").withPartitionStatsIndexParallelism(1).build(), (HoodieTableMetaClient)this.metaClient, (Option)Option.of((Object)HoodieTestDataGenerator.AVRO_SCHEMA_WITH_METADATA_FIELDS), (Option)Option.empty());
        TestHoodieTableMetadataUtil.validatePartitionStats((HoodieData<HoodieRecord>)result, instant1, instant2, 6);
    }

    private static void validatePartitionStats(HoodieData<HoodieRecord> result, String instant1, String instant2) {
        TestHoodieTableMetadataUtil.validatePartitionStats(result, instant1, instant2, 15);
    }

    private static void validatePartitionStats(HoodieData<HoodieRecord> result, String instant1, String instant2, int expectedTotalRecords) {
        List records = result.collectAsList();
        Assertions.assertEquals((int)expectedTotalRecords, (int)records.size());
        Assertions.assertEquals((Object)MetadataPartitionType.PARTITION_STATS.getPartitionPath(), (Object)((HoodieRecord)records.get(0)).getPartitionPath());
        ((HoodieMetadataColumnStats)((HoodieMetadataPayload)((HoodieRecord)result.collectAsList().get(0)).getData()).getColumnStatMetadata().get()).getColumnName();
        records.forEach(r -> {
            HoodieMetadataPayload payload = (HoodieMetadataPayload)r.getData();
            Assertions.assertTrue((boolean)payload.getColumnStatMetadata().isPresent());
            if (((HoodieMetadataColumnStats)payload.getColumnStatMetadata().get()).getColumnName().equals("rider")) {
                Assertions.assertEquals((Object)String.format("{\"value\": \"rider-%s\"}", instant1), (Object)String.valueOf(((HoodieMetadataColumnStats)payload.getColumnStatMetadata().get()).getMinValue()));
                Assertions.assertEquals((Object)String.format("{\"value\": \"rider-%s\"}", instant2), (Object)String.valueOf(((HoodieMetadataColumnStats)payload.getColumnStatMetadata().get()).getMaxValue()));
            } else if (((HoodieMetadataColumnStats)payload.getColumnStatMetadata().get()).getColumnName().equals("driver")) {
                Assertions.assertEquals((Object)String.format("{\"value\": \"driver-%s\"}", instant1), (Object)String.valueOf(((HoodieMetadataColumnStats)payload.getColumnStatMetadata().get()).getMinValue()));
                Assertions.assertEquals((Object)String.format("{\"value\": \"driver-%s\"}", instant2), (Object)String.valueOf(((HoodieMetadataColumnStats)payload.getColumnStatMetadata().get()).getMaxValue()));
            }
        });
    }

    private static void writeParquetFile(String instant, StoragePath path, List<HoodieRecord> records, HoodieTableMetaClient metaClient, HoodieLocalEngineContext engineContext) throws IOException {
        HoodieFileWriter writer = HoodieFileWriterFactory.getFileWriter((String)instant, (StoragePath)path, (HoodieStorage)metaClient.getStorage(), (HoodieConfig)metaClient.getTableConfig(), (Schema)HoodieTestDataGenerator.AVRO_SCHEMA_WITH_METADATA_FIELDS, (TaskContextSupplier)engineContext.getTaskContextSupplier(), (HoodieRecord.HoodieRecordType)HoodieRecord.HoodieRecordType.AVRO);
        for (HoodieRecord record : records) {
            writer.writeWithMetadata(record.getKey(), record, HoodieTestDataGenerator.AVRO_SCHEMA_WITH_METADATA_FIELDS);
        }
        writer.close();
    }

    @Test
    public void testGetFileGroupIndexFromFileId() {
        String result = HoodieTableMetadataUtil.getFileIDForFileGroup((MetadataPartitionType)MetadataPartitionType.FILES, (int)1, (String)"test_partition");
        Assertions.assertEquals((Object)"files-0001-0", (Object)result);
        result = HoodieTableMetadataUtil.getFileIDForFileGroup((MetadataPartitionType)MetadataPartitionType.COLUMN_STATS, (int)2, (String)"stats_partition");
        Assertions.assertEquals((Object)"col-stats-0002-0", (Object)result);
        result = HoodieTableMetadataUtil.getFileIDForFileGroup((MetadataPartitionType)MetadataPartitionType.BLOOM_FILTERS, (int)3, (String)"bloom_partition");
        Assertions.assertEquals((Object)"bloom-filters-0003-0", (Object)result);
        result = HoodieTableMetadataUtil.getFileIDForFileGroup((MetadataPartitionType)MetadataPartitionType.RECORD_INDEX, (int)4, (String)"record_partition");
        Assertions.assertEquals((Object)"record-index-0004-0", (Object)result);
        result = HoodieTableMetadataUtil.getFileIDForFileGroup((MetadataPartitionType)MetadataPartitionType.SECONDARY_INDEX, (int)6, (String)"secondary_index_idx_ts");
        Assertions.assertEquals((Object)"secondary-index-idx-ts-0006-0", (Object)result);
        result = HoodieTableMetadataUtil.getFileIDForFileGroup((MetadataPartitionType)MetadataPartitionType.EXPRESSION_INDEX, (int)5, (String)"expr_index_ts");
        Assertions.assertEquals((Object)"expr-index-ts-0005-0", (Object)result);
    }

    @Test
    public void testValidateDataTypeForSecondaryOrExpressionIndex() {
        Schema schema = (Schema)((SchemaBuilder.RecordDefault)((SchemaBuilder.MapDefault)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)"TestRecord").fields().requiredString("stringField").optionalInt("intField").name("arrayField").type().array().items().stringType()).noDefault().name("mapField").type().map().values().intType()).noDefault().name("structField").type().record("NestedRecord").fields().requiredString("nestedString").endRecord()).noDefault().endRecord();
        Assertions.assertTrue((boolean)HoodieTableMetadataUtil.validateDataTypeForSecondaryOrExpressionIndex(Arrays.asList("stringField", "intField"), (Schema)schema));
        Assertions.assertFalse((boolean)HoodieTableMetadataUtil.validateDataTypeForSecondaryOrExpressionIndex(Arrays.asList("arrayField", "mapField", "structField"), (Schema)schema));
    }

    @Test
    public void testGetColumnsToIndex() {
        HoodieTableConfig tableConfig = this.metaClient.getTableConfig();
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexColumnStats(true).build();
        ArrayList<String> colNames = new ArrayList<String>();
        this.addNColumns(colNames, (Integer)HoodieMetadataConfig.COLUMN_STATS_INDEX_MAX_COLUMNS.defaultValue() + 10);
        ArrayList<String> expected = new ArrayList<String>(Arrays.asList(HoodieTableMetadataUtil.META_COLS_TO_ALWAYS_INDEX));
        this.addNColumns(expected, (Integer)HoodieMetadataConfig.COLUMN_STATS_INDEX_MAX_COLUMNS.defaultValue());
        this.assertListEquality(expected, new ArrayList<String>(HoodieTableMetadataUtil.getColumnsToIndex((HoodieTableConfig)tableConfig, (HoodieMetadataConfig)metadataConfig, (Lazy)Lazy.eagerly((Object)Option.of((Object)this.getTableSchema(expected))), (boolean)false).keySet()));
        int tableSchemaSize = (Integer)HoodieMetadataConfig.COLUMN_STATS_INDEX_MAX_COLUMNS.defaultValue() - 10;
        Assertions.assertTrue((tableSchemaSize > 0 ? 1 : 0) != 0);
        colNames = new ArrayList();
        this.addNColumns(colNames, tableSchemaSize);
        expected = new ArrayList<String>(Arrays.asList(HoodieTableMetadataUtil.META_COLS_TO_ALWAYS_INDEX));
        this.addNColumns(expected, tableSchemaSize);
        this.assertListEquality(expected, new ArrayList<String>(HoodieTableMetadataUtil.getColumnsToIndex((HoodieTableConfig)tableConfig, (HoodieMetadataConfig)metadataConfig, (Lazy)Lazy.eagerly((Object)Option.of((Object)this.getTableSchema(expected))), (boolean)false).keySet()));
        metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexColumnStats(true).withMaxColumnsToIndexForColStats(3).build();
        colNames = new ArrayList();
        this.addNColumns(colNames, (Integer)HoodieMetadataConfig.COLUMN_STATS_INDEX_MAX_COLUMNS.defaultValue() + 10);
        expected = new ArrayList<String>(Arrays.asList(HoodieTableMetadataUtil.META_COLS_TO_ALWAYS_INDEX));
        this.addNColumns(expected, 3);
        this.assertListEquality(expected, new ArrayList<String>(HoodieTableMetadataUtil.getColumnsToIndex((HoodieTableConfig)tableConfig, (HoodieMetadataConfig)metadataConfig, (Lazy)Lazy.eagerly((Object)Option.of((Object)this.getTableSchema(expected))), (boolean)false).keySet()));
        metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexColumnStats(true).withMaxColumnsToIndexForColStats((Integer)HoodieMetadataConfig.COLUMN_STATS_INDEX_MAX_COLUMNS.defaultValue() + 10).build();
        colNames = new ArrayList();
        this.addNColumns(colNames, tableSchemaSize);
        expected = new ArrayList<String>(Arrays.asList(HoodieTableMetadataUtil.META_COLS_TO_ALWAYS_INDEX));
        this.addNColumns(expected, tableSchemaSize);
        this.assertListEquality(expected, new ArrayList<String>(HoodieTableMetadataUtil.getColumnsToIndex((HoodieTableConfig)tableConfig, (HoodieMetadataConfig)metadataConfig, (Lazy)Lazy.eagerly((Object)Option.of((Object)this.getTableSchema(expected))), (boolean)false).keySet()));
        metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexColumnStats(true).withColumnStatsIndexForColumns("col_1,col_7,col_11,col_12.col12_1").build();
        colNames = new ArrayList();
        this.addNColumns(colNames, 15);
        expected = new ArrayList<String>(Arrays.asList(HoodieTableMetadataUtil.META_COLS_TO_ALWAYS_INDEX));
        expected.add("col_1");
        expected.add("col_7");
        expected.add("col_11");
        expected.add("col_12.col12_1");
        Schema schema = (Schema)((SchemaBuilder.RecordDefault)SchemaBuilder.record((String)"TestRecord").fields().requiredString("col_1").requiredString("col_7").requiredString("col_11").name("col_12").type().record("NestedRecord").fields().requiredString("col12_1").endRecord()).noDefault().endRecord();
        this.assertListEquality(expected, new ArrayList<String>(HoodieTableMetadataUtil.getColumnsToIndex((HoodieTableConfig)tableConfig, (HoodieMetadataConfig)metadataConfig, (Lazy)Lazy.eagerly((Object)Option.of((Object)schema)), (boolean)false).keySet()));
        metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexColumnStats(true).withMaxColumnsToIndexForColStats(1).withColumnStatsIndexForColumns("col_1,col_7,col_11").build();
        colNames = new ArrayList();
        this.addNColumns(colNames, 15);
        expected = new ArrayList<String>(Arrays.asList(HoodieTableMetadataUtil.META_COLS_TO_ALWAYS_INDEX));
        expected.add("col_1");
        expected.add("col_7");
        expected.add("col_11");
        this.assertListEquality(expected, new ArrayList<String>(HoodieTableMetadataUtil.getColumnsToIndex((HoodieTableConfig)tableConfig, (HoodieMetadataConfig)metadataConfig, (Lazy)Lazy.eagerly((Object)Option.of((Object)this.getTableSchema(expected))), (boolean)false).keySet()));
        metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexColumnStats(true).withColumnStatsIndexForColumns("col_1,col_7,_hoodie_commit_time,col_11,_hoodie_commit_seqno").build();
        colNames = new ArrayList();
        this.addNColumns(colNames, 15);
        expected = new ArrayList<String>(Arrays.asList(HoodieTableMetadataUtil.META_COLS_TO_ALWAYS_INDEX));
        expected.add("col_1");
        expected.add("col_7");
        expected.add("col_11");
        expected.add("_hoodie_commit_seqno");
        this.assertListEquality(expected, new ArrayList<String>(HoodieTableMetadataUtil.getColumnsToIndex((HoodieTableConfig)tableConfig, (HoodieMetadataConfig)metadataConfig, (Lazy)Lazy.eagerly((Object)Option.of((Object)this.getTableSchema(expected))), (boolean)false).keySet()));
        schema = new Schema.Parser().parse("{\"name\":\"TestRecordAvroTypes\",\"type\":\"record\",\"fields\":[{\"name\":\"booleanField\",\"type\":\"boolean\"},{\"name\":\"intField\",\"type\":\"int\"},{\"name\":\"longField\",\"type\":\"long\"},{\"name\":\"floatField\",\"type\":\"float\"},{\"name\":\"doubleField\",\"type\":\"double\"},{\"name\":\"bytesField\",\"type\":\"bytes\"},{\"name\":\"stringField\",\"type\":\"string\"},{\"name\":\"decimalField\",\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":20,\"scale\":5},{\"name\":\"timeMillisField\",\"type\":\"int\",\"logicalType\":\"time-millis\"},{\"name\":\"timeMicrosField\",\"type\":\"long\",\"logicalType\":\"time-micros\"},{\"name\":\"timestampMillisField\",\"type\":\"long\",\"logicalType\":\"timestamp-millis\"},{\"name\":\"timestampMicrosField\",\"type\":\"long\",\"logicalType\":\"timestamp-micros\"},{\"name\":\"localTimestampMillisField\",\"type\":\"long\",\"logicalType\":\"local-timestamp-millis\"},{\"name\":\"localTimestampMicrosField\",\"type\":\"long\",\"logicalType\":\"local-timestamp-micros\"}]}");
        metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexColumnStats(true).withColumnStatsIndexForColumns("booleanField,decimalField,localTimestampMillisField").build();
        expected = new ArrayList<String>(Arrays.asList(HoodieTableMetadataUtil.META_COLS_TO_ALWAYS_INDEX));
        expected.add("booleanField");
        expected.add("decimalField");
        expected.add("localTimestampMillisField");
        this.assertListEquality(expected, new ArrayList<String>(HoodieTableMetadataUtil.getColumnsToIndex((HoodieTableConfig)tableConfig, (HoodieMetadataConfig)metadataConfig, (Lazy)Lazy.eagerly((Object)Option.of((Object)schema)), (boolean)true).keySet()));
        schema = new Schema.Parser().parse(TestHoodieAvroUtils.SCHEMA_WITH_NESTED_FIELD_STR);
        metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexColumnStats(true).withColumnStatsIndexForColumns("firstname,student.lastname,student").build();
        expected = new ArrayList<String>(Arrays.asList(HoodieTableMetadataUtil.META_COLS_TO_ALWAYS_INDEX));
        expected.add("firstname");
        expected.add("student.lastname");
        this.assertListEquality(expected, new ArrayList<String>(HoodieTableMetadataUtil.getColumnsToIndex((HoodieTableConfig)tableConfig, (HoodieMetadataConfig)metadataConfig, (Lazy)Lazy.eagerly((Object)Option.of((Object)schema)), (boolean)false).keySet()));
        schema = new Schema.Parser().parse("{\"name\":\"TestRecordAvroTypes\",\"type\":\"record\",\"fields\":[{\"name\":\"booleanField\",\"type\":\"boolean\"},{\"name\":\"intField\",\"type\":\"int\"},{\"name\":\"longField\",\"type\":\"long\"},{\"name\":\"floatField\",\"type\":\"float\"},{\"name\":\"doubleField\",\"type\":\"double\"},{\"name\":\"bytesField\",\"type\":\"bytes\"},{\"name\":\"stringField\",\"type\":\"string\"},{\"name\":\"decimalField\",\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":20,\"scale\":5},{\"name\":\"timeMillisField\",\"type\":\"int\",\"logicalType\":\"time-millis\"},{\"name\":\"timeMicrosField\",\"type\":\"long\",\"logicalType\":\"time-micros\"},{\"name\":\"timestampMillisField\",\"type\":\"long\",\"logicalType\":\"timestamp-millis\"},{\"name\":\"timestampMicrosField\",\"type\":\"long\",\"logicalType\":\"timestamp-micros\"},{\"name\":\"localTimestampMillisField\",\"type\":\"long\",\"logicalType\":\"local-timestamp-millis\"},{\"name\":\"localTimestampMicrosField\",\"type\":\"long\",\"logicalType\":\"local-timestamp-micros\"}]}");
        metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexColumnStats(true).withMaxColumnsToIndexForColStats(2).build();
        expected = new ArrayList<String>(Arrays.asList(HoodieTableMetadataUtil.META_COLS_TO_ALWAYS_INDEX));
        expected.add("booleanField");
        expected.add("intField");
        this.assertListEquality(expected, new ArrayList<String>(HoodieTableMetadataUtil.getColumnsToIndex((HoodieTableConfig)tableConfig, (HoodieMetadataConfig)metadataConfig, (Lazy)Lazy.eagerly((Object)Option.of((Object)schema)), (boolean)false).keySet()));
        this.assertListEquality(expected, new ArrayList<String>(HoodieTableMetadataUtil.getColumnsToIndex((HoodieTableConfig)tableConfig, (HoodieMetadataConfig)metadataConfig, (Lazy)Lazy.eagerly((Object)Option.of((Object)HoodieAvroUtils.addMetadataFields((Schema)schema))), (boolean)false).keySet()));
        metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexColumnStats(true).withMaxColumnsToIndexForColStats(100).build();
        expected = new ArrayList<String>(Arrays.asList(HoodieTableMetadataUtil.META_COLS_TO_ALWAYS_INDEX));
        expected.add("timestamp");
        expected.add("_row_key");
        expected.add("partition_path");
        expected.add("rider");
        expected.add("driver");
        expected.add("begin_lat");
        expected.add("begin_lon");
        expected.add("end_lat");
        expected.add("end_lon");
        expected.add("distance_in_meters");
        expected.add("seconds_since_epoch");
        expected.add("weight");
        expected.add("current_date");
        expected.add("current_ts");
        expected.add("_hoodie_is_deleted");
        this.assertListEquality(expected, new ArrayList<String>(HoodieTableMetadataUtil.getColumnsToIndex((HoodieTableConfig)tableConfig, (HoodieMetadataConfig)metadataConfig, (Lazy)Lazy.eagerly((Object)Option.of((Object)HoodieTestDataGenerator.AVRO_SCHEMA)), (boolean)false).keySet()));
        this.assertListEquality(expected, new ArrayList<String>(HoodieTableMetadataUtil.getColumnsToIndex((HoodieTableConfig)tableConfig, (HoodieMetadataConfig)metadataConfig, (Lazy)Lazy.eagerly((Object)Option.of((Object)HoodieAvroUtils.addMetadataFields((Schema)HoodieTestDataGenerator.AVRO_SCHEMA))), (boolean)false).keySet()));
        tableConfig.setValue(HoodieTableConfig.POPULATE_META_FIELDS.key(), "false");
        metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexColumnStats(true).build();
        colNames = new ArrayList();
        this.addNColumns(colNames, tableSchemaSize);
        expected = new ArrayList();
        this.addNColumns(expected, tableSchemaSize);
        this.assertListEquality(expected, new ArrayList<String>(HoodieTableMetadataUtil.getColumnsToIndex((HoodieTableConfig)tableConfig, (HoodieMetadataConfig)metadataConfig, (Lazy)Lazy.eagerly((Object)Option.of((Object)this.getTableSchema(expected))), (boolean)false).keySet()));
        metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexColumnStats(true).withColumnStatsIndexForColumns("col_1,col_7,col_11").build();
        colNames = new ArrayList();
        this.addNColumns(colNames, 15);
        expected = new ArrayList();
        expected.add("col_1");
        expected.add("col_7");
        expected.add("col_11");
        this.assertListEquality(expected, new ArrayList<String>(HoodieTableMetadataUtil.getColumnsToIndex((HoodieTableConfig)tableConfig, (HoodieMetadataConfig)metadataConfig, (Lazy)Lazy.eagerly((Object)Option.of((Object)this.getTableSchema(expected))), (boolean)false).keySet()));
        metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexColumnStats(true).withColumnStatsIndexForColumns("booleanField,decimalField,localTimestampMillisField").build();
        expected = new ArrayList();
        expected.add("booleanField");
        expected.add("decimalField");
        expected.add("localTimestampMillisField");
        this.assertListEquality(expected, new ArrayList<String>(HoodieTableMetadataUtil.getColumnsToIndex((HoodieTableConfig)tableConfig, (HoodieMetadataConfig)metadataConfig, (Lazy)Lazy.eagerly((Object)Option.of((Object)schema)), (boolean)true).keySet()));
    }

    private void assertListEquality(List<String> expected, List<String> actual) {
        Collections.sort(expected);
        Collections.sort(actual);
        Assertions.assertEquals(expected, actual);
    }

    private void addNColumns(List<String> list, int n) {
        for (int i = 0; i < n; ++i) {
            list.add("col_" + i);
        }
    }

    private Schema getTableSchema(List<String> fieldNames) {
        List fields = fieldNames.stream().map(fieldName -> new Schema.Field(fieldName, AvroSchemaUtils.createNullableSchema((Schema.Type)Schema.Type.STRING), "", (Object)JsonProperties.NULL_VALUE)).collect(Collectors.toList());
        return Schema.createRecord((String)"Test_Hoodie_Record", (String)"", (String)"", (boolean)false, fields);
    }

    @Test
    public void testValidateDataTypeForPartitionStats() {
        Schema schema = (Schema)((SchemaBuilder.RecordDefault)((SchemaBuilder.MapDefault)((SchemaBuilder.ArrayDefault)((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)SchemaBuilder.record((String)"TestRecord").fields().requiredString("stringField").optionalInt("intField").optionalBoolean("booleanField").optionalFloat("floatField").optionalDouble("doubleField").optionalLong("longField").optionalBytes("bytesField").name("unionIntField").type().unionOf().nullType().and().intType()).endUnion()).noDefault().name("arrayField").type().array().items().stringType()).noDefault().name("mapField").type().map().values().intType()).noDefault().name("structField").type().record("NestedRecord").fields().requiredString("nestedString").endRecord()).noDefault().endRecord();
        Assertions.assertTrue((boolean)HoodieTableMetadataUtil.isColumnTypeSupported((Schema)schema.getField("stringField").schema(), (Option)Option.empty()));
        Assertions.assertTrue((boolean)HoodieTableMetadataUtil.isColumnTypeSupported((Schema)schema.getField("intField").schema(), (Option)Option.empty()));
        Assertions.assertTrue((boolean)HoodieTableMetadataUtil.isColumnTypeSupported((Schema)schema.getField("booleanField").schema(), (Option)Option.empty()));
        Assertions.assertTrue((boolean)HoodieTableMetadataUtil.isColumnTypeSupported((Schema)schema.getField("floatField").schema(), (Option)Option.empty()));
        Assertions.assertTrue((boolean)HoodieTableMetadataUtil.isColumnTypeSupported((Schema)schema.getField("doubleField").schema(), (Option)Option.empty()));
        Assertions.assertTrue((boolean)HoodieTableMetadataUtil.isColumnTypeSupported((Schema)schema.getField("longField").schema(), (Option)Option.empty()));
        Assertions.assertTrue((boolean)HoodieTableMetadataUtil.isColumnTypeSupported((Schema)schema.getField("unionIntField").schema(), (Option)Option.empty()));
        Assertions.assertFalse((boolean)HoodieTableMetadataUtil.isColumnTypeSupported((Schema)schema.getField("arrayField").schema(), (Option)Option.empty()));
        Assertions.assertFalse((boolean)HoodieTableMetadataUtil.isColumnTypeSupported((Schema)schema.getField("mapField").schema(), (Option)Option.empty()));
        Assertions.assertFalse((boolean)HoodieTableMetadataUtil.isColumnTypeSupported((Schema)schema.getField("structField").schema(), (Option)Option.empty()));
        Assertions.assertFalse((boolean)HoodieTableMetadataUtil.isColumnTypeSupported((Schema)schema.getField("bytesField").schema(), (Option)Option.of((Object)HoodieRecord.HoodieRecordType.SPARK)));
        Schema dateFieldSchema = LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        schema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("dateField").type(dateFieldSchema).noDefault().endRecord();
        Assertions.assertTrue((boolean)HoodieTableMetadataUtil.isColumnTypeSupported((Schema)schema.getField("dateField").schema(), (Option)Option.empty()));
        schema = Schema.create((Schema.Type)Schema.Type.BYTES);
        LogicalTypes.Decimal decimalType = LogicalTypes.decimal((int)30, (int)15);
        decimalType.addToSchema(schema);
        Assertions.assertTrue((boolean)HoodieTableMetadataUtil.isColumnTypeSupported((Schema)schema, (Option)Option.of((Object)HoodieRecord.HoodieRecordType.AVRO)));
        schema = Schema.create((Schema.Type)Schema.Type.BYTES);
        decimalType = LogicalTypes.decimal((int)35, (int)20);
        decimalType.addToSchema(schema);
        Assertions.assertFalse((boolean)HoodieTableMetadataUtil.isColumnTypeSupported((Schema)schema, (Option)Option.of((Object)HoodieRecord.HoodieRecordType.AVRO)));
        schema = Schema.create((Schema.Type)Schema.Type.BYTES);
        decimalType = LogicalTypes.decimal((int)28, (int)10);
        decimalType.addToSchema(schema);
        Assertions.assertFalse((boolean)HoodieTableMetadataUtil.isColumnTypeSupported((Schema)schema, (Option)Option.of((Object)HoodieRecord.HoodieRecordType.AVRO)));
    }

    @Test
    public void testComputeRevivedAndDeletedKeys() {
        HashSet<String> validKeysForPreviousLogs = new HashSet<String>(Arrays.asList("K1", "K2", "K3"));
        HashSet<String> deletedKeysForPreviousLogs = new HashSet<String>(Arrays.asList("K4", "K5"));
        HashSet<String> validKeysForAllLogs = new HashSet<String>(Arrays.asList("K2", "K4", "K6"));
        HashSet<String> deletedKeysForAllLogs = new HashSet<String>(Arrays.asList("K1", "K5", "K7"));
        HashSet<String> expectedRevivedKeys = new HashSet<String>(Collections.singletonList("K4"));
        HashSet<String> expectedDeletedKeys = new HashSet<String>(Collections.singletonList("K1"));
        Pair result = HoodieTableMetadataUtil.computeRevivedAndDeletedKeys(validKeysForPreviousLogs, deletedKeysForPreviousLogs, validKeysForAllLogs, deletedKeysForAllLogs);
        Assertions.assertEquals(expectedRevivedKeys, (Object)result.getKey());
        Assertions.assertEquals(expectedDeletedKeys, (Object)result.getValue());
        HashSet<String> allValidKeys = new HashSet<String>(Arrays.asList("K1", "K2", "K3"));
        Set allEmpty = Collections.emptySet();
        result = HoodieTableMetadataUtil.computeRevivedAndDeletedKeys(allValidKeys, allEmpty, allValidKeys, allEmpty);
        Assertions.assertEquals(Collections.emptySet(), (Object)result.getKey());
        Assertions.assertEquals(Collections.emptySet(), (Object)result.getValue());
        result = HoodieTableMetadataUtil.computeRevivedAndDeletedKeys(allValidKeys, allEmpty, allEmpty, allValidKeys);
        Assertions.assertEquals(Collections.emptySet(), (Object)result.getKey());
        Assertions.assertEquals(allValidKeys, (Object)result.getValue());
        result = HoodieTableMetadataUtil.computeRevivedAndDeletedKeys(allValidKeys, allEmpty, new HashSet<String>(Arrays.asList("K1", "K2")), new HashSet<String>(Collections.singletonList("K3")));
        Assertions.assertEquals(Collections.emptySet(), (Object)result.getKey());
        Assertions.assertEquals(new HashSet<String>(Collections.singletonList("K3")), (Object)result.getValue());
        result = HoodieTableMetadataUtil.computeRevivedAndDeletedKeys(Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        Assertions.assertEquals(Collections.emptySet(), (Object)result.getKey());
        Assertions.assertEquals(Collections.emptySet(), (Object)result.getValue());
    }

    @Test
    public void testGetExpressionIndexPartitionsToInit() {
        MetadataPartitionType partitionType = MetadataPartitionType.EXPRESSION_INDEX;
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        Mockito.when((Object)metaClient.getIndexMetadata()).thenReturn((Object)Option.empty());
        HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)metaClient.getTableConfig()).thenReturn((Object)tableConfig);
        Mockito.when((Object)tableConfig.getMetadataPartitions()).thenReturn(new HashSet<String>(Collections.singleton("expr_index_idx_ts")));
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).withExpressionIndexColumn("ts").withExpressionIndexType("column_stats").withExpressionIndexOptions(Collections.singletonMap("expr", "from_unixtime(ts, format='yyyy-MM-dd')")).build();
        Set result = HoodieTableMetadataUtil.getExpressionIndexPartitionsToInit((MetadataPartitionType)partitionType, (HoodieMetadataConfig)metadataConfig, (HoodieTableMetaClient)metaClient);
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEmpty());
        ((HoodieTableMetaClient)Mockito.verify((Object)metaClient, (VerificationMode)Mockito.atLeastOnce())).buildIndexDefinition((HoodieIndexDefinition)ArgumentMatchers.any());
    }

    static {
        DATE_PARTITIONS = Arrays.asList("2019/01/01", "2020/01/02", "2021/03/01");
    }
}

