/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction.lock;

import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hudi.client.transaction.lock.InProcessLockProvider;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.exception.HoodieLockException;
import org.apache.hudi.storage.StorageConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestInProcessLockProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TestInProcessLockProvider.class);
    private final StorageConfiguration<?> storageConf = HoodieTestUtils.getDefaultStorageConf();
    private final LockConfiguration lockConfiguration1;
    private final LockConfiguration lockConfiguration2;

    public TestInProcessLockProvider() {
        TypedProperties properties = new TypedProperties();
        properties.put((Object)HoodieCommonConfig.BASE_PATH.key(), (Object)"table1");
        this.lockConfiguration1 = new LockConfiguration((Properties)properties);
        properties.put((Object)HoodieCommonConfig.BASE_PATH.key(), (Object)"table2");
        this.lockConfiguration2 = new LockConfiguration((Properties)properties);
    }

    @Test
    public void testLockIdentity() throws InterruptedException {
        ArrayList<InProcessLockProvider> lockProviderList = new ArrayList<InProcessLockProvider>();
        InProcessLockProvider lockProvider1 = new InProcessLockProvider(this.lockConfiguration1, this.storageConf);
        lockProviderList.add(lockProvider1);
        AtomicBoolean writer1Completed = new AtomicBoolean(false);
        AtomicBoolean writer2TryLock = new AtomicBoolean(false);
        AtomicBoolean writer2Locked = new AtomicBoolean(false);
        AtomicBoolean writer2Completed = new AtomicBoolean(false);
        AtomicBoolean writer3TryLock = new AtomicBoolean(false);
        AtomicBoolean writer3Completed = new AtomicBoolean(false);
        Assertions.assertDoesNotThrow(() -> {
            LOG.info("Writer 1 tries to acquire the lock.");
            lockProvider1.lock();
            LOG.info("Writer 1 acquires the lock.");
        });
        Thread writer2 = new Thread(() -> {
            InProcessLockProvider lockProvider2 = new InProcessLockProvider(this.lockConfiguration1, this.storageConf);
            lockProviderList.add(lockProvider2);
            Assertions.assertDoesNotThrow(() -> {
                LOG.info("Writer 2 tries to acquire the lock.");
                writer2TryLock.set(true);
                lockProvider2.lock();
                LOG.info("Writer 2 acquires the lock.");
            });
            writer2Locked.set(true);
            while (!writer3TryLock.get()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assertions.assertDoesNotThrow(() -> {
                lockProvider2.unlock();
                LOG.info("Writer 2 releases the lock.");
            });
            lockProvider2.close();
            LOG.info("Writer 2 closes the lock provider.");
            writer2Completed.set(true);
        });
        Thread writer3 = new Thread(() -> {
            while (!writer2Locked.get() || !writer1Completed.get()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            InProcessLockProvider lockProvider3 = new InProcessLockProvider(this.lockConfiguration1, this.storageConf);
            lockProviderList.add(lockProvider3);
            boolean isLocked = lockProvider3.getLock().isWriteLocked();
            if (!isLocked) {
                writer3TryLock.set(true);
                throw new RuntimeException("The lock instance in Writer 3 should be held by Writer 2: " + lockProvider3.getLock());
            }
            Assertions.assertDoesNotThrow(() -> {
                LOG.info("Writer 3 tries to acquire the lock.");
                writer3TryLock.set(true);
                lockProvider3.lock();
                LOG.info("Writer 3 acquires the lock.");
            });
            Assertions.assertDoesNotThrow(() -> {
                lockProvider3.unlock();
                LOG.info("Writer 3 releases the lock.");
            });
            lockProvider3.close();
            LOG.info("Writer 3 closes the lock provider.");
            writer3Completed.set(true);
        });
        writer2.start();
        writer3.start();
        while (!writer2TryLock.get()) {
            Thread.sleep(100L);
        }
        Assertions.assertDoesNotThrow(() -> {
            lockProvider1.unlock();
            LOG.info("Writer 1 releases the lock.");
            lockProvider1.close();
            LOG.info("Writer 1 closes the lock provider.");
            writer1Completed.set(true);
        });
        try {
            writer2.join();
            writer3.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)writer2Completed.get());
        Assertions.assertTrue((boolean)writer3Completed.get());
        Assertions.assertEquals((Object)((InProcessLockProvider)lockProviderList.get(0)).getLock(), (Object)((InProcessLockProvider)lockProviderList.get(1)).getLock());
        Assertions.assertEquals((Object)((InProcessLockProvider)lockProviderList.get(1)).getLock(), (Object)((InProcessLockProvider)lockProviderList.get(2)).getLock());
        writer2.interrupt();
        writer3.interrupt();
    }

    @Test
    public void testLockAcquisition() {
        InProcessLockProvider inProcessLockProvider = new InProcessLockProvider(this.lockConfiguration1, this.storageConf);
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.lock());
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock());
    }

    @Test
    public void testLockReAcquisitionBySameThread() {
        InProcessLockProvider inProcessLockProvider = new InProcessLockProvider(this.lockConfiguration1, this.storageConf);
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.lock());
        Assertions.assertThrows(HoodieLockException.class, () -> inProcessLockProvider.lock());
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock());
    }

    @Test
    public void testLockReAcquisitionBySameThreadWithTwoTables() {
        InProcessLockProvider inProcessLockProvider1 = new InProcessLockProvider(this.lockConfiguration1, this.storageConf);
        InProcessLockProvider inProcessLockProvider2 = new InProcessLockProvider(this.lockConfiguration2, this.storageConf);
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider1.lock());
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider2.lock());
        Assertions.assertThrows(HoodieLockException.class, () -> inProcessLockProvider2.lock());
        Assertions.assertThrows(HoodieLockException.class, () -> inProcessLockProvider1.lock());
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider1.unlock());
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider2.unlock());
    }

    @Test
    public void testLockReAcquisitionByDifferentThread() {
        final InProcessLockProvider inProcessLockProvider = new InProcessLockProvider(this.lockConfiguration1, this.storageConf);
        final AtomicBoolean writer2Completed = new AtomicBoolean(false);
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.lock());
        Thread writer2 = new Thread(new Runnable(){

            @Override
            public void run() {
                Assertions.assertDoesNotThrow(() -> inProcessLockProvider.lock());
                Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock());
                writer2Completed.set(true);
            }
        });
        writer2.start();
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock());
        try {
            writer2.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)writer2Completed.get());
        writer2.interrupt();
    }

    @Test
    public void testLockReAcquisitionByDifferentThreadWithTwoTables() {
        final InProcessLockProvider inProcessLockProvider1 = new InProcessLockProvider(this.lockConfiguration1, this.storageConf);
        final InProcessLockProvider inProcessLockProvider2 = new InProcessLockProvider(this.lockConfiguration2, this.storageConf);
        final AtomicBoolean writer2Stream1Completed = new AtomicBoolean(false);
        final AtomicBoolean writer2Stream2Completed = new AtomicBoolean(false);
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider1.lock());
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider2.lock());
        Thread writer2Stream1 = new Thread(new Runnable(){

            @Override
            public void run() {
                Assertions.assertDoesNotThrow(() -> inProcessLockProvider1.lock());
                Assertions.assertDoesNotThrow(() -> inProcessLockProvider1.unlock());
                writer2Stream1Completed.set(true);
            }
        });
        Thread writer2Stream2 = new Thread(new Runnable(){

            @Override
            public void run() {
                Assertions.assertDoesNotThrow(() -> inProcessLockProvider2.lock());
                Assertions.assertDoesNotThrow(() -> inProcessLockProvider2.unlock());
                writer2Stream2Completed.set(true);
            }
        });
        writer2Stream1.start();
        writer2Stream2.start();
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider1.unlock());
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider2.unlock());
        try {
            writer2Stream1.join();
            writer2Stream2.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)writer2Stream1Completed.get());
        Assertions.assertTrue((boolean)writer2Stream2Completed.get());
        writer2Stream1.interrupt();
        writer2Stream2.interrupt();
    }

    @Test
    public void testTryLockAcquisition() {
        InProcessLockProvider inProcessLockProvider = new InProcessLockProvider(this.lockConfiguration1, this.storageConf);
        Assertions.assertTrue((boolean)inProcessLockProvider.tryLock());
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock());
    }

    @Test
    public void testTryLockAcquisitionWithTimeout() {
        InProcessLockProvider inProcessLockProvider = new InProcessLockProvider(this.lockConfiguration1, this.storageConf);
        Assertions.assertTrue((boolean)inProcessLockProvider.tryLock(1L, TimeUnit.MILLISECONDS));
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock());
    }

    @Test
    public void testTryLockReAcquisitionBySameThread() {
        InProcessLockProvider inProcessLockProvider = new InProcessLockProvider(this.lockConfiguration1, this.storageConf);
        Assertions.assertTrue((boolean)inProcessLockProvider.tryLock());
        Assertions.assertThrows(HoodieLockException.class, () -> inProcessLockProvider.tryLock(1L, TimeUnit.MILLISECONDS));
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock());
    }

    @Test
    public void testTryLockReAcquisitionByDifferentThread() {
        InProcessLockProvider inProcessLockProvider = new InProcessLockProvider(this.lockConfiguration1, this.storageConf);
        AtomicBoolean writer2Completed = new AtomicBoolean(false);
        Assertions.assertTrue((boolean)inProcessLockProvider.tryLock());
        Thread writer2 = new Thread(() -> {
            Assertions.assertFalse((boolean)inProcessLockProvider.tryLock(100L, TimeUnit.MILLISECONDS));
            writer2Completed.set(true);
        });
        writer2.start();
        try {
            writer2.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)writer2Completed.get());
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock());
        writer2.interrupt();
    }

    @Test
    public void testTryUnLockByDifferentThread() {
        InProcessLockProvider inProcessLockProvider = new InProcessLockProvider(this.lockConfiguration1, this.storageConf);
        AtomicBoolean writer3Completed = new AtomicBoolean(false);
        Assertions.assertTrue((boolean)inProcessLockProvider.tryLock());
        Thread writer2 = new Thread(() -> Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock()));
        writer2.start();
        try {
            writer2.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Thread writer3 = new Thread(() -> {
            Assertions.assertFalse((boolean)inProcessLockProvider.tryLock(50L, TimeUnit.MILLISECONDS));
            writer3Completed.set(true);
        });
        writer3.start();
        try {
            writer3.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)writer3Completed.get());
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock());
        writer2.interrupt();
        writer3.interrupt();
    }

    @Test
    public void testTryLockAcquisitionBeforeTimeOutFromTwoThreads() {
        InProcessLockProvider inProcessLockProvider = new InProcessLockProvider(this.lockConfiguration1, this.storageConf);
        int threadCount = 3;
        long awaitMaxTimeoutMs = 2000L;
        CountDownLatch latch = new CountDownLatch(3);
        AtomicBoolean writer1Completed = new AtomicBoolean(false);
        AtomicBoolean writer2Completed = new AtomicBoolean(false);
        Thread writer1 = new Thread(() -> {
            Assertions.assertTrue((boolean)inProcessLockProvider.tryLock());
            latch.countDown();
            try {
                latch.await(2000L, TimeUnit.MILLISECONDS);
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock());
            writer1Completed.set(true);
        });
        writer1.start();
        Thread writer2 = new Thread(() -> {
            latch.countDown();
            Assertions.assertTrue((boolean)inProcessLockProvider.tryLock(2000L, TimeUnit.MILLISECONDS));
            Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock());
            writer2Completed.set(true);
        });
        writer2.start();
        latch.countDown();
        try {
            writer1.join();
            writer2.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)writer1Completed.get());
        Assertions.assertTrue((boolean)writer2Completed.get());
        writer1.interrupt();
        writer2.interrupt();
    }

    @Test
    public void testLockReleaseByClose() {
        InProcessLockProvider inProcessLockProvider = new InProcessLockProvider(this.lockConfiguration1, this.storageConf);
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.lock());
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.close());
    }

    @Test
    public void testRedundantUnlock() {
        InProcessLockProvider inProcessLockProvider = new InProcessLockProvider(this.lockConfiguration1, this.storageConf);
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.lock());
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock());
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock());
    }

    @Test
    public void testUnlockWithoutLock() {
        InProcessLockProvider inProcessLockProvider = new InProcessLockProvider(this.lockConfiguration1, this.storageConf);
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock());
    }
}

