/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.bloom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestBloomFilter {
    public static List<Arguments> bloomFilterTypeCodes() {
        return Arrays.asList(Arguments.of((Object[])new Object[]{BloomFilterTypeCode.SIMPLE.name()}), Arguments.of((Object[])new Object[]{BloomFilterTypeCode.DYNAMIC_V0.name()}));
    }

    @ParameterizedTest
    @MethodSource(value={"bloomFilterTypeCodes"})
    public void testAddKey(String typeCode) {
        int[] sizes;
        for (int size : sizes = new int[]{100, 1000, 10000}) {
            int i;
            ArrayList<String> inputs = new ArrayList<String>();
            BloomFilter filter = this.getBloomFilter(typeCode, size, 1.0E-6, size * 10);
            for (i = 0; i < size; ++i) {
                String key = UUID.randomUUID().toString();
                inputs.add(key);
                filter.add(key);
            }
            for (String key : inputs) {
                Assertions.assertTrue((boolean)filter.mightContain(key), (String)("Filter should have returned true for " + key));
            }
            for (i = 0; i < 100; ++i) {
                String randomKey = UUID.randomUUID().toString();
                if (!inputs.contains(randomKey)) continue;
                Assertions.assertTrue((boolean)filter.mightContain(randomKey), (String)("Filter should have returned true for " + randomKey));
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"bloomFilterTypeCodes"})
    public void testBloomORMethod(String typeCode) {
        int i;
        ArrayList<String> inputs = new ArrayList<String>();
        int[] sizes = new int[]{100, 1000, 10000};
        BloomFilter bloomFilter = null;
        for (int size : sizes) {
            BloomFilter filter = this.getBloomFilter(typeCode, 20000, 1.0E-8, 100000);
            for (int i2 = 0; i2 < size; ++i2) {
                String key = String.format("key%d", size + i2);
                inputs.add(key);
                filter.add(key);
            }
            if (bloomFilter == null) {
                bloomFilter = filter;
                continue;
            }
            bloomFilter.or(filter);
        }
        Object object = inputs.iterator();
        while (object.hasNext()) {
            String key = (String)object.next();
            Assertions.assertTrue((boolean)bloomFilter.mightContain(key), (String)("Filter should have returned true for " + key));
        }
        for (i = 150; i <= 210; ++i) {
            if (inputs.contains(String.format("key%d", i))) {
                Assertions.assertTrue((boolean)bloomFilter.mightContain(String.format("key%d", i)), (String)("Filter should have returned false for " + String.format("key%d", i)));
                continue;
            }
            Assertions.assertFalse((boolean)bloomFilter.mightContain(String.format("key%d", i)), (String)("Filter should have returned false for " + String.format("key%d", i)));
        }
        for (i = 998; i <= 1001; ++i) {
            if (inputs.contains(String.format("key%d", i))) {
                Assertions.assertTrue((boolean)bloomFilter.mightContain(String.format("key%d", i)), (String)("Filter should have returned false for " + String.format("key%d", i)));
                continue;
            }
            Assertions.assertFalse((boolean)bloomFilter.mightContain(String.format("key%d", i)), (String)("Filter should have returned false for " + String.format("key%d", i)));
        }
        for (i = 9998; i <= 10001; ++i) {
            if (inputs.contains(String.format("key%d", i))) {
                Assertions.assertTrue((boolean)bloomFilter.mightContain(String.format("key%d", i)), (String)("Filter should have returned false for " + String.format("key%d", i)));
                continue;
            }
            Assertions.assertFalse((boolean)bloomFilter.mightContain(String.format("key%d", i)), (String)("Filter should have returned false for " + String.format("key%d", i)));
        }
        for (i = 19998; i <= 20001; ++i) {
            if (inputs.contains(String.format("key%d", i))) {
                Assertions.assertTrue((boolean)bloomFilter.mightContain(String.format("key%d", i)), (String)("Filter should have returned false for " + String.format("key%d", i)));
                continue;
            }
            Assertions.assertFalse((boolean)bloomFilter.mightContain(String.format("key%d", i)), (String)("Filter should have returned false for " + String.format("key%d", i)));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"bloomFilterTypeCodes"})
    public void testSerialize(String typeCode) {
        int[] sizes;
        for (int size : sizes = new int[]{100, 1000, 10000}) {
            ArrayList<String> inputs = new ArrayList<String>();
            BloomFilter filter = this.getBloomFilter(typeCode, size, 1.0E-6, size * 10);
            for (int i = 0; i < size; ++i) {
                String key = UUID.randomUUID().toString();
                inputs.add(key);
                filter.add(key);
            }
            String serString = filter.serializeToString();
            BloomFilter recreatedBloomFilter = BloomFilterFactory.fromString((String)serString, (String)typeCode);
            for (String key : inputs) {
                Assertions.assertTrue((boolean)recreatedBloomFilter.mightContain(key), (String)("Filter should have returned true for " + key));
            }
        }
    }

    public static List<Arguments> bloomFilterParams() {
        return Arrays.asList(Arguments.of((Object[])new Object[]{"hadoop", BloomFilterTypeCode.SIMPLE.name(), 200, 1.0E-6, 1, -1}), Arguments.of((Object[])new Object[]{"hadoop", BloomFilterTypeCode.SIMPLE.name(), 1000, 1.0E-6, 1, -1}), Arguments.of((Object[])new Object[]{"hadoop", BloomFilterTypeCode.SIMPLE.name(), 5000, 1.0E-6, 1, -1}), Arguments.of((Object[])new Object[]{"hadoop", BloomFilterTypeCode.SIMPLE.name(), 10000, 1.0E-6, 1, -1}), Arguments.of((Object[])new Object[]{"hadoop", BloomFilterTypeCode.SIMPLE.name(), 5000, 1.0E-6, 0, -1}), Arguments.of((Object[])new Object[]{"hadoop", BloomFilterTypeCode.DYNAMIC_V0.name(), 200, 1.0E-6, 1, 1000}), Arguments.of((Object[])new Object[]{"hadoop", BloomFilterTypeCode.DYNAMIC_V0.name(), 1000, 1.0E-6, 1, 5000}), Arguments.of((Object[])new Object[]{"hadoop", BloomFilterTypeCode.DYNAMIC_V0.name(), 1000, 1.0E-6, 0, 5000}), Arguments.of((Object[])new Object[]{"hudi", BloomFilterTypeCode.SIMPLE.name(), 1000, 1.0E-6, 1, -1}), Arguments.of((Object[])new Object[]{"hudi", BloomFilterTypeCode.SIMPLE.name(), 5000, 1.0E-6, 1, -1}), Arguments.of((Object[])new Object[]{"hudi", BloomFilterTypeCode.DYNAMIC_V0.name(), 1000, 1.0E-6, 1, 5000}));
    }

    @ParameterizedTest
    @MethodSource(value={"bloomFilterParams"})
    public void testDeserialize(String lib, String typeCode, int numEntries, double errorRate, int hashType, int maxEntries) throws IOException {
        String serializedFilter;
        List<String> keyList = Arrays.stream(HoodieTestTable.readLastLineFromResourceFile("/format/bloom-filter/hadoop/all_10000.keys.data").split(",")).collect(Collectors.toList());
        if ("hadoop".equals(lib)) {
            String fileName = (BloomFilterTypeCode.DYNAMIC_V0.name().equals(typeCode) ? "dynamic" : "simple") + "_" + numEntries + "_000001_" + (hashType == 1 ? "murmur" : "jenkins") + (BloomFilterTypeCode.DYNAMIC_V0.name().equals(typeCode) ? "_" + maxEntries : "") + ".bf.data";
            serializedFilter = HoodieTestTable.readLastLineFromResourceFile("/format/bloom-filter/hadoop/" + fileName);
        } else {
            BloomFilter inputFilter = this.getBloomFilter(typeCode, numEntries, errorRate, maxEntries);
            for (String key : keyList) {
                inputFilter.add(key);
            }
            serializedFilter = inputFilter.serializeToString();
        }
        this.validateBloomFilter(serializedFilter, keyList, lib, typeCode, numEntries, errorRate, hashType, maxEntries);
    }

    BloomFilter getBloomFilter(String typeCode, int numEntries, double errorRate, int maxEntries) {
        if (typeCode.equalsIgnoreCase(BloomFilterTypeCode.SIMPLE.name())) {
            return BloomFilterFactory.createBloomFilter((int)numEntries, (double)errorRate, (int)-1, (String)typeCode);
        }
        return BloomFilterFactory.createBloomFilter((int)numEntries, (double)errorRate, (int)maxEntries, (String)typeCode);
    }

    private void validateBloomFilter(String serializedFilter, List<String> keyList, String lib, String typeCode, int numEntries, double errorRate, int hashType, int maxEntries) {
        BloomFilter bloomFilter = BloomFilterFactory.fromString((String)serializedFilter, (String)typeCode);
        for (String key : keyList) {
            Assertions.assertTrue((boolean)bloomFilter.mightContain(key), (String)("Filter should have returned true for " + key));
        }
        if ("hadoop".equals(lib) && hashType == 1) {
            BloomFilter hudiBloomFilter = this.getBloomFilter(typeCode, numEntries, errorRate, maxEntries);
            for (String key : keyList) {
                hudiBloomFilter.add(key);
            }
            Assertions.assertEquals((Object)hudiBloomFilter.serializeToString(), (Object)serializedFilter);
        }
    }
}

