/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieListPairData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.storage.HoodieStorage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHoodieLocalEngineContext {
    private HoodieLocalEngineContext context;

    @BeforeEach
    void setUp() {
        HoodieStorage storageConf = HoodieTestUtils.getDefaultStorage();
        this.context = new HoodieLocalEngineContext(storageConf.getConf());
    }

    @Test
    void testProcessKeyGroups() {
        List<Pair> unsortedPairs = Arrays.asList(ImmutablePair.of((Object)"key2", (Object)5), ImmutablePair.of((Object)"key1", (Object)3), ImmutablePair.of((Object)"key1", (Object)1), ImmutablePair.of((Object)"key3", (Object)7), ImmutablePair.of((Object)"key1", (Object)2), ImmutablePair.of((Object)"key2", (Object)4));
        HoodieListPairData pairData = HoodieListPairData.lazy(unsortedPairs);
        SerializableFunction & Serializable func = (SerializableFunction & Serializable)iterator -> {
            ArrayList values = new ArrayList();
            iterator.forEachRemaining(values::add);
            for (int i = 1; i < values.size(); ++i) {
                Assertions.assertTrue(((Integer)values.get(i - 1) <= (Integer)values.get(i) ? 1 : 0) != 0, (String)("Values should be sorted: " + values.get(i - 1) + " <= " + values.get(i)));
            }
            return values.stream().map(String::valueOf).iterator();
        };
        List<String> shardIndices = Arrays.asList("key1", "key2", "key3");
        HoodieData result = this.context.mapGroupsByKey((HoodiePairData)pairData, (SerializableFunction)func, shardIndices, false);
        List resultList = result.collectAsList();
        Assertions.assertEquals((int)6, (int)resultList.size());
        Assertions.assertTrue((boolean)resultList.contains("1"));
        Assertions.assertTrue((boolean)resultList.contains("2"));
        Assertions.assertTrue((boolean)resultList.contains("3"));
        Assertions.assertTrue((boolean)resultList.contains("4"));
        Assertions.assertTrue((boolean)resultList.contains("5"));
        Assertions.assertTrue((boolean)resultList.contains("7"));
    }

    @Test
    void testProcessKeyGroupsWithStrings() {
        List<Pair> unsortedPairs = Arrays.asList(ImmutablePair.of((Object)"key1", (Object)"zebra"), ImmutablePair.of((Object)"key1", (Object)"apple"), ImmutablePair.of((Object)"key1", (Object)"banana"), ImmutablePair.of((Object)"key2", (Object)"cherry"), ImmutablePair.of((Object)"key2", (Object)"date"));
        HoodieListPairData pairData = HoodieListPairData.lazy(unsortedPairs);
        SerializableFunction & Serializable func = (SerializableFunction & Serializable)iterator -> {
            ArrayList values = new ArrayList();
            iterator.forEachRemaining(values::add);
            for (int i = 1; i < values.size(); ++i) {
                Assertions.assertTrue((((String)values.get(i - 1)).compareTo((String)values.get(i)) <= 0 ? 1 : 0) != 0, (String)("Values should be sorted: " + (String)values.get(i - 1) + " <= " + (String)values.get(i)));
            }
            return values.iterator();
        };
        List<String> shardIndices = Arrays.asList("key1", "key2");
        HoodieData result = this.context.mapGroupsByKey((HoodiePairData)pairData, (SerializableFunction)func, shardIndices, false);
        List resultList = result.collectAsList();
        Assertions.assertEquals((int)5, (int)resultList.size());
        Assertions.assertTrue((boolean)resultList.contains("apple"));
        Assertions.assertTrue((boolean)resultList.contains("banana"));
        Assertions.assertTrue((boolean)resultList.contains("zebra"));
        Assertions.assertTrue((boolean)resultList.contains("cherry"));
        Assertions.assertTrue((boolean)resultList.contains("date"));
    }

    @Test
    void testProcessKeyGroupsWithSingleValue() {
        List<Pair> singleValuePairs = Arrays.asList(ImmutablePair.of((Object)"key1", (Object)42), ImmutablePair.of((Object)"key2", (Object)17));
        HoodieListPairData pairData = HoodieListPairData.lazy(singleValuePairs);
        SerializableFunction & Serializable func = (SerializableFunction & Serializable)iterator -> {
            ArrayList values = new ArrayList();
            iterator.forEachRemaining(values::add);
            return values.iterator();
        };
        List<String> shardIndices = Arrays.asList("key1", "key2");
        HoodieData result = this.context.mapGroupsByKey((HoodiePairData)pairData, (SerializableFunction)func, shardIndices, false);
        List resultList = result.collectAsList();
        Assertions.assertEquals((int)2, (int)resultList.size());
        Assertions.assertTrue((boolean)resultList.contains(42));
        Assertions.assertTrue((boolean)resultList.contains(17));
    }
}

