/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs.inline;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.testutils.FileSystemTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.hadoop.fs.HadoopSeekableDataInputStream;
import org.apache.hudi.hadoop.fs.inline.InLineFileSystem;
import org.apache.hudi.hadoop.fs.inline.InMemoryFileSystem;
import org.apache.hudi.io.SeekableDataInputStream;
import org.apache.hudi.io.hfile.HFileContext;
import org.apache.hudi.io.hfile.HFileReader;
import org.apache.hudi.io.hfile.HFileReaderImpl;
import org.apache.hudi.io.hfile.HFileUtils;
import org.apache.hudi.io.hfile.HFileWriter;
import org.apache.hudi.io.hfile.HFileWriterImpl;
import org.apache.hudi.io.hfile.Key;
import org.apache.hudi.io.hfile.KeyValue;
import org.apache.hudi.io.hfile.UTF8StringKey;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestInLineFileSystemWithHFileReader {
    protected static final String LOCAL_FORMATTER = "%010d";
    protected static final String VALUE_PREFIX = "value";
    private final Configuration inMemoryConf;
    private final Configuration inlineConf;
    private final int maxRows = 100 + FileSystemTestUtils.RANDOM.nextInt(1000);
    private Path generatedPath;

    TestInLineFileSystemWithHFileReader() {
        this.inMemoryConf = new Configuration();
        this.inMemoryConf.set("fs.inmemfs.impl", InMemoryFileSystem.class.getName());
        this.inlineConf = new Configuration();
        this.inlineConf.set("fs.inlinefs.impl", InLineFileSystem.class.getName());
    }

    @AfterEach
    public void teardown() throws IOException {
        File filePath;
        if (this.generatedPath != null && (filePath = new File(this.generatedPath.toString().substring(this.generatedPath.toString().indexOf(58) + 1))).exists()) {
            FileSystemTestUtils.deleteFile(filePath);
        }
    }

    @Test
    void testSimpleInlineFileSystem() throws IOException {
        Path outerPath;
        Path outerInMemFSPath = FileSystemTestUtils.getRandomOuterInMemPath();
        this.generatedPath = outerPath = new Path("file" + outerInMemFSPath.toString().substring(outerInMemFSPath.toString().indexOf(58)));
        FSDataOutputStream out = this.createFSOutput(outerInMemFSPath, this.inMemoryConf);
        HFileContext context = new HFileContext.Builder().build();
        HFileWriterImpl writer = new HFileWriterImpl(context, (OutputStream)out);
        this.writeRecords((HFileWriter)writer);
        out.close();
        byte[] inlineBytes = this.getBytesToInline(outerInMemFSPath);
        long startOffset = this.generateOuterFile(outerPath, inlineBytes);
        long inlineLength = inlineBytes.length;
        Path inlinePath = new Path(FileSystemTestUtils.getPhantomFile(new StoragePath(outerPath.toUri()), startOffset, inlineLength).toUri());
        InLineFileSystem inlineFileSystem = (InLineFileSystem)inlinePath.getFileSystem(this.inlineConf);
        FSDataInputStream fin = inlineFileSystem.open(inlinePath);
        this.validateHFileReading(inlineFileSystem, this.inMemoryConf, this.inlineConf, inlinePath, this.maxRows);
        fin.close();
        outerPath.getFileSystem(this.inMemoryConf).delete(outerPath, true);
    }

    protected Set<Integer> getRandomValidRowIds(int count) {
        HashSet<Integer> rowIds = new HashSet<Integer>();
        while (rowIds.size() < count) {
            int index = FileSystemTestUtils.RANDOM.nextInt(this.maxRows);
            if (rowIds.contains(index)) continue;
            rowIds.add(index);
        }
        return rowIds;
    }

    protected void validateHFileReading(InLineFileSystem inlineFileSystem, Configuration conf, Configuration inlineConf, Path inlinePath, int maxRows) throws IOException {
        long fileSize = inlineFileSystem.getFileStatus(inlinePath).getLen();
        try (HadoopSeekableDataInputStream stream = new HadoopSeekableDataInputStream(inlineFileSystem.open(inlinePath));
             HFileReaderImpl reader = new HFileReaderImpl((SeekableDataInputStream)stream, fileSize);){
            int[] invalidRowIds;
            reader.seekTo();
            this.readAllRecords((HFileReader)reader, maxRows);
            reader.seekTo();
            List rowIdsToSearch = this.getRandomValidRowIds(10).stream().sorted().collect(Collectors.toList());
            Iterator iterator = rowIdsToSearch.iterator();
            while (iterator.hasNext()) {
                int rowId = (Integer)iterator.next();
                Key lookupKey = this.getKey(rowId);
                Assertions.assertEquals((int)0, (int)reader.seekTo(lookupKey), (String)"location lookup failed");
                Option keyValue = reader.getKeyValue();
                Assertions.assertTrue((boolean)keyValue.isPresent());
                Assertions.assertEquals((Object)lookupKey, (Object)((KeyValue)keyValue.get()).getKey(), (String)"seeked key does not match");
                reader.seekTo(lookupKey);
                String val1 = HFileUtils.getValue((KeyValue)((KeyValue)reader.getKeyValue().get()));
                reader.seekTo(lookupKey);
                String val2 = HFileUtils.getValue((KeyValue)((KeyValue)reader.getKeyValue().get()));
                Assertions.assertEquals((Object)val1, (Object)val2);
            }
            reader.seekTo();
            for (int rowId : invalidRowIds = new int[]{-4, maxRows, maxRows + 1, maxRows + 120, maxRows + 160, maxRows + 1000}) {
                Assertions.assertNotEquals((int)0, (int)reader.seekTo(this.getKey(rowId)), (String)"location lookup should have failed");
            }
        }
    }

    private Key getKey(int rowId) {
        return new UTF8StringKey(String.format(LOCAL_FORMATTER, rowId));
    }

    private void readAllRecords(HFileReader reader, int maxRows) throws IOException {
        for (int i = 0; i < maxRows; ++i) {
            Option keyValue = reader.getKeyValue();
            Assertions.assertTrue((boolean)keyValue.isPresent());
            String key = ((KeyValue)keyValue.get()).getKey().getContentInString();
            String value = HFileUtils.getValue((KeyValue)((KeyValue)keyValue.get()));
            String expectedKeyStr = String.format(LOCAL_FORMATTER, i);
            String expectedValStr = VALUE_PREFIX + expectedKeyStr;
            Assertions.assertEquals((Object)expectedKeyStr, (Object)key, (String)("keys do not match " + expectedKeyStr + " " + key));
            Assertions.assertEquals((Object)expectedValStr, (Object)value, (String)("values do not match " + expectedValStr + " " + value));
            Assertions.assertEquals((Object)(i != maxRows - 1 ? 1 : 0), (Object)reader.next());
        }
    }

    private FSDataOutputStream createFSOutput(Path name, Configuration conf) throws IOException {
        return name.getFileSystem(conf).create(name);
    }

    private void writeRecords(HFileWriter writer) throws IOException {
        this.writeSomeRecords(writer);
        writer.close();
    }

    private void writeSomeRecords(HFileWriter writer) throws IOException {
        for (int i = 0; i < this.maxRows; ++i) {
            String key = String.format(LOCAL_FORMATTER, i);
            writer.append(key, StringUtils.getUTF8Bytes((String)(VALUE_PREFIX + key)));
        }
    }

    private long generateOuterFile(Path outerPath, byte[] inlineBytes) throws IOException {
        FSDataOutputStream wrappedOut = outerPath.getFileSystem(this.inMemoryConf).create(outerPath, true);
        this.writeRandomBytes(wrappedOut, 10);
        long startOffset = wrappedOut.getPos();
        wrappedOut.write(inlineBytes);
        this.writeRandomBytes(wrappedOut, 5);
        wrappedOut.hsync();
        wrappedOut.close();
        return startOffset;
    }

    private byte[] getBytesToInline(Path outerInMemFSPath) throws IOException {
        InMemoryFileSystem inMemoryFileSystem = (InMemoryFileSystem)outerInMemFSPath.getFileSystem(this.inMemoryConf);
        return inMemoryFileSystem.getFileAsBytes();
    }

    private void writeRandomBytes(FSDataOutputStream writer, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            writer.writeUTF(UUID.randomUUID().toString());
        }
    }
}

