/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.table.read.DeleteContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestHoodieAvroIndexedRecord {
    TestHoodieAvroIndexedRecord() {
    }

    @Test
    void testIsBuiltInDelete() {
        Schema schema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().optionalBoolean("_hoodie_is_deleted").requiredString("field2").endRecord();
        GenericData.Record record1 = new GenericRecordBuilder(schema).set("_hoodie_is_deleted", (Object)true).set("field2", (Object)"value2").build();
        TypedProperties props = new TypedProperties();
        DeleteContext deleteContext = new DeleteContext((Properties)props, schema).withReaderSchema(schema);
        HoodieAvroIndexedRecord indexedRecord1 = new HoodieAvroIndexedRecord((IndexedRecord)record1);
        Assertions.assertTrue((boolean)indexedRecord1.isDelete(deleteContext, (Properties)props));
        GenericData.Record record2 = new GenericRecordBuilder(schema).set("_hoodie_is_deleted", (Object)false).set("field2", (Object)"value2").build();
        HoodieAvroIndexedRecord indexedRecord2 = new HoodieAvroIndexedRecord((IndexedRecord)record2);
        Assertions.assertFalse((boolean)indexedRecord2.isDelete(deleteContext, (Properties)props));
    }

    @Test
    void testIsDeleteWithCustomField() {
        Schema schema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().optionalString("custom_is_deleted").requiredString("field2").endRecord();
        GenericData.Record record1 = new GenericRecordBuilder(schema).set("custom_is_deleted", (Object)"d").set("field2", (Object)"value2").build();
        TypedProperties props = new TypedProperties();
        props.setProperty("hoodie.payload.delete.field", "custom_is_deleted");
        props.setProperty("hoodie.payload.delete.marker", "d");
        DeleteContext deleteContext = new DeleteContext((Properties)props, schema).withReaderSchema(schema);
        HoodieAvroIndexedRecord indexedRecord1 = new HoodieAvroIndexedRecord((IndexedRecord)record1);
        Assertions.assertTrue((boolean)indexedRecord1.isDelete(deleteContext, (Properties)props));
        GenericData.Record record2 = new GenericRecordBuilder(schema).set("custom_is_deleted", (Object)"a").set("field2", (Object)"value2").build();
        HoodieAvroIndexedRecord indexedRecord2 = new HoodieAvroIndexedRecord((IndexedRecord)record2);
        Assertions.assertFalse((boolean)indexedRecord2.isDelete(deleteContext, (Properties)props));
    }

    @Test
    void testIsDeleteWithOperationField() {
        Schema schema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().optionalString("_hoodie_operation").requiredString("field2").endRecord();
        GenericData.Record record1 = new GenericRecordBuilder(schema).set("_hoodie_operation", (Object)HoodieOperation.DELETE.getName()).set("field2", (Object)"value2").build();
        TypedProperties props = new TypedProperties();
        DeleteContext deleteContext = new DeleteContext((Properties)props, schema).withReaderSchema(schema);
        HoodieAvroIndexedRecord indexedRecord1 = new HoodieAvroIndexedRecord((IndexedRecord)record1);
        Assertions.assertTrue((boolean)indexedRecord1.isDelete(deleteContext, (Properties)props));
        GenericData.Record record2 = new GenericRecordBuilder(schema).set("_hoodie_operation", (Object)HoodieOperation.INSERT.getName()).set("field2", (Object)"value2").build();
        HoodieAvroIndexedRecord indexedRecord2 = new HoodieAvroIndexedRecord((IndexedRecord)record2);
        Assertions.assertFalse((boolean)indexedRecord2.isDelete(deleteContext, (Properties)props));
    }
}

