/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.AWSDmsAvroPayload;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.EventTimeAvroPayload;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.OverwriteNonDefaultsWithLatestAvroPayload;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.model.PartialUpdateAvroPayload;
import org.apache.hudi.common.model.debezium.MySqlDebeziumAvroPayload;
import org.apache.hudi.common.model.debezium.PostgresDebeziumAvroPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.PartialUpdateMode;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Triple;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

class TestHoodieTableConfig
extends HoodieCommonTestHarness {
    private HoodieStorage storage;
    private StoragePath metaPath;
    private StoragePath cfgPath;
    private StoragePath backupCfgPath;

    TestHoodieTableConfig() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.initPath();
        this.storage = HoodieStorageUtils.getStorage((String)this.basePath, (StorageConfiguration)HoodieTestUtils.getDefaultStorageConfWithDefaults());
        this.metaPath = new StoragePath(this.basePath, ".hoodie");
        Properties props = new Properties();
        props.setProperty(HoodieTableConfig.NAME.key(), "test-table");
        this.initializeNewTableConfig(props);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.storage.close();
    }

    private void initializeNewTableConfig(Properties properties) throws IOException {
        HoodieTableConfig.create((HoodieStorage)this.storage, (StoragePath)this.metaPath, (Properties)properties);
        this.cfgPath = new StoragePath(this.metaPath, "hoodie.properties");
        this.backupCfgPath = new StoragePath(this.metaPath, "hoodie.properties.backup");
    }

    @Test
    void testCreate() throws IOException {
        Assertions.assertTrue((boolean)this.storage.exists(new StoragePath(this.metaPath, "hoodie.properties")));
        HoodieTableConfig config = new HoodieTableConfig(this.storage, this.metaPath);
        Assertions.assertEquals((int)7, (int)config.getProps().size());
    }

    @Test
    void testUpdate() throws IOException {
        Properties updatedProps = new Properties();
        updatedProps.setProperty(HoodieTableConfig.NAME.key(), "test-table2");
        updatedProps.setProperty(HoodieTableConfig.ORDERING_FIELDS.key(), "new_field");
        HoodieTableConfig.update((HoodieStorage)this.storage, (StoragePath)this.metaPath, (Properties)updatedProps);
        Assertions.assertTrue((boolean)this.storage.exists(this.cfgPath));
        Assertions.assertFalse((boolean)this.storage.exists(this.backupCfgPath));
        HoodieTableConfig config = new HoodieTableConfig(this.storage, this.metaPath);
        Assertions.assertEquals((int)8, (int)config.getProps().size());
        Assertions.assertEquals((Object)"test-table2", (Object)config.getTableName());
        Assertions.assertEquals(Collections.singletonList("new_field"), (Object)config.getOrderingFields());
        Assertions.assertEquals((Object)Option.of((Object)"new_field"), (Object)config.getOrderingFieldsStr());
    }

    @Test
    void testDelete() throws IOException {
        Set deletedProps = CollectionUtils.createSet((Object[])new String[]{HoodieTableConfig.TIMELINE_HISTORY_PATH.key(), "hoodie.invalid.config"});
        HoodieTableConfig.delete((HoodieStorage)this.storage, (StoragePath)this.metaPath, (Set)deletedProps);
        Assertions.assertTrue((boolean)this.storage.exists(this.cfgPath));
        Assertions.assertFalse((boolean)this.storage.exists(this.backupCfgPath));
        HoodieTableConfig config = new HoodieTableConfig(this.storage, this.metaPath);
        Assertions.assertEquals((int)6, (int)config.getProps().size());
        Assertions.assertNull((Object)config.getProps().getProperty("hoodie.invalid.config"));
        Assertions.assertFalse((boolean)config.getProps().contains((Object)HoodieTableConfig.TIMELINE_HISTORY_PATH.key()));
    }

    @Test
    void testUpdateAndDelete() throws IOException {
        Properties updatedProps = new Properties();
        updatedProps.setProperty(HoodieTableConfig.NAME.key(), "test-table2");
        updatedProps.setProperty(HoodieTableConfig.ORDERING_FIELDS.key(), "new_field");
        updatedProps.setProperty(HoodieTableConfig.PARTITION_FIELDS.key(), "partition_path");
        HoodieTableConfig.update((HoodieStorage)this.storage, (StoragePath)this.metaPath, (Properties)updatedProps);
        Assertions.assertTrue((boolean)this.storage.exists(this.cfgPath));
        Assertions.assertFalse((boolean)this.storage.exists(this.backupCfgPath));
        HoodieTableConfig config = new HoodieTableConfig(this.storage, this.metaPath);
        Assertions.assertEquals((int)9, (int)config.getProps().size());
        Assertions.assertEquals((Object)"test-table2", (Object)config.getTableName());
        Assertions.assertEquals(Collections.singletonList("new_field"), (Object)config.getOrderingFields());
        Assertions.assertEquals((Object)"partition_path", (Object)((String[])config.getPartitionFields().get())[0]);
        updatedProps = new Properties();
        updatedProps.setProperty(HoodieTableConfig.ORDERING_FIELDS.key(), "new_field2");
        HashSet<String> propsToDelete = new HashSet<String>();
        propsToDelete.add(HoodieTableConfig.PARTITION_FIELDS.key());
        propsToDelete.add(HoodieTableConfig.RECORDKEY_FIELDS.key());
        HoodieTableConfig.updateAndDeleteProps((HoodieStorage)this.storage, (StoragePath)this.metaPath, (Properties)updatedProps, propsToDelete);
        config = new HoodieTableConfig(this.storage, this.metaPath);
        Assertions.assertEquals((int)8, (int)config.getProps().size());
        Assertions.assertEquals((Object)"test-table2", (Object)config.getTableName());
        Assertions.assertEquals(Collections.singletonList("new_field2"), (Object)config.getOrderingFields());
        Assertions.assertFalse((boolean)config.getPartitionFields().isPresent());
        updatedProps = new Properties();
        HoodieTableConfig.updateAndDeleteProps((HoodieStorage)this.storage, (StoragePath)this.metaPath, (Properties)updatedProps, Collections.singleton(HoodieTableConfig.ORDERING_FIELDS.key()));
        config = new HoodieTableConfig(this.storage, this.metaPath);
        Assertions.assertEquals((int)7, (int)config.getProps().size());
        Assertions.assertEquals((Object)"test-table2", (Object)config.getTableName());
        Assertions.assertTrue((boolean)config.getOrderingFields().isEmpty());
        Assertions.assertFalse((boolean)config.getPartitionFields().isPresent());
    }

    @Test
    void testReadsWhenPropsFileDoesNotExist() throws IOException {
        this.storage.deleteFile(this.cfgPath);
        Assertions.assertThrows(HoodieIOException.class, () -> new HoodieTableConfig(this.storage, this.metaPath));
    }

    @Test
    void testReadsWithUpdateFailures() throws IOException {
        HoodieTableConfig config = new HoodieTableConfig(this.storage, this.metaPath);
        this.storage.deleteFile(this.cfgPath);
        try (OutputStream out = this.storage.create(this.backupCfgPath);){
            config.getProps().store(out, "");
        }
        Assertions.assertFalse((boolean)this.storage.exists(this.cfgPath));
        Assertions.assertTrue((boolean)this.storage.exists(this.backupCfgPath));
        config = new HoodieTableConfig(this.storage, this.metaPath);
        Assertions.assertEquals((int)7, (int)config.getProps().size());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testUpdateRecovery(boolean shouldPropsFileExist) throws IOException {
        HoodieTableConfig config = new HoodieTableConfig(this.storage, this.metaPath);
        if (!shouldPropsFileExist) {
            this.storage.deleteFile(this.cfgPath);
        }
        try (OutputStream out = this.storage.create(this.backupCfgPath);){
            config.getProps().store(out, "");
        }
        ConfigUtils.recoverIfNeeded((HoodieStorage)this.storage, (StoragePath)this.cfgPath, (StoragePath)this.backupCfgPath);
        Assertions.assertTrue((boolean)this.storage.exists(this.cfgPath));
        Assertions.assertFalse((boolean)this.storage.exists(this.backupCfgPath));
        config = new HoodieTableConfig(this.storage, this.metaPath);
        Assertions.assertEquals((int)7, (int)config.getProps().size());
    }

    @Test
    void testUpdateRecoveryWithInvalidProps() throws IOException {
        HoodieTableConfig config = new HoodieTableConfig(this.storage, this.metaPath);
        try (OutputStream out = this.storage.create(this.backupCfgPath);){
            config.getProps().store(out, "");
        }
        this.storage.deleteFile(this.cfgPath);
        this.storage.create(this.cfgPath);
        ConfigUtils.recoverIfNeeded((HoodieStorage)this.storage, (StoragePath)this.cfgPath, (StoragePath)this.backupCfgPath);
        Assertions.assertTrue((boolean)this.storage.exists(this.cfgPath));
        Assertions.assertFalse((boolean)this.storage.exists(this.backupCfgPath));
        config = new HoodieTableConfig(this.storage, this.metaPath);
        Assertions.assertEquals((int)7, (int)config.getProps().size());
        var3_3 = null;
        try (InputStream in = this.storage.open(this.cfgPath);
             OutputStream out = this.storage.create(this.backupCfgPath);){
            TypedProperties props = new TypedProperties();
            props.load(in);
            props.setProperty(HoodieTableConfig.TABLE_CHECKSUM.key(), "000000000");
            props.store(out, "");
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        this.storage.deleteFile(this.cfgPath);
        Assertions.assertThrows(IOException.class, () -> ConfigUtils.recoverIfNeeded((HoodieStorage)this.storage, (StoragePath)this.cfgPath, (StoragePath)this.backupCfgPath));
        Assertions.assertFalse((boolean)this.storage.exists(this.backupCfgPath));
        Assertions.assertFalse((boolean)this.storage.exists(this.cfgPath));
    }

    @Test
    void testReadRetry() throws IOException {
        this.storage.rename(this.cfgPath, new StoragePath(this.cfgPath.toString() + ".bak"));
        Assertions.assertThrows(HoodieIOException.class, () -> new HoodieTableConfig(this.storage, this.metaPath));
        this.storage.rename(new StoragePath(this.cfgPath.toString() + ".bak"), this.backupCfgPath);
        new HoodieTableConfig(this.storage, this.metaPath);
        Properties props = new Properties();
        props.put(HoodieTableConfig.TABLE_CHECKSUM.key(), "0");
        try (OutputStream out = this.storage.create(this.cfgPath);){
            props.store(out, "Wrong checksum in file so is invalid");
        }
        new HoodieTableConfig(this.storage, this.metaPath);
        out = this.storage.create(this.backupCfgPath);
        var3_3 = null;
        try {
            props.store(out, "Wrong checksum in file so is invalid");
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (out != null) {
                if (var3_3 != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    out.close();
                }
            }
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new HoodieTableConfig(this.storage, this.metaPath));
    }

    @Test
    void testConcurrentlyUpdate() throws ExecutionException, InterruptedException {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        Future<?> updaterFuture = executor.submit(() -> {
            for (int i = 0; i < 100; ++i) {
                Properties updatedProps = new Properties();
                updatedProps.setProperty(HoodieTableConfig.NAME.key(), "test-table" + i);
                updatedProps.setProperty(HoodieTableConfig.ORDERING_FIELDS.key(), "new_field" + i);
                HoodieTableConfig.update((HoodieStorage)this.storage, (StoragePath)this.metaPath, (Properties)updatedProps);
            }
        });
        Future<?> readerFuture = executor.submit(() -> {
            for (int i = 0; i < 100; ++i) {
                new HoodieTableConfig(this.storage, this.metaPath);
            }
        });
        updaterFuture.get();
        readerFuture.get();
        executor.shutdown();
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableVersion.class, names={"SEVEN", "EIGHT"})
    void testPartitionFields(HoodieTableVersion version) {
        Properties updatedProps = new Properties();
        updatedProps.setProperty(HoodieTableConfig.PARTITION_FIELDS.key(), version.greaterThan(HoodieTableVersion.SEVEN) ? "p1:simple,p2:timestamp" : "p1,p2");
        updatedProps.setProperty(HoodieTableConfig.VERSION.key(), String.valueOf(HoodieTableVersion.EIGHT.versionCode()));
        HoodieTableConfig.update((HoodieStorage)this.storage, (StoragePath)this.metaPath, (Properties)updatedProps);
        HoodieTableConfig config = new HoodieTableConfig(this.storage, this.metaPath);
        Assertions.assertArrayEquals((Object[])new String[]{"p1", "p2"}, (Object[])((Object[])config.getPartitionFields().get()));
        Assertions.assertEquals((Object)"p1,p2", (Object)config.getPartitionFieldProp());
    }

    @ParameterizedTest
    @ValueSource(strings={"p1:simple,p2:timestamp", "p1,p2"})
    void testPartitionFieldAPIs(String partitionFields) {
        Properties updatedProps = new Properties();
        updatedProps.setProperty(HoodieTableConfig.PARTITION_FIELDS.key(), partitionFields);
        HoodieTableConfig.update((HoodieStorage)this.storage, (StoragePath)this.metaPath, (Properties)updatedProps);
        HoodieTableConfig config = new HoodieTableConfig(this.storage, this.metaPath);
        Assertions.assertEquals((Object)partitionFields, (Object)HoodieTableConfig.getPartitionFieldPropForKeyGenerator((HoodieConfig)config).get());
        Assertions.assertEquals((Object)"p1,p2", (Object)HoodieTableConfig.getPartitionFieldProp((HoodieConfig)config).get());
        Assertions.assertArrayEquals((Object[])Arrays.stream(partitionFields.split(",")).toArray(), (Object[])((List)HoodieTableConfig.getPartitionFieldsForKeyGenerator((HoodieConfig)config).get()).toArray());
        Assertions.assertArrayEquals((Object[])new String[]{"p1", "p2"}, (Object[])((Object[])HoodieTableConfig.getPartitionFields((HoodieConfig)config).get()));
        Assertions.assertEquals((Object)"p1", (Object)HoodieTableConfig.getPartitionFieldWithoutKeyGenPartitionType((String)partitionFields.split(",")[0], (HoodieConfig)config));
    }

    @Test
    void testValidateConfigVersion() {
        Assertions.assertTrue((boolean)HoodieTableConfig.validateConfigVersion((ConfigProperty)HoodieTableConfig.INITIAL_VERSION, (HoodieTableVersion)HoodieTableVersion.EIGHT));
        Assertions.assertTrue((boolean)HoodieTableConfig.validateConfigVersion((ConfigProperty)ConfigProperty.key((String)"").noDefaultValue().withDocumentation(""), (HoodieTableVersion)HoodieTableVersion.SIX));
        Assertions.assertFalse((boolean)HoodieTableConfig.validateConfigVersion((ConfigProperty)HoodieTableConfig.INITIAL_VERSION, (HoodieTableVersion)HoodieTableVersion.SIX));
    }

    @Test
    void testDropInvalidConfigs() {
        HoodieConfig config = new HoodieConfig();
        config.setValue(HoodieTableConfig.VERSION, String.valueOf(HoodieTableVersion.SIX.versionCode()));
        config.setValue(HoodieTableConfig.INITIAL_VERSION, String.valueOf(HoodieTableVersion.EIGHT.versionCode()));
        config.setValue(HoodieTableConfig.RECORD_MERGE_MODE, RecordMergeMode.COMMIT_TIME_ORDERING.name());
        HoodieTableConfig.dropInvalidConfigs((HoodieConfig)config);
        Assertions.assertTrue((boolean)config.contains(HoodieTableConfig.VERSION));
        Assertions.assertFalse((boolean)config.contains(HoodieTableConfig.INITIAL_VERSION));
        Assertions.assertFalse((boolean)config.contains(HoodieTableConfig.RECORD_MERGE_MODE));
        config = new HoodieConfig();
        config.setValue(HoodieTableConfig.VERSION, String.valueOf(HoodieTableVersion.EIGHT.versionCode()));
        config.setValue(HoodieTableConfig.RECORD_MERGE_MODE, RecordMergeMode.COMMIT_TIME_ORDERING.name());
        HoodieTableConfig.dropInvalidConfigs((HoodieConfig)config);
        Assertions.assertTrue((boolean)config.contains(HoodieTableConfig.RECORD_MERGE_MODE));
    }

    @Test
    void testDefinedTableConfigs() {
        List configProperties = HoodieTableConfig.definedTableConfigs();
        Assertions.assertEquals((int)42, (int)configProperties.size());
        configProperties.forEach(c -> {
            Assertions.assertNotNull((Object)c);
            Assertions.assertFalse((boolean)c.doc().isEmpty());
        });
    }

    @Test
    void testTableMergeProperties() throws IOException {
        HoodieTableConfig config = new HoodieTableConfig(this.storage, this.metaPath);
        Assertions.assertTrue((boolean)config.getTableMergeProperties().isEmpty());
        this.storage.deleteFile(this.cfgPath);
        this.storage.deleteFile(this.backupCfgPath);
        Properties props = new Properties();
        props.setProperty(HoodieTableConfig.NAME.key(), "test-table");
        props.setProperty("hoodie.record.merge.property.key1", "value1");
        props.setProperty("hoodie.record.merge.property.key2", "value2");
        props.setProperty("key3", "value3");
        this.initializeNewTableConfig(props);
        config = new HoodieTableConfig(this.storage, this.metaPath);
        HashMap<String, String> expectedProps = new HashMap<String, String>();
        expectedProps.put("key1", "value1");
        expectedProps.put("key2", "value2");
        Assertions.assertEquals(expectedProps, (Object)config.getTableMergeProperties());
    }

    private static Stream<Arguments> testInferMergingConfigsForPreV9Table() {
        String defaultPayload = DefaultHoodieRecordPayload.class.getName();
        String overwritePayload = OverwriteWithLatestAvroPayload.class.getName();
        String customPayload = "custom_payload";
        String customStrategy = "custom_strategy";
        String orderingFieldName = "timestamp";
        Stream<Arguments> arguments = Stream.of(Arguments.arguments((Object[])new Object[]{null, null, null, null, "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{null, null, null, "", "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{null, null, null, orderingFieldName, "false", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{null, "", "", null, "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{null, "", "", orderingFieldName, "false", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, null, null, null, "false", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, null, null, orderingFieldName, "false", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, null, orderingFieldName, "false", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", orderingFieldName, "false", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, null, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", orderingFieldName, "false", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{null, defaultPayload, null, null, "false", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{null, defaultPayload, null, orderingFieldName, "false", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{null, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", orderingFieldName, "false", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{null, null, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", null, "false", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{null, null, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", orderingFieldName, "false", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, null, null, null, "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, null, null, "", "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, null, null, orderingFieldName, "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, null, null, "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d", null, "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, null, "ce9acb64-bde0-424c-9b91-f6ebba25356d", null, "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{null, overwritePayload, null, null, "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{null, overwritePayload, null, "", "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{null, overwritePayload, null, orderingFieldName, "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{null, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d", null, "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{null, null, "ce9acb64-bde0-424c-9b91-f6ebba25356d", null, "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{null, null, "ce9acb64-bde0-424c-9b91-f6ebba25356d", orderingFieldName, "false", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, customPayload, null, null, "false", RecordMergeMode.CUSTOM, customPayload, "00000000-0000-0000-0000-000000000000"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, customPayload, "00000000-0000-0000-0000-000000000000", null, "false", RecordMergeMode.CUSTOM, customPayload, "00000000-0000-0000-0000-000000000000"}), Arguments.arguments((Object[])new Object[]{null, customPayload, "00000000-0000-0000-0000-000000000000", null, "false", RecordMergeMode.CUSTOM, customPayload, "00000000-0000-0000-0000-000000000000"}), Arguments.arguments((Object[])new Object[]{null, customPayload, null, null, "false", RecordMergeMode.CUSTOM, customPayload, "00000000-0000-0000-0000-000000000000"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, null, customStrategy, null, "false", RecordMergeMode.CUSTOM, defaultPayload, customStrategy}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, customPayload, customStrategy, null, "false", RecordMergeMode.CUSTOM, customPayload, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, defaultPayload, customStrategy, null, "six-only", RecordMergeMode.CUSTOM, defaultPayload, customStrategy}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, defaultPayload, "00000000-0000-0000-0000-000000000000", null, "six-only", RecordMergeMode.CUSTOM, defaultPayload, "00000000-0000-0000-0000-000000000000"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, overwritePayload, "00000000-0000-0000-0000-000000000000", null, "six-only", RecordMergeMode.CUSTOM, overwritePayload, "00000000-0000-0000-0000-000000000000"}), Arguments.arguments((Object[])new Object[]{null, defaultPayload, "00000000-0000-0000-0000-000000000000", null, "false", null, defaultPayload, null}), Arguments.arguments((Object[])new Object[]{null, overwritePayload, "00000000-0000-0000-0000-000000000000", null, "false", null, overwritePayload, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, null, null, null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, null, "00000000-0000-0000-0000-000000000000", null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, overwritePayload, null, orderingFieldName, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, customPayload, null, orderingFieldName, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, null, "ce9acb64-bde0-424c-9b91-f6ebba25356d", orderingFieldName, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, null, customStrategy, orderingFieldName, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, null, "00000000-0000-0000-0000-000000000000", orderingFieldName, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, defaultPayload, null, null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, customPayload, null, null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, null, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, null, customStrategy, null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, null, "00000000-0000-0000-0000-000000000000", null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, defaultPayload, null, null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, overwritePayload, null, null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, null, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, null, "ce9acb64-bde0-424c-9b91-f6ebba25356d", null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, defaultPayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d", null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, overwritePayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", null, "true", null, null, null}), Arguments.arguments((Object[])new Object[]{null, defaultPayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d", null, "eight-only", RecordMergeMode.EVENT_TIME_ORDERING, defaultPayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"}), Arguments.arguments((Object[])new Object[]{null, overwritePayload, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", null, "eight-only", RecordMergeMode.COMMIT_TIME_ORDERING, overwritePayload, "ce9acb64-bde0-424c-9b91-f6ebba25356d"}));
        return arguments;
    }

    @ParameterizedTest
    @MethodSource
    void testInferMergingConfigsForPreV9Table(RecordMergeMode inputMergeMode, String inputPayloadClass, String inputMergeStrategy, String orderingFieldName, String shouldThrowString, RecordMergeMode outputMergeMode, String outputPayloadClass, String outputMergeStrategy) throws IOException {
        Arrays.stream(new HoodieTableVersion[]{HoodieTableVersion.EIGHT, HoodieTableVersion.SIX}).forEach(tableVersion -> {
            boolean shouldThrow = "eight-only".equals(shouldThrowString) ? tableVersion.greaterThanOrEquals(HoodieTableVersion.EIGHT) : ("six-only".equals(shouldThrowString) ? !tableVersion.greaterThanOrEquals(HoodieTableVersion.EIGHT) : Boolean.parseBoolean(shouldThrowString));
            RecordMergeMode expectedMergeMode = outputMergeMode;
            String expectedMergeStrategy = outputMergeStrategy;
            if (!(shouldThrow || outputMergeMode != null && outputMergeStrategy != null)) {
                expectedMergeMode = tableVersion.greaterThanOrEquals(HoodieTableVersion.EIGHT) ? RecordMergeMode.CUSTOM : HoodieTableConfig.inferRecordMergeModeFromPayloadClass((String)outputPayloadClass);
                expectedMergeStrategy = HoodieRecordMerger.getRecordMergeStrategyId((RecordMergeMode)expectedMergeMode, (String)outputPayloadClass, (String)inputMergeStrategy, (HoodieTableVersion)tableVersion);
            }
            if (shouldThrow) {
                Assertions.assertThrows(IllegalArgumentException.class, () -> HoodieTableConfig.inferMergingConfigsForPreV9Table((RecordMergeMode)inputMergeMode, (String)inputPayloadClass, (String)inputMergeStrategy, (String)orderingFieldName, (HoodieTableVersion)tableVersion));
            } else {
                Triple inferredConfigs = HoodieTableConfig.inferMergingConfigsForPreV9Table((RecordMergeMode)inputMergeMode, (String)inputPayloadClass, (String)inputMergeStrategy, (String)orderingFieldName, (HoodieTableVersion)tableVersion);
                Assertions.assertEquals((Object)expectedMergeMode, (Object)inferredConfigs.getLeft());
                Assertions.assertEquals((Object)outputPayloadClass, (Object)inferredConfigs.getMiddle());
                Assertions.assertEquals((Object)expectedMergeStrategy, (Object)inferredConfigs.getRight());
            }
        });
    }

    private static Stream<Arguments> testInferMergingConfigsForV9TableCreation() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{"Non-version 9 table", RecordMergeMode.EVENT_TIME_ORDERING, null, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", "ts", HoodieTableVersion.EIGHT, 0, null, null, null, null, null, null, null, null, null}), Arguments.arguments((Object[])new Object[]{"Version 9 with event time ordering", RecordMergeMode.EVENT_TIME_ORDERING, null, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", "ts", HoodieTableVersion.NINE, 1, RecordMergeMode.EVENT_TIME_ORDERING.name(), null, null, null, null, null, null, null}), Arguments.arguments((Object[])new Object[]{"Version 9 with commit time ordering", RecordMergeMode.COMMIT_TIME_ORDERING, null, "ce9acb64-bde0-424c-9b91-f6ebba25356d", null, HoodieTableVersion.NINE, 1, RecordMergeMode.COMMIT_TIME_ORDERING.name(), null, null, null, null, null, null, null}), Arguments.arguments((Object[])new Object[]{"Version 9 with custom merge mode", RecordMergeMode.CUSTOM, null, "1897ef5f-18bc-4557-939c-9d6a8afd1519", null, HoodieTableVersion.NINE, 2, RecordMergeMode.CUSTOM.name(), null, "1897ef5f-18bc-4557-939c-9d6a8afd1519", null, null, null, null, null}), Arguments.arguments((Object[])new Object[]{"Version 9 with custom payload", null, "com.example.CustomPayload", null, null, HoodieTableVersion.NINE, 3, RecordMergeMode.CUSTOM.name(), "com.example.CustomPayload", "00000000-0000-0000-0000-000000000000", null, null, null, null, null}), Arguments.arguments((Object[])new Object[]{"Version 9 with DefaultHoodieRecordPayload", null, DefaultHoodieRecordPayload.class.getName(), null, "ts", HoodieTableVersion.NINE, 2, RecordMergeMode.EVENT_TIME_ORDERING.name(), null, null, DefaultHoodieRecordPayload.class.getName(), null, null, null, null}), Arguments.arguments((Object[])new Object[]{"Version 9 with OverwriteWithLatestAvroPayload", null, OverwriteWithLatestAvroPayload.class.getName(), null, null, HoodieTableVersion.NINE, 2, RecordMergeMode.COMMIT_TIME_ORDERING.name(), null, null, OverwriteWithLatestAvroPayload.class.getName(), null, null, null, null}), Arguments.arguments((Object[])new Object[]{"Version 9 with PartialUpdateAvroPayload", null, PartialUpdateAvroPayload.class.getName(), null, "ts", HoodieTableVersion.NINE, 3, RecordMergeMode.EVENT_TIME_ORDERING.name(), null, null, PartialUpdateAvroPayload.class.getName(), PartialUpdateMode.IGNORE_DEFAULTS.name(), null, null, null}), Arguments.arguments((Object[])new Object[]{"Version 9 with OverwriteNonDefaultsWithLatestAvroPayload", null, OverwriteNonDefaultsWithLatestAvroPayload.class.getName(), null, null, HoodieTableVersion.NINE, 3, RecordMergeMode.COMMIT_TIME_ORDERING.name(), null, null, OverwriteNonDefaultsWithLatestAvroPayload.class.getName(), PartialUpdateMode.IGNORE_DEFAULTS.name(), null, null, null}), Arguments.arguments((Object[])new Object[]{"Version 9 with PostgresDebeziumAvroPayload", null, PostgresDebeziumAvroPayload.class.getName(), null, "ts", HoodieTableVersion.NINE, 7, RecordMergeMode.EVENT_TIME_ORDERING.name(), null, null, PostgresDebeziumAvroPayload.class.getName(), PartialUpdateMode.FILL_UNAVAILABLE.name(), "__debezium_unavailable_value", "_change_operation_type", "d"}), Arguments.arguments((Object[])new Object[]{"Version 9 with AWSDmsAvroPayload", null, AWSDmsAvroPayload.class.getName(), null, null, HoodieTableVersion.NINE, 4, RecordMergeMode.COMMIT_TIME_ORDERING.name(), null, null, AWSDmsAvroPayload.class.getName(), null, null, "Op", "D"}), Arguments.arguments((Object[])new Object[]{"Version 9 with EventTimeAvroPayload", null, EventTimeAvroPayload.class.getName(), null, "ts", HoodieTableVersion.NINE, 2, RecordMergeMode.EVENT_TIME_ORDERING.name(), null, null, EventTimeAvroPayload.class.getName(), null, null, null, null}), Arguments.arguments((Object[])new Object[]{"Version 9 with MySqlDebeziumAvroPayload", null, MySqlDebeziumAvroPayload.class.getName(), null, "ts", HoodieTableVersion.NINE, 5, RecordMergeMode.EVENT_TIME_ORDERING.name(), null, null, MySqlDebeziumAvroPayload.class.getName(), null, null, "_change_operation_type", "d"}));
    }

    @ParameterizedTest
    @MethodSource
    void testInferMergingConfigsForV9TableCreation(String testName, RecordMergeMode recordMergeMode, String payloadClassName, String recordMergeStrategyId, String orderingFieldName, HoodieTableVersion tableVersion, int expectedConfigSize, String expectedMergeMode, String expectedPayloadClass, String expectedMergeStrategyId, String expectedLegacyPayloadClass, String expectedPartialUpdateMode, String expectedDebeziumMarker, String expectedDeleteKey, String expectedDeleteMarker) {
        if (tableVersion.lesserThan(HoodieTableVersion.NINE)) {
            this.assertExceptionWithInferMergingConfigsForV9TableCreation(recordMergeMode, payloadClassName, recordMergeStrategyId, orderingFieldName, tableVersion);
        } else {
            Map configs = HoodieTableConfig.inferMergingConfigsForV9TableCreation((RecordMergeMode)recordMergeMode, (String)payloadClassName, (String)recordMergeStrategyId, (String)orderingFieldName, (HoodieTableVersion)tableVersion);
            Assertions.assertEquals((int)expectedConfigSize, (int)configs.size(), (String)("Config size mismatch for: " + testName));
            if (expectedMergeMode != null) {
                Assertions.assertEquals((Object)expectedMergeMode, configs.get(HoodieTableConfig.RECORD_MERGE_MODE.key()), (String)("Merge mode mismatch for: " + testName));
            } else {
                Assertions.assertFalse((boolean)configs.containsKey(HoodieTableConfig.RECORD_MERGE_MODE.key()), (String)"Record merge mode not expected to be set");
            }
            if (expectedPayloadClass != null) {
                Assertions.assertEquals((Object)expectedPayloadClass, configs.get(HoodieTableConfig.PAYLOAD_CLASS_NAME.key()), (String)("Payload class mismatch for: " + testName));
            } else {
                Assertions.assertFalse((boolean)configs.containsKey(HoodieTableConfig.PAYLOAD_CLASS_NAME.key()), (String)"Payload class not expected to be set");
            }
            if (expectedMergeStrategyId != null) {
                Assertions.assertEquals((Object)expectedMergeStrategyId, configs.get(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID.key()), (String)("Merge strategy ID mismatch for: " + testName));
            } else {
                Assertions.assertFalse((boolean)configs.containsKey(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID.key()), (String)"Record merge strategy id not expected to be set");
            }
            if (expectedLegacyPayloadClass != null) {
                Assertions.assertEquals((Object)expectedLegacyPayloadClass, configs.get(HoodieTableConfig.LEGACY_PAYLOAD_CLASS_NAME.key()), (String)("Legacy payload class mismatch for: " + testName));
            } else {
                Assertions.assertFalse((boolean)configs.containsKey(HoodieTableConfig.LEGACY_PAYLOAD_CLASS_NAME.key()), (String)"Legacy payload class not expected to be set");
            }
            if (expectedPartialUpdateMode != null) {
                Assertions.assertEquals((Object)expectedPartialUpdateMode, configs.get(HoodieTableConfig.PARTIAL_UPDATE_MODE.key()), (String)("Partial update mode mismatch for: " + testName));
            } else {
                Assertions.assertFalse((boolean)configs.containsKey(HoodieTableConfig.PARTIAL_UPDATE_MODE.key()), (String)(HoodieTableConfig.PARTIAL_UPDATE_MODE.key() + " not expected to be set"));
            }
            if (expectedDebeziumMarker != null) {
                Assertions.assertEquals((Object)expectedDebeziumMarker, configs.get("hoodie.record.merge.property.hoodie.write.partial.update.unavailable.value"), (String)("Debezium marker mismatch for: " + testName));
            } else {
                Assertions.assertFalse((boolean)configs.containsKey("hoodie.record.merge.property.hoodie.write.partial.update.unavailable.value"), (String)"Custom merge property hoodie.record.merge.property.hoodie.write.partial.update.unavailable.value not expected to be set");
            }
            if (expectedDeleteKey != null || configs.containsKey("hoodie.record.merge.property.hoodie.payload.delete.field")) {
                Assertions.assertEquals((Object)expectedDeleteKey, configs.get("hoodie.record.merge.property.hoodie.payload.delete.field"), (String)("Delete key mismatch for: " + testName));
            } else {
                Assertions.assertFalse((boolean)configs.containsKey("hoodie.record.merge.property.hoodie.payload.delete.field"), (String)"Custom merge property hoodie.record.merge.property.hoodie.payload.delete.field  not expected to be set");
            }
            if (expectedDeleteMarker != null) {
                Assertions.assertEquals((Object)expectedDeleteMarker, configs.get("hoodie.record.merge.property.hoodie.payload.delete.marker"), (String)("Delete marker mismatch for: " + testName));
            } else {
                Assertions.assertFalse((boolean)configs.containsKey("hoodie.record.merge.property.hoodie.payload.delete.marker"), (String)"Custom merge property hoodie.record.merge.property.hoodie.payload.delete.marker  not expected to be set");
            }
        }
    }

    @Test
    void testInferMergingConfigsForVersion9WithInconsistentConfigs() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> HoodieTableConfig.inferMergingConfigsForV9TableCreation((RecordMergeMode)RecordMergeMode.EVENT_TIME_ORDERING, null, (String)"ce9acb64-bde0-424c-9b91-f6ebba25356d", (String)"ts", (HoodieTableVersion)HoodieTableVersion.NINE));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HoodieTableConfig.inferMergingConfigsForV9TableCreation((RecordMergeMode)RecordMergeMode.COMMIT_TIME_ORDERING, null, (String)"eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", null, (HoodieTableVersion)HoodieTableVersion.NINE));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HoodieTableConfig.inferMergingConfigsForV9TableCreation((RecordMergeMode)RecordMergeMode.CUSTOM, null, (String)"eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", null, (HoodieTableVersion)HoodieTableVersion.NINE));
    }

    @Test
    void testInferMergingConfigsForVersion9EdgeCases() {
        Map configs = HoodieTableConfig.inferMergingConfigsForV9TableCreation((RecordMergeMode)RecordMergeMode.EVENT_TIME_ORDERING, (String)"", (String)"eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", (String)"ts", (HoodieTableVersion)HoodieTableVersion.NINE);
        Assertions.assertEquals((int)1, (int)configs.size());
        Assertions.assertEquals((Object)RecordMergeMode.EVENT_TIME_ORDERING.name(), configs.get(HoodieTableConfig.RECORD_MERGE_MODE.key()));
        this.assertExceptionWithInferMergingConfigsForV9TableCreation(RecordMergeMode.EVENT_TIME_ORDERING, DefaultHoodieRecordPayload.class.getName(), "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", "ts", HoodieTableVersion.EIGHT);
        configs = HoodieTableConfig.inferMergingConfigsForV9TableCreation((RecordMergeMode)RecordMergeMode.EVENT_TIME_ORDERING, null, (String)"eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", null, (HoodieTableVersion)HoodieTableVersion.NINE);
        Assertions.assertEquals((int)1, (int)configs.size());
        Assertions.assertEquals((Object)RecordMergeMode.EVENT_TIME_ORDERING.name(), configs.get(HoodieTableConfig.RECORD_MERGE_MODE.key()));
    }

    @Test
    void testInferMergingConfigsForVersion9WithAllTableVersions() {
        for (HoodieTableVersion version : HoodieTableVersion.values()) {
            if (version.lesserThan(HoodieTableVersion.NINE)) {
                this.assertExceptionWithInferMergingConfigsForV9TableCreation(RecordMergeMode.EVENT_TIME_ORDERING, DefaultHoodieRecordPayload.class.getName(), "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", "ts", version);
                continue;
            }
            Map configs = HoodieTableConfig.inferMergingConfigsForV9TableCreation((RecordMergeMode)RecordMergeMode.EVENT_TIME_ORDERING, (String)DefaultHoodieRecordPayload.class.getName(), (String)"eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", (String)"ts", (HoodieTableVersion)version);
            Assertions.assertEquals((int)2, (int)configs.size(), (String)"Table version 9 and above should return 2 configs");
        }
    }

    private void assertExceptionWithInferMergingConfigsForV9TableCreation(RecordMergeMode recordMergeMode, String payloadClassName, String recordMergeStrategyId, String orderingFieldName, HoodieTableVersion tableVersion) {
        HoodieIOException ioException = (HoodieIOException)Assertions.assertThrows(HoodieIOException.class, () -> HoodieTableConfig.inferMergingConfigsForV9TableCreation((RecordMergeMode)recordMergeMode, (String)payloadClassName, (String)recordMergeStrategyId, (String)orderingFieldName, (HoodieTableVersion)tableVersion));
        Assertions.assertEquals((Object)"Unsupported flow for table versions less than 9", (Object)ioException.getMessage().toString());
    }
}

