/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.versioning.v2.InstantComparatorV2;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.FileFormatUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.internal.schema.HoodieSchemaException;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class TestTableSchemaResolver {
    @TempDir
    Path tempDir;

    TestTableSchemaResolver() {
    }

    @Test
    void testRecreateSchemaWhenDropPartitionColumns() {
        Schema originSchema = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
        String[] pts1 = new String[]{};
        Schema s2 = TableSchemaResolver.appendPartitionColumns((Schema)originSchema, (Option)Option.of((Object)pts1));
        Assertions.assertEquals((Object)originSchema, (Object)s2);
        String[] pts2 = new String[]{"partition_path"};
        Schema s3 = TableSchemaResolver.appendPartitionColumns((Schema)originSchema, (Option)Option.of((Object)pts2));
        Assertions.assertEquals((Object)originSchema, (Object)s3);
        String[] pts3 = new String[]{"user_partition"};
        Schema s4 = TableSchemaResolver.appendPartitionColumns((Schema)originSchema, (Option)Option.of((Object)pts3));
        Assertions.assertNotEquals((Object)originSchema, (Object)s4);
        Assertions.assertTrue((boolean)s4.getFields().stream().anyMatch(f -> f.name().equals("user_partition")));
        Schema.Field f2 = s4.getField("user_partition");
        Assertions.assertEquals((Object)f2.schema(), (Object)AvroSchemaUtils.createNullableSchema((Schema.Type)Schema.Type.STRING));
        String[] pts4 = new String[]{"user_partition", "partition_path"};
        try {
            TableSchemaResolver.appendPartitionColumns((Schema)originSchema, (Option)Option.of((Object)pts3));
        }
        catch (HoodieSchemaException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Partial partition fields are still in the schema"));
        }
    }

    @Test
    void testReadSchemaFromLogFile() throws IOException, URISyntaxException, InterruptedException {
        String testDir = this.initTestDir("read_schema_from_log_file");
        StoragePath partitionPath = new StoragePath(testDir, "partition1");
        Schema expectedSchema = SchemaTestUtil.getSimpleSchema();
        StoragePath logFilePath = this.writeLogFile(partitionPath, expectedSchema);
        Assertions.assertEquals((Object)expectedSchema, (Object)TableSchemaResolver.readSchemaFromLogFile((HoodieStorage)new HoodieHadoopStorage(logFilePath, HoodieTestUtils.getDefaultStorageConfWithDefaults()), (StoragePath)logFilePath));
    }

    @Test
    void testHasOperationFieldFileInspectionOrdering() throws IOException {
        HadoopStorageConfiguration conf = new HadoopStorageConfiguration(Boolean.valueOf(false));
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)metaClient.getStorageConf()).thenReturn((Object)conf);
        Mockito.when((Object)metaClient.getTableType()).thenReturn((Object)HoodieTableType.MERGE_ON_READ);
        Mockito.when((Object)metaClient.getBasePath()).thenReturn((Object)new StoragePath("/tmp/hudi_table"));
        TableSchemaResolver schemaResolver = new TableSchemaResolver(metaClient);
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        HoodieWriteStat baseFileWriteStat = TestTableSchemaResolver.buildWriteStat("partition1/baseFile1.parquet", 10, 100);
        HoodieWriteStat logFileWriteStat = TestTableSchemaResolver.buildWriteStat("partition1/" + FSUtils.makeLogFileName((String)"001", (String)".log", (String)"100", (int)2, (String)"1-0-1"), 0, 10);
        HoodieWriteStat baseFileWriteStat2 = (HoodieWriteStat)Mockito.mock(HoodieWriteStat.class);
        HoodieWriteStat logFileWithOnlyDeletes = TestTableSchemaResolver.buildWriteStat("partition1/" + FSUtils.makeLogFileName((String)"002", (String)".log", (String)"100", (int)2, (String)"1-0-1"), 0, 0);
        HoodieWriteStat baseFileWithOnlyDeletes = TestTableSchemaResolver.buildWriteStat("partition2/baseFile2.parquet", 0, 0);
        commitMetadata.addWriteStat("partition1", baseFileWriteStat);
        commitMetadata.addWriteStat("partition1", logFileWithOnlyDeletes);
        commitMetadata.addWriteStat("partition1", logFileWriteStat);
        commitMetadata.addWriteStat("partition1", baseFileWriteStat2);
        commitMetadata.addWriteStat("partition2", baseFileWithOnlyDeletes);
        HoodieInstant instant = new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "001", InstantComparatorV2.COMPLETION_TIME_BASED_COMPARATOR);
        HoodieTimeline timeline = (HoodieTimeline)Mockito.mock(HoodieTimeline.class);
        Mockito.when((Object)metaClient.getCommitsTimeline().filterCompletedInstants()).thenReturn((Object)timeline);
        Mockito.when((Object)timeline.getReverseOrderedInstants()).thenReturn(Stream.of(instant));
        Mockito.when((Object)timeline.readCommitMetadata(instant)).thenReturn((Object)commitMetadata);
        try (MockedStatic ioFactoryMockedStatic = Mockito.mockStatic(HoodieIOFactory.class);
             MockedStatic tableSchemaResolverMockedStatic = Mockito.mockStatic(TableSchemaResolver.class);){
            Schema schema = Schema.createRecord((String)"test_schema", null, (String)"test_namespace", (boolean)false);
            schema.setFields(Arrays.asList(new Schema.Field("int_field", Schema.create((Schema.Type)Schema.Type.INT)), new Schema.Field("_hoodie_operation", Schema.create((Schema.Type)Schema.Type.STRING))));
            HoodieIOFactory ioFactory = (HoodieIOFactory)Mockito.mock(HoodieIOFactory.class);
            FileFormatUtils fileFormatUtils = (FileFormatUtils)Mockito.mock(FileFormatUtils.class);
            StoragePath parquetPath = new StoragePath("/tmp/hudi_table/partition1/baseFile1.parquet");
            Mockito.when((Object)ioFactory.getFileFormatUtils(parquetPath)).thenReturn((Object)fileFormatUtils);
            Mockito.when((Object)fileFormatUtils.readAvroSchema((HoodieStorage)ArgumentMatchers.any(), (StoragePath)ArgumentMatchers.eq((Object)parquetPath))).thenReturn(null);
            ioFactoryMockedStatic.when(() -> HoodieIOFactory.getIOFactory((HoodieStorage)((HoodieStorage)ArgumentMatchers.any()))).thenReturn((Object)ioFactory);
            tableSchemaResolverMockedStatic.when(() -> TableSchemaResolver.readSchemaFromLogFile((HoodieStorage)((HoodieStorage)ArgumentMatchers.any()), (StoragePath)((StoragePath)ArgumentMatchers.eq((Object)new StoragePath("/tmp/hudi_table/" + logFileWriteStat.getPath()))))).thenReturn((Object)schema);
            Assertions.assertTrue((boolean)schemaResolver.hasOperationField());
        }
        Mockito.verifyNoInteractions((Object[])new Object[]{baseFileWriteStat2});
    }

    private static HoodieWriteStat buildWriteStat(String path, int numInserts, int numUpdateWrites) {
        HoodieWriteStat logFileWriteStat = new HoodieWriteStat();
        logFileWriteStat.setPath(path);
        logFileWriteStat.setNumInserts((long)numInserts);
        logFileWriteStat.setNumUpdateWrites((long)numUpdateWrites);
        logFileWriteStat.setNumDeletes(1L);
        return logFileWriteStat;
    }

    private String initTestDir(String folderName) throws IOException {
        Path basePath = this.tempDir.resolve(folderName);
        Files.createDirectories(basePath, new FileAttribute[0]);
        return basePath.toString();
    }

    private StoragePath writeLogFile(StoragePath partitionPath, Schema schema) throws IOException, URISyntaxException, InterruptedException {
        HoodieStorage storage = HoodieTestUtils.getStorage((StoragePath)partitionPath);
        HoodieLogFormat.Writer writer = HoodieLogFormat.newWriterBuilder().onParentPath(partitionPath).withFileExtension(".log").withFileId("test-fileid1").withInstantTime("100").withStorage(storage).build();
        List records = SchemaTestUtil.generateTestRecords((int)0, (int)100);
        HashMap<HoodieLogBlock.HeaderMetadataType, String> header = new HashMap<HoodieLogBlock.HeaderMetadataType, String>();
        header.put(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME, "100");
        header.put(HoodieLogBlock.HeaderMetadataType.SCHEMA, schema.toString());
        HoodieDataBlock dataBlock = HoodieCommonTestHarness.getDataBlock(HoodieLogBlock.HoodieLogBlockType.AVRO_DATA_BLOCK, records, header);
        writer.appendBlock((HoodieLogBlock)dataBlock);
        writer.close();
        return writer.getLogFile().getPath();
    }
}

