/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.util.stream.Stream;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.MockHoodieTimeline;
import org.apache.hudi.exception.HoodieException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class TestTimelineUtilsBackComp
extends HoodieCommonTestHarness {
    TestTimelineUtilsBackComp() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.initPath();
    }

    @ParameterizedTest
    @CsvSource(value={"FAIL, SIX", "FAIL, EIGHT", "BLOCK, SIX", "BLOCK, EIGHT", "USE_TRANSITION_TIME, SIX", "USE_TRANSITION_TIME, EIGHT"})
    void testHandleHollowCommit(TimelineUtils.HollowCommitHandling handlingMode, HoodieTableVersion tableVersion) throws Exception {
        Integer timelineLayoutVersion = tableVersion == HoodieTableVersion.SIX ? TimelineLayoutVersion.VERSION_1 : TimelineLayoutVersion.VERSION_2;
        this.metaClient = HoodieTableMetaClient.newTableBuilder().setDatabaseName("dataset").setTableName("testTable").setTimelineLayoutVersion(timelineLayoutVersion).setTableVersion(tableVersion).setTableType(HoodieTableType.MERGE_ON_READ).initTable(HoodieTestUtils.getDefaultStorageConf(), this.basePath);
        HoodieTableVersion actualTableVersion = this.metaClient.getTableConfig().getTableVersion();
        Assertions.assertEquals((Integer)actualTableVersion.getTimelineLayoutVersion().getVersion(), (Integer)timelineLayoutVersion);
        Assertions.assertEquals((int)actualTableVersion.versionCode(), (int)tableVersion.versionCode());
        HoodieTestTable.of(this.metaClient).addCommit("001").addInflightCommit("003").addCommit("005");
        this.verifyHollowCommitHandling(handlingMode);
    }

    private void verifyHollowCommitHandling(TimelineUtils.HollowCommitHandling handlingMode) {
        Stream<String> completed = Stream.of("001", "005");
        MockHoodieTimeline completedTimeline = new MockHoodieTimeline(completed, Stream.empty());
        switch (handlingMode) {
            case FAIL: {
                HoodieException e = (HoodieException)Assertions.assertThrows(HoodieException.class, () -> this.lambda$verifyHollowCommitHandling$0((HoodieTimeline)completedTimeline, handlingMode));
                Assertions.assertTrue((boolean)e.getMessage().startsWith("Found hollow commit:"));
                break;
            }
            case BLOCK: {
                HoodieTimeline filteredTimeline = TimelineUtils.handleHollowCommitIfNeeded((HoodieTimeline)completedTimeline, (HoodieTableMetaClient)this.metaClient, (TimelineUtils.HollowCommitHandling)handlingMode);
                Assertions.assertTrue((boolean)filteredTimeline.containsInstant("001"));
                Assertions.assertFalse((boolean)filteredTimeline.containsInstant("003"));
                Assertions.assertFalse((boolean)filteredTimeline.containsInstant("005"));
                break;
            }
            case USE_TRANSITION_TIME: {
                HoodieTimeline filteredTimeline = TimelineUtils.handleHollowCommitIfNeeded((HoodieTimeline)completedTimeline, (HoodieTableMetaClient)this.metaClient, (TimelineUtils.HollowCommitHandling)handlingMode);
                Assertions.assertTrue((boolean)filteredTimeline.containsInstant("001"));
                Assertions.assertFalse((boolean)filteredTimeline.containsInstant("003"));
                Assertions.assertTrue((boolean)filteredTimeline.containsInstant("005"));
                break;
            }
            default: {
                Assertions.fail((String)"should cover all handling mode.");
            }
        }
    }

    private /* synthetic */ void lambda$verifyHollowCommitHandling$0(HoodieTimeline completedTimeline, TimelineUtils.HollowCommitHandling handlingMode) throws Throwable {
        TimelineUtils.handleHollowCommitIfNeeded((HoodieTimeline)completedTimeline, (HoodieTableMetaClient)this.metaClient, (TimelineUtils.HollowCommitHandling)handlingMode);
    }
}

