/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroReaderContext;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.BufferedRecords;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.reader.DataGenerationPlan;
import org.apache.hudi.common.testutils.reader.HoodieFileGroupReaderTestHarness;
import org.apache.hudi.common.testutils.reader.HoodieFileSliceTestUtils;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.OrderingValues;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

public class TestCustomRecordMerger
extends HoodieFileGroupReaderTestHarness {
    @Override
    protected Properties getMetaProps() {
        Properties metaProps = super.getMetaProps();
        metaProps.setProperty(HoodieTableConfig.RECORD_MERGE_MODE.key(), RecordMergeMode.CUSTOM.name());
        metaProps.setProperty(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID.key(), "KEEP_CERTAIN_TIMESTAMP_VALUE_ONLY");
        metaProps.setProperty(HoodieTableConfig.ORDERING_FIELDS.key(), "timestamp");
        return metaProps;
    }

    @BeforeAll
    public static void setUp() throws IOException {
        properties.setProperty("hoodie.write.record.merge.mode", RecordMergeMode.CUSTOM.name());
        properties.setProperty("hoodie.write.record.merge.custom.implementation.classes", CustomAvroMerger.class.getName());
        keyRanges = Arrays.asList(new HoodieFileSliceTestUtils.KeyRange(1, 10), new HoodieFileSliceTestUtils.KeyRange(1, 5), new HoodieFileSliceTestUtils.KeyRange(1, 3), new HoodieFileSliceTestUtils.KeyRange(6, 8), new HoodieFileSliceTestUtils.KeyRange(1, 10));
        timestamps = Arrays.asList(2L, 3L, 4L, 1L, 9L);
        operationTypes = Arrays.asList(DataGenerationPlan.OperationType.INSERT, DataGenerationPlan.OperationType.DELETE, DataGenerationPlan.OperationType.UPDATE, DataGenerationPlan.OperationType.DELETE, DataGenerationPlan.OperationType.UPDATE);
        instantTimes = Arrays.asList("001", "002", "003", "004", "005");
    }

    @BeforeEach
    public void initialize() throws Exception {
        this.setTableName(TestCustomRecordMerger.class.getName());
        this.initPath(this.tableName);
        this.initMetaClient();
        this.initTestDataGenerator(new String[]{"any-partition-path"});
        testTable = HoodieTestTable.of(this.metaClient);
        this.readerContext = new HoodieAvroReaderContext(storageConf, this.metaClient.getTableConfig(), Option.empty(), Option.empty());
        this.setUpMockCommits();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testWithOneLogFile(boolean useRecordPositions) throws IOException, InterruptedException {
        this.shouldWritePositions = Arrays.asList(useRecordPositions, useRecordPositions);
        try (ClosableIterator<IndexedRecord> iterator = this.getFileGroupIterator(2, useRecordPositions);){
            List<String> leftKeysExpected = Arrays.asList("6", "7", "8", "9", "10");
            ArrayList<String> leftKeysActual = new ArrayList<String>();
            while (iterator.hasNext()) {
                leftKeysActual.add(((IndexedRecord)iterator.next()).get(HoodieTestDataGenerator.AVRO_SCHEMA.getField("_row_key").pos()).toString());
            }
            Assertions.assertEquals(leftKeysExpected, leftKeysActual);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testWithTwoLogFiles(boolean useRecordPositions) throws IOException, InterruptedException {
        this.shouldWritePositions = Arrays.asList(useRecordPositions, useRecordPositions, useRecordPositions);
        try (ClosableIterator<IndexedRecord> iterator = this.getFileGroupIterator(3, useRecordPositions);){
            List<String> leftKeysExpected = Arrays.asList("1", "3", "6", "7", "8", "9", "10");
            ArrayList<String> leftKeysActual = new ArrayList<String>();
            while (iterator.hasNext()) {
                leftKeysActual.add(((IndexedRecord)iterator.next()).get(HoodieTestDataGenerator.AVRO_SCHEMA.getField("_row_key").pos()).toString());
            }
            Assertions.assertEquals(leftKeysExpected, leftKeysActual);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testWithThreeLogFiles(boolean useRecordPositions) throws IOException, InterruptedException {
        this.shouldWritePositions = Arrays.asList(useRecordPositions, useRecordPositions, useRecordPositions, useRecordPositions);
        try (ClosableIterator<IndexedRecord> iterator = this.getFileGroupIterator(4, useRecordPositions);){
            List<String> leftKeysExpected = Arrays.asList("1", "3", "7", "9", "10");
            ArrayList<String> leftKeysActual = new ArrayList<String>();
            while (iterator.hasNext()) {
                leftKeysActual.add(((IndexedRecord)iterator.next()).get(HoodieTestDataGenerator.AVRO_SCHEMA.getField("_row_key").pos()).toString());
            }
            Assertions.assertEquals(leftKeysExpected, leftKeysActual);
        }
    }

    @Test
    public void testWithFourLogFiles() throws IOException, InterruptedException {
        this.shouldWritePositions = Arrays.asList(false, false, false, false, false);
        try (ClosableIterator<IndexedRecord> iterator = this.getFileGroupIterator(5);){
            List<String> leftKeysExpected = Arrays.asList("1", "3", "5", "7", "9");
            ArrayList<String> leftKeysActual = new ArrayList<String>();
            while (iterator.hasNext()) {
                leftKeysActual.add(((IndexedRecord)iterator.next()).get(HoodieTestDataGenerator.AVRO_SCHEMA.getField("_row_key").pos()).toString());
            }
            Assertions.assertEquals(leftKeysExpected, leftKeysActual);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"testArgs"})
    public void testPositionMergeFallback(boolean log1haspositions, boolean log2haspositions, boolean log3haspositions, boolean log4haspositions) throws IOException, InterruptedException {
        this.shouldWritePositions = Arrays.asList(true, log1haspositions, log2haspositions, log3haspositions, log4haspositions);
        try (ClosableIterator<IndexedRecord> iterator = this.getFileGroupIterator(5, true);){
            List<String> leftKeysExpected = Arrays.asList("1", "3", "5", "7", "9");
            ArrayList<String> leftKeysActual = new ArrayList<String>();
            while (iterator.hasNext()) {
                leftKeysActual.add(((IndexedRecord)iterator.next()).get(HoodieTestDataGenerator.AVRO_SCHEMA.getField("_row_key").pos()).toString());
            }
            Assertions.assertEquals(leftKeysExpected, leftKeysActual);
        }
    }

    private static Stream<Arguments> testArgs() {
        Stream.Builder<Arguments> b = Stream.builder();
        for (int i = 0; i < 16; ++i) {
            b.add(Arguments.of((Object[])new Object[]{i % 2 == 0, i / 2 % 2 == 0, i / 4 % 2 == 0, i / 8 % 2 == 0}));
        }
        return b.build();
    }

    public static class CustomAvroMerger
    implements HoodieRecordMerger {
        public static final String KEEP_CERTAIN_TIMESTAMP_VALUE_ONLY = "KEEP_CERTAIN_TIMESTAMP_VALUE_ONLY";
        private String[] orderingFields;

        public <T> BufferedRecord<T> merge(BufferedRecord<T> older, BufferedRecord<T> newer, RecordContext<T> recordContext, TypedProperties props) throws IOException {
            if (this.orderingFields == null) {
                this.orderingFields = ConfigUtils.getOrderingFields((Properties)props);
            }
            if (newer.getOrderingValue().compareTo(older.getOrderingValue()) >= 0) {
                if (newer.isDelete()) {
                    return newer;
                }
                int id = Integer.parseInt(newer.getRecordKey());
                if ((long)(id % 2) == 1L) {
                    return newer;
                }
            } else {
                if (older.isDelete()) {
                    return older;
                }
                int id = Integer.parseInt(older.getRecordKey());
                if ((long)(id % 2) == 1L) {
                    return older;
                }
            }
            return BufferedRecords.createDelete((String)newer.getRecordKey(), (Comparable)OrderingValues.getDefault());
        }

        public HoodieRecord.HoodieRecordType getRecordType() {
            return HoodieRecord.HoodieRecordType.AVRO;
        }

        public String getMergingStrategy() {
            return KEEP_CERTAIN_TIMESTAMP_VALUE_ONLY;
        }
    }
}

